/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.llama;

import java.util.HashMap;
import java.util.Map;

abstract class JsonParameters {
    final Map<String, String> parameters = new HashMap<String, String>();

    JsonParameters() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        int n = 0;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            stringBuilder.append("\t\"").append(string).append("\": ").append(string2);
            if (n++ < this.parameters.size() - 1) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    String toJsonString(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        char c = '\u0000';
        int n = string.length();
        stringBuilder.append('\"');
        block9: for (int i = 0; i < n; ++i) {
            char c2 = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue block9;
                }
                case '/': {
                    if (c2 == '<') {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c);
                    continue block9;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block9;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        stringBuilder.append("\\u");
                        String string2 = Integer.toHexString(c);
                        stringBuilder.append("0000", 0, 4 - string2.length());
                        stringBuilder.append(string2);
                        continue block9;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

