/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.llama;

import com.johnsnowlabs.nlp.llama.InferenceParameters;
import com.johnsnowlabs.nlp.llama.LlamaModel;
import com.johnsnowlabs.nlp.llama.LlamaOutput;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LlamaIterator
implements Iterator<LlamaOutput> {
    private final LlamaModel model;
    private final int taskId;
    private boolean hasNext = true;

    LlamaIterator(LlamaModel llamaModel, InferenceParameters inferenceParameters) {
        this.model = llamaModel;
        inferenceParameters.setStream(true);
        this.taskId = llamaModel.requestCompletion(inferenceParameters.toString());
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public LlamaOutput next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        LlamaOutput llamaOutput = this.model.receiveCompletion(this.taskId);
        this.hasNext = !llamaOutput.stop;
        return llamaOutput;
    }

    public void cancel() {
        this.model.cancelCompletion(this.taskId);
        this.hasNext = false;
    }
}

