/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.llama;

import com.johnsnowlabs.nlp.llama.OSInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

class LlamaLoader {
    private static boolean extracted = false;

    LlamaLoader() {
    }

    static synchronized void initialize() throws UnsatisfiedLinkError {
        if (!extracted) {
            LlamaLoader.cleanup();
        }
        LlamaLoader.loadNativeLibrary("jllama");
        extracted = true;
    }

    private static void cleanup() {
        try (Stream<Path> stream = Files.list(LlamaLoader.getTempDir().toPath());){
            stream.filter(LlamaLoader::shouldCleanPath).forEach(LlamaLoader::cleanPath);
        }
        catch (IOException iOException) {
            System.err.println("Failed to open directory: " + iOException.getMessage());
        }
    }

    private static boolean shouldCleanPath(Path path) {
        String string = path.getFileName().toString();
        return string.startsWith("jllama") || string.startsWith("llama");
    }

    private static void cleanPath(Path path) {
        try {
            Files.delete(path);
        }
        catch (Exception exception) {
            System.err.println("Failed to delete old native lib: " + exception.getMessage());
        }
    }

    private static void loadNativeLibrary(String string) {
        Object object;
        String string2;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string3 = System.getProperty("com.johnsnowlabs.nlp.llama.lib.name");
        if (string3 == null) {
            string3 = System.mapLibraryName(string);
        }
        if ((string2 = System.getProperty("com.johnsnowlabs.nlp.llama.lib.path")) != null) {
            object = Paths.get(string2, string3);
            if (LlamaLoader.loadNativeLibrary((Path)object)) {
                return;
            }
            linkedList.add(string2);
        }
        if (OSInfo.isAndroid()) {
            try {
                System.loadLibrary(string);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                linkedList.add("Directly from .apk/lib");
            }
        }
        object = System.getProperty("java.library.path", "");
        for (String string4 : ((String)object).split(File.pathSeparator)) {
            if (string4.isEmpty()) continue;
            Path path = Paths.get(string4, string3);
            if (LlamaLoader.loadNativeLibrary(path)) {
                return;
            }
            linkedList.add(string4);
        }
        string2 = LlamaLoader.getNativeResourcePath();
        if (LlamaLoader.hasNativeLib(string2, string3)) {
            String string5 = LlamaLoader.getTempDir().getAbsolutePath();
            if (LlamaLoader.extractAndLoadLibraryFile(string2, string3, string5)) {
                return;
            }
            linkedList.add(string2);
        }
        throw new UnsatisfiedLinkError(String.format("No native library '%s' found for os.name=%s, os.arch=%s, paths=[%s]", string, OSInfo.getOSName(), OSInfo.getArchName(), String.join((CharSequence)File.pathSeparator, linkedList)));
    }

    private static boolean loadNativeLibrary(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        String string = path.toAbsolutePath().toString();
        try {
            System.load(string);
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(unsatisfiedLinkError.getMessage());
            System.err.println("Failed to load native library: " + string + ". osinfo: " + OSInfo.getNativeLibFolderPathForCurrentOS());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Path extractFile(String string, String string2, String string3, boolean bl) {
        String string4 = string + "/" + string2;
        Path path = Paths.get(string3, string2);
        try {
            Throwable throwable;
            InputStream inputStream;
            try {
                inputStream = LlamaLoader.class.getResourceAsStream(string4);
                throwable = null;
                try {
                    if (inputStream == null) {
                        Path path2 = null;
                        return path2;
                    }
                    Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            finally {
                path.toFile().deleteOnExit();
            }
            path.toFile().setReadable(true);
            path.toFile().setWritable(true, true);
            path.toFile().setExecutable(true);
            inputStream = LlamaLoader.class.getResourceAsStream(string4);
            throwable = null;
            try (InputStream inputStream2 = Files.newInputStream(path, new OpenOption[0]);){
                if (!LlamaLoader.contentsEquals(inputStream, inputStream2)) {
                    throw new RuntimeException(String.format("Failed to write a native library file at %s", path));
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            System.out.println("jsl-llama: Extracted '" + string2 + "' to '" + path + "'");
            return path;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return null;
        }
    }

    private static boolean extractAndLoadLibraryFile(String string, String string2, String string3) {
        Path path = LlamaLoader.extractFile(string, string2, string3, true);
        if (path == null) {
            return false;
        }
        return LlamaLoader.loadNativeLibrary(path);
    }

    private static boolean contentsEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n2 = inputStream.read();
        while (n2 != -1) {
            n = inputStream2.read();
            if (n2 != n) {
                return false;
            }
            n2 = inputStream.read();
        }
        n = inputStream2.read();
        return n == -1;
    }

    private static File getTempDir() {
        return new File(System.getProperty("com.johnsnowlabs.nlp.llama.tmpdir", System.getProperty("java.io.tmpdir")));
    }

    private static String getNativeResourcePath() {
        String string = LlamaLoader.class.getPackage().getName().replace(".", "/");
        return String.format("/%s/%s", string, OSInfo.getNativeLibFolderPathForCurrentOS());
    }

    private static boolean hasNativeLib(String string, String string2) {
        return LlamaLoader.class.getResource(string + "/" + string2) != null;
    }
}

