/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.llama;

import com.johnsnowlabs.nlp.llama.InferenceParameters;
import com.johnsnowlabs.nlp.llama.LlamaException;
import com.johnsnowlabs.nlp.llama.LlamaIterable;
import com.johnsnowlabs.nlp.llama.LlamaIterator;
import com.johnsnowlabs.nlp.llama.LlamaLoader;
import com.johnsnowlabs.nlp.llama.LlamaOutput;
import com.johnsnowlabs.nlp.llama.LogLevel;
import com.johnsnowlabs.nlp.llama.ModelParameters;
import com.johnsnowlabs.nlp.llama.args.LogFormat;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;

public class LlamaModel
implements AutoCloseable {
    private long ctx;

    public LlamaModel(ModelParameters modelParameters) {
        this.loadModel(modelParameters.toString());
    }

    public String complete(InferenceParameters inferenceParameters) {
        inferenceParameters.setStream(false);
        int n = this.requestCompletion(inferenceParameters.toString());
        LlamaOutput llamaOutput = this.receiveCompletion(n);
        return llamaOutput.text;
    }

    public LlamaIterable generate(InferenceParameters inferenceParameters) {
        return () -> new LlamaIterator(this, inferenceParameters);
    }

    public native int requestEmbedding(String var1);

    public native float[] receiveEmbedding(int var1);

    public native int[] encode(String var1);

    public String decode(int[] nArray) {
        byte[] byArray = this.decodeBytes(nArray);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    public static native void setLogger(LogFormat var0, BiConsumer<LogLevel, String> var1);

    public static native String applyChatTemplate(String var0, String[][] var1, boolean var2) throws LlamaException;

    @Override
    public void close() {
        this.delete();
    }

    native int requestCompletion(String var1) throws LlamaException;

    native LlamaOutput receiveCompletion(int var1) throws LlamaException;

    native void cancelCompletion(int var1);

    native byte[] decodeBytes(int[] var1);

    private native void loadModel(String var1) throws LlamaException;

    public native String getMetadata();

    public static native String getMetadataFromFile(String var0);

    private native void delete();

    public String[] requestBatchCompletion(String[] stringArray, InferenceParameters inferenceParameters) throws LlamaException {
        int n;
        int[] nArray = new int[stringArray.length];
        String[] stringArray2 = new String[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            inferenceParameters.setPrompt(stringArray[n]);
            inferenceParameters.setStream(false);
            nArray[n] = this.requestCompletion(inferenceParameters.toString());
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2[n] = this.receiveCompletion((int)nArray[n]).text;
        }
        return stringArray2;
    }

    public float[][] requestBatchEmbeddings(String[] stringArray) throws LlamaException {
        int n;
        int[] nArray = new int[stringArray.length];
        float[][] fArrayArray = new float[stringArray.length][];
        for (n = 0; n < stringArray.length; ++n) {
            nArray[n] = this.requestEmbedding(stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            fArrayArray[n] = this.receiveEmbedding(nArray[n]);
        }
        return fArrayArray;
    }

    public String[] requestBatchImageCompletion(String[] stringArray, String[] stringArray2, InferenceParameters inferenceParameters) throws LlamaException {
        int n;
        int[] nArray = new int[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            String string = "[img-" + n + "]" + stringArray[n];
            inferenceParameters.setPrompt(string);
            inferenceParameters.setImageData(stringArray2[n], n);
            inferenceParameters.setStream(false);
            nArray[n] = this.requestCompletion(inferenceParameters.toString());
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = this.receiveCompletion((int)nArray[n]).text;
        }
        return stringArray3;
    }

    static {
        LlamaLoader.initialize();
    }
}

