/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.llama;

import com.johnsnowlabs.nlp.llama.JsonParameters;
import com.johnsnowlabs.nlp.llama.args.GpuSplitMode;
import com.johnsnowlabs.nlp.llama.args.NumaStrategy;
import com.johnsnowlabs.nlp.llama.args.PoolingType;
import com.johnsnowlabs.nlp.llama.args.RopeScalingType;
import java.util.Map;

public final class ModelParameters
extends JsonParameters {
    private static final String PARAM_SEED = "seed";
    private static final String PARAM_N_THREADS = "n_threads";
    private static final String PARAM_N_THREADS_DRAFT = "n_threads_draft";
    private static final String PARAM_N_THREADS_BATCH = "n_threads_batch";
    private static final String PARAM_N_THREADS_BATCH_DRAFT = "n_threads_batch_draft";
    private static final String PARAM_N_PREDICT = "n_predict";
    private static final String PARAM_N_CTX = "n_ctx";
    private static final String PARAM_N_BATCH = "n_batch";
    private static final String PARAM_N_UBATCH = "n_ubatch";
    private static final String PARAM_N_KEEP = "n_keep";
    private static final String PARAM_N_DRAFT = "n_draft";
    private static final String PARAM_N_CHUNKS = "n_chunks";
    private static final String PARAM_N_PARALLEL = "n_parallel";
    private static final String PARAM_N_SEQUENCES = "n_sequences";
    private static final String PARAM_P_SPLIT = "p_split";
    private static final String PARAM_N_GPU_LAYERS = "n_gpu_layers";
    private static final String PARAM_N_GPU_LAYERS_DRAFT = "n_gpu_layers_draft";
    private static final String PARAM_SPLIT_MODE = "split_mode";
    private static final String PARAM_MAIN_GPU = "main_gpu";
    private static final String PARAM_TENSOR_SPLIT = "tensor_split";
    private static final String PARAM_GRP_ATTN_N = "grp_attn_n";
    private static final String PARAM_GRP_ATTN_W = "grp_attn_w";
    private static final String PARAM_ROPE_FREQ_BASE = "rope_freq_base";
    private static final String PARAM_ROPE_FREQ_SCALE = "rope_freq_scale";
    private static final String PARAM_YARN_EXT_FACTOR = "yarn_ext_factor";
    private static final String PARAM_YARN_ATTN_FACTOR = "yarn_attn_factor";
    private static final String PARAM_YARN_BETA_FAST = "yarn_beta_fast";
    private static final String PARAM_YARN_BETA_SLOW = "yarn_beta_slow";
    private static final String PARAM_YARN_ORIG_CTX = "yarn_orig_ctx";
    private static final String PARAM_DEFRAG_THOLD = "defrag_thold";
    private static final String PARAM_NUMA = "numa";
    private static final String PARAM_ROPE_SCALING_TYPE = "rope_scaling_type";
    private static final String PARAM_POOLING_TYPE = "pooling_type";
    private static final String PARAM_MODEL = "model";
    private static final String PARAM_MODEL_DRAFT = "model_draft";
    private static final String PARAM_MODEL_ALIAS = "model_alias";
    private static final String PARAM_MODEL_URL = "model_url";
    private static final String PARAM_HF_REPO = "hf_repo";
    private static final String PARAM_HF_FILE = "hf_file";
    private static final String PARAM_LOOKUP_CACHE_STATIC = "lookup_cache_static";
    private static final String PARAM_LOOKUP_CACHE_DYNAMIC = "lookup_cache_dynamic";
    private static final String PARAM_LORA_ADAPTER = "lora_adapter";
    private static final String PARAM_EMBEDDING = "embedding";
    private static final String PARAM_CONT_BATCHING = "cont_batching";
    private static final String PARAM_FLASH_ATTENTION = "flash_attn";
    private static final String PARAM_INPUT_PREFIX_BOS = "input_prefix_bos";
    private static final String PARAM_IGNORE_EOS = "ignore_eos";
    private static final String PARAM_USE_MMAP = "use_mmap";
    private static final String PARAM_USE_MLOCK = "use_mlock";
    private static final String PARAM_NO_KV_OFFLOAD = "no_kv_offload";
    private static final String PARAM_SYSTEM_PROMPT = "system_prompt";
    private static final String PARAM_CHAT_TEMPLATE = "chat_template";
    private static final String PARAM_MMPROJ = "mmproj";

    public ModelParameters setSeed(int n) {
        this.parameters.put(PARAM_SEED, String.valueOf(n));
        return this;
    }

    public ModelParameters setNThreads(int n) {
        this.parameters.put(PARAM_N_THREADS, String.valueOf(n));
        return this;
    }

    public ModelParameters setNThreadsDraft(int n) {
        this.parameters.put(PARAM_N_THREADS_DRAFT, String.valueOf(n));
        return this;
    }

    public ModelParameters setNThreadsBatch(int n) {
        this.parameters.put(PARAM_N_THREADS_BATCH, String.valueOf(n));
        return this;
    }

    public ModelParameters setNThreadsBatchDraft(int n) {
        this.parameters.put(PARAM_N_THREADS_BATCH_DRAFT, String.valueOf(n));
        return this;
    }

    public ModelParameters setNPredict(int n) {
        this.parameters.put(PARAM_N_PREDICT, String.valueOf(n));
        return this;
    }

    public ModelParameters setNCtx(int n) {
        this.parameters.put(PARAM_N_CTX, String.valueOf(n));
        return this;
    }

    public ModelParameters setNBatch(int n) {
        this.parameters.put(PARAM_N_BATCH, String.valueOf(n));
        return this;
    }

    public ModelParameters setNUbatch(int n) {
        this.parameters.put(PARAM_N_UBATCH, String.valueOf(n));
        return this;
    }

    public ModelParameters setNKeep(int n) {
        this.parameters.put(PARAM_N_KEEP, String.valueOf(n));
        return this;
    }

    public ModelParameters setNDraft(int n) {
        this.parameters.put(PARAM_N_DRAFT, String.valueOf(n));
        return this;
    }

    public ModelParameters setNChunks(int n) {
        this.parameters.put(PARAM_N_CHUNKS, String.valueOf(n));
        return this;
    }

    public ModelParameters setNParallel(int n) {
        this.parameters.put(PARAM_N_PARALLEL, String.valueOf(n));
        return this;
    }

    public ModelParameters setNSequences(int n) {
        this.parameters.put(PARAM_N_SEQUENCES, String.valueOf(n));
        return this;
    }

    public ModelParameters setPSplit(float f) {
        this.parameters.put(PARAM_P_SPLIT, String.valueOf(f));
        return this;
    }

    public ModelParameters setNGpuLayers(int n) {
        this.parameters.put(PARAM_N_GPU_LAYERS, String.valueOf(n));
        return this;
    }

    public ModelParameters setNGpuLayersDraft(int n) {
        this.parameters.put(PARAM_N_GPU_LAYERS_DRAFT, String.valueOf(n));
        return this;
    }

    public ModelParameters setSplitMode(GpuSplitMode gpuSplitMode) {
        this.parameters.put(PARAM_SPLIT_MODE, String.valueOf(gpuSplitMode.ordinal()));
        return this;
    }

    public ModelParameters setMainGpu(int n) {
        this.parameters.put(PARAM_MAIN_GPU, String.valueOf(n));
        return this;
    }

    public ModelParameters setTensorSplit(float[] fArray) {
        if (fArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            for (int i = 0; i < fArray.length; ++i) {
                stringBuilder.append(fArray[i]);
                if (i >= fArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
            this.parameters.put(PARAM_TENSOR_SPLIT, stringBuilder.toString());
        }
        return this;
    }

    public ModelParameters setGrpAttnN(int n) {
        this.parameters.put(PARAM_GRP_ATTN_N, String.valueOf(n));
        return this;
    }

    public ModelParameters setGrpAttnW(int n) {
        this.parameters.put(PARAM_GRP_ATTN_W, String.valueOf(n));
        return this;
    }

    public ModelParameters setRopeFreqBase(float f) {
        this.parameters.put(PARAM_ROPE_FREQ_BASE, String.valueOf(f));
        return this;
    }

    public ModelParameters setRopeFreqScale(float f) {
        this.parameters.put(PARAM_ROPE_FREQ_SCALE, String.valueOf(f));
        return this;
    }

    public ModelParameters setYarnExtFactor(float f) {
        this.parameters.put(PARAM_YARN_EXT_FACTOR, String.valueOf(f));
        return this;
    }

    public ModelParameters setYarnAttnFactor(float f) {
        this.parameters.put(PARAM_YARN_ATTN_FACTOR, String.valueOf(f));
        return this;
    }

    public ModelParameters setYarnBetaFast(float f) {
        this.parameters.put(PARAM_YARN_BETA_FAST, String.valueOf(f));
        return this;
    }

    public ModelParameters setYarnBetaSlow(float f) {
        this.parameters.put(PARAM_YARN_BETA_SLOW, String.valueOf(f));
        return this;
    }

    public ModelParameters setYarnOrigCtx(int n) {
        this.parameters.put(PARAM_YARN_ORIG_CTX, String.valueOf(n));
        return this;
    }

    public ModelParameters setDefragmentationThreshold(float f) {
        this.parameters.put(PARAM_DEFRAG_THOLD, String.valueOf(f));
        return this;
    }

    public ModelParameters setNuma(NumaStrategy numaStrategy) {
        this.parameters.put(PARAM_NUMA, String.valueOf(numaStrategy.ordinal()));
        return this;
    }

    public ModelParameters setRopeScalingType(RopeScalingType ropeScalingType) {
        this.parameters.put(PARAM_ROPE_SCALING_TYPE, String.valueOf(ropeScalingType.ordinal()));
        return this;
    }

    public ModelParameters setPoolingType(PoolingType poolingType) {
        this.parameters.put(PARAM_POOLING_TYPE, String.valueOf(poolingType.ordinal()));
        return this;
    }

    public ModelParameters setModelFilePath(String string) {
        this.parameters.put(PARAM_MODEL, this.toJsonString(string));
        return this;
    }

    public ModelParameters setModelDraft(String string) {
        this.parameters.put(PARAM_MODEL_DRAFT, this.toJsonString(string));
        return this;
    }

    public ModelParameters setModelAlias(String string) {
        this.parameters.put(PARAM_MODEL_ALIAS, this.toJsonString(string));
        return this;
    }

    public ModelParameters setModelUrl(String string) {
        this.parameters.put(PARAM_MODEL_URL, this.toJsonString(string));
        return this;
    }

    public ModelParameters setHuggingFaceRepository(String string) {
        this.parameters.put(PARAM_HF_REPO, this.toJsonString(string));
        return this;
    }

    public ModelParameters setHuggingFaceFile(String string) {
        this.parameters.put(PARAM_HF_FILE, this.toJsonString(string));
        return this;
    }

    public ModelParameters setLookupCacheStaticFilePath(String string) {
        this.parameters.put(PARAM_LOOKUP_CACHE_STATIC, this.toJsonString(string));
        return this;
    }

    public ModelParameters setLookupCacheDynamicFilePath(String string) {
        this.parameters.put(PARAM_LOOKUP_CACHE_DYNAMIC, this.toJsonString(string));
        return this;
    }

    public ModelParameters setLoraAdapters(Map<String, Float> map) {
        if (!map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            int n = 0;
            for (Map.Entry<String, Float> entry : map.entrySet()) {
                String string = entry.getKey();
                Float f = entry.getValue();
                stringBuilder.append(this.toJsonString(string)).append(": ").append(f);
                if (n++ >= map.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
            this.parameters.put(PARAM_LORA_ADAPTER, stringBuilder.toString());
        }
        return this;
    }

    public ModelParameters setEmbedding(boolean bl) {
        this.parameters.put(PARAM_EMBEDDING, String.valueOf(bl));
        return this;
    }

    public ModelParameters setContinuousBatching(boolean bl) {
        this.parameters.put(PARAM_CONT_BATCHING, String.valueOf(bl));
        return this;
    }

    public ModelParameters setFlashAttention(boolean bl) {
        this.parameters.put(PARAM_FLASH_ATTENTION, String.valueOf(bl));
        return this;
    }

    public ModelParameters setInputPrefixBos(boolean bl) {
        this.parameters.put(PARAM_INPUT_PREFIX_BOS, String.valueOf(bl));
        return this;
    }

    public ModelParameters setIgnoreEos(boolean bl) {
        this.parameters.put(PARAM_IGNORE_EOS, String.valueOf(bl));
        return this;
    }

    public ModelParameters setUseMmap(boolean bl) {
        this.parameters.put(PARAM_USE_MMAP, String.valueOf(bl));
        return this;
    }

    public ModelParameters setUseMlock(boolean bl) {
        this.parameters.put(PARAM_USE_MLOCK, String.valueOf(bl));
        return this;
    }

    public ModelParameters setNoKvOffload(boolean bl) {
        this.parameters.put(PARAM_NO_KV_OFFLOAD, String.valueOf(bl));
        return this;
    }

    public ModelParameters setSystemPrompt(String string) {
        this.parameters.put(PARAM_SYSTEM_PROMPT, this.toJsonString(string));
        return this;
    }

    public ModelParameters setChatTemplate(String string) {
        this.parameters.put(PARAM_CHAT_TEMPLATE, this.toJsonString(string));
        return this;
    }

    public ModelParameters setMMProj(String string) {
        this.parameters.put(PARAM_MMPROJ, this.toJsonString(string));
        return this;
    }
}

