/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.llama;

import com.johnsnowlabs.nlp.llama.ProcessRunner;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Locale;
import java.util.stream.Stream;

class OSInfo {
    public static final String X86 = "x86";
    public static final String X86_64 = "x86_64";
    public static final String IA64_32 = "ia64_32";
    public static final String IA64 = "ia64";
    public static final String PPC = "ppc";
    public static final String PPC64 = "ppc64";
    private static final ProcessRunner processRunner = new ProcessRunner();
    private static final HashMap<String, String> archMapping = new HashMap();

    OSInfo() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            if ("--os".equals(stringArray[0])) {
                System.out.print(OSInfo.getOSName());
                return;
            }
            if ("--arch".equals(stringArray[0])) {
                System.out.print(OSInfo.getArchName());
                return;
            }
        }
        System.out.print(OSInfo.getNativeLibFolderPathForCurrentOS());
    }

    static String getNativeLibFolderPathForCurrentOS() {
        return OSInfo.getOSName() + "/" + OSInfo.getArchName();
    }

    static String getOSName() {
        return OSInfo.translateOSNameToFolderName(System.getProperty("os.name"));
    }

    static boolean isAndroid() {
        return OSInfo.isAndroidRuntime() || OSInfo.isAndroidTermux();
    }

    static boolean isAndroidRuntime() {
        return System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
    }

    static boolean isAndroidTermux() {
        try {
            return processRunner.runAndWaitFor("uname -o").toLowerCase().contains("android");
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isMusl() {
        Path path2 = Paths.get("/proc/self/map_files", new String[0]);
        try (Stream<Path> stream = Files.list(path2);){
            boolean bl = stream.map(path -> {
                try {
                    return path.toRealPath(new LinkOption[0]).toString();
                }
                catch (IOException iOException) {
                    return "";
                }
            }).anyMatch(string -> string.toLowerCase().contains("musl"));
            return bl;
        }
        catch (Exception exception) {
            return OSInfo.isAlpineLinux();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isAlpineLinux() {
        try (Stream<String> stream = Files.lines(Paths.get("/etc/os-release", new String[0]));){
            boolean bl = stream.anyMatch(string -> string.startsWith("ID") && string.contains("alpine"));
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static String getHardwareName() {
        try {
            return processRunner.runAndWaitFor("uname -m");
        }
        catch (Throwable throwable) {
            System.err.println("Error while running uname -m: " + throwable.getMessage());
            return "unknown";
        }
    }

    static String resolveArmArchType() {
        if (System.getProperty("os.name").contains("Linux")) {
            String string = OSInfo.getHardwareName();
            if (OSInfo.isAndroid()) {
                if (string.startsWith("aarch64")) {
                    return "aarch64";
                }
                return "arm";
            }
            if (string.startsWith("armv6")) {
                return "armv6";
            }
            if (string.startsWith("armv7")) {
                return "armv7";
            }
            if (string.startsWith("armv5")) {
                return "arm";
            }
            if (string.startsWith("aarch64")) {
                return "aarch64";
            }
            String string2 = System.getProperty("sun.arch.abi");
            if (string2 != null && string2.startsWith("gnueabihf")) {
                return "armv7";
            }
            String string3 = System.getProperty("java.home");
            try {
                int n = Runtime.getRuntime().exec("which readelf").waitFor();
                if (n == 0) {
                    String[] stringArray = new String[]{"/bin/sh", "-c", "find '" + string3 + "' -name 'libjvm.so' | head -1 | xargs readelf -A | grep 'Tag_ABI_VFP_args: VFP registers'"};
                    n = Runtime.getRuntime().exec(stringArray).waitFor();
                    if (n == 0) {
                        return "armv7";
                    }
                } else {
                    System.err.println("WARNING! readelf not found. Cannot check if running on an armhf system, armel architecture will be presumed.");
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return "arm";
    }

    static String getArchName() {
        String string = System.getProperty("com.johnsnowlabs.nlp.llama.osinfo.architecture");
        if (string != null) {
            return string;
        }
        String string2 = System.getProperty("os.arch");
        if (string2.startsWith("arm")) {
            string2 = OSInfo.resolveArmArchType();
        } else {
            String string3 = string2.toLowerCase(Locale.US);
            if (archMapping.containsKey(string3)) {
                return archMapping.get(string3);
            }
        }
        return OSInfo.translateArchNameToFolderName(string2);
    }

    static String translateOSNameToFolderName(String string) {
        if (string.contains("Windows")) {
            return "Windows";
        }
        if (string.contains("Mac") || string.contains("Darwin")) {
            return "Mac";
        }
        if (string.contains("AIX")) {
            return "AIX";
        }
        if (OSInfo.isMusl()) {
            return "Linux-Musl";
        }
        if (OSInfo.isAndroid()) {
            return "Linux-Android";
        }
        if (string.contains("Linux")) {
            return "Linux";
        }
        return string.replaceAll("\\W", "");
    }

    static String translateArchNameToFolderName(String string) {
        return string.replaceAll("\\W", "");
    }

    static {
        archMapping.put(X86, X86);
        archMapping.put("i386", X86);
        archMapping.put("i486", X86);
        archMapping.put("i586", X86);
        archMapping.put("i686", X86);
        archMapping.put("pentium", X86);
        archMapping.put(X86_64, X86_64);
        archMapping.put("amd64", X86_64);
        archMapping.put("em64t", X86_64);
        archMapping.put("universal", X86_64);
        archMapping.put(IA64, IA64);
        archMapping.put("ia64w", IA64);
        archMapping.put(IA64_32, IA64_32);
        archMapping.put("ia64n", IA64_32);
        archMapping.put(PPC, PPC);
        archMapping.put("power", PPC);
        archMapping.put("powerpc", PPC);
        archMapping.put("power_pc", PPC);
        archMapping.put("power_rs", PPC);
        archMapping.put(PPC64, PPC64);
        archMapping.put("power64", PPC64);
        archMapping.put("powerpc64", PPC64);
        archMapping.put("power_pc64", PPC64);
        archMapping.put("power_rs64", PPC64);
        archMapping.put("ppc64el", PPC64);
        archMapping.put("ppc64le", PPC64);
    }
}

