/*
 * Decompiled with CFR 0.152.
 */
package org.intel.openvino;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.intel.openvino.Any;
import org.intel.openvino.CompiledModel;
import org.intel.openvino.Model;
import org.intel.openvino.Wrapper;

public class Core
extends Wrapper {
    private static final Logger logger = Logger.getLogger(Core.class.getName());

    public Core() {
        super(Core.GetCore());
    }

    public Core(String xmlConfigFile) {
        super(Core.GetCore1(xmlConfigFile));
    }

    public Model read_model(String modelPath) {
        return new Model(Core.ReadModel(this.nativeObj, modelPath));
    }

    public Model read_model(String modelPath, String weightPath) {
        return new Model(Core.ReadModel1(this.nativeObj, modelPath, weightPath));
    }

    public CompiledModel compile_model(String path) {
        return new CompiledModel(Core.CompileModel1(this.nativeObj, path));
    }

    public CompiledModel compile_model(String path, String device) {
        return new CompiledModel(Core.CompileModel2(this.nativeObj, path, device));
    }

    public CompiledModel compile_model(String path, String device, Map<String, String> properties) {
        return new CompiledModel(Core.CompileModel3(this.nativeObj, path, device, properties));
    }

    public CompiledModel compile_model(Model model, String device) {
        return new CompiledModel(Core.CompileModel(this.nativeObj, model.getNativeObjAddr(), device));
    }

    public CompiledModel compile_model(Model model, String device, Map<String, String> properties) {
        return new CompiledModel(Core.CompileModel4(this.nativeObj, model.getNativeObjAddr(), device, properties));
    }

    public Any get_property(String device, String name) {
        return new Any(Core.GetProperty(this.nativeObj, device, name));
    }

    public void set_property(String device, Map<String, String> prop) {
        Core.SetProperty(this.nativeObj, device, prop);
    }

    public List<String> get_available_devices() {
        return Core.GetAvailableDevices(this.nativeObj);
    }

    private static native long GetCore();

    private static native long GetCore1(String var0);

    private static native long ReadModel(long var0, String var2);

    private static native long ReadModel1(long var0, String var2, String var3);

    private static native long CompileModel(long var0, long var2, String var4);

    private static native long CompileModel1(long var0, String var2);

    private static native long CompileModel2(long var0, String var2, String var3);

    private static native long CompileModel4(long var0, long var2, String var4, Map<String, String> var5);

    private static native long CompileModel3(long var0, String var2, String var3, Map<String, String> var4);

    private static native long GetProperty(long var0, String var2, String var3);

    private static native void SetProperty(long var0, String var2, Map<String, String> var3);

    private static native List<String> GetAvailableDevices(long var0);

    @Override
    protected native void delete(long var1);
}

