/*
 * Decompiled with CFR 0.152.
 */
package org.intel.openvino;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;

public final class NativeLibrary {
    public static final String NATIVE_LIBRARY_NAME = "inference_engine_java_api";
    private static final Logger logger = Logger.getLogger(NativeLibrary.class.getName());

    private static String getLibraryName(String name, String linux_ver) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return name + ".dll";
        }
        if (osName.contains("mac")) {
            return "lib" + name + ".dylib";
        }
        name = "lib" + name + ".so";
        if (linux_ver != null) {
            name = name + "." + linux_ver;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNativeLibs() {
        String[] nativeLibs = new String[]{"tbb", "tbbmalloc", "openvino", NATIVE_LIBRARY_NAME};
        InputStream resources_list = null;
        try {
            String file;
            resources_list = NativeLibrary.class.getClassLoader().getResourceAsStream("resources_list.txt");
            BufferedReader r = new BufferedReader(new InputStreamReader(resources_list));
            File tmpDir = Files.createTempDirectory("openvino-native", new FileAttribute[0]).toFile();
            tmpDir.deleteOnExit();
            while ((file = r.readLine()) != null) {
                if (!file.chars().allMatch(c -> Character.isLetterOrDigit(c) || c == 46 || c == 95 || c == 45)) {
                    throw new IOException("Invalid file path: " + file);
                }
                URL url = NativeLibrary.class.getClassLoader().getResource(file);
                if (url == null) {
                    logger.warning("Resource not found: " + file);
                    continue;
                }
                File nativeLibTmpFile = new File(tmpDir, file);
                nativeLibTmpFile.deleteOnExit();
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    Files.copy(in, nativeLibTmpFile.toPath(), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            for (String lib : nativeLibs) {
                String version = lib.startsWith("tbb") || lib.equals("gna") ? "2" : null;
                lib = NativeLibrary.getLibraryName(lib, version);
                File nativeLibTmpFile = new File(tmpDir, lib);
                try {
                    System.load(nativeLibTmpFile.getAbsolutePath());
                }
                catch (UnsatisfiedLinkError ex) {
                    logger.warning("Failed to load library " + file + ": " + ex);
                }
            }
        }
        catch (IOException ex) {
            logger.warning("Failed to load native Inference Engine libraries: " + ex.getMessage());
        }
        finally {
            if (resources_list != null) {
                try {
                    resources_list.close();
                }
                catch (IOException ex) {
                    logger.warning("Failed to read native libraries list");
                }
            }
        }
    }

    static {
        try {
            System.loadLibrary(NATIVE_LIBRARY_NAME);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                NativeLibrary.loadNativeLibs();
            }
            catch (Exception ex) {
                logger.warning("Failed to load OpenVINO native libraries");
                throw ex;
            }
        }
    }
}

