/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.client.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.client.builder.AwsSyncClientBuilder;
import com.amazonaws.services.pi.model.InvalidArgumentException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.MultipleFileDownload;
import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.johnsnowlabs.client.CredentialParams;
import com.johnsnowlabs.client.aws.AWSGateway$;
import com.johnsnowlabs.client.aws.AWSTokenCredentials;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%b\u0001B\u0012%\u00015B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005u!A\u0001\n\u0001B\u0001B\u0003%!\b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003;\u0011!Q\u0005A!A!\u0002\u0013Q\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000b1\u0003A\u0011A'\t\u000fY\u0003!\u0019!C\t/\"1\u0001\r\u0001Q\u0001\naC\u0001b\n\u0001\t\u0006\u0004%\t!\u0019\u0005\u0006Y\u0002!I!\u001c\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002N\u0001!\t!a\u0014\t\u000f\u00055\u0003\u0001\"\u0001\u0002r!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\ty\u000b\u0001C\u0001\u0003cC\u0011\"!3\u0001#\u0003%\t!a3\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u00111\u001f\u0001\u0005\u0002\u0005U\bb\u0002B\u0004\u0001\u0011\u0005#\u0011B\u0004\n\u0005\u0017!\u0013\u0011!E\u0001\u0005\u001b1\u0001b\t\u0013\u0002\u0002#\u0005!q\u0002\u0005\u0007\u0019n!\tAa\u0006\t\u0013\te1$%A\u0005\u0002\tm\u0001\"\u0003B\u00107E\u0005I\u0011\u0001B\u000e\u0011%\u0011\tcGI\u0001\n\u0003\u0011Y\u0002C\u0005\u0003$m\t\n\u0011\"\u0001\u0003\u001c!I!QE\u000e\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005OY\u0012\u0013!C\u0001\u00057\u0011!\"Q,T\u000f\u0006$Xm^1z\u0015\t)c%A\u0002boNT!a\n\u0015\u0002\r\rd\u0017.\u001a8u\u0015\tI#&\u0001\u0007k_\"t7O\\8xY\u0006\u00147OC\u0001,\u0003\r\u0019w.\\\u0002\u0001'\r\u0001aF\u000e\t\u0003_Qj\u0011\u0001\r\u0006\u0003cI\nA\u0001\\1oO*\t1'\u0001\u0003kCZ\f\u0017BA\u001b1\u0005\u0019y%M[3diB\u0011qfN\u0005\u0003qA\u0012Q\"Q;u_\u000ecwn]3bE2,\u0017aC1dG\u0016\u001c8oS3z\u0013\u0012\u0004\"a\u000f#\u000f\u0005q\u0012\u0005CA\u001fA\u001b\u0005q$BA -\u0003\u0019a$o\\8u})\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\u00061\u0001K]3eK\u001aL!!\u0012$\u0003\rM#(/\u001b8h\u0015\t\u0019\u0005)A\btK\u000e\u0014X\r^!dG\u0016\u001c8oS3z\u00031\u0019Xm]:j_:$vn[3o\u0003)\two\u001d)s_\u001aLG.Z\u0001\u0007e\u0016<\u0017n\u001c8\u0002\u001f\r\u0014X\rZ3oi&\fGn\u001d+za\u0016\fa\u0001P5oSRtDc\u0002(Q#J\u001bF+\u0016\t\u0003\u001f\u0002i\u0011\u0001\n\u0005\bs\u001d\u0001\n\u00111\u0001;\u0011\u001d9u\u0001%AA\u0002iBq\u0001S\u0004\u0011\u0002\u0003\u0007!\bC\u0004J\u000fA\u0005\t\u0019\u0001\u001e\t\u000f);\u0001\u0013!a\u0001u!91j\u0002I\u0001\u0002\u0004Q\u0014A\u00027pO\u001e,'/F\u0001Y!\tIf,D\u0001[\u0015\tYF,A\u0003tY\u001a$$NC\u0001^\u0003\ry'oZ\u0005\u0003?j\u0013a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u000b\u0002EB\u00111M[\u0007\u0002I*\u0011QMZ\u0001\u0003gNR!a\u001a5\u0002\u0011M,'O^5dKNT!!\u001b\u0016\u0002\u0013\u0005l\u0017M_8oC^\u001c\u0018BA6e\u0005!\tU.\u0019>p]N\u001b\u0014!E4fi\u0006k\u0017M_8o'N\u001aE.[3oiR\u0011!M\u001c\u0005\u0006_.\u0001\r\u0001]\u0001\fGJ,G-\u001a8uS\u0006d7\u000fE\u0002reRl\u0011\u0001Q\u0005\u0003g\u0002\u0013aa\u00149uS>t\u0007CA;y\u001b\u00051(BA<i\u0003\u0011\tW\u000f\u001e5\n\u0005e4(AD!X'\u000e\u0013X\rZ3oi&\fGn]\u0001\fO\u0016$X*\u001a;bI\u0006$\u0018\rF\u0004}\u00037\ty\"a\t\u0011\u000bu\f)!a\u0003\u000f\u0007y\f\tA\u0004\u0002>\u007f&\t\u0011)C\u0002\u0002\u0004\u0001\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0005%!\u0001\u0002'jgRT1!a\u0001A!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t!\u0002\u001d:fiJ\f\u0017N\\3e\u0015\r\t)\u0002K\u0001\u0004]2\u0004\u0018\u0002BA\r\u0003\u001f\u0011\u0001CU3t_V\u00148-Z'fi\u0006$\u0017\r^1\t\r\u0005uA\u00021\u0001;\u0003\u0019\u00198\u0007U1uQ\"1\u0011\u0011\u0005\u0007A\u0002i\naAZ8mI\u0016\u0014\bBBA\u0013\u0019\u0001\u0007!(\u0001\u0004ck\u000e\\W\r^\u0001\nO\u0016$8k\r$jY\u0016$2AOA\u0016\u0011\u001d\ti#\u0004a\u0001\u0003_\tQ\u0001]1siN\u0004B!]A\u0019u%\u0019\u00111\u0007!\u0003\u0015q\u0012X\r]3bi\u0016$g(A\te_\u0016\u001c8kM(cU\u0016\u001cG/\u0012=jgR$b!!\u000f\u0002@\u0005\u0005\u0003cA9\u0002<%\u0019\u0011Q\b!\u0003\u000f\t{w\u000e\\3b]\"1\u0011Q\u0005\bA\u0002iBa!a\u0011\u000f\u0001\u0004Q\u0014AC:4\r&dW\rU1uQ\u0006\tBm\\3t'N2u\u000e\u001c3fe\u0016C\u0018n\u001d;\u0015\r\u0005e\u0012\u0011JA&\u0011\u0019\t)c\u0004a\u0001u!1\u00111I\bA\u0002i\n1bZ3u'Nz%M[3diRA\u0011\u0011KA/\u0003?\n\t\u0007\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9\u0006Z\u0001\u0006[>$W\r\\\u0005\u0005\u00037\n)F\u0001\bPE*,7\r^'fi\u0006$\u0017\r^1\t\r\u0005\u0015\u0002\u00031\u0001;\u0011\u0019\t\u0019\u0005\u0005a\u0001u!9\u00111\r\tA\u0002\u0005\u0015\u0014a\u0002;na\u001aKG.\u001a\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111\u000e\u001a\u0002\u0005%|\u0017\u0002BA8\u0003S\u0012AAR5mKR1\u00111OA=\u0003w\u0002B!a\u0015\u0002v%!\u0011qOA+\u0005!\u00196g\u00142kK\u000e$\bBBA\u0013#\u0001\u0007!\b\u0003\u0004\u0002DE\u0001\rAO\u0001\u0012O\u0016$8k\r#po:dw.\u00193TSj,GCCAA\u0003\u0013\u000bY)!$\u0002\u0012B!\u0011O]AB!\r\t\u0018QQ\u0005\u0004\u0003\u000f\u0003%\u0001\u0002'p]\u001eDa!!\b\u0013\u0001\u0004Q\u0004BBA\u0011%\u0001\u0007!\b\u0003\u0004\u0002\u0010J\u0001\rAO\u0001\tM&dWMT1nK\"1\u0011Q\u0005\nA\u0002i\nAbY8qs\u001aKG.\u001a+p'N\"\u0002\"a&\u0002\u001e\u0006}\u0015\u0011\u0015\t\u0005\u0003'\nI*\u0003\u0003\u0002\u001c\u0006U#a\u0004)vi>\u0013'.Z2u%\u0016\u001cX\u000f\u001c;\t\r\u0005\u00152\u00031\u0001;\u0011\u0019\t\u0019e\u0005a\u0001u!1\u00111U\nA\u0002i\nab]8ve\u000e,g)\u001b7f!\u0006$\b.A\nd_BL\u0018J\u001c9viN#(/Z1n)>\u001c6\u0007\u0006\u0005\u0002\u0018\u0006%\u00161VAW\u0011\u0019\t)\u0003\u0006a\u0001u!1\u00111\t\u000bA\u0002iBa!a)\u0015\u0001\u0004Q\u0014A\u00073po:dw.\u00193GS2,7O\u0012:p[\u0012K'/Z2u_JLHCCAZ\u0003s\u000bi,!1\u0002FB\u0019\u0011/!.\n\u0007\u0005]\u0006I\u0001\u0003V]&$\bBBA^+\u0001\u0007!(\u0001\u0006ck\u000e\\W\r\u001e(b[\u0016Da!a0\u0016\u0001\u0004Q\u0014!C6fsB\u0013XMZ5y\u0011\u001d\t\u0019-\u0006a\u0001\u0003K\nQ\u0002Z5sK\u000e$xN]=QCRD\u0007\"CAd+A\u0005\t\u0019AA\u001d\u0003\u001dI7/\u00138eKb\fA\u0005Z8x]2|\u0017\r\u001a$jY\u0016\u001chI]8n\t&\u0014Xm\u0019;pef$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u001bTC!!\u000f\u0002P.\u0012\u0011\u0011\u001b\t\u0005\u0003'\fi.\u0004\u0002\u0002V*!\u0011q[Am\u0003%)hn\u00195fG.,GMC\u0002\u0002\\\u0002\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty.!6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\txC&$hi\u001c:D_6\u0004H.\u001a;j_:$B!a-\u0002f\"9\u0011q]\fA\u0002\u0005%\u0018\u0001\u0003;sC:\u001ch-\u001a:\u0011\t\u0005-\u0018q^\u0007\u0003\u0003[T1!a:e\u0013\u0011\t\t0!<\u0003\u0011Q\u0013\u0018M\\:gKJ\f1\u0002\\5tiN\u001bd)\u001b7fgR1\u0011q\u001fB\u0002\u0005\u000b\u0001R!]A}\u0003{L1!a?A\u0005\u0015\t%O]1z!\u0011\t\u0019&a@\n\t\t\u0005\u0011Q\u000b\u0002\u0010'Nz%M[3diN+X.\\1ss\"1\u0011Q\u0005\rA\u0002iBa!!\b\u0019\u0001\u0004Q\u0014!B2m_N,GCAAZ\u0003)\tukU$bi\u0016<\u0018-\u001f\t\u0003\u001fn\u00192a\u0007B\t!\r\t(1C\u0005\u0004\u0005+\u0001%AB!osJ+g\r\u0006\u0002\u0003\u000e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"A!\b+\u0007i\ny-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY\u0002")
public class AWSGateway
implements AutoCloseable {
    private AmazonS3 client;
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final String awsProfile;
    private final String region;
    private final String credentialsType;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$6() {
        return AWSGateway$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return AWSGateway$.MODULE$.$lessinit$greater$default$5();
    }

    public static String $lessinit$greater$default$4() {
        return AWSGateway$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return AWSGateway$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return AWSGateway$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return AWSGateway$.MODULE$.$lessinit$greater$default$1();
    }

    public Logger logger() {
        return this.logger;
    }

    private AmazonS3 client$lzycompute() {
        block7: {
            AWSGateway aWSGateway = this;
            synchronized (aWSGateway) {
                CredentialParams credentialParams;
                block9: {
                    block8: {
                        if (this.bitmap$0) break block7;
                        if (this.region.isEmpty() || this.region == null) {
                            throw new InvalidArgumentException("Region argument is mandatory to create Amazon S3 client.");
                        }
                        credentialParams = new CredentialParams(this.accessKeyId, this.secretAccessKey, this.sessionToken, this.awsProfile, this.region);
                        String string = this.credentialsType;
                        String string2 = "public";
                        if (!(string == null ? string2 != null : !string.equals(string2))) break block8;
                        String string3 = this.credentialsType;
                        String string4 = "community";
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block9;
                    }
                    credentialParams = new CredentialParams("anonymous", "", "", "", this.region);
                }
                AWSTokenCredentials awsCredentials = new AWSTokenCredentials();
                Option<AWSCredentials> credentials = awsCredentials.buildCredentials(credentialParams);
                this.client = this.getAmazonS3Client(credentials);
                this.bitmap$0 = true;
            }
        }
        return this.client;
    }

    public AmazonS3 client() {
        return !this.bitmap$0 ? this.client$lzycompute() : this.client;
    }

    private AmazonS3 getAmazonS3Client(Option<AWSCredentials> credentials) {
        AmazonS3ClientBuilder amazonS3ClientBuilder;
        ClientConfiguration config = new ClientConfiguration();
        int timeout = ConfigLoader$.MODULE$.getConfigIntValue(ConfigHelper$.MODULE$.s3SocketTimeout());
        config.setSocketTimeout(timeout);
        if (credentials.isDefined()) {
            amazonS3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials.get())).withClientConfiguration(config);
        } else {
            String warning_message = "Unable to build AWS credential via AWSGateway chain, some parameter is missing or malformed. S3 integration may not work well.";
            this.logger().warn(warning_message);
            amazonS3ClientBuilder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(config);
        }
        AmazonS3ClientBuilder s3Client = amazonS3ClientBuilder;
        return (AmazonS3)((AwsSyncClientBuilder)s3Client.withRegion(this.region)).build();
    }

    public List<ResourceMetadata> getMetadata(String s3Path, String folder, String bucket) {
        String metaFile = this.getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s3Path, folder, "metadata.json"}));
        S3Object obj = this.client().getObject(bucket, metaFile);
        List<ResourceMetadata> metadata = ResourceMetadata$.MODULE$.readResources((InputStream)obj.getObjectContent());
        return metadata;
    }

    public String getS3File(Seq<String> parts) {
        return ((TraversableOnce)((TraversableLike)parts.map((Function1 & Serializable & scala.Serializable)part -> new StringOps(Predef$.MODULE$.augmentString(part)).stripSuffix("/"), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)part -> BoxesRunTime.boxToBoolean((boolean)AWSGateway.$anonfun$getS3File$2(part)))).mkString("/");
    }

    public boolean doesS3ObjectExist(String bucket, String s3FilePath) {
        boolean bl;
        try {
            this.client().getObjectMetadata(bucket, s3FilePath);
            bl = true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AmazonServiceException) {
                AmazonServiceException amazonServiceException = (AmazonServiceException)throwable2;
                if (amazonServiceException.getStatusCode() != 404) {
                    throw amazonServiceException;
                }
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable unexpectedException = (Throwable)option.get();
                    String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
                    throw new Exception(new StringBuilder(23).append("Unexpected error in ").append(this.getClass().getName()).append(".").append(methodName).append(": ").append(unexpectedException).toString());
                }
                throw throwable;
            }
            boolean bl2 = false;
            bl = bl2;
        }
        return bl;
    }

    public boolean doesS3FolderExist(String bucket, String s3FilePath) {
        boolean bl;
        block7: {
            try {
                ListObjectsV2Result listObjects = this.client().listObjectsV2(bucket, s3FilePath);
                if (listObjects.getObjectSummaries().size() > 0) {
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AmazonServiceException) {
                    AmazonServiceException amazonServiceException = (AmazonServiceException)throwable2;
                    if (amazonServiceException.getStatusCode() != 404) {
                        throw amazonServiceException;
                    }
                } else {
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable unexpectedException = (Throwable)option.get();
                        String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
                        throw new Exception(new StringBuilder(23).append("Unexpected error in ").append(this.getClass().getName()).append(".").append(methodName).append(": ").append(unexpectedException).toString());
                    }
                    throw throwable;
                }
                boolean bl2 = false;
                bl = bl2;
            }
        }
        return bl;
    }

    public ObjectMetadata getS3Object(String bucket, String s3FilePath, File tmpFile) {
        GetObjectRequest req = new GetObjectRequest(bucket, s3FilePath);
        return this.client().getObject(req, tmpFile);
    }

    /*
     * WARNING - void declaration
     */
    public S3Object getS3Object(String bucket, String s3FilePath) {
        void var3_3;
        S3Object s3Object = this.client().getObject(bucket, s3FilePath);
        return var3_3;
    }

    public Option<Object> getS3DownloadSize(String s3Path, String folder, String fileName, String bucket) {
        None$ none$;
        try {
            String s3FilePath = this.getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{s3Path, folder, fileName}));
            ObjectMetadata meta = this.client().getObjectMetadata(bucket, s3FilePath);
            none$ = new Some((Object)BoxesRunTime.boxToLong((long)meta.getContentLength()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AmazonServiceException) {
                AmazonServiceException amazonServiceException = (AmazonServiceException)throwable2;
                if (amazonServiceException.getStatusCode() != 404) {
                    throw amazonServiceException;
                }
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable unexpectedException = (Throwable)option.get();
                    String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
                    throw new Exception(new StringBuilder(23).append("Unexpected error in ").append(this.getClass().getName()).append(".").append(methodName).append(": ").append(unexpectedException).toString());
                }
                throw throwable;
            }
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    public PutObjectResult copyFileToS3(String bucket, String s3FilePath, String sourceFilePath) {
        File sourceFile = new File(new StringBuilder(7).append("file://").append(sourceFilePath).toString());
        return this.client().putObject(bucket, s3FilePath, sourceFile);
    }

    public PutObjectResult copyInputStreamToS3(String bucket, String s3FilePath, String sourceFilePath) {
        FileSystem fileSystem = FileSystem.get((Configuration)ResourceHelper$.MODULE$.spark().sparkContext().hadoopConfiguration());
        FSDataInputStream inputStream = fileSystem.open(new Path(sourceFilePath));
        return this.client().putObject(bucket, s3FilePath, (InputStream)inputStream, new ObjectMetadata());
    }

    public void downloadFilesFromDirectory(String bucketName, String keyPrefix, File directoryPath, boolean isIndex) {
        block2: {
            TransferManager transferManager = TransferManagerBuilder.standard().withS3Client(this.client()).build();
            try {
                MultipleFileDownload multipleFileDownload = transferManager.downloadDirectory(bucketName, keyPrefix, directoryPath);
                Predef$.MODULE$.println((Object)multipleFileDownload.getDescription());
                this.waitForCompletion((Transfer)multipleFileDownload);
            }
            catch (AmazonServiceException e) {
                throw new AmazonServiceException(new StringBuilder(63).append("Amazon service error when downloading files from S3 directory: ").append(e.getMessage()).toString());
            }
            transferManager.shutdownNow();
            if (!isIndex) break block2;
            String keySuffix = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyPrefix.split("/"))).tail())).mkString("/");
            AWSGateway.renameFiles$1(directoryPath, keySuffix, directoryPath, keyPrefix);
            AWSGateway.removeAllFolders$1(directoryPath);
        }
    }

    public boolean downloadFilesFromDirectory$default$4() {
        return false;
    }

    private void waitForCompletion(Transfer transfer) {
        try {
            transfer.waitForCompletion();
        }
        catch (AmazonServiceException e) {
            throw new AmazonServiceException(new StringBuilder(22).append("Amazon service error: ").append(e.getMessage()).toString());
        }
        catch (AmazonClientException e) {
            throw new AmazonClientException(new StringBuilder(21).append("Amazon client error: ").append(e.getMessage()).toString());
        }
        catch (InterruptedException e) {
            throw new InterruptedException(new StringBuilder(22).append("Transfer interrupted: ").append(e.getMessage()).toString());
        }
    }

    public S3ObjectSummary[] listS3Files(String bucket, String s3Path) {
        S3ObjectSummary[] s3ObjectSummaryArray;
        try {
            ListObjectsV2Result listObjects = this.client().listObjectsV2(bucket, s3Path);
            s3ObjectSummaryArray = (S3ObjectSummary[])((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(listObjects.getObjectSummaries()).asScala()).toArray(ClassTag$.MODULE$.apply(S3ObjectSummary.class));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof AmazonServiceException) {
                AmazonServiceException amazonServiceException = (AmazonServiceException)throwable2;
                throw new AmazonServiceException(new StringBuilder(22).append("Amazon service error: ").append(amazonServiceException.getMessage()).toString());
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable unexpectedException = (Throwable)option.get();
                String methodName = Thread.currentThread().getStackTrace()[1].getMethodName();
                throw new Exception(new StringBuilder(23).append("Unexpected error in ").append(this.getClass().getName()).append(".").append(methodName).append(": ").append(unexpectedException).toString());
            }
            throw throwable;
        }
        return s3ObjectSummaryArray;
    }

    @Override
    public void close() {
        this.client().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$getS3File$2(String part) {
        return new StringOps(Predef$.MODULE$.augmentString(part)).nonEmpty();
    }

    private static final void renameFiles$1(File directory, String keySuffix, File directoryPath$1, String keyPrefix$1) {
        File[] downloadedFiles = directory.listFiles();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])downloadedFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Object object;
            if (file.isDirectory()) {
                File subDirectory = new File(directory, file.getName());
                String subKeySuffix = file.getName();
                AWSGateway.renameFiles$1(subDirectory, subKeySuffix, directoryPath$1, keyPrefix$1);
                object = BoxedUnit.UNIT;
            } else {
                String fileName = file.getName();
                String newFilePath = new File(directoryPath$1, new StringOps(Predef$.MODULE$.augmentString(fileName)).stripPrefix(keyPrefix$1)).getPath();
                object = BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(newFilePath)));
            }
            return object;
        });
    }

    private static final void removeAllFolders$1(File directoryPath) {
        File[] files = directoryPath.listFiles();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Object object;
            if (file.isDirectory()) {
                AWSGateway.removeAllFolders$1(file);
                object = BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public AWSGateway(String accessKeyId, String secretAccessKey, String sessionToken, String awsProfile, String region, String credentialsType) {
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.sessionToken = sessionToken;
        this.awsProfile = awsProfile;
        this.region = region;
        this.credentialsType = credentialsType;
        this.logger = LoggerFactory.getLogger((String)this.getClass().toString());
    }
}

