/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.client.gcp;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.johnsnowlabs.client.gcp.GCPGateway$;
import java.io.InputStream;
import org.sparkproject.guava.collect.Iterables;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4AAC\u0006\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006\u0003\u0005-\u0001!\u0015\r\u0011\"\u0003.\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015Y\u0005\u0001\"\u0001M\u000f\u001d\u00196\"!A\t\u0002Q3qAC\u0006\u0002\u0002#\u0005Q\u000bC\u0003(\u000f\u0011\u0005a\u000bC\u0004X\u000fE\u0005I\u0011\u0001-\u0003\u0015\u001d\u001b\u0005kR1uK^\f\u0017P\u0003\u0002\r\u001b\u0005\u0019qm\u00199\u000b\u00059y\u0011AB2mS\u0016tGO\u0003\u0002\u0011#\u0005a!n\u001c5og:|w\u000f\\1cg*\t!#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\f\u0011\u0002\u001d:pU\u0016\u001cG/\u00133\u0011\u0005u!cB\u0001\u0010#!\tyr#D\u0001!\u0015\t\t3#\u0001\u0004=e>|GOP\u0005\u0003G]\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111eF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%Z\u0003C\u0001\u0016\u0001\u001b\u0005Y\u0001bB\u000e\u0003!\u0003\u0005\r\u0001H\u0001\u000egR|'/Y4f\u00072LWM\u001c;\u0016\u00039\u0002\"a\f\u001c\u000e\u0003AR!!\r\u001a\u0002\u000fM$xN]1hK*\u00111\u0007N\u0001\u0006G2|W\u000f\u001a\u0006\u0003kE\taaZ8pO2,\u0017BA\u001c1\u0005\u001d\u0019Fo\u001c:bO\u0016\fAcY8qs\u001aKG.\u001a+p\u000f\u000e\u00036\u000b^8sC\u001e,G\u0003\u0002\u001e>\u007f\u0005\u0003\"AF\u001e\n\u0005q:\"\u0001B+oSRDQA\u0010\u0003A\u0002q\taAY;dW\u0016$\b\"\u0002!\u0005\u0001\u0004a\u0012!\u00073fgRLg.\u0019;j_:<5\tU*u_J\fw-\u001a)bi\"DQA\u0011\u0003A\u0002\r\u000b1\"\u001b8qkR\u001cFO]3b[B\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0003S>T\u0011\u0001S\u0001\u0005U\u00064\u0018-\u0003\u0002K\u000b\nY\u0011J\u001c9viN#(/Z1n\u0003=!w.Z:G_2$WM]#ySN$HcA'Q#B\u0011aCT\u0005\u0003\u001f^\u0011qAQ8pY\u0016\fg\u000eC\u0003?\u000b\u0001\u0007A\u0004C\u0003S\u000b\u0001\u0007A$\u0001\u0004qe\u00164\u0017\u000e_\u0001\u000b\u000f\u000e\u0003v)\u0019;fo\u0006L\bC\u0001\u0016\b'\t9Q\u0003F\u0001U\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0011L\u000b\u0002\u001d5.\n1\f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003A^\t!\"\u00198o_R\fG/[8o\u0013\t\u0011WLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class GCPGateway {
    private Storage storageClient;
    private final String projectId;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$1() {
        return GCPGateway$.MODULE$.$lessinit$greater$default$1();
    }

    private Storage storageClient$lzycompute() {
        GCPGateway gCPGateway = this;
        synchronized (gCPGateway) {
            if (!this.bitmap$0) {
                if (this.projectId == null || this.projectId.isEmpty()) {
                    throw new UnsupportedOperationException("projectId argument is mandatory to create GCP Storage client.");
                }
                this.storageClient = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).build().getService();
                this.bitmap$0 = true;
            }
        }
        return this.storageClient;
    }

    private Storage storageClient() {
        return !this.bitmap$0 ? this.storageClient$lzycompute() : this.storageClient;
    }

    public void copyFileToGCPStorage(String bucket, String destinationGCPStoragePath, InputStream inputStream) {
        BlobId blobId = BlobId.of((String)bucket, (String)destinationGCPStoragePath);
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).build();
        this.storageClient().createFrom(blobInfo, inputStream, new Storage.BlobWriteOption[0]);
    }

    public boolean doesFolderExist(String bucket, String prefix) {
        Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).build().getService();
        Page blobs = storage.list(bucket, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix), Storage.BlobListOption.currentDirectory()});
        int blobsSize = Iterables.size((Iterable)blobs.iterateAll());
        return blobsSize > 0;
    }

    public GCPGateway(String projectId) {
        this.projectId = projectId;
    }
}

