/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.ner.dl;

import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.SparkFiles$;
import org.apache.spark.sql.SparkSession;
import org.tensorflow.TensorFlow;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;

public final class LoadsContrib$ {
    public static LoadsContrib$ MODULE$;
    private String lib1;
    private String lib2;
    private Option<Tuple2<String, String>> contribPaths;
    private transient boolean loadedToCluster;
    private transient boolean loadedToTensorflow;
    private volatile byte bitmap$0;

    static {
        new LoadsContrib$();
    }

    public boolean loadedToCluster() {
        return this.loadedToCluster;
    }

    public void loadedToCluster_$eq(boolean x$1) {
        this.loadedToCluster = x$1;
    }

    public boolean loadedToTensorflow() {
        return this.loadedToTensorflow;
    }

    public void loadedToTensorflow_$eq(boolean x$1) {
        this.loadedToTensorflow = x$1;
    }

    private String lib1$lzycompute() {
        LoadsContrib$ loadsContrib$ = this;
        synchronized (loadsContrib$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.lib1 = "_sparse_feature_cross_op.so";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.lib1;
    }

    private String lib1() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.lib1$lzycompute() : this.lib1;
    }

    private String lib2$lzycompute() {
        LoadsContrib$ loadsContrib$ = this;
        synchronized (loadsContrib$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.lib2 = "_lstm_ops.so";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.lib2;
    }

    private String lib2() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.lib2$lzycompute() : this.lib2;
    }

    private String resourcePath(String os, String lib) {
        return new StringBuilder(8).append("ner-dl/").append(os).append("/").append(lib).toString();
    }

    private Option<Tuple2<String, String>> contribPaths$lzycompute() {
        LoadsContrib$ loadsContrib$ = this;
        synchronized (loadsContrib$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.contribPaths = SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_MAC_OSX ? None$.MODULE$ : (SystemUtils.IS_OS_WINDOWS ? None$.MODULE$ : None$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.contribPaths;
    }

    public Option<Tuple2<String, String>> contribPaths() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.contribPaths$lzycompute() : this.contribPaths;
    }

    private String getFileName(String path) {
        return new StringBuilder(16).append("sparknlp_contrib").append(new StringOps(Predef$.MODULE$.augmentString(new File(path).getName())).take(5)).toString();
    }

    private File copyResourceToTmp(String path) {
        InputStream stream = ResourceHelper$.MODULE$.getResourceStream(path);
        String tmpFolder = System.getProperty("java.io.tmpdir");
        File tmp = Paths.get(tmpFolder, this.getFileName(path)).toFile();
        BufferedOutputStream target = new BufferedOutputStream(new FileOutputStream(tmp));
        byte[] buffer = new byte[8192];
        int read = stream.read(buffer);
        while (read > 0) {
            target.write(buffer, 0, read);
            read = stream.read(buffer);
        }
        stream.close();
        target.close();
        return tmp;
    }

    public void loadContribToCluster(SparkSession spark) {
        block0: {
            if (this.loadedToCluster() || !this.contribPaths().isDefined()) break block0;
            this.loadedToCluster_$eq(true);
            spark.sparkContext().addFile(this.copyResourceToTmp((String)((Tuple2)this.contribPaths().get())._1()).getPath());
            spark.sparkContext().addFile(this.copyResourceToTmp((String)((Tuple2)this.contribPaths().get())._2()).getPath());
        }
    }

    public void loadContribToTensorflow() {
        block1: {
            if (this.loadedToTensorflow() || !this.contribPaths().isDefined()) break block1;
            this.loadedToTensorflow_$eq(true);
            String fp1 = SparkFiles$.MODULE$.get(this.getFileName((String)((Tuple2)this.contribPaths().get())._1()));
            String fp2 = SparkFiles$.MODULE$.get(this.getFileName((String)((Tuple2)this.contribPaths().get())._2()));
            if (new File(fp1).exists() && new File(fp2).exists()) {
                TensorFlow.loadLibrary((String)fp1);
                TensorFlow.loadLibrary((String)fp2);
            }
        }
    }

    private LoadsContrib$() {
        MODULE$ = this;
        this.loadedToCluster = false;
        this.loadedToTensorflow = false;
    }
}

