/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep.feature;

import com.johnsnowlabs.nlp.annotators.parser.typdep.DependencyInstance;
import com.johnsnowlabs.nlp.annotators.parser.typdep.LowRankTensor;
import com.johnsnowlabs.nlp.annotators.parser.typdep.Parameters;
import com.johnsnowlabs.nlp.annotators.parser.typdep.feature.FeatureTemplate;
import com.johnsnowlabs.nlp.annotators.parser.typdep.feature.LazyCollector;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.Alphabet;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.Collector;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.FeatureVector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntacticFeatureFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LoggerFactory.getLogger((String)"TypedDependencyParser");
    private static final int BITS = 30;
    private int tokenStart = 1;
    private int tokenEnd = 2;
    private int tokenMid = 3;
    private int tagNumBits;
    private int wordNumBits;
    private int depNumBits;
    private int flagBits;
    private int numberLabeledArcFeatures = 0xFFFFFFF;
    private int numberWordFeatures = 0;
    private boolean stoppedGrowth = false;
    private transient HashSet<Long> featureHashSet;
    private Alphabet wordAlphabet = new Alphabet();
    static final int C1 = -862048943;
    static final int C2 = 461845907;

    public void setTokenStart(int n) {
        this.tokenStart = n;
    }

    public void setTokenEnd(int n) {
        this.tokenEnd = n;
    }

    public void setTokenMid(int n) {
        this.tokenMid = n;
    }

    public int getTagNumBits() {
        return this.tagNumBits;
    }

    public void setTagNumBits(int n) {
        this.tagNumBits = n;
    }

    public int getWordNumBits() {
        return this.wordNumBits;
    }

    public void setWordNumBits(int n) {
        this.wordNumBits = n;
    }

    public int getDepNumBits() {
        return this.depNumBits;
    }

    public void setDepNumBits(int n) {
        this.depNumBits = n;
    }

    public int getFlagBits() {
        return this.flagBits;
    }

    public void setFlagBits(int n) {
        this.flagBits = n;
    }

    public int getNumberLabeledArcFeatures() {
        return this.numberLabeledArcFeatures;
    }

    public int getNumberWordFeatures() {
        return this.numberWordFeatures;
    }

    public SyntacticFeatureFactory() {
        this.featureHashSet = new HashSet(100000);
    }

    public void closeAlphabets() {
        this.wordAlphabet.stopGrowth();
        this.stoppedGrowth = true;
    }

    public void checkCollisions() {
        Long[] longArray = (Long[])Arrays.copyOf(this.featureHashSet.toArray(), this.featureHashSet.toArray().length, Long[].class);
        int n = longArray.length;
        int n2 = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Long[] longArray2 = longArray;
        int n3 = longArray2.length;
        for (int i = 0; i < n3; ++i) {
            long l = longArray2[i];
            int n4 = this.hashcode2int(l) & this.numberLabeledArcFeatures;
            if (hashSet.contains(n4)) {
                ++n2;
                continue;
            }
            hashSet.add(n4);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Hash collision: %.4f%% (%d / %d)%n", (double)n2 / ((double)n + 1.0E-30) * 100.0, n2, n));
        }
    }

    private final int hashcode2int(long l) {
        int n = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        int n2 = (int)(l >>> 32);
        int n3 = 0;
        n *= -862048943;
        n = this.rotl32(n, 15, 17);
        n3 ^= (n *= 461845907);
        n3 = this.rotl32(n3, 13, 19);
        n3 = n3 * 5 + -430675100;
        n2 *= -862048943;
        n2 = this.rotl32(n2, 15, 17);
        n3 ^= (n2 *= 461845907);
        n3 = this.rotl32(n3, 13, 19);
        n3 = n3 * 5 + -430675100;
        n3 ^= n3 >> 16;
        n3 *= -2048144789;
        n3 ^= n3 >> 13;
        n3 *= -1028477387;
        n3 ^= n3 >> 16;
        return n3;
    }

    private final int rotl32(int n, int n2, int n3) {
        return n << n2 | n >>> n3;
    }

    private void addLabeledArcFeature(long l, Collector collector) {
        int n = this.hashcode2int(l) & this.numberLabeledArcFeatures;
        collector.addEntry(n);
        if (!this.stoppedGrowth) {
            this.featureHashSet.add(l);
        }
    }

    public void initFeatureAlphabets(DependencyInstance dependencyInstance) {
        int n;
        LazyCollector lazyCollector = new LazyCollector();
        int n2 = dependencyInstance.getLength();
        for (n = 0; n < n2; ++n) {
            this.createWordFeatures(dependencyInstance, n);
        }
        for (n = 1; n < n2; ++n) {
            this.createLabelFeatures(lazyCollector, dependencyInstance, dependencyInstance.getHeads(), dependencyInstance.getDependencyLabelIds(), n, 0);
        }
    }

    public FeatureVector createWordFeatures(DependencyInstance dependencyInstance, int n) {
        int[][] nArray;
        int[] nArray2 = dependencyInstance.getUPosTagIds();
        int[] nArray3 = dependencyInstance.getXPosTagIds();
        int[] nArray4 = dependencyInstance.getFormIds();
        int[] nArray5 = dependencyInstance.getLemmaIds();
        int n2 = nArray2[n];
        int n3 = n > 0 ? nArray2[n - 1] : this.tokenStart;
        int n4 = n < nArray2.length - 1 ? nArray2[n + 1] : this.tokenEnd;
        int n5 = nArray3[n];
        int n6 = n > 0 ? nArray3[n - 1] : this.tokenStart;
        int n7 = n < nArray3.length - 1 ? nArray3[n + 1] : this.tokenEnd;
        int n8 = nArray4[n];
        int n9 = n == 0 ? this.tokenStart : nArray4[n - 1];
        int n10 = n == dependencyInstance.getLength() - 1 ? this.tokenEnd : nArray4[n + 1];
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        if (nArray5 != null) {
            n11 = nArray5[n];
            n12 = n == 0 ? this.tokenStart : nArray5[n - 1];
            n13 = n == dependencyInstance.getLength() - 1 ? this.tokenEnd : nArray5[n + 1];
        }
        FeatureVector featureVector = new FeatureVector();
        long l = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, n8);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeW(FeatureTemplate.Word.WORDFV_Wp, n9);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeW(FeatureTemplate.Word.WORDFV_Wn, n10);
        this.addWordFeature(l, featureVector);
        if (n11 != 0) {
            l = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, n11);
            this.addWordFeature(l, featureVector);
            l = this.createWordCodeW(FeatureTemplate.Word.WORDFV_Wp, n12);
            this.addWordFeature(l, featureVector);
            l = this.createWordCodeW(FeatureTemplate.Word.WORDFV_Wn, n13);
            this.addWordFeature(l, featureVector);
        }
        l = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, n2);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeP(FeatureTemplate.Word.WORDFV_Pp, n3);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeP(FeatureTemplate.Word.WORDFV_Pn, n4);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, n5);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeP(FeatureTemplate.Word.WORDFV_Pp, n6);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeP(FeatureTemplate.Word.WORDFV_Pn, n7);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, n3, n2);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, n2, n4);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpPn, n3, n4);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodePPP(FeatureTemplate.Word.WORDFV_PpP0Pn, n3, n2, n4);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, n6, n5);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, n5, n7);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpPn, n6, n7);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodePPP(FeatureTemplate.Word.WORDFV_PpP0Pn, n6, n5, n7);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, n8, n2);
        this.addWordFeature(l, featureVector);
        l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, n8, n5);
        this.addWordFeature(l, featureVector);
        if (n11 != 0) {
            l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, n11, n2);
            this.addWordFeature(l, featureVector);
            l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, n11, n5);
            this.addWordFeature(l, featureVector);
            l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0Pp, n11, n6);
            this.addWordFeature(l, featureVector);
            l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0Pn, n11, n7);
            this.addWordFeature(l, featureVector);
            l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_WpPp, n12, n6);
            this.addWordFeature(l, featureVector);
            l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_WnPn, n13, n7);
            this.addWordFeature(l, featureVector);
        }
        if ((nArray = dependencyInstance.getFeatIds())[n] != null) {
            for (int i = 0; i < nArray[n].length; ++i) {
                int n14 = nArray[n][i];
                l = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, n14);
                this.addWordFeature(l, featureVector);
                if (n11 == 0) continue;
                l = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, n11, n14);
                this.addWordFeature(l, featureVector);
            }
        }
        return featureVector;
    }

    private void addWordFeature(long l, FeatureVector featureVector) {
        int n = this.wordAlphabet.lookupIndex(l, this.numberWordFeatures);
        if (n >= 0) {
            featureVector.addEntry(n);
            if (n == this.numberWordFeatures) {
                ++this.numberWordFeatures;
            }
        }
    }

    private void addWordFeature(long l, float f, FeatureVector featureVector) {
        int n = this.wordAlphabet.lookupIndex(l, this.numberWordFeatures);
        if (n >= 0) {
            featureVector.addEntry(n, f);
            if (n == this.numberWordFeatures) {
                ++this.numberWordFeatures;
            }
        }
    }

    public void createLabelFeatures(Collector collector, DependencyInstance dependencyInstance, int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = nArray[n];
        int n4 = nArray2[n];
        if (n2 != 2) {
            this.createLabeledArcFeatures(collector, dependencyInstance, n3, n, n4);
        }
        int n5 = nArray[n3];
        int n6 = nArray2[n3];
        if (n2 != 1 && n5 != -1) {
            this.createLabeledGPCFeatureVector(collector, dependencyInstance, n5, n3, n, n4, n6);
        }
    }

    private void createLabeledArcFeatures(Collector collector, DependencyInstance dependencyInstance, int n, int n2, int n3) {
        int n4 = n > n2 ? 1 : 2;
        this.addBasic1OFeatures(collector, dependencyInstance, n, n2, n4, n3);
        this.addCore1OPosFeatures(collector, dependencyInstance, n, n2, n4, n3);
        this.addCore1OBigramFeatures(collector, dependencyInstance.getFormIds()[n], dependencyInstance.getUPosTagIds()[n], dependencyInstance.getFormIds()[n2], dependencyInstance.getUPosTagIds()[n2], n4, n3);
        if (dependencyInstance.getLemmaIds() != null) {
            this.addCore1OBigramFeatures(collector, dependencyInstance.getLemmaIds()[n], dependencyInstance.getUPosTagIds()[n], dependencyInstance.getLemmaIds()[n2], dependencyInstance.getUPosTagIds()[n2], n4, n3);
        }
        this.addCore1OBigramFeatures(collector, dependencyInstance.getFormIds()[n], dependencyInstance.getXPosTagIds()[n], dependencyInstance.getFormIds()[n2], dependencyInstance.getUPosTagIds()[n2], n4, n3);
        if (dependencyInstance.getLemmaIds() != null) {
            this.addCore1OBigramFeatures(collector, dependencyInstance.getLemmaIds()[n], dependencyInstance.getXPosTagIds()[n], dependencyInstance.getLemmaIds()[n2], dependencyInstance.getXPosTagIds()[n2], n4, n3);
        }
        if (dependencyInstance.getFeatIds()[n] != null && dependencyInstance.getFeatIds()[n2] != null) {
            int n5 = dependencyInstance.getFeatIds()[n].length;
            for (int i = 0; i < n5; ++i) {
                int n6 = dependencyInstance.getFeatIds()[n2].length;
                for (int j = 0; j < n6; ++j) {
                    this.addCore1OBigramFeatures(collector, dependencyInstance.getFormIds()[n], dependencyInstance.getFeatIds()[n][i], dependencyInstance.getFormIds()[n2], dependencyInstance.getFeatIds()[n2][j], n4, n3);
                    if (dependencyInstance.getLemmas() == null) continue;
                    this.addCore1OBigramFeatures(collector, dependencyInstance.getLemmaIds()[n], dependencyInstance.getFeatIds()[n][i], dependencyInstance.getLemmaIds()[n2], dependencyInstance.getFeatIds()[n2][j], n4, n3);
                }
            }
        }
    }

    private void addBasic1OFeatures(Collector collector, DependencyInstance dependencyInstance, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int[] nArray = dependencyInstance.getFormIds();
        int[] nArray2 = dependencyInstance.getLemmaIds();
        int[] nArray3 = dependencyInstance.getUPosTagIds();
        int[] nArray4 = dependencyInstance.getXPosTagIds();
        int[][] nArray5 = dependencyInstance.getFeatIds();
        int n12 = n4 << 4;
        long l = this.createArcCodeW(FeatureTemplate.Arc.CORE_HEAD_WORD, nArray[n]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeW(FeatureTemplate.Arc.CORE_MOD_WORD, nArray[n2]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeWW(FeatureTemplate.Arc.HW_MW, nArray[n], nArray[n2]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        if (n == 0) {
            n11 = this.tokenStart;
        } else {
            int n13 = n11 = n == n2 + 1 ? this.tokenMid : nArray[n - 1];
        }
        if (n == dependencyInstance.getLength() - 1) {
            n10 = this.tokenEnd;
        } else {
            int n14 = n10 = n + 1 == n2 ? this.tokenMid : nArray[n + 1];
        }
        if (n2 == 0) {
            n9 = this.tokenStart;
        } else {
            int n15 = n9 = n2 == n + 1 ? this.tokenMid : nArray[n2 - 1];
        }
        int n16 = n2 == dependencyInstance.getLength() - 1 ? this.tokenEnd : (n2 + 1 == n ? this.tokenMid : nArray[n2 + 1]);
        l = this.createArcCodeW(FeatureTemplate.Arc.CORE_HEAD_pWORD, n11) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeW(FeatureTemplate.Arc.CORE_HEAD_nWORD, n10) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeW(FeatureTemplate.Arc.CORE_MOD_pWORD, n9) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeW(FeatureTemplate.Arc.CORE_MOD_nWORD, n16) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeP(FeatureTemplate.Arc.CORE_HEAD_POS, nArray3[n]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeP(FeatureTemplate.Arc.CORE_HEAD_POS, nArray4[n]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeP(FeatureTemplate.Arc.CORE_MOD_POS, nArray3[n2]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodeP(FeatureTemplate.Arc.CORE_MOD_POS, nArray4[n2]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.HP_MP, nArray3[n], nArray3[n2]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.HP_MP, nArray4[n], nArray4[n2]) | (long)n12;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        if (nArray2 != null) {
            l = this.createArcCodeW(FeatureTemplate.Arc.CORE_HEAD_WORD, nArray2[n]) | (long)n12;
            this.addLabeledArcFeature(l, collector);
            this.addLabeledArcFeature(l | (long)n3, collector);
            l = this.createArcCodeW(FeatureTemplate.Arc.CORE_MOD_WORD, nArray2[n2]) | (long)n12;
            this.addLabeledArcFeature(l, collector);
            this.addLabeledArcFeature(l | (long)n3, collector);
            l = this.createArcCodeWW(FeatureTemplate.Arc.HW_MW, nArray2[n], nArray2[n2]) | (long)n12;
            this.addLabeledArcFeature(l, collector);
            this.addLabeledArcFeature(l | (long)n3, collector);
            if (n == 0) {
                n8 = this.tokenStart;
            } else {
                int n17 = n8 = n == n2 + 1 ? this.tokenMid : nArray2[n - 1];
            }
            if (n == dependencyInstance.getLength() - 1) {
                n7 = this.tokenEnd;
            } else {
                int n18 = n7 = n + 1 == n2 ? this.tokenMid : nArray2[n + 1];
            }
            if (n2 == 0) {
                n6 = this.tokenStart;
            } else {
                int n19 = n6 = n2 == n + 1 ? this.tokenMid : nArray2[n2 - 1];
            }
            n5 = n2 == dependencyInstance.getLength() - 1 ? this.tokenEnd : (n2 + 1 == n ? this.tokenMid : nArray2[n2 + 1]);
            l = this.createArcCodeW(FeatureTemplate.Arc.CORE_HEAD_pWORD, n8) | (long)n12;
            this.addLabeledArcFeature(l, collector);
            this.addLabeledArcFeature(l | (long)n3, collector);
            l = this.createArcCodeW(FeatureTemplate.Arc.CORE_HEAD_nWORD, n7) | (long)n12;
            this.addLabeledArcFeature(l, collector);
            this.addLabeledArcFeature(l | (long)n3, collector);
            l = this.createArcCodeW(FeatureTemplate.Arc.CORE_MOD_pWORD, n6) | (long)n12;
            this.addLabeledArcFeature(l, collector);
            this.addLabeledArcFeature(l | (long)n3, collector);
            l = this.createArcCodeW(FeatureTemplate.Arc.CORE_MOD_nWORD, n5) | (long)n12;
            this.addLabeledArcFeature(l, collector);
            this.addLabeledArcFeature(l | (long)n3, collector);
        }
        if (nArray5[n] != null) {
            n7 = nArray5[n].length;
            for (n8 = 0; n8 < n7; ++n8) {
                l = this.createArcCodeP(FeatureTemplate.Arc.CORE_HEAD_POS, nArray5[n][n8]) | (long)n12;
                this.addLabeledArcFeature(l, collector);
                this.addLabeledArcFeature(l | (long)n3, collector);
            }
        }
        if (nArray5[n2] != null) {
            n7 = nArray5[n2].length;
            for (n8 = 0; n8 < n7; ++n8) {
                l = this.createArcCodeP(FeatureTemplate.Arc.CORE_MOD_POS, nArray5[n2][n8]) | (long)n12;
                this.addLabeledArcFeature(l, collector);
                this.addLabeledArcFeature(l | (long)n3, collector);
            }
        }
        if (nArray5[n] != null && nArray5[n2] != null) {
            n7 = nArray5[n].length;
            for (n8 = 0; n8 < n7; ++n8) {
                n5 = nArray5[n2].length;
                for (n6 = 0; n6 < n5; ++n6) {
                    l = this.createArcCodePP(FeatureTemplate.Arc.HP_MP, nArray5[n][n8], nArray5[n2][n6]) | (long)n12;
                    this.addLabeledArcFeature(l, collector);
                    this.addLabeledArcFeature(l | (long)n3, collector);
                }
            }
        }
    }

    private void addCore1OPosFeatures(Collector collector, DependencyInstance dependencyInstance, int n, int n2, int n3, int n4) {
        int[] nArray = dependencyInstance.getUPosTagIds();
        int[] nArray2 = dependencyInstance.getXPosTagIds();
        int n5 = n4 << 4;
        int n6 = nArray[n];
        int n7 = nArray2[n];
        int n8 = nArray[n2];
        int n9 = nArray2[n2];
        int n10 = n > 0 ? (n - 1 == n2 ? this.tokenMid : nArray[n - 1]) : this.tokenStart;
        int n11 = n2 < nArray.length - 1 ? (n2 + 1 == n ? this.tokenMid : nArray[n2 + 1]) : this.tokenEnd;
        int n12 = n < nArray.length - 1 ? (n + 1 == n2 ? this.tokenMid : nArray[n + 1]) : this.tokenEnd;
        int n13 = n2 > 0 ? (n2 - 1 == n ? this.tokenMid : nArray[n2 - 1]) : this.tokenStart;
        int n14 = n > 0 ? (n - 1 == n2 ? this.tokenMid : nArray2[n - 1]) : this.tokenStart;
        int n15 = n2 < nArray2.length - 1 ? (n2 + 1 == n ? this.tokenMid : nArray2[n2 + 1]) : this.tokenEnd;
        int n16 = n < nArray2.length - 1 ? (n + 1 == n2 ? this.tokenMid : nArray2[n + 1]) : this.tokenEnd;
        int n17 = n2 > 0 ? (n2 - 1 == n ? this.tokenMid : nArray2[n2 - 1]) : this.tokenStart;
        long l = this.createArcCodePP(FeatureTemplate.Arc.HPp_HP, n10, n6) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.HP_HPn, n6, n12) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPp_HP_HPn, n10, n6, n12) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.MPp_MP, n13, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.MP_MPn, n8, n11) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.MPp_MP_MPn, n13, n8, n11) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.HPp_HP, n14, n7) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.HP_HPn, n7, n16) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPp_HP_HPn, n14, n7, n16) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.MPp_MP, n17, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.MP_MPn, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.MPp_MP_MPn, n17, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.HPp_HP_MP_MPn, n10, n6, n8, n11) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HP_MP_MPn, n6, n8, n11) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPp_HP_MP, n10, n6, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPp_MP_MPn, n10, n8, n11) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPp_HP_MPn, n10, n6, n11) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.HPp_HP_MP_MPn, n14, n7, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HP_MP_MPn, n7, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPp_HP_MP, n14, n7, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPp_MP_MPn, n14, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPp_HP_MPn, n14, n7, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.HP_HPn_MPp_MP, n6, n12, n13, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HP_MPp_MP, n6, n13, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HP_HPn_MP, n6, n12, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPn_MPp_MP, n12, n13, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HP_HPn_MPp, n6, n12, n13) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.HP_HPn_MPp_MP, n7, n16, n17, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HP_MPp_MP, n7, n17, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HP_HPn_MP, n7, n16, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HPn_MPp_MP, n16, n17, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.HP_HPn_MPp, n7, n16, n17) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.HPp_HP_MPp_MP, n10, n6, n13, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.HP_HPn_MP_MPn, n6, n12, n8, n11) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.HPp_HP_MPp_MP, n14, n7, n17, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.HP_HPn_MP_MPn, n7, n16, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n3, collector);
    }

    private void addCore1OBigramFeatures(Collector collector, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 << 4;
        long l = this.createArcCodeWWPP(FeatureTemplate.Arc.HW_MW_HP_MP, n, n3, n2, n4) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n5, collector);
        l = this.createArcCodeWPP(FeatureTemplate.Arc.MW_HP_MP, n3, n2, n4) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n5, collector);
        l = this.createArcCodeWPP(FeatureTemplate.Arc.HW_HP_MP, n, n2, n4) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n5, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.MW_HP, n3, n2) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n5, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.HW_MP, n, n4) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n5, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.HW_HP, n, n2) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n5, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.MW_MP, n3, n4) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n5, collector);
    }

    private void createLabeledGPCFeatureVector(Collector collector, DependencyInstance dependencyInstance, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = dependencyInstance.getUPosTagIds();
        int[] nArray2 = dependencyInstance.getXPosTagIds();
        int[] nArray3 = dependencyInstance.getLemmaIds() != null ? dependencyInstance.getLemmaIds() : dependencyInstance.getFormIds();
        int n6 = ((n > n2 ? 0 : 1) << 1 | (n2 > n3 ? 0 : 1)) << 1 | 1;
        int n7 = (n5 << this.depNumBits | n4) << 4;
        int n8 = nArray[n];
        int n9 = nArray[n2];
        int n10 = nArray[n3];
        int n11 = nArray2[n];
        int n12 = nArray2[n2];
        int n13 = nArray2[n3];
        long l = this.createArcCodePPP(FeatureTemplate.Arc.GP_HP_MP, n8, n9, n10) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodePPP(FeatureTemplate.Arc.GC_HC_MC, n11, n12, n13) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        int n14 = nArray3[n];
        int n15 = nArray3[n2];
        int n16 = nArray3[n3];
        l = this.createArcCodeWPP(FeatureTemplate.Arc.GL_HC_MC, n14, n12, n13) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWPP(FeatureTemplate.Arc.GC_HL_MC, n15, n11, n13) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWPP(FeatureTemplate.Arc.GC_HC_ML, n16, n11, n12) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.GC_HC, n11, n12) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.GC_MC, n11, n13) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodePP(FeatureTemplate.Arc.HC_MC, n12, n13) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWWP(FeatureTemplate.Arc.GL_HL_MC, n14, n15, n13) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWWP(FeatureTemplate.Arc.GL_HC_ML, n14, n16, n12) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWWP(FeatureTemplate.Arc.GC_HL_ML, n15, n16, n11) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWWW(FeatureTemplate.Arc.GL_HL_ML, n14, n15, n16) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.GL_HC, n14, n12) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.GC_HL, n15, n11) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWW(FeatureTemplate.Arc.GL_HL, n14, n15) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.GL_MC, n14, n13) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.GC_ML, n16, n11) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWW(FeatureTemplate.Arc.GL_ML, n14, n16) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.HL_MC, n15, n13) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWP(FeatureTemplate.Arc.HC_ML, n16, n12) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        l = this.createArcCodeWW(FeatureTemplate.Arc.HL_ML, n15, n16) | (long)n7;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n6, collector);
        this.addLabeledTurboGPC(dependencyInstance, n, n2, n3, n6, n7, collector);
    }

    private void addLabeledTurboGPC(DependencyInstance dependencyInstance, int n, int n2, int n3, int n4, int n5, Collector collector) {
        int[] nArray = dependencyInstance.getXPosTagIds();
        int[] nArray2 = dependencyInstance.getLemmaIds() != null ? dependencyInstance.getLemmaIds() : dependencyInstance.getFormIds();
        int n6 = nArray.length;
        int n7 = nArray[n];
        int n8 = nArray[n2];
        int n9 = nArray[n3];
        int n10 = n > 0 ? nArray[n - 1] : this.tokenStart;
        int n11 = n < n6 - 1 ? nArray[n + 1] : this.tokenEnd;
        int n12 = n2 > 0 ? nArray[n2 - 1] : this.tokenStart;
        int n13 = n2 < n6 - 1 ? nArray[n2 + 1] : this.tokenEnd;
        int n14 = n3 > 0 ? nArray[n3 - 1] : this.tokenStart;
        int n15 = n3 < n6 - 1 ? nArray[n3 + 1] : this.tokenEnd;
        long l = 0L;
        l = this.createArcCodePPPP(FeatureTemplate.Arc.pGC_GC_HC_MC, n10, n7, n8, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.GC_nGC_HC_MC, n7, n11, n8, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.GC_pHC_HC_MC, n7, n12, n8, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.GC_HC_nHC_MC, n7, n8, n13, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.GC_HC_pMC_MC, n7, n8, n14, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPP(FeatureTemplate.Arc.GC_HC_MC_nMC, n7, n8, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_pGC_pHC, n7, n8, n9, n10, n12) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_pGC_pMC, n7, n8, n9, n10, n14) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_pHC_pMC, n7, n8, n9, n12, n14) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_nGC_nHC, n7, n8, n9, n11, n13) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_nGC_nMC, n7, n8, n9, n11, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_nHC_nMC, n7, n8, n9, n13, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_pGC_nHC, n7, n8, n9, n10, n13) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_pGC_nMC, n7, n8, n9, n10, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_pHC_nMC, n7, n8, n9, n12, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_nGC_pHC, n7, n8, n9, n11, n12) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_nGC_pMC, n7, n8, n9, n11, n14) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodePPPPP(FeatureTemplate.Arc.GC_HC_MC_nHC_pMC, n7, n8, n9, n13, n14) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        int n16 = nArray2[n];
        int n17 = nArray2[n2];
        int n18 = nArray2[n3];
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.pGC_GL_HC_MC, n16, n10, n8, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GL_nGC_HC_MC, n16, n11, n8, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GL_pHC_HC_MC, n16, n12, n8, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GL_HC_nHC_MC, n16, n8, n13, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GL_HC_pMC_MC, n16, n8, n14, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GL_HC_MC_nMC, n16, n8, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.pGC_GC_HL_MC, n17, n10, n7, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_nGC_HL_MC, n17, n7, n11, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_pHC_HL_MC, n17, n7, n12, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_HL_nHC_MC, n17, n7, n13, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_HL_pMC_MC, n17, n7, n14, n9) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_HL_MC_nMC, n17, n7, n9, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.pGC_GC_HC_ML, n18, n10, n7, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_nGC_HC_ML, n18, n7, n11, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_pHC_HC_ML, n18, n7, n12, n8) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_HC_nHC_ML, n18, n7, n8, n13) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_HC_pMC_ML, n18, n7, n8, n14) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
        l = this.createArcCodeWPPP(FeatureTemplate.Arc.GC_HC_ML_nMC, n18, n7, n8, n15) | (long)n5;
        this.addLabeledArcFeature(l, collector);
        this.addLabeledArcFeature(l | (long)n4, collector);
    }

    private long extractArcTemplateCode(long l) {
        return l >> this.flagBits & (long)((1 << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS) - 1);
    }

    private long extractDistanceCode(long l) {
        return l & 0xFL;
    }

    private long extractLabelCode(long l) {
        return l >> 4 & (long)((1 << this.depNumBits) - 1);
    }

    private long extractPLabelCode(long l) {
        return l >> this.depNumBits + 4 & (long)((1 << this.depNumBits) - 1);
    }

    private void extractArcCodeP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[0] = (int)(l & (long)((1 << this.tagNumBits) - 1));
    }

    private void extractArcCodePP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[1] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[0] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
    }

    private void extractArcCodePPP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[2] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[1] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[0] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
    }

    private void extractArcCodePPPP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[3] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[2] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[1] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[0] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
    }

    private void extractArcCodePPPPP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[4] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[3] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[2] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[1] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[0] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
    }

    private void extractArcCodeWPPP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[3] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[2] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[1] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[0] = (int)((l >>= this.tagNumBits) & (long)((1 << this.wordNumBits) - 1));
    }

    private void extractArcCodeW(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[0] = (int)(l & (long)((1 << this.wordNumBits) - 1));
    }

    private void extractArcCodeWW(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[1] = (int)(l & (long)((1 << this.wordNumBits) - 1));
        nArray[0] = (int)((l >>= this.wordNumBits) & (long)((1 << this.wordNumBits) - 1));
    }

    private void extractArcCodeWP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[1] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[0] = (int)((l >>= this.tagNumBits) & (long)((1 << this.wordNumBits) - 1));
    }

    private void extractArcCodeWPP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[2] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[1] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[0] = (int)((l >>= this.tagNumBits) & (long)((1 << this.wordNumBits) - 1));
    }

    private void extractArcCodeWWP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[2] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[1] = (int)((l >>= this.tagNumBits) & (long)((1 << this.wordNumBits) - 1));
        nArray[0] = (int)((l >>= this.wordNumBits) & (long)((1 << this.wordNumBits) - 1));
    }

    private void extractArcCodeWWW(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[2] = (int)(l & (long)((1 << this.wordNumBits) - 1));
        nArray[1] = (int)((l >>= this.wordNumBits) & (long)((1 << this.wordNumBits) - 1));
        nArray[0] = (int)((l >>= this.wordNumBits) & (long)((1 << this.wordNumBits) - 1));
    }

    private void extractArcCodeWWPP(long l, int[] nArray) {
        l = l >> this.flagBits >> FeatureTemplate.Arc.NUM_ARC_FEAT_BITS;
        nArray[3] = (int)(l & (long)((1 << this.tagNumBits) - 1));
        nArray[2] = (int)((l >>= this.tagNumBits) & (long)((1 << this.tagNumBits) - 1));
        nArray[1] = (int)((l >>= this.tagNumBits) & (long)((1 << this.wordNumBits) - 1));
        nArray[0] = (int)((l >>= this.wordNumBits) & (long)((1 << this.wordNumBits) - 1));
    }

    private long createArcCodeP(FeatureTemplate.Arc arc, long l) {
        return (l << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodePP(FeatureTemplate.Arc arc, long l, long l2) {
        return ((l << this.tagNumBits | l2) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodePPP(FeatureTemplate.Arc arc, long l, long l2, long l3) {
        return (((l << this.tagNumBits | l2) << this.tagNumBits | l3) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodePPPP(FeatureTemplate.Arc arc, long l, long l2, long l3, long l4) {
        return ((((l << this.tagNumBits | l2) << this.tagNumBits | l3) << this.tagNumBits | l4) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodePPPPP(FeatureTemplate.Arc arc, long l, long l2, long l3, long l4, long l5) {
        return (((((l << this.tagNumBits | l2) << this.tagNumBits | l3) << this.tagNumBits | l4) << this.tagNumBits | l5) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodeW(FeatureTemplate.Arc arc, long l) {
        return (l << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodeWW(FeatureTemplate.Arc arc, long l, long l2) {
        return ((l << this.wordNumBits | l2) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodeWWW(FeatureTemplate.Arc arc, long l, long l2, long l3) {
        return (((l << this.wordNumBits | l2) << this.wordNumBits | l3) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodeWP(FeatureTemplate.Arc arc, long l, long l2) {
        return ((l << this.tagNumBits | l2) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodeWPP(FeatureTemplate.Arc arc, long l, long l2, long l3) {
        return (((l << this.tagNumBits | l2) << this.tagNumBits | l3) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodeWPPP(FeatureTemplate.Arc arc, long l, long l2, long l3, long l4) {
        return ((((l << this.tagNumBits | l2) << this.tagNumBits | l3) << this.tagNumBits | l4) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodeWWP(FeatureTemplate.Arc arc, long l, long l2, long l3) {
        return (((l << this.wordNumBits | l2) << this.tagNumBits | l3) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createArcCodeWWPP(FeatureTemplate.Arc arc, long l, long l2, long l3, long l4) {
        return ((((l << this.wordNumBits | l2) << this.tagNumBits | l3) << this.tagNumBits | l4) << FeatureTemplate.Arc.NUM_ARC_FEAT_BITS | (long)arc.ordinal()) << this.flagBits;
    }

    private long createWordCodeW(FeatureTemplate.Word word, long l) {
        return (l << FeatureTemplate.Word.NUM_WORD_FEAT_BITS | (long)word.ordinal()) << this.flagBits;
    }

    private long createWordCodeP(FeatureTemplate.Word word, long l) {
        return (l << FeatureTemplate.Word.NUM_WORD_FEAT_BITS | (long)word.ordinal()) << this.flagBits;
    }

    private long createWordCodePP(FeatureTemplate.Word word, long l, long l2) {
        return ((l << this.tagNumBits | l2) << FeatureTemplate.Word.NUM_WORD_FEAT_BITS | (long)word.ordinal()) << this.flagBits;
    }

    private long createWordCodePPP(FeatureTemplate.Word word, long l, long l2, long l3) {
        return (((l << this.tagNumBits | l2) << this.tagNumBits | l3) << FeatureTemplate.Word.NUM_WORD_FEAT_BITS | (long)word.ordinal()) << this.flagBits;
    }

    private long createWordCodeWP(FeatureTemplate.Word word, long l, long l2) {
        return ((l << this.tagNumBits | l2) << FeatureTemplate.Word.NUM_WORD_FEAT_BITS | (long)word.ordinal()) << this.flagBits;
    }

    private void clearFeatureHashSet() {
        this.featureHashSet = null;
    }

    public void fillParameters(LowRankTensor lowRankTensor, LowRankTensor lowRankTensor2, Parameters parameters) {
        Long[] longArray = (Long[])Arrays.copyOf(this.featureHashSet.toArray(), this.featureHashSet.toArray().length, Long[].class);
        this.clearFeatureHashSet();
        int[] nArray = new int[5];
        Long[] longArray2 = longArray;
        int n = longArray2.length;
        for (int i = 0; i < n; ++i) {
            int[] nArray2;
            int n2;
            long l = longArray2[i];
            int n3 = (int)this.extractDistanceCode(l);
            int n4 = (int)this.extractArcTemplateCode(l);
            int n5 = (int)this.extractLabelCode(l);
            int n6 = (int)this.extractPLabelCode(l);
            long l2 = -1L;
            long l3 = -1L;
            long l4 = -1L;
            if (n4 == FeatureTemplate.Arc.HPp_HP.ordinal()) {
                this.extractArcCodePP(l, nArray);
            }
            if (n4 == FeatureTemplate.Arc.HP_HPn.ordinal()) {
                this.extractArcCodePP(l, nArray);
            }
            if (n4 == FeatureTemplate.Arc.HPp_HP_HPn.ordinal()) {
                this.extractArcCodePPP(l, nArray);
            }
            if (n4 == FeatureTemplate.Arc.MPp_MP.ordinal()) {
                this.extractArcCodePP(l, nArray);
            }
            if (n4 == FeatureTemplate.Arc.MP_MPn.ordinal()) {
                this.extractArcCodePP(l, nArray);
            }
            if (n4 == FeatureTemplate.Arc.MPp_MP_MPn.ordinal()) {
                this.extractArcCodePPP(l, nArray);
            }
            if (n4 == FeatureTemplate.Arc.HPp_HP_MP_MPn.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[0], nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.HP_MP_MPn.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HPp_HP_MP.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[0], nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HPp_MP_MPn.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_Pp, nArray[0]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HPp_HP_MPn.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[0], nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_Pn, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HP_HPn_MPp_MP.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.HP_MPp_MP.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[1], nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HP_HPn_MP.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HPn_MPp_MP.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_Pn, nArray[0]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[1], nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HP_HPn_MPp.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_Pp, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HPp_HP_MPp_MP.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[0], nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.HP_HPn_MP_MPn.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.HW_MW_HP_MP.ordinal()) {
                this.extractArcCodeWWPP(l, nArray);
                l2 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, nArray[0], nArray[2]);
                l3 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, nArray[1], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.MW_HP_MP.ordinal()) {
                this.extractArcCodeWPP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, nArray[0], nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.HW_HP_MP.ordinal()) {
                this.extractArcCodeWPP(l, nArray);
                l2 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, nArray[0], nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.MW_HP.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.HW_MP.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.HW_MW.ordinal()) {
                this.extractArcCodeWW(l, nArray);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.HP_MP.ordinal()) {
                this.extractArcCodePP(l, nArray);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.HW_HP.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l2 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, nArray[0], nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.MW_MP.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l3 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0P0, nArray[0], nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.CORE_HEAD_WORD.ordinal()) {
                this.extractArcCodeW(l, nArray);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.CORE_HEAD_POS.ordinal()) {
                this.extractArcCodeP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.CORE_MOD_WORD.ordinal()) {
                this.extractArcCodeW(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.CORE_MOD_POS.ordinal()) {
                this.extractArcCodeP(l, nArray);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.CORE_HEAD_pWORD.ordinal()) {
                this.extractArcCodeW(l, nArray);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_Wp, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.CORE_HEAD_nWORD.ordinal()) {
                this.extractArcCodeW(l, nArray);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_Wn, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.CORE_MOD_pWORD.ordinal()) {
                this.extractArcCodeW(l, nArray);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_Wp, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.CORE_MOD_nWORD.ordinal()) {
                this.extractArcCodeW(l, nArray);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_Wn, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.HEAD_EMB.ordinal()) {
                this.extractArcCodeW(l, nArray);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_EMB, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.MOD_EMB.ordinal()) {
                this.extractArcCodeW(l, nArray);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_EMB, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.GP_HP_MP.ordinal() || n4 == FeatureTemplate.Arc.GC_HC_MC.ordinal()) {
                this.extractArcCodePPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GL_HC_MC.ordinal()) {
                this.extractArcCodeWPP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GC_HL_MC.ordinal()) {
                this.extractArcCodeWPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_ML.ordinal()) {
                this.extractArcCodeWPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.GL_HL_MC.ordinal()) {
                this.extractArcCodeWWP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GL_HC_ML.ordinal()) {
                this.extractArcCodeWWP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.GC_HL_ML.ordinal()) {
                this.extractArcCodeWWP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.GL_HL_ML.ordinal()) {
                this.extractArcCodeWWW(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[1]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC.ordinal()) {
                this.extractArcCodePP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.GL_HC.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.GC_HL.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.GL_HL.ordinal()) {
                this.extractArcCodeWW(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
            } else if (n4 == FeatureTemplate.Arc.GC_MC.ordinal()) {
                this.extractArcCodePP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.GL_MC.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.GC_ML.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.GL_ML.ordinal()) {
                this.extractArcCodeWW(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.HC_MC.ordinal()) {
                this.extractArcCodePP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.HL_MC.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.HC_ML.ordinal()) {
                this.extractArcCodeWP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.HL_ML.ordinal()) {
                this.extractArcCodeWW(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_BIAS, 0L);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[1]);
            } else if (n4 == FeatureTemplate.Arc.pGC_GC_HC_MC.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[0], nArray[1]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_nGC_HC_MC.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[1]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_pHC_HC_MC.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[1], nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_nHC_MC.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_pMC_MC.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_nMC.ordinal()) {
                this.extractArcCodePPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.pGC_GL_HC_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0Pp, nArray[0], nArray[1]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GL_nGC_HC_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0Pn, nArray[0], nArray[1]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GL_pHC_HC_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[1], nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GL_HC_nHC_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GL_HC_pMC_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GL_HC_MC_nMC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.pGC_GC_HL_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[1], nArray[2]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_nGC_HL_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[2]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_pHC_HL_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0Pp, nArray[0], nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_HL_nHC_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0Pn, nArray[0], nArray[2]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_HL_pMC_MC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_HL_MC_nMC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.pGC_GC_HC_ML.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[1], nArray[2]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.GC_nGC_HC_ML.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[2]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[3]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.GC_pHC_HC_ML.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[2], nArray[3]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_nHC_ML.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[3]);
                l3 = this.createWordCodeW(FeatureTemplate.Word.WORDFV_W0, nArray[0]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_pMC_ML.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l3 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0Pp, nArray[0], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_ML_nMC.ordinal()) {
                this.extractArcCodeWPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
                l3 = this.createWordCodeWP(FeatureTemplate.Word.WORDFV_W0Pn, nArray[0], nArray[3]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_pGC_pHC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[3], nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[4], nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_pGC_pMC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[3], nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[4], nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_pHC_pMC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[3], nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[4], nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_nGC_nHC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[3]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[4]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_nGC_nMC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[3]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[4]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_nHC_nMC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[3]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[4]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_pGC_nHC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[3], nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[1], nArray[4]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_pGC_nMC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[3], nArray[0]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[4]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_pHC_nMC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[0]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[3], nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[2], nArray[4]);
            } else if (n4 == FeatureTemplate.Arc.GC_HC_MC_nGC_pHC.ordinal()) {
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[3]);
                l2 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[4], nArray[1]);
                l3 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[2]);
            } else {
                if (n4 != FeatureTemplate.Arc.GC_HC_MC_nGC_pMC.ordinal()) continue;
                this.extractArcCodePPPPP(l, nArray);
                l4 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_P0Pn, nArray[0], nArray[3]);
                l2 = this.createWordCodeP(FeatureTemplate.Word.WORDFV_P0, nArray[1]);
                l3 = this.createWordCodePP(FeatureTemplate.Word.WORDFV_PpP0, nArray[4], nArray[2]);
            }
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = this.wordAlphabet.lookupIndex(l2);
            int n11 = this.wordAlphabet.lookupIndex(l3);
            if (l4 != -1L) {
                n7 = this.wordAlphabet.lookupIndex(l4);
                if (n3 != 0) {
                    n8 = (n3 >> 1 & 1) + 1;
                    n9 = (n3 >> 2 & 1) + 1;
                }
            }
            if (n10 < 0 || n11 < 0 || n7 < 0 || (n2 = this.hashcode2int(l) & this.numberLabeledArcFeatures) < 0) continue;
            float f = parameters.getParamsL()[n2];
            if (l4 == -1L) {
                nArray2 = new int[]{n10, n11, n3 * parameters.getT() + n5};
                lowRankTensor.add(nArray2, f);
                continue;
            }
            nArray2 = new int[]{n7, n10, n11, n9 * parameters.getT() + n6, n8 * parameters.getT() + n5};
            lowRankTensor2.add(nArray2, f);
        }
    }
}

