/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.spell.norvig;

import com.johnsnowlabs.nlp.Annotation;
import com.johnsnowlabs.nlp.Annotation$;
import com.johnsnowlabs.nlp.AnnotatorModel;
import com.johnsnowlabs.nlp.AnnotatorType$;
import com.johnsnowlabs.nlp.HasSimpleAnnotate;
import com.johnsnowlabs.nlp.annotators.spell.norvig.NorvigSweetingModel$;
import com.johnsnowlabs.nlp.annotators.spell.norvig.NorvigSweetingParams;
import com.johnsnowlabs.nlp.annotators.spell.util.Utilities$;
import com.johnsnowlabs.nlp.serialization.MapFeature;
import java.io.Serializable;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.FilterMonadic;
import scala.collection.immutable.;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0015+\u0001]B\u0001\u0002\u0012\u0001\u0003\u0006\u0004%\t%\u0012\u0005\t'\u0002\u0011\t\u0011)A\u0005\r\")A\u000b\u0001C\u0001+\")A\u000b\u0001C\u0001/\"9\u0001\f\u0001b\u0001\n\u0013I\u0006B\u00022\u0001A\u0003%!\fC\u0004d\u0001\t\u0007I\u0011\t3\t\r-\u0004\u0001\u0015!\u0003f\u0011\u001da\u0007A1A\u0005B5DaA\u001d\u0001!\u0002\u0013q\u0007bB:\u0001\u0005\u0004%\t\u0002\u001e\u0005\u0007}\u0002\u0001\u000b\u0011B;\t\r}\u0004A\u0011CA\u0001\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017A!\"!\u0005\u0001\u0011\u000b\u0007I\u0011BA\n\u0011)\t)\u0003\u0001EC\u0002\u0013%\u0011q\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u0018\u0001\t\u0013\t\t\u0007C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0005bBAD\u0001\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!!'\u0001\t\u0013\tY\nC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005=\u0006\u0001\"\u0003\u00022\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003\u000f\u0004A\u0011AAe\u0011\u001d\t)\u000e\u0001C\u0005\u0003/Dq!!8\u0001\t\u0013\ty\u000eC\u0004\u0002j\u0002!\t!a;\t\u000f\u0005=\b\u0001\"\u0001\u0002r\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]xaBA\u0000U!\u0005!\u0011\u0001\u0004\u0007S)B\tAa\u0001\t\rQ3C\u0011\u0001B\f\u0011%\u0011IBJA\u0001\n\u0013\u0011YBA\nO_J4\u0018nZ*xK\u0016$\u0018N\\4N_\u0012,GN\u0003\u0002,Y\u00051an\u001c:wS\u001eT!!\f\u0018\u0002\u000bM\u0004X\r\u001c7\u000b\u0005=\u0002\u0014AC1o]>$\u0018\r^8sg*\u0011\u0011GM\u0001\u0004]2\u0004(BA\u001a5\u00031Qw\u000e\u001b8t]><H.\u00192t\u0015\u0005)\u0014aA2p[\u000e\u00011\u0003\u0002\u00019}\u0005\u00032!\u000f\u001e=\u001b\u0005\u0001\u0014BA\u001e1\u00059\teN\\8uCR|'/T8eK2\u0004\"!\u0010\u0001\u000e\u0003)\u00022!O =\u0013\t\u0001\u0005GA\tICN\u001c\u0016.\u001c9mK\u0006sgn\u001c;bi\u0016\u0004\"!\u0010\"\n\u0005\rS#\u0001\u0006(peZLwmU<fKRLgn\u001a)be\u0006l7/A\u0002vS\u0012,\u0012A\u0012\t\u0003\u000fBs!\u0001\u0013(\u0011\u0005%cU\"\u0001&\u000b\u0005-3\u0014A\u0002\u001fs_>$hHC\u0001N\u0003\u0015\u00198-\u00197b\u0013\tyE*\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(M\u0003\u0011)\u0018\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\tad\u000bC\u0003E\u0007\u0001\u0007a\tF\u0001=\u0003\u0019awnZ4feV\t!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006)1\u000f\u001c45U*\tq,A\u0002pe\u001eL!!\u0019/\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n1c\\;uaV$\u0018I\u001c8pi\u0006$xN\u001d+za\u0016,\u0012!\u001a\t\u0003M\u001el\u0011\u0001A\u0005\u0003Q&\u0014Q\"\u00118o_R\fGo\u001c:UsB,\u0017B\u000161\u0005YA\u0015m](viB,H/\u00118o_R\fGo\u001c:UsB,\u0017\u0001F8viB,H/\u00118o_R\fGo\u001c:UsB,\u0007%A\nj]B,H/\u00118o_R\fGo\u001c:UsB,7/F\u0001o!\ry\u0007/Z\u0007\u0002\u0019&\u0011\u0011\u000f\u0014\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0015S:\u0004X\u000f^!o]>$\u0018\r^8s)f\u0004Xm\u001d\u0011\u0002\u0013]|'\u000fZ\"pk:$X#A;\u0011\tYLhi_\u0007\u0002o*\u0011\u0001\u0010M\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\n\u0005i<(AC'ba\u001a+\u0017\r^;sKB\u0011q\u000e`\u0005\u0003{2\u0013A\u0001T8oO\u0006Qqo\u001c:e\u0007>,h\u000e\u001e\u0011\u0002\u0019\u001d,GoV8sI\u000e{WO\u001c;\u0016\u0005\u0005\r\u0001#B$\u0002\u0006\u0019[\u0018bAA\u0004%\n\u0019Q*\u00199\u0002\u0019M,GoV8sI\u000e{WO\u001c;\u0015\u0007\u0019\fi\u0001C\u0004\u0002\u00109\u0001\r!a\u0001\u0002\u000bY\fG.^3\u0002\u0011\u0005dGnV8sIN,\"!!\u0006\u0011\u000b\u0005]\u0011\u0011\u0005$\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005}A*\u0001\u0006d_2dWm\u0019;j_:LA!a\t\u0002\u001a\t9\u0001*Y:i'\u0016$\u0018a\u00064sKF,XM\\2z\u0005>,h\u000eZ1ssZ\u000bG.^3t+\t\tI\u0003E\u0003p\u0003WY80C\u0002\u0002.1\u0013a\u0001V;qY\u0016\u0014\u0014\u0001C1o]>$\u0018\r^3\u0015\t\u0005M\u00121\n\t\u0007\u0003k\ty$!\u0012\u000f\t\u0005]\u00121\b\b\u0004\u0013\u0006e\u0012\"A'\n\u0007\u0005uB*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00131\t\u0002\u0004'\u0016\f(bAA\u001f\u0019B\u0019\u0011(a\u0012\n\u0007\u0005%\u0003G\u0001\u0006B]:|G/\u0019;j_:Dq!!\u0014\u0012\u0001\u0004\t\u0019$A\u0006b]:|G/\u0019;j_:\u001c\u0018AD2iK\u000e\\7\u000b]3mY^{'\u000f\u001a\u000b\u0005\u0003'\nY\u0006\u0005\u0004p\u0003W1\u0015Q\u000b\t\u0004_\u0006]\u0013bAA-\u0019\n1Ai\\;cY\u0016Da!!\u0018\u0013\u0001\u00041\u0015a\u0001:bo\u0006Ir-\u001a;CKN$8\u000b]3mY&twmU;hO\u0016\u001cH/[8o)\u0011\t\u0019'a\u001b\u0011\u000f=\fY#!\u001a\u0002VA!q.a\u001aG\u0013\r\tI\u0007\u0014\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u000554\u00031\u0001G\u0003\u00119xN\u001d3\u00023\u001d,Go\u00155peR\u001c\u0015N]2vSR\u001cVoZ4fgRLwN\u001c\u000b\u0005\u0003K\n\u0019\b\u0003\u0004\u0002nQ\u0001\rAR\u0001\u0016G>l\u0007/\u001e;f\t>,(\r\\3WCJL\u0017M\u001c;t)\u0011\tI(a \u0011\u000b\u0005U\u00121\u0010$\n\t\u0005u\u00141\t\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004\u0002nU\u0001\rAR\u0001\u000eO\u0016$8+^4hKN$\u0018n\u001c8\u0015\t\u0005\r\u0014Q\u0011\u0005\u0007\u0003[2\u0002\u0019\u0001$\u0002#\u001d,GoU2pe\u00164%/Z9vK:\u001c\u0017\u0010\u0006\u0003\u0002V\u0005-\u0005BBA7/\u0001\u0007a)A\fo_Jl\u0017\r\\5{K\u001a\u0013X-];f]\u000eLh+\u00197vKR!\u0011QKAI\u0011\u0019\ty\u0001\u0007a\u0001w\u0006Y1/^4hKN$\u0018n\u001c8t)\u0011\tI(a&\t\r\u00055\u0014\u00041\u0001G\u0003\u0011\u0011w\u000e\u001e5\u0015\t\u0005e\u0014Q\u0014\u0005\u0007\u0003[R\u0002\u0019\u0001$\u00023\u001d,GoU8si\u0016$wk\u001c:eg\nKhI]3rk\u0016t7-\u001f\u000b\u0007\u0003G\u000b9+a+\u0011\r\u0005U\u00121PAS!\u0015y\u00171\u0006$|\u0011\u001d\tIk\u0007a\u0001\u0003s\nQa^8sINDa!!,\u001c\u0001\u00041\u0015!B5oaV$\u0018AE2p[B\f'/\u001a$sKF,XM\\2jKN$2a_AZ\u0011\u0019\ty\u0001\ba\u0001\r\u00069r-\u001a;T_J$X\rZ,pe\u0012\u001c()\u001f%b[6Lgn\u001a\u000b\u0007\u0003G\u000bI,a/\t\u000f\u0005%V\u00041\u0001\u0002z!1\u0011QV\u000fA\u0002\u0019\u000babY8na\u0006\u0014X\rS1n[\u0016\u00148\u000f\u0006\u0003\u0002B\u0006\u0015GcA>\u0002D\"1\u0011q\u0002\u0010A\u0002\u0019Ca!!,\u001f\u0001\u00041\u0015!C4fiJ+7/\u001e7u)!\t\u0019&a3\u0002P\u0006M\u0007bBAg?\u0001\u0007\u00111U\u0001\u0011o>\u0014Hm\u001d\"z\rJ,\u0017/^3oGfDq!!5 \u0001\u0004\t\u0019+\u0001\bx_J$7OQ=IC6l\u0017N\\4\t\r\u00055v\u00041\u0001G\u0003E9W\r\u001e*fG>lW.\u001a8eCRLwN\u001c\u000b\u0007\u0003G\nI.a7\t\u000f\u00055\u0007\u00051\u0001\u0002$\"9\u0011\u0011\u001b\u0011A\u0002\u0005\r\u0016\u0001J4fi\u001a\u0013X-];f]\u000eL\u0018I\u001c3IC6l\u0017N\\4SK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u0015\u0011\u0005\r\u0014\u0011]Ar\u0003KDq!!4\"\u0001\u0004\t\u0019\u000bC\u0004\u0002R\u0006\u0002\r!a)\t\u000f\u0005\u001d\u0018\u00051\u0001\u0002z\u0005q\u0011N\u001c;feN,7\r^,pe\u0012\u001c\u0018\u0001F4fiJ+7/\u001e7u\u0005f4%/Z9vK:\u001c\u0017\u0010\u0006\u0003\u0002d\u00055\bbBAgE\u0001\u0007\u00111U\u0001\u0013O\u0016$(+Z:vYR\u0014\u0015\u0010S1n[&tw\r\u0006\u0003\u0002d\u0005M\bbBAiG\u0001\u0007\u00111U\u0001$O\u0016$hI]3rk\u0016t7-_(s\u0011\u0006lW.\u001b8h%\u0016\u001cw.\\7f]\u0012\fG/[8o)!\t\u0019'!?\u0002|\u0006u\bbBAgI\u0001\u0007\u00111\u0015\u0005\b\u0003#$\u0003\u0019AAR\u0011\u0019\ti\u000b\na\u0001\r\u0006\u0019bj\u001c:wS\u001e\u001cv/Z3uS:<Wj\u001c3fYB\u0011QHJ\n\bM\t\u0015!1\u0002B\t!\ry'qA\u0005\u0004\u0005\u0013a%AB!osJ+g\rE\u0002>\u0005\u001bI1Aa\u0004+\u0005a\u0011V-\u00193bE2,\u0007K]3ue\u0006Lg.\u001a3O_J4\u0018n\u001a\t\u0004_\nM\u0011b\u0001B\u000b\u0019\na1+\u001a:jC2L'0\u00192mKR\u0011!\u0011A\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u001eA!!q\u0004B\u0015\u001b\t\u0011\tC\u0003\u0003\u0003$\t\u0015\u0012\u0001\u00027b]\u001eT!Aa\n\u0002\t)\fg/Y\u0005\u0005\u0005W\u0011\tC\u0001\u0004PE*,7\r\u001e")
public class NorvigSweetingModel
extends AnnotatorModel<NorvigSweetingModel>
implements HasSimpleAnnotate<NorvigSweetingModel>,
NorvigSweetingParams {
    private HashSet<String> allWords;
    private Tuple2<Object, Object> frequencyBoundaryValues;
    private final String uid;
    private final Logger logger;
    private final String outputAnnotatorType;
    private final String[] inputAnnotatorTypes;
    private final MapFeature<String, Object> wordCount;
    private final BooleanParam caseSensitive;
    private final BooleanParam doubleVariants;
    private final BooleanParam shortCircuit;
    private final BooleanParam frequencyPriority;
    private final IntParam wordSizeIgnore;
    private final IntParam dupsLimit;
    private final IntParam reductLimit;
    private final IntParam intersections;
    private final IntParam vowelSwapLimit;
    private volatile byte bitmap$0;

    public static NorvigSweetingModel pretrained(String string, String string2, String string3) {
        return NorvigSweetingModel$.MODULE$.pretrained(string, string2, string3);
    }

    public static NorvigSweetingModel pretrained(String string, String string2) {
        return NorvigSweetingModel$.MODULE$.pretrained(string, string2);
    }

    public static NorvigSweetingModel pretrained(String string) {
        return NorvigSweetingModel$.MODULE$.pretrained(string);
    }

    public static NorvigSweetingModel pretrained() {
        return NorvigSweetingModel$.MODULE$.pretrained();
    }

    public static Some<String> defaultModelName() {
        return NorvigSweetingModel$.MODULE$.defaultModelName();
    }

    public static String defaultLoc() {
        return NorvigSweetingModel$.MODULE$.defaultLoc();
    }

    public static String defaultLang() {
        return NorvigSweetingModel$.MODULE$.defaultLang();
    }

    public static MLReader<NorvigSweetingModel> read() {
        return NorvigSweetingModel$.MODULE$.read();
    }

    public static void addReader(Function3<NorvigSweetingModel, String, SparkSession, BoxedUnit> function3) {
        NorvigSweetingModel$.MODULE$.addReader(function3);
    }

    public static Object load(String string) {
        return NorvigSweetingModel$.MODULE$.load(string);
    }

    @Override
    public NorvigSweetingParams setCaseSensitive(boolean value) {
        return NorvigSweetingParams.setCaseSensitive$(this, value);
    }

    @Override
    public NorvigSweetingParams setDoubleVariants(boolean value) {
        return NorvigSweetingParams.setDoubleVariants$(this, value);
    }

    @Override
    public NorvigSweetingParams setShortCircuit(boolean value) {
        return NorvigSweetingParams.setShortCircuit$(this, value);
    }

    @Override
    public NorvigSweetingParams setFrequencyPriority(boolean value) {
        return NorvigSweetingParams.setFrequencyPriority$(this, value);
    }

    @Override
    public NorvigSweetingParams setWordSizeIgnore(int value) {
        return NorvigSweetingParams.setWordSizeIgnore$(this, value);
    }

    @Override
    public NorvigSweetingParams setDupsLimit(int value) {
        return NorvigSweetingParams.setDupsLimit$(this, value);
    }

    @Override
    public NorvigSweetingParams setReductLimit(int value) {
        return NorvigSweetingParams.setReductLimit$(this, value);
    }

    @Override
    public NorvigSweetingParams setIntersections(int value) {
        return NorvigSweetingParams.setIntersections$(this, value);
    }

    @Override
    public NorvigSweetingParams setVowelSwapLimit(int value) {
        return NorvigSweetingParams.setVowelSwapLimit$(this, value);
    }

    @Override
    public boolean getCaseSensitive() {
        return NorvigSweetingParams.getCaseSensitive$(this);
    }

    @Override
    public boolean getDoubleVariants() {
        return NorvigSweetingParams.getDoubleVariants$(this);
    }

    @Override
    public boolean getShortCircuit() {
        return NorvigSweetingParams.getShortCircuit$(this);
    }

    @Override
    public boolean getFrequencyPriority() {
        return NorvigSweetingParams.getFrequencyPriority$(this);
    }

    @Override
    public int getWordSizeIgnore() {
        return NorvigSweetingParams.getWordSizeIgnore$(this);
    }

    @Override
    public int getDupsLimit() {
        return NorvigSweetingParams.getDupsLimit$(this);
    }

    @Override
    public int getReductLimit() {
        return NorvigSweetingParams.getReductLimit$(this);
    }

    @Override
    public int getIntersections() {
        return NorvigSweetingParams.getIntersections$(this);
    }

    @Override
    public int getVowelSwapLimit() {
        return NorvigSweetingParams.getVowelSwapLimit$(this);
    }

    @Override
    public UserDefinedFunction dfAnnotate() {
        return HasSimpleAnnotate.dfAnnotate$(this);
    }

    @Override
    public BooleanParam caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public BooleanParam doubleVariants() {
        return this.doubleVariants;
    }

    @Override
    public BooleanParam shortCircuit() {
        return this.shortCircuit;
    }

    @Override
    public BooleanParam frequencyPriority() {
        return this.frequencyPriority;
    }

    @Override
    public IntParam wordSizeIgnore() {
        return this.wordSizeIgnore;
    }

    @Override
    public IntParam dupsLimit() {
        return this.dupsLimit;
    }

    @Override
    public IntParam reductLimit() {
        return this.reductLimit;
    }

    @Override
    public IntParam intersections() {
        return this.intersections;
    }

    @Override
    public IntParam vowelSwapLimit() {
        return this.vowelSwapLimit;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$caseSensitive_$eq(BooleanParam x$1) {
        this.caseSensitive = x$1;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$doubleVariants_$eq(BooleanParam x$1) {
        this.doubleVariants = x$1;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$shortCircuit_$eq(BooleanParam x$1) {
        this.shortCircuit = x$1;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$frequencyPriority_$eq(BooleanParam x$1) {
        this.frequencyPriority = x$1;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$wordSizeIgnore_$eq(IntParam x$1) {
        this.wordSizeIgnore = x$1;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$dupsLimit_$eq(IntParam x$1) {
        this.dupsLimit = x$1;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$reductLimit_$eq(IntParam x$1) {
        this.reductLimit = x$1;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$intersections_$eq(IntParam x$1) {
        this.intersections = x$1;
    }

    @Override
    public void com$johnsnowlabs$nlp$annotators$spell$norvig$NorvigSweetingParams$_setter_$vowelSwapLimit_$eq(IntParam x$1) {
        this.vowelSwapLimit = x$1;
    }

    public String uid() {
        return this.uid;
    }

    private Logger logger() {
        return this.logger;
    }

    @Override
    public String outputAnnotatorType() {
        return this.outputAnnotatorType;
    }

    @Override
    public String[] inputAnnotatorTypes() {
        return this.inputAnnotatorTypes;
    }

    public MapFeature<String, Object> wordCount() {
        return this.wordCount;
    }

    public scala.collection.immutable.Map<String, Object> getWordCount() {
        return this.$$(this.wordCount());
    }

    public NorvigSweetingModel setWordCount(scala.collection.immutable.Map<String, Object> value) {
        return (NorvigSweetingModel)this.set(this.wordCount(), value);
    }

    private HashSet<String> allWords$lzycompute() {
        NorvigSweetingModel norvigSweetingModel = this;
        synchronized (norvigSweetingModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.allWords = BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.caseSensitive())) ? (HashSet)HashSet$.MODULE$.apply(this.$$(this.wordCount()).keys().toSeq()) : (HashSet)HashSet$.MODULE$.apply((Seq)this.$$(this.wordCount()).keys().toSeq().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(), Seq$.MODULE$.canBuildFrom()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.allWords;
    }

    private HashSet<String> allWords() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.allWords$lzycompute() : this.allWords;
    }

    private Tuple2<Object, Object> frequencyBoundaryValues$lzycompute() {
        NorvigSweetingModel norvigSweetingModel = this;
        synchronized (norvigSweetingModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                long min = ((Tuple2)((TraversableOnce)this.$$(this.wordCount()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$frequencyBoundaryValues$1(this, x$2)))).minBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3._2$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$))._2$mcJ$sp();
                long max = ((Tuple2)((TraversableOnce)this.$$(this.wordCount()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$frequencyBoundaryValues$3(this, x$4)))).maxBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5._2$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$))._2$mcJ$sp();
                this.frequencyBoundaryValues = new Tuple2.mcJJ.sp(min, max);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.frequencyBoundaryValues;
    }

    private Tuple2<Object, Object> frequencyBoundaryValues() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.frequencyBoundaryValues$lzycompute() : this.frequencyBoundaryValues;
    }

    @Override
    public Seq<Annotation> annotate(Seq<Annotation> annotations) {
        return (Seq)annotations.map((Function1 & Serializable & scala.Serializable)token -> {
            Tuple2<String, Object> verifiedWord = this.checkSpellWord(token.result());
            return new Annotation(this.outputAnnotatorType(), token.begin(), token.end(), (String)verifiedWord._1(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"confidence"), (Object)Double.toString(verifiedWord._2$mcD$sp())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sentence"), token.metadata().apply((Object)"sentence"))}))), Annotation$.MODULE$.apply$default$6());
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<String, Object> checkSpellWord(String raw) {
        String input = Utilities$.MODULE$.limitDuplicates(BoxesRunTime.unboxToInt((Object)this.$((Param)this.dupsLimit())), raw, Utilities$.MODULE$.limitDuplicates$default$3());
        this.logger().debug(new StringBuilder(27).append("spell checker target word: ").append(input).toString());
        Tuple2<Option<String>, Object> possibility = this.getBestSpellingSuggestion(input);
        if (((Option)possibility._1()).isDefined()) {
            return new Tuple2(((Option)possibility._1()).get(), (Object)BoxesRunTime.boxToDouble((double)possibility._2$mcD$sp()));
        }
        List<String> listedSuggestions = this.suggestions(input);
        List<Tuple2<String, Object>> sortedFrequencies = this.getSortedWordsByFrequency(listedSuggestions, input);
        List<Tuple2<String, Object>> sortedHamming = this.getSortedWordsByHamming(listedSuggestions, input);
        return this.getResult(sortedFrequencies, sortedHamming, input);
    }

    private Tuple2<Option<String>, Object> getBestSpellingSuggestion(String word) {
        Tuple2 tuple2;
        double score = 0.0;
        if (BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.shortCircuit()))) {
            String suggestedWord = (String)this.getShortCircuitSuggestion(word).getOrElse((Function0 & Serializable & scala.Serializable)() -> word);
            score = this.getScoreFrequency(suggestedWord);
            tuple2 = new Tuple2((Object)new Some((Object)suggestedWord), (Object)BoxesRunTime.boxToDouble((double)score));
        } else {
            Tuple2<Option<String>, Object> suggestions = this.getSuggestion(word);
            tuple2 = new Tuple2(suggestions._1(), (Object)BoxesRunTime.boxToDouble((double)suggestions._2$mcD$sp()));
        }
        return tuple2;
    }

    private Option<String> getShortCircuitSuggestion(String word) {
        return Utilities$.MODULE$.reductions(word, BoxesRunTime.unboxToInt((Object)this.$((Param)this.reductLimit()))).exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getShortCircuitSuggestion$1(this, e))) ? new Some((Object)word) : (Utilities$.MODULE$.getVowelSwaps(word, BoxesRunTime.unboxToInt((Object)this.$((Param)this.vowelSwapLimit()))).exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getShortCircuitSuggestion$2(this, e))) ? new Some((Object)word) : (Utilities$.MODULE$.variants(word).exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getShortCircuitSuggestion$3(this, e))) ? new Some((Object)word) : (this.both(word).exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getShortCircuitSuggestion$4(this, e))) ? new Some((Object)word) : (BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.doubleVariants())) && this.computeDoubleVariants(word).exists((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getShortCircuitSuggestion$5(this, e))) ? new Some((Object)word) : None$.MODULE$))));
    }

    public List<String> computeDoubleVariants(String word) {
        return (List)Utilities$.MODULE$.variants(word).flatMap((Function1 & Serializable & scala.Serializable)variant -> Utilities$.MODULE$.variants((String)variant), List$.MODULE$.canBuildFrom());
    }

    private Tuple2<Option<String>, Object> getSuggestion(String word) {
        Tuple2 tuple2;
        if (this.allWords().contains((Object)word)) {
            this.logger().debug("Word found in dictionary. No spell change");
            tuple2 = new Tuple2((Object)new Some((Object)word), (Object)BoxesRunTime.boxToDouble((double)1.0));
        } else if (word.length() <= BoxesRunTime.unboxToInt((Object)this.$((Param)this.wordSizeIgnore()))) {
            this.logger().debug("word ignored because length is less than wordSizeIgnore");
            tuple2 = new Tuple2((Object)new Some((Object)word), (Object)BoxesRunTime.boxToDouble((double)0.0));
        } else if (this.allWords().contains(new StringOps(Predef$.MODULE$.augmentString(word)).distinct())) {
            this.logger().debug("Word as distinct found in dictionary");
            double score = this.getScoreFrequency((String)new StringOps(Predef$.MODULE$.augmentString(word)).distinct());
            tuple2 = new Tuple2((Object)new Some(new StringOps(Predef$.MODULE$.augmentString(word)).distinct()), (Object)BoxesRunTime.boxToDouble((double)score));
        } else {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)-1.0));
        }
        return tuple2;
    }

    public double getScoreFrequency(String word) {
        long frequency = Utilities$.MODULE$.getFrequency(word, this.$$(this.wordCount()));
        return this.normalizeFrequencyValue(frequency);
    }

    public double normalizeFrequencyValue(long value) {
        if (value > this.frequencyBoundaryValues()._2$mcJ$sp()) {
            return 1.0;
        }
        if (value < this.frequencyBoundaryValues()._1$mcJ$sp()) {
            return 0.0;
        }
        double normalizedValue = (double)(value - this.frequencyBoundaryValues()._1$mcJ$sp()) / (double)(this.frequencyBoundaryValues()._2$mcJ$sp() - this.frequencyBoundaryValues()._1$mcJ$sp());
        return package$.MODULE$.BigDecimal().apply(normalizedValue).setScale(4, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> suggestions(String word) {
        void var3_2;
        List base = (List)((List)((List)Utilities$.MODULE$.reductions(word, BoxesRunTime.unboxToInt((Object)this.$((Param)this.reductLimit()))).$plus$plus(Utilities$.MODULE$.getVowelSwaps(word, BoxesRunTime.unboxToInt((Object)this.$((Param)this.vowelSwapLimit()))), List$.MODULE$.canBuildFrom())).$plus$plus(Utilities$.MODULE$.variants(word), List$.MODULE$.canBuildFrom())).$plus$plus(this.both(word), List$.MODULE$.canBuildFrom());
        HashSet intersectedPossibilities = this.allWords().intersect((GenSet)((TraversableOnce)(BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.doubleVariants())) ? base.$plus$plus(this.computeDoubleVariants(word), List$.MODULE$.canBuildFrom()) : var3_2)).toSet());
        return intersectedPossibilities.nonEmpty() ? intersectedPossibilities.toList() : List$.MODULE$.empty();
    }

    private List<String> both(String word) {
        return (List)Utilities$.MODULE$.reductions(word, BoxesRunTime.unboxToInt((Object)this.$((Param)this.reductLimit()))).flatMap((Function1 & Serializable & scala.Serializable)reduction -> Utilities$.MODULE$.getVowelSwaps((String)reduction, BoxesRunTime.unboxToInt((Object)this.$((Param)this.vowelSwapLimit()))), List$.MODULE$.canBuildFrom());
    }

    public List<Tuple2<String, Object>> getSortedWordsByFrequency(List<String> words, String input) {
        FilterMonadic filteredWords = words.withFilter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getSortedWordsByFrequency$1(input, x$6)));
        List sortedWordsByFrequency = ((List)((SeqLike)filteredWords.map((Function1 & Serializable & scala.Serializable)word -> new Tuple2(word, (Object)BoxesRunTime.boxToLong((long)this.compareFrequencies((String)word))), List$.MODULE$.canBuildFrom())).sortWith((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getSortedWordsByFrequency$3(x$7, x$8)))).take(BoxesRunTime.unboxToInt((Object)this.$((Param)this.intersections())));
        this.logger().debug(new StringBuilder(26).append("recommended by frequency: ").append(sortedWordsByFrequency.mkString(", ")).toString());
        return sortedWordsByFrequency;
    }

    private long compareFrequencies(String value) {
        return Utilities$.MODULE$.getFrequency(value, this.$$(this.wordCount()));
    }

    /*
     * WARNING - void declaration
     */
    public List<Tuple2<String, Object>> getSortedWordsByHamming(List<String> words, String input) {
        void var3_3;
        List sortedWordByHamming = ((List)((SeqLike)words.map((Function1 & Serializable & scala.Serializable)word -> new Tuple2(word, (Object)BoxesRunTime.boxToLong((long)this.compareHammers(input, (String)word))), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9._2$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$)).takeRight(BoxesRunTime.unboxToInt((Object)this.$((Param)this.intersections())));
        this.logger().debug(new StringBuilder(24).append("recommended by hamming: ").append(sortedWordByHamming.mkString(", ")).toString());
        return var3_3;
    }

    private long compareHammers(String input, String value) {
        return Utilities$.MODULE$.computeHammingDistance(input, value);
    }

    public Tuple2<String, Object> getResult(List<Tuple2<String, Object>> wordsByFrequency, List<Tuple2<String, Object>> wordsByHamming, String input) {
        Tuple2 recommendation = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToDouble((double)0.0));
        List intersectWords = (List)((SeqLike)wordsByFrequency.map((Function1 & Serializable & scala.Serializable)word -> (String)word._1(), List$.MODULE$.canBuildFrom())).intersect((GenSeq)wordsByHamming.map((Function1 & Serializable & scala.Serializable)word -> (String)word._1(), List$.MODULE$.canBuildFrom()));
        if (wordsByFrequency.isEmpty() && wordsByHamming.isEmpty()) {
            this.logger().debug("no intersection or frequent words found");
            recommendation = new Tuple2((Object)new Some((Object)input), (Object)BoxesRunTime.boxToDouble((double)0.0));
        } else if (wordsByFrequency.isEmpty() || wordsByHamming.isEmpty()) {
            this.logger().debug("no intersection but one recommendation found");
            recommendation = this.getRecommendation(wordsByFrequency, wordsByHamming);
        } else if (intersectWords.nonEmpty()) {
            this.logger().debug("hammer and frequency recommendations found");
            Tuple2<Option<String>, Object> frequencyAndHammingRecommendation = this.getFrequencyAndHammingRecommendation(wordsByFrequency, wordsByHamming, (List<String>)intersectWords);
            recommendation = new Tuple2(frequencyAndHammingRecommendation._1(), (Object)BoxesRunTime.boxToDouble((double)frequencyAndHammingRecommendation._2$mcD$sp()));
        } else {
            this.logger().debug("no intersection of hammer and frequency");
            recommendation = this.getFrequencyOrHammingRecommendation(wordsByFrequency, wordsByHamming, input);
        }
        return new Tuple2(((Option)recommendation._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> input), (Object)BoxesRunTime.boxToDouble((double)recommendation._2$mcD$sp()));
    }

    private Tuple2<Option<String>, Object> getRecommendation(List<Tuple2<String, Object>> wordsByFrequency, List<Tuple2<String, Object>> wordsByHamming) {
        return wordsByFrequency.nonEmpty() ? this.getResultByFrequency(wordsByFrequency) : this.getResultByHamming(wordsByHamming);
    }

    private Tuple2<Option<String>, Object> getFrequencyAndHammingRecommendation(List<Tuple2<String, Object>> wordsByFrequency, List<Tuple2<String, Object>> wordsByHamming, List<String> intersectWords) {
        Tuple2 tuple2;
        long bestHammingValue;
        long bestFrequencyValue;
        List wordsByFrequencyAndHamming = (List)intersectWords.map((Function1 & Serializable & scala.Serializable)word -> {
            long frequency = ((Tuple2)wordsByFrequency.find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$2(word, x$10))).get())._2$mcJ$sp();
            long hamming = ((Tuple2)wordsByHamming.find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$3(word, x$11))).get())._2$mcJ$sp();
            return new Tuple3(word, (Object)BoxesRunTime.boxToLong((long)frequency), (Object)BoxesRunTime.boxToLong((long)hamming));
        }, List$.MODULE$.canBuildFrom());
        List bestRecommendations = (List)wordsByFrequencyAndHamming.filter(arg_0 -> NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$6$adapted(bestFrequencyValue = BoxesRunTime.unboxToLong((Object)((Tuple3)wordsByFrequencyAndHamming.maxBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$4(x$12)), (Ordering)Ordering.Long$.MODULE$))._2()), bestHammingValue = BoxesRunTime.unboxToLong((Object)((Tuple3)wordsByFrequencyAndHamming.minBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$5(x$13)), (Ordering)Ordering.Long$.MODULE$))._3()), arg_0));
        if (bestRecommendations.nonEmpty()) {
            Tuple2 result = new Tuple2(Utilities$.MODULE$.getRandomValueFromList(bestRecommendations), (Object)BoxesRunTime.boxToDouble((double)Utilities$.MODULE$.computeConfidenceValue(bestRecommendations)));
            tuple2 = new Tuple2((Object)new Some(((Tuple3)((Option)result._1()).get())._1()), (Object)BoxesRunTime.boxToDouble((double)result._2$mcD$sp()));
        } else {
            tuple2 = BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.frequencyPriority())) ? new Tuple2((Object)new Some(((Tuple3)((TraversableOnce)wordsByFrequencyAndHamming.sortBy((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$7(x$14)), (Ordering)Ordering.Long$.MODULE$)).maxBy((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$8(x$15)), (Ordering)Ordering.Long$.MODULE$))._1()), (Object)BoxesRunTime.boxToDouble((double)1.0)) : new Tuple2((Object)new Some(((Tuple3)((List)wordsByFrequencyAndHamming.sortBy((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$9(x$16)), (Ordering)Ordering.Long$.MODULE$)).reverse().minBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$10(x$17)), (Ordering)Ordering.Long$.MODULE$))._1()), (Object)BoxesRunTime.boxToDouble((double)1.0));
        }
        return tuple2;
    }

    public Tuple2<Option<String>, Object> getResultByFrequency(List<Tuple2<String, Object>> wordsByFrequency) {
        long bestFrequencyValue = ((Tuple2)wordsByFrequency.maxBy((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)x$18._2$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$))._2$mcJ$sp();
        List bestRecommendations = (List)((List)wordsByFrequency.filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getResultByFrequency$2(bestFrequencyValue, x$19)))).map((Function1 & Serializable & scala.Serializable)x$20 -> (String)x$20._1(), List$.MODULE$.canBuildFrom());
        return new Tuple2(Utilities$.MODULE$.getRandomValueFromList(bestRecommendations), (Object)BoxesRunTime.boxToDouble((double)Utilities$.MODULE$.computeConfidenceValue(bestRecommendations)));
    }

    public Tuple2<Option<String>, Object> getResultByHamming(List<Tuple2<String, Object>> wordsByHamming) {
        long bestHammingValue = ((Tuple2)wordsByHamming.minBy((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21._2$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$))._2$mcJ$sp();
        List bestRecommendations = (List)((List)wordsByHamming.filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getResultByHamming$2(bestHammingValue, x$22)))).map((Function1 & Serializable & scala.Serializable)x$23 -> (String)x$23._1(), List$.MODULE$.canBuildFrom());
        return new Tuple2(Utilities$.MODULE$.getRandomValueFromList(bestRecommendations), (Object)BoxesRunTime.boxToDouble((double)Utilities$.MODULE$.computeConfidenceValue(bestRecommendations)));
    }

    public Tuple2<Option<String>, Object> getFrequencyOrHammingRecommendation(List<Tuple2<String, Object>> wordsByFrequency, List<Tuple2<String, Object>> wordsByHamming, String input) {
        String frequencyResult = (String)((Option)this.getResultByFrequency(wordsByFrequency)._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> input);
        String hammingResult = (String)((Option)this.getResultByHamming(wordsByHamming)._1()).getOrElse((Function0 & Serializable & scala.Serializable)() -> input);
        .colon.colon result = new .colon.colon((Object)frequencyResult, (List)new .colon.colon((Object)hammingResult, (List)Nil$.MODULE$));
        String string = frequencyResult;
        String string2 = input;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            result = new .colon.colon((Object)hammingResult, (List)Nil$.MODULE$);
        } else {
            String string3 = hammingResult;
            String string4 = input;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                result = new .colon.colon((Object)frequencyResult, (List)Nil$.MODULE$);
            }
        }
        return new Tuple2(Utilities$.MODULE$.getRandomValueFromList(result), (Object)BoxesRunTime.boxToDouble((double)Utilities$.MODULE$.computeConfidenceValue(result)));
    }

    public static final /* synthetic */ boolean $anonfun$frequencyBoundaryValues$1(NorvigSweetingModel $this, Tuple2 x$2) {
        return ((String)x$2._1()).length() > BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.wordSizeIgnore()));
    }

    public static final /* synthetic */ boolean $anonfun$frequencyBoundaryValues$3(NorvigSweetingModel $this, Tuple2 x$4) {
        return ((String)x$4._1()).length() > BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.wordSizeIgnore()));
    }

    public static final /* synthetic */ boolean $anonfun$getShortCircuitSuggestion$1(NorvigSweetingModel $this, String e) {
        return $this.allWords().contains((Object)e);
    }

    public static final /* synthetic */ boolean $anonfun$getShortCircuitSuggestion$2(NorvigSweetingModel $this, String e) {
        return $this.allWords().contains((Object)e);
    }

    public static final /* synthetic */ boolean $anonfun$getShortCircuitSuggestion$3(NorvigSweetingModel $this, String e) {
        return $this.allWords().contains((Object)e);
    }

    public static final /* synthetic */ boolean $anonfun$getShortCircuitSuggestion$4(NorvigSweetingModel $this, String e) {
        return $this.allWords().contains((Object)e);
    }

    public static final /* synthetic */ boolean $anonfun$getShortCircuitSuggestion$5(NorvigSweetingModel $this, String e) {
        return $this.allWords().contains((Object)e);
    }

    public static final /* synthetic */ boolean $anonfun$getSortedWordsByFrequency$1(String input$1, String x$6) {
        return x$6.length() >= input$1.length();
    }

    public static final /* synthetic */ boolean $anonfun$getSortedWordsByFrequency$3(Tuple2 x$7, Tuple2 x$8) {
        return x$7._2$mcJ$sp() > x$8._2$mcJ$sp();
    }

    public static final /* synthetic */ boolean $anonfun$getFrequencyAndHammingRecommendation$2(String word$2, Tuple2 x$10) {
        Object object = x$10._1();
        String string = word$2;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ boolean $anonfun$getFrequencyAndHammingRecommendation$3(String word$2, Tuple2 x$11) {
        Object object = x$11._1();
        String string = word$2;
        return !(object != null ? !object.equals(string) : string != null);
    }

    public static final /* synthetic */ long $anonfun$getFrequencyAndHammingRecommendation$4(Tuple3 x$12) {
        return BoxesRunTime.unboxToLong((Object)x$12._2());
    }

    public static final /* synthetic */ long $anonfun$getFrequencyAndHammingRecommendation$5(Tuple3 x$13) {
        return BoxesRunTime.unboxToLong((Object)x$13._3());
    }

    public static final /* synthetic */ boolean $anonfun$getFrequencyAndHammingRecommendation$6(long bestFrequencyValue$1, long bestHammingValue$1, Tuple3 word) {
        return BoxesRunTime.unboxToLong((Object)word._2()) == bestFrequencyValue$1 && BoxesRunTime.unboxToLong((Object)word._3()) == bestHammingValue$1;
    }

    public static final /* synthetic */ long $anonfun$getFrequencyAndHammingRecommendation$7(Tuple3 x$14) {
        return BoxesRunTime.unboxToLong((Object)x$14._3());
    }

    public static final /* synthetic */ long $anonfun$getFrequencyAndHammingRecommendation$8(Tuple3 x$15) {
        return BoxesRunTime.unboxToLong((Object)x$15._2());
    }

    public static final /* synthetic */ long $anonfun$getFrequencyAndHammingRecommendation$9(Tuple3 x$16) {
        return BoxesRunTime.unboxToLong((Object)x$16._2());
    }

    public static final /* synthetic */ long $anonfun$getFrequencyAndHammingRecommendation$10(Tuple3 x$17) {
        return BoxesRunTime.unboxToLong((Object)x$17._3());
    }

    public static final /* synthetic */ boolean $anonfun$getResultByFrequency$2(long bestFrequencyValue$2, Tuple2 x$19) {
        return x$19._2$mcJ$sp() == bestFrequencyValue$2;
    }

    public static final /* synthetic */ boolean $anonfun$getResultByHamming$2(long bestHammingValue$2, Tuple2 x$22) {
        return x$22._2$mcJ$sp() == bestHammingValue$2;
    }

    public NorvigSweetingModel(String uid) {
        this.uid = uid;
        HasSimpleAnnotate.$init$(this);
        NorvigSweetingParams.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"NorvigApproach");
        this.outputAnnotatorType = AnnotatorType$.MODULE$.TOKEN();
        this.inputAnnotatorTypes = (String[])((Object[])new String[]{AnnotatorType$.MODULE$.TOKEN()});
        this.wordCount = new MapFeature(this, "wordCount", ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long());
    }

    public NorvigSweetingModel() {
        this(Identifiable$.MODULE$.randomUID("SPELL"));
    }

    public static final /* synthetic */ Object $anonfun$getFrequencyAndHammingRecommendation$6$adapted(long bestFrequencyValue$1, long bestHammingValue$1, Tuple3 word) {
        return BoxesRunTime.boxToBoolean((boolean)NorvigSweetingModel.$anonfun$getFrequencyAndHammingRecommendation$6(bestFrequencyValue$1, bestHammingValue$1, word));
    }
}

