/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.johnsnowlabs.client.aws.AWSGateway;
import com.johnsnowlabs.client.aws.AWSGateway$;
import com.johnsnowlabs.client.gcp.GCPGateway;
import com.johnsnowlabs.client.gcp.GCPGateway$;
import com.johnsnowlabs.nlp.pretrained.RepositoryMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata$;
import com.johnsnowlabs.nlp.pretrained.ResourceRequest;
import com.johnsnowlabs.nlp.pretrained.S3ResourceDownloader$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.FileHelper$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001\u0002\u0010 \u0001!B\u0001b\r\u0001\u0003\u0002\u0013\u0006I\u0001\u000e\u0005\t\u0005\u0002\u0011\t\u0011*A\u0005i!A1\t\u0001B\u0001J\u0003%A\u0007\u0003\u0005E\u0001\t\u0005I\u0015!\u00035\u0011!)\u0005A!A!\u0002\u00139\u0004\"\u0002$\u0001\t\u00039\u0005b\u0002(\u0001\u0005\u0004%Ia\u0014\u0005\u00077\u0002\u0001\u000b\u0011\u0002)\t\u000fq\u0003!\u0019!C\u0001;\"1!\u000e\u0001Q\u0001\nyC\u0001b\u001b\u0001\t\u0006\u0004%\t\u0001\u001c\u0005\u0006k\u0002!IA\u001e\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\r\u0001\t\u0013\t\u0019\u0004C\u0004\u0002B\u0001!I!a\u0011\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0005bBAL\u0001\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003/\u0003A\u0011AAT\u0011\u001d\tY\u000b\u0001C!\u0003[Cq!!/\u0001\t\u0003\nY\fC\u0004\u0002F\u0002!I!a2\t\u0013\u0005u\u0007!%A\u0005\n\u0005}w!CA{?\u0005\u0005\t\u0012AA|\r!qr$!A\t\u0002\u0005e\bB\u0002$\u001c\t\u0003\tY\u0010C\u0005\u0002~n\t\n\u0011\"\u0001\u0002\u0000\n!2k\r*fg>,(oY3E_^tGn\\1eKJT!\u0001I\u0011\u0002\u0015A\u0014X\r\u001e:bS:,GM\u0003\u0002#G\u0005\u0019a\u000e\u001c9\u000b\u0005\u0011*\u0013\u0001\u00046pQ:\u001chn\\<mC\n\u001c(\"\u0001\u0014\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aEj\u0011aH\u0005\u0003e}\u0011!CU3t_V\u00148-\u001a#po:dw.\u00193fe\u00061!-^2lKR\u00042AK\u001b8\u0013\t14F\u0001\u0005=Eft\u0017-\\3?!\tAtH\u0004\u0002:{A\u0011!hK\u0007\u0002w)\u0011AhJ\u0001\u0007yI|w\u000e\u001e \n\u0005yZ\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!AP\u0016\u0002\rM\u001c\u0004+\u0019;i\u0003-\u0019\u0017m\u00195f\r>dG-\u001a:\u0002\u001f\r\u0014X\rZ3oi&\fGn\u001d+za\u0016\faA]3hS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0004I\u0013*[E*\u0014\t\u0003a\u0001Aaa\r\u0004\u0005\u0002\u0004!\u0004B\u0002\"\u0007\t\u0003\u0007A\u0007\u0003\u0004D\r\u0011\u0005\r\u0001\u000e\u0005\u0007\t\u001a!\t\u0019\u0001\u001b\t\u000f\u00153\u0001\u0013!a\u0001o\u0005\u0019\"/\u001a9p\r>dG-\u001a:3\u001b\u0016$\u0018\rZ1uCV\t\u0001\u000b\u0005\u0003R-^BV\"\u0001*\u000b\u0005M#\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003+.\n!bY8mY\u0016\u001cG/[8o\u0013\t9&KA\u0002NCB\u0004\"\u0001M-\n\u0005i{\"A\u0005*fa>\u001c\u0018\u000e^8ss6+G/\u00193bi\u0006\fAC]3q_\u001a{G\u000eZ3se5+G/\u00193bi\u0006\u0004\u0013!C2bG\",\u0007+\u0019;i+\u0005q\u0006CA0i\u001b\u0005\u0001'BA1c\u0003\t17O\u0003\u0002dI\u00061\u0001.\u00193p_BT!!\u001a4\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0017aA8sO&\u0011\u0011\u000e\u0019\u0002\u0005!\u0006$\b.\u0001\u0006dC\u000eDW\rU1uQ\u0002\n!\"Y<t\u000f\u0006$Xm^1z+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\r\two\u001d\u0006\u0003e\u000e\naa\u00197jK:$\u0018B\u0001;p\u0005)\tukU$bi\u0016<\u0018-_\u0001\u0017I>,7oQ1dQ\u00164u\u000e\u001c3fe&s7\t\\8vIR\tq\u000f\u0005\u0002+q&\u0011\u0011p\u000b\u0002\b\u0005>|G.Z1o\u0003Y!wn\u001e8m_\u0006$W*\u001a;bI\u0006$\u0018-\u00134OK\u0016$Gc\u0001?\u0002\u0012A)Q0!\u0002\u0002\f9\u0019a0!\u0001\u000f\u0005iz\u0018\"\u0001\u0017\n\u0007\u0005\r1&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0005\u0019&\u001cHOC\u0002\u0002\u0004-\u00022\u0001MA\u0007\u0013\r\tya\b\u0002\u0011%\u0016\u001cx.\u001e:dK6+G/\u00193bi\u0006Da!a\u0005\u000e\u0001\u00049\u0014A\u00024pY\u0012,'/A\u0006sKN|GN^3MS:\\G\u0003BA\r\u0003?\u0001RAKA\u000e\u0003\u0017I1!!\b,\u0005\u0019y\u0005\u000f^5p]\"9\u0011\u0011\u0005\bA\u0002\u0005\r\u0012a\u0002:fcV,7\u000f\u001e\t\u0004a\u0005\u0015\u0012bAA\u0014?\ty!+Z:pkJ\u001cWMU3rk\u0016\u001cH/\u0001\u0005e_^tGn\\1e)\u0011\ti#a\f\u0011\t)\nYb\u000e\u0005\b\u0003Cy\u0001\u0019AA\u0012\u0003\u0011\"w.Z:N_\u0012,G.\u0012=jgRLe.\u0012=uKJt\u0017\r\\\"m_V$7\u000b^8sC\u001e,GcB<\u00026\u0005e\u0012Q\b\u0005\u0007\u0003o\u0001\u0002\u0019A\u001c\u0002\u00135|G-\u001a7OC6,\u0007BBA\u001e!\u0001\u0007q'\u0001\beKN$\u0018N\\1uS>tWKU%\t\r\u0005}\u0002\u00031\u00018\u0003A!Wm\u001d;j]\u0006$\u0018n\u001c8DY>,H-A\u000ev]jL\u0007/\u00138FqR,'O\\1m\u00072|W\u000fZ*u_J\fw-\u001a\u000b\u000b\u0003\u000b\n\u0019&a\u001a\u0002l\u0005=\u0004\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002P\u0005!!.\u0019<b\u0013\r\u0001\u0015\u0011\n\u0005\b\u0003+\n\u0002\u0019AA,\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\tI&a\u0019\u000e\u0005\u0005m#\u0002BA/\u0003?\n1a]9m\u0015\r\t\t\u0007Z\u0001\u0006gB\f'o[\u0005\u0005\u0003K\nYF\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0003\u0004\u0002jE\u0001\raN\u0001\fg>,(oY3TgU\u0013\u0016\n\u0003\u0004\u0002nE\u0001\raN\u0001\u0016I\u0016\u001cH/\u001b8bi&|gn\u0015;pe\u0006<W-\u0016*J\u0011\u0019\ty$\u0005a\u0001o\u0005Yq-\u001a;Tg\r{gNZ5h)\u0019\t)(a\u001f\u0002~A1!&a\u001eno]J1!!\u001f,\u0005\u0019!V\u000f\u001d7fg!9\u0011Q\u000b\nA\u0002\u0005]\u0003BBA@%\u0001\u0007q'\u0001\teKN$\u0018N\\1uS>t7kM+S\u0013\u0006\u0019r-\u001a;H\u0007B\u001bFo\u001c:bO\u0016\u001cuN\u001c4jOR!\u0011QQAJ!\u001dQ\u0013qOADo]\u0002B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u000b\u0018aA4da&!\u0011\u0011SAF\u0005)95\tU$bi\u0016<\u0018-\u001f\u0005\u0007\u0003+\u001b\u0002\u0019A\u001c\u00021\u0011,7\u000f^5oCRLwN\\$D!N#xN]1hKV\u0013\u0016*\u0001\u000be_^tGn\\1e\u0003:$WK\u001c>ja\u001aKG.\u001a\u000b\t\u0003[\tY*a(\u0002$\"1\u0011Q\u0014\u000bA\u0002y\u000bq\u0002Z3ti&t\u0017\r^5p]\u001aKG.\u001a\u0005\b\u0003C#\u0002\u0019AA\u0006\u0003!\u0011Xm]8ve\u000e,\u0007BBAS)\u0001\u0007q'\u0001\u0006tg\u0019KG.\u001a)bi\"$B!!\f\u0002*\"1\u0011QU\u000bA\u0002]\nqbZ3u\t><h\u000e\\8bINK'0\u001a\u000b\u0005\u0003_\u000b9\fE\u0003+\u00037\t\t\fE\u0002+\u0003gK1!!.,\u0005\u0011auN\\4\t\u000f\u0005\u0005b\u00031\u0001\u0002$\u0005Q1\r\\3be\u000e\u000b7\r[3\u0015\t\u0005u\u00161\u0019\t\u0004U\u0005}\u0016bAAaW\t!QK\\5u\u0011\u001d\t\tc\u0006a\u0001\u0003G\tAbZ3u)&lWm\u001d;b[B$B!!3\u0002TB!\u00111ZAh\u001b\t\tiM\u0003\u0003\u0002^\u00055\u0013\u0002BAi\u0003\u001b\u0014\u0011\u0002V5nKN$\u0018-\u001c9\t\u0013\u0005U\u0007\u0004%AA\u0002\u0005]\u0017AC1eI6Kg.\u001e;fgB\u0019!&!7\n\u0007\u0005m7FA\u0002J]R\facZ3u)&lWm\u001d;b[B$C-\u001a4bk2$H%M\u000b\u0003\u0003CTC!a6\u0002d.\u0012\u0011Q\u001d\t\u0005\u0003O\f\t0\u0004\u0002\u0002j*!\u00111^Aw\u0003%)hn\u00195fG.,GMC\u0002\u0002p.\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u00190!;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000bTgI+7o\\;sG\u0016$un\u001e8m_\u0006$WM\u001d\t\u0003am\u0019\"aG\u0015\u0015\u0005\u0005]\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0003\u0002)\u001aq'a9")
public class S3ResourceDownloader
implements ResourceDownloader {
    private AWSGateway awsGateway;
    private final Function0<String> bucket;
    private final Function0<String> s3Path;
    private final Function0<String> cacheFolder;
    private final Function0<String> credentialsType;
    private final String region;
    private final Map<String, RepositoryMetadata> repoFolder2Metadata;
    private final Path cachePath;
    private final FileSystem fileSystem;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$5() {
        return S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public void com$johnsnowlabs$nlp$pretrained$ResourceDownloader$_setter_$fileSystem_$eq(FileSystem x$1) {
        this.fileSystem = x$1;
    }

    private Map<String, RepositoryMetadata> repoFolder2Metadata() {
        return this.repoFolder2Metadata;
    }

    public Path cachePath() {
        return this.cachePath;
    }

    private AWSGateway awsGateway$lzycompute() {
        S3ResourceDownloader s3ResourceDownloader = this;
        synchronized (s3ResourceDownloader) {
            if (!this.bitmap$0) {
                String x$1 = this.region;
                String x$2 = (String)this.credentialsType.apply();
                String x$3 = AWSGateway$.MODULE$.$lessinit$greater$default$1();
                String x$4 = AWSGateway$.MODULE$.$lessinit$greater$default$2();
                String x$5 = AWSGateway$.MODULE$.$lessinit$greater$default$3();
                String x$6 = AWSGateway$.MODULE$.$lessinit$greater$default$4();
                this.awsGateway = new AWSGateway(x$3, x$4, x$5, x$6, x$1, x$2);
                this.bitmap$0 = true;
            }
        }
        return this.awsGateway;
    }

    public AWSGateway awsGateway() {
        return !this.bitmap$0 ? this.awsGateway$lzycompute() : this.awsGateway;
    }

    private boolean doesCacheFolderInCloud() {
        return ((String)this.cacheFolder.apply()).startsWith("s3") || ((String)this.cacheFolder.apply()).startsWith("gs");
    }

    @Override
    public List<ResourceMetadata> downloadMetadataIfNeed(String folder) {
        Option lastState = this.repoFolder2Metadata().get((Object)folder);
        Timestamp fiveMinsBefore = this.getTimestamp(-5);
        boolean needToRefresh = lastState.isEmpty() || ((RepositoryMetadata)lastState.get()).lastMetadataDownloaded().before(fiveMinsBefore);
        return !needToRefresh ? ((RepositoryMetadata)lastState.get()).metadata() : this.awsGateway().getMetadata((String)this.s3Path.apply(), folder, (String)this.bucket.apply());
    }

    public Option<ResourceMetadata> resolveLink(ResourceRequest request) {
        List<ResourceMetadata> metadata = this.downloadMetadataIfNeed(request.folder());
        return ResourceMetadata$.MODULE$.resolveResource(metadata, request);
    }

    @Override
    public Option<String> download(ResourceRequest request) {
        Option<ResourceMetadata> link = this.resolveLink(request);
        return link.flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            Option option;
            String s3FilePath = this.awsGateway().getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)$this.s3Path.apply(), request.folder(), resource.fileName()}));
            if (!this.awsGateway().doesS3ObjectExist((String)$this.bucket.apply(), s3FilePath)) {
                option = None$.MODULE$;
            } else {
                Option option2;
                Regex s3Path = new StringOps(Predef$.MODULE$.augmentString("^s3.*")).r();
                Regex gcpStoragePath = new StringOps(Predef$.MODULE$.augmentString("^gs.*")).r();
                String sourceS3URI = new StringBuilder(7).append("s3a://").append($this.bucket.apply()).append("/").append(s3FilePath).toString();
                String zipFile = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceS3URI.split("/"))).last();
                String modelName = zipFile.substring(0, zipFile.indexOf(".zip"));
                String string = this.cachePath().toString();
                Option option3 = s3Path.unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(0) == 0) {
                    Option option4;
                    String destinationS3URI = this.cachePath().toString().replace("s3:", "s3a:");
                    boolean modelExists = this.doesModelExistInExternalCloudStorage(modelName, destinationS3URI, "S3");
                    if (!modelExists) {
                        String destinationKey = this.unzipInExternalCloudStorage(ResourceHelper$.MODULE$.spark(), sourceS3URI, destinationS3URI, "S3");
                        option4 = Option$.MODULE$.apply((Object)destinationKey);
                    } else {
                        option4 = Option$.MODULE$.apply((Object)new StringBuilder(1).append(destinationS3URI).append("/").append(modelName).toString());
                    }
                    option2 = option4;
                } else {
                    Option option5 = gcpStoragePath.unapplySeq((CharSequence)string);
                    if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(0) == 0) {
                        Option option6;
                        String sourceS3URI2 = new StringBuilder(7).append("s3a://").append($this.bucket.apply()).append("/").append(s3FilePath).toString();
                        boolean modelExists = this.doesModelExistInExternalCloudStorage(modelName, this.cachePath().toString(), "GCP");
                        if (!modelExists) {
                            String destination = this.unzipInExternalCloudStorage(ResourceHelper$.MODULE$.spark(), sourceS3URI2, this.cachePath().toString(), "GCP");
                            option6 = Option$.MODULE$.apply((Object)destination);
                        } else {
                            option6 = Option$.MODULE$.apply((Object)new StringBuilder(1).append(this.cachePath().toString()).append("/").append(modelName).toString());
                        }
                        option2 = option6;
                    } else {
                        Path destinationFile = new Path(this.cachePath().toString(), resource.fileName());
                        option2 = this.downloadAndUnzipFile(destinationFile, (ResourceMetadata)resource, s3FilePath);
                    }
                }
                option = option2;
            }
            return option;
        });
    }

    private boolean doesModelExistInExternalCloudStorage(String modelName, String destinationURI, String destinationCloud) {
        boolean bl;
        String string = destinationCloud;
        if ("S3".equals(string)) {
            Tuple3<String, String, String> tuple3 = ConfigHelper$.MODULE$.getHadoopS3Config();
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String accessKeyId = (String)tuple3._1();
            String secretKey = (String)tuple3._2();
            String sessionToken = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)accessKeyId, (Object)secretKey, (Object)sessionToken);
            Tuple3 tuple33 = tuple32;
            String accessKeyId2 = (String)tuple33._1();
            String secretKey2 = (String)tuple33._2();
            String sessionToken2 = (String)tuple33._3();
            AWSGateway awsDestinationGateway = new AWSGateway(accessKeyId2, secretKey2, sessionToken2, AWSGateway$.MODULE$.$lessinit$greater$default$4(), AWSGateway$.MODULE$.$lessinit$greater$default$5(), AWSGateway$.MODULE$.$lessinit$greater$default$6());
            Tuple2<String, String> tuple2 = ResourceHelper$.MODULE$.parseS3URI(destinationURI);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String destinationBucketName = (String)tuple2._1();
            String destinationKey = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)destinationBucketName, (Object)destinationKey);
            Tuple2 tuple23 = tuple22;
            String destinationBucketName2 = (String)tuple23._1();
            String destinationKey2 = (String)tuple23._2();
            String modelPath = new StringBuilder(1).append(destinationKey2).append("/").append(modelName).toString();
            bl = awsDestinationGateway.doesS3FolderExist(destinationBucketName2, modelPath);
        } else if ("GCP".equals(string)) {
            Tuple3<GCPGateway, String, String> tuple3 = this.getGCPStorageConfig(destinationURI);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            GCPGateway gcpGateway = (GCPGateway)tuple3._1();
            String destinationBucketName = (String)tuple3._2();
            String destinationStoragePath = (String)tuple3._3();
            Tuple3 tuple34 = new Tuple3((Object)gcpGateway, (Object)destinationBucketName, (Object)destinationStoragePath);
            Tuple3 tuple35 = tuple34;
            GCPGateway gcpGateway2 = (GCPGateway)tuple35._1();
            String destinationBucketName3 = (String)tuple35._2();
            String destinationStoragePath2 = (String)tuple35._3();
            String modelPath = new StringBuilder(1).append(destinationStoragePath2).append("/").append(modelName).toString();
            bl = gcpGateway2.doesFolderExist(destinationBucketName3, modelPath);
        } else {
            throw new MatchError((Object)string);
        }
        return bl;
    }

    private String unzipInExternalCloudStorage(SparkSession sparkSession, String sourceS3URI, String destinationStorageURI, String destinationCloud) {
        Tuple2<String, String> tuple2 = ResourceHelper$.MODULE$.parseS3URI(sourceS3URI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sourceBucketName = (String)tuple2._1();
        String sourceKey = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sourceBucketName, (Object)sourceKey);
        Tuple2 tuple23 = tuple22;
        String sourceBucketName2 = (String)tuple23._1();
        String sourceKey2 = (String)tuple23._2();
        S3Object zippedModel = this.awsGateway().getS3Object(sourceBucketName2, sourceKey2);
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)zippedModel.getObjectContent());
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        String zipFile = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceKey2.split("/"))).last();
        String modelName = zipFile.substring(0, zipFile.indexOf(".zip"));
        Predef$.MODULE$.println((Object)new StringBuilder(48).append("Uploading model ").append(modelName).append(" to external Cloud Storage URI: ").append(destinationStorageURI).toString());
        while (zipEntry != null) {
            BoxedUnit boxedUnit;
            if (!zipEntry.isDirectory()) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                String string = destinationCloud;
                String string2 = "S3";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Tuple3<AWSGateway, String, String> tuple3 = this.getS3Config(sparkSession, destinationStorageURI);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    AWSGateway awsGatewayDestination = (AWSGateway)tuple3._1();
                    String destinationBucketName = (String)tuple3._2();
                    String destinationKey = (String)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)awsGatewayDestination, (Object)destinationBucketName, (Object)destinationKey);
                    Tuple3 tuple33 = tuple32;
                    AWSGateway awsGatewayDestination2 = (AWSGateway)tuple33._1();
                    String destinationBucketName2 = (String)tuple33._2();
                    String destinationKey2 = (String)tuple33._3();
                    String fileName = new StringBuilder(1).append(modelName).append("/").append(zipEntry.getName()).toString();
                    String destinationS3Path = new StringBuilder(1).append(destinationKey2).append("/").append(fileName).toString();
                    boxedUnit = awsGatewayDestination2.client().putObject(destinationBucketName2, destinationS3Path, (InputStream)inputStream, new ObjectMetadata());
                } else {
                    Tuple3<GCPGateway, String, String> tuple3 = this.getGCPStorageConfig(destinationStorageURI);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    GCPGateway gcpGateway = (GCPGateway)tuple3._1();
                    String destinationBucketName = (String)tuple3._2();
                    String destinationStoragePath = (String)tuple3._3();
                    Tuple3 tuple34 = new Tuple3((Object)gcpGateway, (Object)destinationBucketName, (Object)destinationStoragePath);
                    Tuple3 tuple35 = tuple34;
                    GCPGateway gcpGateway2 = (GCPGateway)tuple35._1();
                    String destinationBucketName3 = (String)tuple35._2();
                    String destinationStoragePath2 = (String)tuple35._3();
                    String destinationGCPStoragePath = new StringBuilder(2).append(destinationStoragePath2).append("/").append(modelName).append("/").append(zipEntry.getName()).toString();
                    gcpGateway2.copyFileToGCPStorage(destinationBucketName3, destinationGCPStoragePath, inputStream);
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        return new StringBuilder(1).append(destinationStorageURI).append("/").append(modelName).toString();
    }

    private Tuple3<AWSGateway, String, String> getS3Config(SparkSession sparkSession, String destinationS3URI) {
        String accessKeyId = sparkSession.sparkContext().hadoopConfiguration().get("fs.s3a.access.key");
        String secretAccessKey = sparkSession.sparkContext().hadoopConfiguration().get("fs.s3a.secret.key");
        String sessionToken = sparkSession.sparkContext().hadoopConfiguration().get("fs.s3a.session.token");
        if (accessKeyId == null) {
            accessKeyId = "";
        }
        if (secretAccessKey == null) {
            secretAccessKey = "";
        }
        if (sessionToken == null) {
            sessionToken = "";
        }
        String string = accessKeyId;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = secretAccessKey;
            String string4 = "";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                throw new IllegalAccessException("Using S3 as cachePath requires to define access.key and secret.key hadoop configuration");
            }
        }
        AWSGateway awsGatewayDestination = new AWSGateway(accessKeyId, secretAccessKey, sessionToken, AWSGateway$.MODULE$.$lessinit$greater$default$4(), AWSGateway$.MODULE$.$lessinit$greater$default$5(), AWSGateway$.MODULE$.$lessinit$greater$default$6());
        Tuple2<String, String> tuple2 = ResourceHelper$.MODULE$.parseS3URI(destinationS3URI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String destinationBucketName = (String)tuple2._1();
        String destinationKey = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)destinationBucketName, (Object)destinationKey);
        Tuple2 tuple23 = tuple22;
        String destinationBucketName2 = (String)tuple23._1();
        String destinationKey2 = (String)tuple23._2();
        return new Tuple3((Object)awsGatewayDestination, (Object)destinationBucketName2, (Object)destinationKey2);
    }

    private Tuple3<GCPGateway, String, String> getGCPStorageConfig(String destinationGCPStorageURI) {
        GCPGateway gcpGateway = new GCPGateway(GCPGateway$.MODULE$.$lessinit$greater$default$1());
        Tuple2<String, String> tuple2 = ResourceHelper$.MODULE$.parseGCPStorageURI(destinationGCPStorageURI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String destinationBucketName = (String)tuple2._1();
        String destinationStoragePath = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)destinationBucketName, (Object)destinationStoragePath);
        Tuple2 tuple23 = tuple22;
        String destinationBucketName2 = (String)tuple23._1();
        String destinationStoragePath2 = (String)tuple23._2();
        return new Tuple3((Object)gcpGateway, (Object)destinationBucketName2, (Object)destinationStoragePath2);
    }

    public Option<String> downloadAndUnzipFile(Path destinationFile, ResourceMetadata resource, String s3FilePath) {
        Some some;
        String splitPath = destinationFile.toString().substring(0, destinationFile.toString().length() - 4);
        if (!this.fileSystem().exists(destinationFile) && !this.fileSystem().exists(new Path(splitPath))) {
            String tmpFileName = ((Object)Files.createTempFile(resource.fileName(), "", new FileAttribute[0])).toString();
            File tmpFile = new File(tmpFileName);
            this.awsGateway().getS3Object((String)this.bucket.apply(), s3FilePath, tmpFile);
            if (!resource.checksum().equals("")) {
                Predef$.MODULE$.require(FileHelper$.MODULE$.generateChecksum(tmpFileName).equals(resource.checksum()), (Function0 & Serializable & scala.Serializable)() -> "Checksum validation failed!");
            }
            this.fileSystem().moveFromLocalFile(new Path(tmpFile.toString()), destinationFile);
        }
        if (resource.isZipped()) {
            Object object;
            if (!this.fileSystem().exists(new Path(splitPath))) {
                ZipInputStream zis = new ZipInputStream((InputStream)this.fileSystem().open(destinationFile));
                byte[] buf = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
                ZipEntry entry = zis.getNextEntry();
                String string = destinationFile.toString().substring(destinationFile.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Not a zip file.");
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        Path entryName = new Path(splitPath, entry.getName());
                        FSDataOutputStream outputStream = this.fileSystem().create(entryName);
                        int bytesRead = zis.read(buf, 0, 1024);
                        while (bytesRead > -1) {
                            outputStream.write(buf, 0, bytesRead);
                            bytesRead = zis.read(buf, 0, 1024);
                        }
                        outputStream.close();
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
                zis.close();
                object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(destinationFile, true));
            } else {
                object = BoxedUnit.UNIT;
            }
            some = new Some((Object)splitPath);
        } else {
            some = new Some((Object)destinationFile.getName());
        }
        return some;
    }

    @Override
    public Option<String> downloadAndUnzipFile(String s3FilePath) {
        Object object;
        String s3File = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s3FilePath.split("/"))).last();
        Path destinationFile = new Path(new StringBuilder(1).append(this.cachePath().toString()).append("/").append(s3File).toString());
        String splitPath = destinationFile.toString().substring(0, destinationFile.toString().length() - 4);
        if (!this.fileSystem().exists(destinationFile) && !this.fileSystem().exists(new Path(splitPath))) {
            String tmpFileName = ((Object)Files.createTempFile(s3File, "", new FileAttribute[0])).toString();
            File tmpFile = new File(tmpFileName);
            String newStrfilePath = s3FilePath;
            String mybucket = (String)this.bucket.apply();
            this.awsGateway().getS3Object(mybucket, newStrfilePath, tmpFile);
            this.fileSystem().moveFromLocalFile(new Path(tmpFile.toString()), destinationFile);
        }
        if (!this.fileSystem().exists(new Path(splitPath))) {
            ZipInputStream zis = new ZipInputStream((InputStream)this.fileSystem().open(destinationFile));
            byte[] buf = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
            ZipEntry entry = zis.getNextEntry();
            String string = destinationFile.toString().substring(destinationFile.toString().length() - 4);
            String string2 = ".zip";
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Not a zip file.");
            while (entry != null) {
                if (!entry.isDirectory()) {
                    Path entryName = new Path(splitPath, entry.getName());
                    FSDataOutputStream outputStream = this.fileSystem().create(entryName);
                    int bytesRead = zis.read(buf, 0, 1024);
                    while (bytesRead > -1) {
                        outputStream.write(buf, 0, bytesRead);
                        bytesRead = zis.read(buf, 0, 1024);
                    }
                    outputStream.close();
                }
                zis.closeEntry();
                entry = zis.getNextEntry();
            }
            zis.close();
            object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(destinationFile, true));
        } else {
            object = BoxedUnit.UNIT;
        }
        return new Some((Object)splitPath);
    }

    @Override
    public Option<Object> getDownloadSize(ResourceRequest request) {
        Option<ResourceMetadata> link = this.resolveLink(request);
        return link.flatMap((Function1 & Serializable & scala.Serializable)resource -> this.awsGateway().getS3DownloadSize((String)$this.s3Path.apply(), request.folder(), resource.fileName(), (String)$this.bucket.apply()));
    }

    @Override
    public void clearCache(ResourceRequest request) {
        List<ResourceMetadata> metadata = this.downloadMetadataIfNeed(request.folder());
        Option<ResourceMetadata> resources = ResourceMetadata$.MODULE$.resolveResource(metadata, request);
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            Object object;
            Path fileName = new Path(this.cachePath().toString(), resource.fileName());
            Object object2 = this.fileSystem().exists(fileName) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(fileName, true)) : BoxedUnit.UNIT;
            if (resource.isZipped()) {
                String string = fileName.toString().substring(fileName.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
                String unzipped = fileName.toString().substring(0, fileName.toString().length() - 4);
                Path unzippedFile = new Path(unzipped);
                object = this.fileSystem().exists(unzippedFile) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(unzippedFile, true)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Timestamp getTimestamp(int addMinutes) {
        void var3_3;
        Calendar cal = Calendar.getInstance();
        cal.add(12, addMinutes);
        Timestamp timestamp = new Timestamp(cal.getTime().getTime());
        cal.clear();
        return var3_3;
    }

    private int getTimestamp$default$1() {
        return 0;
    }

    public S3ResourceDownloader(Function0<String> bucket, Function0<String> s3Path, Function0<String> cacheFolder, Function0<String> credentialsType, String region) {
        this.bucket = bucket;
        this.s3Path = s3Path;
        this.cacheFolder = cacheFolder;
        this.credentialsType = credentialsType;
        this.region = region;
        ResourceDownloader.$init$(this);
        this.repoFolder2Metadata = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.cachePath = new Path((String)cacheFolder.apply());
        Object object = !this.doesCacheFolderInCloud() && !this.fileSystem().exists(this.cachePath()) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().mkdirs(this.cachePath())) : BoxedUnit.UNIT;
    }
}

