/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.johnsnowlabs.client.aws.AWSGateway;
import com.johnsnowlabs.client.aws.AWSGateway$;
import com.johnsnowlabs.nlp.pretrained.ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceRequest;
import com.johnsnowlabs.nlp.pretrained.ResourceRequest$;
import com.johnsnowlabs.nlp.pretrained.ResourceType$;
import com.johnsnowlabs.nlp.pretrained.S3ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.S3ResourceDownloader$;
import com.johnsnowlabs.nlp.util.io.OutputHelper$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.Build$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import com.johnsnowlabs.util.FileHelper$;
import com.johnsnowlabs.util.Version;
import com.johnsnowlabs.util.Version$;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.SparkFiles$;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineModel$;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ResourceDownloader$ {
    public static ResourceDownloader$ MODULE$;
    private Version sparkVersion;
    private Version libVersion;
    private final Logger logger;
    private final FileSystem fileSystem;
    private final String publicLoc;
    private final Map<ResourceRequest, PipelineStage> cache;
    private ResourceDownloader privateDownloader;
    private ResourceDownloader publicDownloader;
    private ResourceDownloader communityDownloader;
    private volatile byte bitmap$0;

    static {
        new ResourceDownloader$();
    }

    private Logger logger() {
        return this.logger;
    }

    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    public String s3Bucket() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.pretrainedS3BucketKey());
    }

    public String s3BucketCommunity() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.pretrainedCommunityS3BucketKey());
    }

    public String s3Path() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.pretrainedS3PathKey());
    }

    public String cacheFolder() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.pretrainedCacheFolder());
    }

    public String publicLoc() {
        return this.publicLoc;
    }

    private Map<ResourceRequest, PipelineStage> cache() {
        return this.cache;
    }

    private Version sparkVersion$lzycompute() {
        ResourceDownloader$ resourceDownloader$ = this;
        synchronized (resourceDownloader$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String spark_version = ResourceHelper$.MODULE$.spark().version();
                this.sparkVersion = Version$.MODULE$.parse(spark_version);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkVersion;
    }

    public Version sparkVersion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.sparkVersion$lzycompute() : this.sparkVersion;
    }

    private Version libVersion$lzycompute() {
        ResourceDownloader$ resourceDownloader$ = this;
        synchronized (resourceDownloader$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.libVersion = Version$.MODULE$.parse(Build$.MODULE$.version());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.libVersion;
    }

    public Version libVersion() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.libVersion$lzycompute() : this.libVersion;
    }

    public ResourceDownloader privateDownloader() {
        return this.privateDownloader;
    }

    public void privateDownloader_$eq(ResourceDownloader x$1) {
        this.privateDownloader = x$1;
    }

    public ResourceDownloader publicDownloader() {
        return this.publicDownloader;
    }

    public void publicDownloader_$eq(ResourceDownloader x$1) {
        this.publicDownloader = x$1;
    }

    public ResourceDownloader communityDownloader() {
        return this.communityDownloader;
    }

    public void communityDownloader_$eq(ResourceDownloader x$1) {
        this.communityDownloader = x$1;
    }

    public ResourceDownloader getResourceDownloader(String folder) {
        String string = folder;
        String string2 = this.publicLoc();
        String string3 = string;
        ResourceDownloader resourceDownloader = !(string2 != null ? !string2.equals(string3) : string3 != null) ? this.publicDownloader() : (string.startsWith("@") ? this.communityDownloader() : this.privateDownloader());
        return resourceDownloader;
    }

    public void resetResourceDownloader() {
        this.cache().empty();
        this.privateDownloader_$eq(new S3ResourceDownloader((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Bucket(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Path(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.cacheFolder(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "private", S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5()));
    }

    public List<String> listPublicModels() {
        return this.listPretrainedResources(this.publicLoc(), ResourceType$.MODULE$.MODEL(), this.listPretrainedResources$default$3(), this.listPretrainedResources$default$4(), this.listPretrainedResources$default$5());
    }

    public void showPublicModels(Option<String> annotator, Option<String> lang, Option<String> version) {
        Predef$.MODULE$.println((Object)this.publicResourceString(annotator, lang, version, ResourceType$.MODULE$.MODEL()));
    }

    public void showPublicModels(String annotator) {
        this.showPublicModels((Option<String>)new Some((Object)annotator), this.showPublicModels$default$2(), this.showPublicModels$default$3());
    }

    public void showPublicModels(String annotator, String lang) {
        this.showPublicModels((Option<String>)new Some((Object)annotator), (Option<String>)new Some((Object)lang), this.showPublicModels$default$3());
    }

    public void showPublicModels(String annotator, String lang, String version) {
        this.showPublicModels((Option<String>)new Some((Object)annotator), (Option<String>)new Some((Object)lang), (Option<String>)new Some((Object)version));
    }

    public Option<String> showPublicModels$default$1() {
        return None$.MODULE$;
    }

    public Option<String> showPublicModels$default$2() {
        return None$.MODULE$;
    }

    public Option<String> showPublicModels$default$3() {
        return new Some((Object)Build$.MODULE$.version());
    }

    public List<String> listPublicPipelines() {
        return this.listPretrainedResources(this.publicLoc(), ResourceType$.MODULE$.PIPELINE(), this.listPretrainedResources$default$3(), this.listPretrainedResources$default$4(), this.listPretrainedResources$default$5());
    }

    public void showPublicPipelines(Option<String> lang, Option<String> version) {
        Predef$.MODULE$.println((Object)this.publicResourceString((Option<String>)None$.MODULE$, lang, version, ResourceType$.MODULE$.PIPELINE()));
    }

    public void showPublicPipelines(String lang) {
        this.showPublicPipelines((Option<String>)new Some((Object)lang), this.showPublicPipelines$default$2());
    }

    public void showPublicPipelines(String lang, String version) {
        this.showPublicPipelines((Option<String>)new Some((Object)lang), (Option<String>)new Some((Object)version));
    }

    public Option<String> showPublicPipelines$default$1() {
        return None$.MODULE$;
    }

    public Option<String> showPublicPipelines$default$2() {
        return new Some((Object)Build$.MODULE$.version());
    }

    public List<String> listUnCategorizedResources() {
        return this.listPretrainedResources(this.publicLoc(), ResourceType$.MODULE$.NOT_DEFINED(), this.listPretrainedResources$default$3(), this.listPretrainedResources$default$4(), this.listPretrainedResources$default$5());
    }

    public void showUnCategorizedResources(String lang) {
        Predef$.MODULE$.println((Object)this.publicResourceString((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)lang), (Option<String>)None$.MODULE$, ResourceType$.MODULE$.NOT_DEFINED()));
    }

    public void showUnCategorizedResources(String lang, String version) {
        Predef$.MODULE$.println((Object)this.publicResourceString((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)lang), (Option<String>)new Some((Object)version), ResourceType$.MODULE$.NOT_DEFINED()));
    }

    public String showString(List<String> list, Enumeration.Value resourceType) {
        StringBuilder sb = new StringBuilder();
        IntRef max_length = IntRef.create((int)14);
        IntRef max_length_version = IntRef.create((int)7);
        list.foreach((Function1 & Serializable & scala.Serializable)data -> {
            ResourceDownloader$.$anonfun$showString$1(max_length, max_length_version, data);
            return BoxedUnit.UNIT;
        });
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length.elem + 2));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length_version.elem + 2));
        sb.append("+\n");
        StringBuilder stringBuilder = resourceType.equals((Object)ResourceType$.MODULE$.PIPELINE()) ? sb.append(new java.lang.StringBuilder(30).append("| Pipeline").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length.elem - 8)).append(" | ").append("lang").append(" | ").append("version").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length_version.elem - 7)).append(" |\n").toString()) : (resourceType.equals((Object)ResourceType$.MODULE$.MODEL()) ? sb.append(new java.lang.StringBuilder(27).append("| Model").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length.elem - 5)).append(" | ").append("lang").append(" | ").append("version").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length_version.elem - 7)).append(" |\n").toString()) : sb.append(new java.lang.StringBuilder(36).append("| Pipeline/Model").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length.elem - 14)).append(" | ").append("lang").append(" | ").append("version").append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length_version.elem - 7)).append(" |\n").toString()));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length.elem + 2));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length_version.elem + 2));
        sb.append("+\n");
        list.foreach((Function1 & Serializable & scala.Serializable)data -> {
            String[] temp = data.split(":");
            return sb.append(new java.lang.StringBuilder(13).append("| ").append(temp[0]).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length$1.elem - temp[0].length())).append(" |  ").append(temp[1]).append("  | ").append(temp[2]).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(max_length_version$1.elem - temp[2].length())).append(" |\n").toString());
        });
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length.elem + 2));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6));
        sb.append("+");
        sb.append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(max_length_version.elem + 2));
        sb.append("+\n");
        return sb.toString();
    }

    public String publicResourceString(Option<String> annotator, Option<String> lang, Option<String> version, Enumeration.Value resourceType) {
        None$ none$;
        String string = this.publicLoc();
        Option<String> option = version;
        if (option instanceof Some) {
            Some some = (Some)option;
            String ver = (String)some.value();
            none$ = new Some((Object)Version$.MODULE$.parse(ver));
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return this.showString(this.listPretrainedResources(string, resourceType, annotator, lang, (Option<Version>)none$), resourceType);
    }

    public Option<String> publicResourceString$default$1() {
        return None$.MODULE$;
    }

    public Option<String> publicResourceString$default$2() {
        return None$.MODULE$;
    }

    public Option<String> publicResourceString$default$3() {
        return new Some((Object)Build$.MODULE$.version());
    }

    public List<String> listPretrainedResources(String folder, Enumeration.Value resourceType, Option<String> annotator, Option<String> lang, Option<Version> version) {
        ListBuffer resourceList = new ListBuffer();
        List<ResourceMetadata> resourceMetaData = this.getResourceMetadata(folder);
        resourceMetaData.foreach((Function1 & Serializable & scala.Serializable)meta -> {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean isSameResourceType = meta.category().getOrElse((Function0 & Serializable & scala.Serializable)() -> ResourceType$.MODULE$.NOT_DEFINED()).toString().equals(resourceType.toString());
            Option option = version;
            if (option instanceof Some) {
                Some some = (Some)option;
                Version ver = (Version)some.value();
                bl3 = Version$.MODULE$.isCompatible(ver, meta.libVersion());
            } else if (None$.MODULE$.equals(option)) {
                bl3 = true;
            } else {
                throw new MatchError((Object)option);
            }
            boolean isCompatibleWithVersion = bl3;
            Option option2 = annotator;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String cls = (String)some.value();
                bl2 = ((String)meta.annotator().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).equalsIgnoreCase(cls);
            } else if (None$.MODULE$.equals(option2)) {
                bl2 = true;
            } else {
                throw new MatchError((Object)option2);
            }
            boolean isSameAnnotator = bl2;
            Option option3 = lang;
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                String l = (String)some.value();
                bl = ((String)meta.language().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).equalsIgnoreCase(l);
            } else if (None$.MODULE$.equals(option3)) {
                bl = true;
            } else {
                throw new MatchError((Object)option3);
            }
            boolean isSameLanguage = bl;
            return isSameResourceType & isCompatibleWithVersion & isSameAnnotator & isSameLanguage ? resourceList.$plus$eq((Object)new java.lang.StringBuilder(2).append(meta.name()).append(":").append(meta.language().getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).append(":").append(meta.libVersion().getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).toString()) : BoxedUnit.UNIT;
        });
        return resourceList.result();
    }

    public List<String> listPretrainedResources(String folder, Enumeration.Value resourceType, String lang) {
        String x$1 = folder;
        Enumeration.Value x$2 = resourceType;
        Some x$3 = new Some((Object)lang);
        Option<String> x$4 = this.listPretrainedResources$default$3();
        Option<Version> x$5 = this.listPretrainedResources$default$5();
        return this.listPretrainedResources(x$1, x$2, x$4, (Option<String>)x$3, x$5);
    }

    public List<String> listPretrainedResources(String folder, Enumeration.Value resourceType, Version version) {
        String x$1 = folder;
        Enumeration.Value x$2 = resourceType;
        Some x$3 = new Some((Object)version);
        Option<String> x$4 = this.listPretrainedResources$default$3();
        Option<String> x$5 = this.listPretrainedResources$default$4();
        return this.listPretrainedResources(x$1, x$2, x$4, x$5, (Option<Version>)x$3);
    }

    public List<String> listPretrainedResources(String folder, Enumeration.Value resourceType, String lang, Version version) {
        String x$1 = folder;
        Enumeration.Value x$2 = resourceType;
        Some x$3 = new Some((Object)lang);
        Some x$4 = new Some((Object)version);
        Option<String> x$5 = this.listPretrainedResources$default$3();
        return this.listPretrainedResources(x$1, x$2, x$5, (Option<String>)x$3, (Option<Version>)x$4);
    }

    public Option<String> listPretrainedResources$default$3() {
        return None$.MODULE$;
    }

    public Option<String> listPretrainedResources$default$4() {
        return None$.MODULE$;
    }

    public Option<Version> listPretrainedResources$default$5() {
        return None$.MODULE$;
    }

    public List<String> listAvailableAnnotators(String folder) {
        List<ResourceMetadata> resourceMetaData = this.getResourceMetadata(folder);
        return (List)((TraversableOnce)((TraversableOnce)resourceMetaData.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.annotator().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), List$.MODULE$.canBuildFrom())).toSet().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)ResourceDownloader$.$anonfun$listAvailableAnnotators$3(a)))).toList().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public String listAvailableAnnotators$default$1() {
        return this.publicLoc();
    }

    private List<ResourceMetadata> getResourceMetadata(String location) {
        return this.getResourceDownloader(location).downloadMetadataIfNeed(location);
    }

    public void showAvailableAnnotators(String folder) {
        Predef$.MODULE$.println((Object)this.listAvailableAnnotators(folder).mkString("\n"));
    }

    public String showAvailableAnnotators$default$1() {
        return this.publicLoc();
    }

    public String downloadResource(String name, Option<String> language, String folder) {
        return this.downloadResource(new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
    }

    public String downloadResource(ResourceRequest request) {
        Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ResourceRequest resourceRequest;
            if (request.folder().startsWith("@")) {
                String x$1 = request.folder().replace("@", "");
                String x$2 = request.copy$default$1();
                Option<String> x$3 = request.copy$default$2();
                Version x$4 = request.copy$default$4();
                Version x$5 = request.copy$default$5();
                resourceRequest = request.copy(x$2, x$3, x$1, x$4, x$5);
            } else {
                resourceRequest = request;
            }
            ResourceRequest updatedRequest = resourceRequest;
            return MODULE$.getResourceDownloader(request.folder()).download(updatedRequest);
        }, ExecutionContext.Implicits$.MODULE$.global());
        BooleanRef downloadFinished = BooleanRef.create((boolean)false);
        ObjectRef path = ObjectRef.create((Object)None$.MODULE$);
        String fileSize = this.getDownloadSize(request);
        Predef$.MODULE$.require(!fileSize.equals("-1"), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(86).append("Can not find ").append(request.name()).append(" inside ").append(request.folder()).append(" to download. Please make sure the name and location are correct!").toString());
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(42).append(request.name()).append(" download started this may take some time.").toString());
        Predef$.MODULE$.println((Object)new java.lang.StringBuilder(29).append("Approximate size to download ").append(fileSize).toString());
        while (!downloadFinished.elem) {
            future.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ResourceDownloader$.$anonfun$downloadResource$3(downloadFinished, path, x0$1);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
            Thread.sleep(1000L);
        }
        Predef$.MODULE$.require(((Option)path.elem).isDefined(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(78).append("Was not found appropriate resource to download for request: ").append(request).append(" with downloader: ").append(MODULE$.privateDownloader()).toString());
        Predef$.MODULE$.println((Object)"Download done! Loading the resource.");
        return (String)((Option)path.elem).get();
    }

    public Option<String> downloadResource$default$2() {
        return None$.MODULE$;
    }

    public String downloadResource$default$3() {
        return this.publicLoc();
    }

    public void downloadModelDirectly(String model, String folder, boolean unzip) {
        this.getResourceDownloader(folder).downloadAndUnzipFile(model, unzip);
    }

    public <TModel extends PipelineStage> TModel downloadModel(DefaultParamsReadable<TModel> reader, String name, Option<String> language, String folder) {
        return this.downloadModel(reader, new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
    }

    public <TModel extends PipelineStage> TModel downloadModel(DefaultParamsReadable<TModel> reader, ResourceRequest request) {
        PipelineStage pipelineStage;
        if (!this.cache().contains((Object)request)) {
            String path = this.downloadResource(request);
            PipelineStage model = (PipelineStage)reader.read().load(path);
            this.cache().update((Object)request, (Object)model);
            pipelineStage = model;
        } else {
            pipelineStage = (PipelineStage)this.cache().apply((Object)request);
        }
        return (TModel)pipelineStage;
    }

    public String downloadModelDirectly$default$2() {
        return this.publicLoc();
    }

    public boolean downloadModelDirectly$default$3() {
        return true;
    }

    public <TModel extends PipelineStage> Option<String> downloadModel$default$3() {
        return None$.MODULE$;
    }

    public <TModel extends PipelineStage> String downloadModel$default$4() {
        return this.publicLoc();
    }

    public PipelineModel downloadPipeline(String name, Option<String> language, String folder) {
        return this.downloadPipeline(new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
    }

    /*
     * WARNING - void declaration
     */
    public PipelineModel downloadPipeline(ResourceRequest request) {
        PipelineModel pipelineModel;
        if (!this.cache().contains((Object)request)) {
            void var3_3;
            String path = this.downloadResource(request);
            PipelineModel model = (PipelineModel)PipelineModel$.MODULE$.read().load(path);
            this.cache().update((Object)request, (Object)model);
            pipelineModel = var3_3;
        } else {
            pipelineModel = (PipelineModel)this.cache().apply((Object)request);
        }
        return pipelineModel;
    }

    public Option<String> downloadPipeline$default$2() {
        return None$.MODULE$;
    }

    public String downloadPipeline$default$3() {
        return this.publicLoc();
    }

    public void clearCache(String name, Option<String> language, String folder) {
        this.clearCache(new ResourceRequest(name, language, folder, ResourceRequest$.MODULE$.apply$default$4(), ResourceRequest$.MODULE$.apply$default$5()));
    }

    public void clearCache(ResourceRequest request) {
        this.privateDownloader().clearCache(request);
        this.publicDownloader().clearCache(request);
        this.communityDownloader().clearCache(request);
        this.cache().remove((Object)request);
    }

    public Option<String> clearCache$default$2() {
        return None$.MODULE$;
    }

    public String clearCache$default$3() {
        return this.publicLoc();
    }

    public String getDownloadSize(ResourceRequest resourceRequest) {
        String string;
        Option<Object> size;
        ResourceRequest resourceRequest2;
        if (resourceRequest.folder().startsWith("@")) {
            String x$1 = resourceRequest.folder().replace("@", "");
            String x$2 = resourceRequest.copy$default$1();
            Option<String> x$3 = resourceRequest.copy$default$2();
            Version x$4 = resourceRequest.copy$default$4();
            Version x$5 = resourceRequest.copy$default$5();
            resourceRequest2 = resourceRequest.copy(x$2, x$3, x$1, x$4, x$5);
        } else {
            resourceRequest2 = resourceRequest;
        }
        ResourceRequest updatedResourceRequest = resourceRequest2;
        Option<Object> option = size = this.getResourceDownloader(resourceRequest.folder()).getDownloadSize(updatedResourceRequest);
        if (option instanceof Some) {
            Some some = (Some)option;
            long downloadBytes = BoxesRunTime.unboxToLong((Object)some.value());
            string = FileHelper$.MODULE$.getHumanReadableFileSize(downloadBytes);
        } else if (None$.MODULE$.equals(option)) {
            string = "-1";
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public URI downloadS3Directory(String s3Path, String tempLocalPath, boolean isIndex) {
        AWSGateway aWSGateway;
        boolean privateS3Defined;
        Tuple2<String, String> tuple2 = ResourceHelper$.MODULE$.parseS3URI(s3Path);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String bucketName = (String)tuple2._1();
        String keyPrefix = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)bucketName, (Object)keyPrefix);
        Tuple2 tuple23 = tuple22;
        String bucketName2 = (String)tuple23._1();
        String keyPrefix2 = (String)tuple23._2();
        Tuple3<String, String, String> tuple3 = ConfigHelper$.MODULE$.getHadoopS3Config();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String accessKey = (String)tuple3._1();
        String secretKey = (String)tuple3._2();
        String sessionToken = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)accessKey, (Object)secretKey, (Object)sessionToken);
        Tuple3 tuple33 = tuple32;
        String accessKey2 = (String)tuple33._1();
        String secretKey2 = (String)tuple33._2();
        String sessionToken2 = (String)tuple33._3();
        String region = ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalRegion());
        boolean bl = privateS3Defined = accessKey2 != null && secretKey2 != null && sessionToken2 != null && new StringOps(Predef$.MODULE$.augmentString(region)).nonEmpty();
        if (privateS3Defined) {
            String x$1 = accessKey2;
            String x$2 = secretKey2;
            String x$3 = sessionToken2;
            String x$4 = region;
            String x$5 = AWSGateway$.MODULE$.$lessinit$greater$default$4();
            String x$6 = AWSGateway$.MODULE$.$lessinit$greater$default$6();
            aWSGateway = new AWSGateway(x$1, x$2, x$3, x$5, x$4, x$6);
        } else {
            if (accessKey2 != null || secretKey2 != null || sessionToken2 != null) {
                this.logger().info("Not all configs set for private S3 access. Defaulting to public downloader.");
            }
            String x$7 = "public";
            String x$8 = AWSGateway$.MODULE$.$lessinit$greater$default$1();
            String x$9 = AWSGateway$.MODULE$.$lessinit$greater$default$2();
            String x$10 = AWSGateway$.MODULE$.$lessinit$greater$default$3();
            String x$11 = AWSGateway$.MODULE$.$lessinit$greater$default$4();
            String x$12 = AWSGateway$.MODULE$.$lessinit$greater$default$5();
            aWSGateway = new AWSGateway(x$8, x$9, x$10, x$11, x$12, x$7);
        }
        AWSGateway awsGateway = aWSGateway;
        String directory = tempLocalPath.isEmpty() ? SparkFiles$.MODULE$.getRootDirectory() : tempLocalPath;
        awsGateway.downloadFilesFromDirectory(bucketName2, keyPrefix2, new File(directory), isIndex);
        return Paths.get(directory, keyPrefix2).toUri();
    }

    public String downloadS3Directory$default$2() {
        return "";
    }

    public boolean downloadS3Directory$default$3() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$showString$1(IntRef max_length$1, IntRef max_length_version$1, String data) {
        String[] temp = data.split(":");
        max_length$1.elem = package$.MODULE$.max(temp[0].length(), max_length$1.elem);
        max_length_version$1.elem = package$.MODULE$.max(temp[2].length(), max_length_version$1.elem);
    }

    public static final /* synthetic */ boolean $anonfun$listAvailableAnnotators$3(String a) {
        return !a.equals("");
    }

    public static final /* synthetic */ void $anonfun$downloadResource$3(BooleanRef downloadFinished$1, ObjectRef path$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Option value = (Option)success.value();
            downloadFinished$1.elem = true;
            path$1.elem = value;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(7).append("Error: ").append(exception.getMessage()).toString());
            MODULE$.logger().error(exception.getMessage());
            downloadFinished$1.elem = true;
            path$1.elem = None$.MODULE$;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private ResourceDownloader$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)this.getClass().toString());
        this.fileSystem = OutputHelper$.MODULE$.getFileSystem();
        this.publicLoc = "public/models";
        this.cache = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.privateDownloader = new S3ResourceDownloader((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Bucket(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Path(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.cacheFolder(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "private", S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5());
        this.publicDownloader = new S3ResourceDownloader((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Bucket(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Path(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.cacheFolder(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "public", S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5());
        this.communityDownloader = new S3ResourceDownloader((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3BucketCommunity(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.s3Path(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> MODULE$.cacheFolder(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "community", S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5());
    }
}

