/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.util.io;

import com.johnsnowlabs.client.aws.AWSGateway;
import com.johnsnowlabs.client.aws.AWSGateway$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFiles$;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class OutputHelper$ {
    public static OutputHelper$ MODULE$;
    private FileSystem fileSystem;
    private SparkSession sparkSession;
    private boolean isDBFS;
    private Path targetPath;
    private String[] historyLog;
    private volatile byte bitmap$0;

    static {
        new OutputHelper$();
    }

    private FileSystem fileSystem$lzycompute() {
        OutputHelper$ outputHelper$ = this;
        synchronized (outputHelper$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.fileSystem = this.getFileSystem();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.fileSystem;
    }

    private FileSystem fileSystem() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.fileSystem$lzycompute() : this.fileSystem;
    }

    private SparkSession sparkSession$lzycompute() {
        OutputHelper$ outputHelper$ = this;
        synchronized (outputHelper$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkSession = ResourceHelper$.MODULE$.spark();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkSession;
    }

    private SparkSession sparkSession() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    public FileSystem getFileSystem() {
        return FileSystem.get((Configuration)this.sparkSession().sparkContext().hadoopConfiguration());
    }

    public FileSystem getFileSystem(String resource) {
        Path resourcePath = new Path(this.parsePath(resource));
        return FileSystem.get((URI)resourcePath.toUri(), (Configuration)this.sparkSession().sparkContext().hadoopConfiguration());
    }

    public String parsePath(String path) {
        String string;
        String pathPrefix = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("://"))).head();
        String string2 = pathPrefix;
        if ("s3".equals(string2)) {
            string = path.replace("s3", "s3a");
        } else if ("file".equals(string2)) {
            Regex pattern = new StringOps(Predef$.MODULE$.augmentString("^file:(/+)")).r();
            string = pattern.replaceAllIn((CharSequence)path, "file:///");
        } else {
            string = path;
        }
        return string;
    }

    public Tuple2<Object, Option<Path>> doesPathExists(String resource) {
        Tuple2 tuple2;
        FileSystem fileSystem = this.getFileSystem(resource);
        ObjectRef modifiedPath = ObjectRef.create((Object)resource);
        String string = fileSystem.getScheme();
        if ("file".equals(string)) {
            boolean bl;
            Path path = new Path(resource);
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fileSystem.exists(path));
            if (try_ instanceof Success) {
                boolean value;
                Success success = (Success)try_;
                bl = value = BoxesRunTime.unboxToBoolean((Object)success.value());
            } else if (try_ instanceof Failure) {
                bl = false;
            } else {
                throw new MatchError((Object)try_);
            }
            boolean exists = bl;
            if (!exists) {
                boolean bl2;
                modifiedPath.elem = resource.replaceFirst("//+", "///");
                Try try_2 = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fileSystem.exists(new Path((String)modifiedPath$1.elem)));
                if (try_2 instanceof Success) {
                    boolean value;
                    Success success = (Success)try_2;
                    bl2 = value = BoxesRunTime.unboxToBoolean((Object)success.value());
                } else if (try_2 instanceof Failure) {
                    bl2 = false;
                } else {
                    throw new MatchError((Object)try_2);
                }
                exists = bl2;
            }
            if (!exists) {
                boolean bl3;
                modifiedPath.elem = resource.replaceFirst("/+", "//");
                Try try_3 = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fileSystem.exists(new Path((String)modifiedPath$1.elem)));
                if (try_3 instanceof Success) {
                    boolean value;
                    Success success = (Success)try_3;
                    bl3 = value = BoxesRunTime.unboxToBoolean((Object)success.value());
                } else if (try_3 instanceof Failure) {
                    bl3 = false;
                } else {
                    throw new MatchError((Object)try_3);
                }
                exists = bl3;
            }
            if (!exists) {
                boolean bl4;
                Regex pattern = new StringOps(Predef$.MODULE$.augmentString("^file:/*")).r();
                modifiedPath.elem = pattern.replaceAllIn((CharSequence)resource, "");
                Try try_4 = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fileSystem.exists(new Path((String)modifiedPath$1.elem)));
                if (try_4 instanceof Success) {
                    boolean value;
                    Success success = (Success)try_4;
                    bl4 = value = BoxesRunTime.unboxToBoolean((Object)success.value());
                } else if (try_4 instanceof Failure) {
                    bl4 = false;
                } else {
                    throw new MatchError((Object)try_4);
                }
                exists = bl4;
            }
            tuple2 = exists ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exists), (Object)new Some((Object)new Path((String)modifiedPath.elem))) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exists), (Object)None$.MODULE$);
        } else {
            boolean bl;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                String modifiedPath = MODULE$.parsePath(resource);
                return fileSystem.exists(new Path(modifiedPath));
            });
            if (try_ instanceof Success) {
                boolean value;
                Success success = (Success)try_;
                bl = value = BoxesRunTime.unboxToBoolean((Object)success.value());
            } else if (try_ instanceof Failure) {
                bl = false;
            } else {
                throw new MatchError((Object)try_);
            }
            boolean exists = bl;
            tuple2 = exists ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exists), (Object)new Some((Object)new Path((String)modifiedPath.elem))) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exists), (Object)None$.MODULE$);
        }
        return tuple2;
    }

    private String getLogsFolder() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.annotatorLogFolder());
    }

    private boolean isDBFS$lzycompute() {
        OutputHelper$ outputHelper$ = this;
        synchronized (outputHelper$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isDBFS = this.fileSystem().getScheme().equals("dbfs");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isDBFS;
    }

    private boolean isDBFS() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.isDBFS$lzycompute() : this.isDBFS;
    }

    private Path targetPath() {
        return this.targetPath;
    }

    private void targetPath_$eq(Path x$1) {
        this.targetPath = x$1;
    }

    private String[] historyLog() {
        return this.historyLog;
    }

    private void historyLog_$eq(String[] x$1) {
        this.historyLog = x$1;
    }

    public void writeAppend(String uuid, String content, String outputLogsPath) {
        String targetFolder = this.getTargetFolder(outputLogsPath);
        this.targetPath_$eq(new Path(targetFolder, new StringBuilder(4).append(uuid).append(".log").toString()));
        if (this.isDBFS()) {
            this.historyLog_$eq((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.historyLog())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{content})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        } else {
            Object object = !this.fileSystem().exists(new Path(targetFolder)) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().mkdirs(new Path(targetFolder))) : BoxedUnit.UNIT;
            if (this.fileSystem().getScheme().equals("file")) {
                File fo = new File(this.targetPath().toUri().getRawPath());
                FileWriter writer = new FileWriter(fo, true);
                writer.append(new StringBuilder(0).append(content).append(System.lineSeparator()).toString());
                writer.close();
            } else {
                this.fileSystem().createNewFile(this.targetPath());
                FSDataOutputStream fo = this.fileSystem().append(this.targetPath());
                PrintWriter writer = new PrintWriter((OutputStream)fo, true);
                writer.append(new StringBuilder(0).append(content).append(System.lineSeparator()).toString());
                writer.close();
                fo.close();
            }
        }
    }

    private String getTargetFolder(String outputLogsPath) {
        return outputLogsPath.isEmpty() ? (this.getLogsFolder().startsWith("s3") ? new StringBuilder(9).append(SparkFiles$.MODULE$.getRootDirectory()).append("/tmp/logs").toString() : this.getLogsFolder()) : (outputLogsPath.startsWith("s3") ? new StringBuilder(9).append(SparkFiles$.MODULE$.getRootDirectory()).append("/tmp/logs").toString() : outputLogsPath);
    }

    public void exportLogFile(String outputLogsPath) {
        try {
            if (this.isDBFS()) {
                Charset charset = StandardCharsets.ISO_8859_1;
                FSDataOutputStream outputStream = this.fileSystem().create(this.targetPath());
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.historyLog())).map((Function1 & Serializable & scala.Serializable)log -> new StringBuilder(0).append((String)log).append(System.lineSeparator()).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).foreach((Function1 & Serializable & scala.Serializable)log -> {
                    outputStream.write(log.getBytes(charset));
                    return BoxedUnit.UNIT;
                });
                outputStream.close();
                this.historyLog_$eq((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
            }
            if (outputLogsPath.startsWith("s3")) {
                String sourceFilePath = this.targetPath().toString();
                String s3Bucket = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputLogsPath.replace("s3://", "").split("/"))).head();
                String s3Path = new StringBuilder(5).append("s3:/").append(outputLogsPath.substring(new StringBuilder(5).append("s3://").append(s3Bucket).toString().length())).append("/").toString();
                this.storeFileInS3(sourceFilePath, s3Bucket, s3Path);
            } else if (this.getLogsFolder().startsWith("s3")) {
                String sourceFilePath = this.targetPath().toString();
                String s3Bucket = ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalS3BucketKey());
                String s3Path = new StringBuilder(1).append(ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.annotatorLogFolder())).append("/").toString();
                this.storeFileInS3(sourceFilePath, s3Bucket, s3Path);
            }
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(60).append("Warning couldn't export log on DBFS or S3 because of error: ").append(e.getMessage()).toString());
        }
    }

    public void storeFileInS3(String sourceFilePath, String s3Bucket, String s3Path) {
        String x$1 = "proprietary";
        String x$2 = AWSGateway$.MODULE$.$lessinit$greater$default$1();
        String x$3 = AWSGateway$.MODULE$.$lessinit$greater$default$2();
        String x$4 = AWSGateway$.MODULE$.$lessinit$greater$default$3();
        String x$5 = AWSGateway$.MODULE$.$lessinit$greater$default$4();
        String x$6 = AWSGateway$.MODULE$.$lessinit$greater$default$5();
        AWSGateway awsGateway = new AWSGateway(x$2, x$3, x$4, x$5, x$6, x$1);
        String s3FilePath = new StringBuilder(0).append(s3Path.substring("s3://".length())).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceFilePath.split("/"))).last()).toString();
        awsGateway.copyInputStreamToS3(s3Bucket, s3FilePath, sourceFilePath);
    }

    private OutputHelper$() {
        MODULE$ = this;
        this.historyLog = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
    }
}

