/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.tensorflow;

import com.johnsnowlabs.ml.tensorflow.TensorResources;
import com.johnsnowlabs.ml.tensorflow.TensorflowWrapper;
import com.johnsnowlabs.ml.tensorflow.Variables;
import com.johnsnowlabs.ml.tensorflow.io.ChunkBytes$;
import com.johnsnowlabs.ml.tensorflow.sentencepiece.LoadSentencepiece$;
import com.johnsnowlabs.ml.tensorflow.sign.ModelSignatureManager$;
import com.johnsnowlabs.nlp.annotators.ner.dl.LoadsContrib$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.FileHelper$;
import com.johnsnowlabs.util.ZipArchiveUtil$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.Graph;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.proto.framework.ConfigProto;
import org.tensorflow.proto.framework.GraphDef;
import org.tensorflow.proto.util.SaverDef;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class TensorflowWrapper$
implements scala.Serializable {
    public static TensorflowWrapper$ MODULE$;
    private final Logger logger;
    private final byte[] com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$TFSessionConfig;
    private final String VariablesKey;
    private final String VariablesPathValue;
    private final String VariablesIdxValue;
    private final String InitAllTableOP;
    private final String SaveRestoreAllOP;
    private final String SaveConstOP;
    private final String SaveControlDependenciesOP;
    private final String SavedModelPB;
    private final String TFVarsSuffix;
    private final int BUFFER_SIZE;

    static {
        new TensorflowWrapper$();
    }

    public Logger logger() {
        return this.logger;
    }

    public final byte[] com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$TFSessionConfig() {
        return this.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$TFSessionConfig;
    }

    public String VariablesKey() {
        return this.VariablesKey;
    }

    public String VariablesPathValue() {
        return this.VariablesPathValue;
    }

    public String VariablesIdxValue() {
        return this.VariablesIdxValue;
    }

    public String InitAllTableOP() {
        return this.InitAllTableOP;
    }

    public String SaveRestoreAllOP() {
        return this.SaveRestoreAllOP;
    }

    public String SaveConstOP() {
        return this.SaveConstOP;
    }

    public String SaveControlDependenciesOP() {
        return this.SaveControlDependenciesOP;
    }

    public String SavedModelPB() {
        return this.SavedModelPB;
    }

    public String TFVarsSuffix() {
        return this.TFVarsSuffix;
    }

    private int BUFFER_SIZE() {
        return this.BUFFER_SIZE;
    }

    public SavedModelBundle withSafeSavedModelBundleLoader(String[] tags, String savedModelDir) {
        SavedModelBundle bundle;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> SavedModelBundle.load((String)savedModelDir, (String[])tags));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable s = failure.exception();
                StringBuilder stringBuilder = new StringBuilder(42).append("Could not retrieve the SavedModelBundle + ");
                s.printStackTrace();
                throw new Exception(stringBuilder.append(BoxedUnit.UNIT).toString());
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        SavedModelBundle savedModelBundle = bundle = (SavedModelBundle)success.value();
        return savedModelBundle;
    }

    private Tuple4<Graph, Session, java.nio.file.Path, java.nio.file.Path> unpackWithoutBundle(String folder) {
        Graph graph = this.readGraph(((Object)Paths.get(folder, this.SavedModelPB())).toString());
        Session session = new Session(graph, ConfigProto.parseFrom((byte[])this.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$TFSessionConfig()));
        try {
            session.initialize();
        }
        catch (Exception exception) {
            Predef$.MODULE$.println((Object)"detect asset_path_initializer");
        }
        java.nio.file.Path varPath = Paths.get(folder, this.VariablesPathValue());
        java.nio.file.Path idxPath = Paths.get(folder, this.VariablesIdxValue());
        return new Tuple4((Object)graph, (Object)session, (Object)varPath, (Object)idxPath);
    }

    private Tuple4<Graph, Session, java.nio.file.Path, java.nio.file.Path> unpackFromBundle(String folder, SavedModelBundle model) {
        Graph graph = model.graph();
        Session session = model.session();
        java.nio.file.Path varPath = Paths.get(folder, this.VariablesKey(), this.VariablesPathValue());
        java.nio.file.Path idxPath = Paths.get(folder, this.VariablesKey(), this.VariablesIdxValue());
        return new Tuple4((Object)graph, (Object)session, (Object)varPath, (Object)idxPath);
    }

    public Object com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$processInitAllTableOp(boolean initAllTables, TensorResources tensorResources, Session session, String variablesDir, String variablesKey, Option<Map<String, String>> savedSignatures) {
        BoxedUnit boxedUnit;
        LazyRef legacySessionRunner$lzy = new LazyRef();
        LazyRef newSessionRunner$lzy = new LazyRef();
        Map _tfSignatures = (Map)savedSignatures.getOrElse((Function0 & Serializable & scala.Serializable)() -> ModelSignatureManager$.MODULE$.apply(ModelSignatureManager$.MODULE$.apply$default$1(), ModelSignatureManager$.MODULE$.apply$default$2(), ModelSignatureManager$.MODULE$.apply$default$3(), ModelSignatureManager$.MODULE$.apply$default$4(), ModelSignatureManager$.MODULE$.apply$default$5(), ModelSignatureManager$.MODULE$.apply$default$6()));
        if (initAllTables) {
            Object object;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.runRestoreLegacyInit$1(legacySessionRunner$lzy, session, tensorResources, variablesDir, variablesKey));
            if (try_ instanceof Success) {
                this.logger().debug("Running restore legacy with init...");
                object = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                object = this.runRestoreNewInit$1(newSessionRunner$lzy, session, _tfSignatures, tensorResources, variablesDir, variablesKey);
            } else {
                throw new MatchError((Object)try_);
            }
            boxedUnit = object;
        } else {
            Object object;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.runRestoreLegacyNoInit$1(legacySessionRunner$lzy, session, tensorResources, variablesDir, variablesKey));
            if (try_ instanceof Success) {
                this.logger().debug("Running restore legacy with no init...");
                object = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                object = TensorflowWrapper$.runRestoreNewNoInit$1(newSessionRunner$lzy, session, _tfSignatures, tensorResources, variablesDir, variablesKey);
            } else {
                throw new MatchError((Object)try_);
            }
            boxedUnit = object;
        }
        return boxedUnit;
    }

    private String processInitAllTableOp$default$5() {
        return this.VariablesKey();
    }

    private Option<Map<String, String>> processInitAllTableOp$default$6() {
        return None$.MODULE$;
    }

    public Graph readGraph(String graphFile) {
        byte[] graphBytesDef = FileUtils.readFileToByteArray((File)new File(graphFile));
        Graph graph = new Graph();
        try {
            graph.importGraphDef(GraphDef.parseFrom((byte[])graphBytesDef));
        }
        catch (Throwable throwable) {
            TensorFlowException tensorFlowException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof TensorFlowException && (tensorFlowException = (TensorFlowException)throwable2).getMessage().contains("Op type not registered 'BlockLSTM'")) {
                throw new UnsupportedOperationException(new StringBuilder(291).append("Spark NLP tried to load a TensorFlow Graph using Contrib module, but failed to load it on this system. If you are on Windows, please follow the correct steps for setup: https://github.com/JohnSnowLabs/spark-nlp/issues/1022").append(" If not the case, please report this issue. Original error message:\n\n").append(tensorFlowException.getMessage()).toString());
            }
            throw throwable;
        }
        return graph;
    }

    public Tuple2<TensorflowWrapper, Option<Map<String, String>>> read(String file, boolean zipped, boolean useBundle, String[] tags, boolean initAllTables, Option<Map<String, String>> savedSignatures) {
        Tuple5 tuple5;
        Tuple5 tuple52;
        TensorResources t = new TensorResources();
        String tmpFolder = ((Object)Files.createTempDirectory(new StringBuilder(4).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append("_ner").toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        String folder = zipped ? ZipArchiveUtil$.MODULE$.unzip(new File(file), (Option<String>)new Some((Object)tmpFolder)) : file;
        LoadsContrib$.MODULE$.loadContribToTensorflow();
        if (useBundle) {
            SavedModelBundle model = this.withSafeSavedModelBundleLoader(tags, folder);
            Tuple4<Graph, Session, java.nio.file.Path, java.nio.file.Path> tuple4 = this.unpackFromBundle(folder, model);
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            Graph graph = (Graph)tuple4._1();
            Session session = (Session)tuple4._2();
            java.nio.file.Path varPath = (java.nio.file.Path)tuple4._3();
            java.nio.file.Path idxPath = (java.nio.file.Path)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)graph, (Object)session, (Object)varPath, (Object)idxPath);
            Tuple4 tuple43 = tuple42;
            Graph graph2 = (Graph)tuple43._1();
            Session session2 = (Session)tuple43._2();
            java.nio.file.Path varPath2 = (java.nio.file.Path)tuple43._3();
            java.nio.file.Path idxPath2 = (java.nio.file.Path)tuple43._4();
            Object object = initAllTables ? session2.runner().addTarget(this.InitAllTableOP()) : BoxedUnit.UNIT;
            SaverDef saverDef = model.metaGraphDef().getSaverDef();
            Option<Map<String, String>> signatures = ModelSignatureManager$.MODULE$.extractSignatures(model, saverDef);
            tuple52 = new Tuple5((Object)graph2, (Object)session2, (Object)varPath2, (Object)idxPath2, signatures);
        } else {
            Tuple4<Graph, Session, java.nio.file.Path, java.nio.file.Path> tuple4 = this.unpackWithoutBundle(folder);
            if (tuple4 == null) {
                throw new MatchError(tuple4);
            }
            Graph graph = (Graph)tuple4._1();
            Session session = (Session)tuple4._2();
            java.nio.file.Path varPath = (java.nio.file.Path)tuple4._3();
            java.nio.file.Path idxPath = (java.nio.file.Path)tuple4._4();
            Tuple4 tuple44 = new Tuple4((Object)graph, (Object)session, (Object)varPath, (Object)idxPath);
            Tuple4 tuple45 = tuple44;
            Graph graph3 = (Graph)tuple45._1();
            Session session3 = (Session)tuple45._2();
            java.nio.file.Path varPath3 = (java.nio.file.Path)tuple45._3();
            java.nio.file.Path idxPath3 = (java.nio.file.Path)tuple45._4();
            boolean x$1 = initAllTables;
            TensorResources x$2 = t;
            Session x$3 = session3;
            String x$4 = folder;
            Option<Map<String, String>> x$5 = savedSignatures;
            String x$6 = this.processInitAllTableOp$default$5();
            this.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$processInitAllTableOp(x$1, x$2, x$3, x$4, x$6, x$5);
            tuple52 = tuple5 = new Tuple5((Object)graph3, (Object)session3, (Object)varPath3, (Object)idxPath3, (Object)None$.MODULE$);
        }
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Graph graph = (Graph)tuple5._1();
        Session session = (Session)tuple5._2();
        java.nio.file.Path varPath = (java.nio.file.Path)tuple5._3();
        java.nio.file.Path idxPath = (java.nio.file.Path)tuple5._4();
        Option signatures = (Option)tuple5._5();
        Tuple5 tuple53 = new Tuple5((Object)graph, (Object)session, (Object)varPath, (Object)idxPath, (Object)signatures);
        Tuple5 tuple54 = tuple53;
        Graph graph4 = (Graph)tuple54._1();
        Session session4 = (Session)tuple54._2();
        java.nio.file.Path varPath4 = (java.nio.file.Path)tuple54._3();
        java.nio.file.Path idxPath4 = (java.nio.file.Path)tuple54._4();
        Option signatures2 = (Option)tuple54._5();
        byte[][] varBytes = ChunkBytes$.MODULE$.readFileInByteChunks(varPath4, this.BUFFER_SIZE());
        byte[] idxBytes = Files.readAllBytes(idxPath4);
        FileHelper$.MODULE$.delete(tmpFolder, FileHelper$.MODULE$.delete$default$2());
        t.clearTensors();
        TensorflowWrapper tfWrapper = new TensorflowWrapper(new Variables(varBytes, idxBytes), graph4.toGraphDef().toByteArray());
        tfWrapper.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$m_session_$eq(session4);
        return new Tuple2((Object)tfWrapper, (Object)signatures2);
    }

    public boolean read$default$2() {
        return true;
    }

    public boolean read$default$3() {
        return false;
    }

    public String[] read$default$4() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean read$default$5() {
        return false;
    }

    public Option<Map<String, String>> read$default$6() {
        return None$.MODULE$;
    }

    public TensorflowWrapper readWithSP(String file, boolean zipped, boolean useBundle, String[] tags, boolean initAllTables, boolean loadSP) {
        Tuple4 tuple4;
        Tuple4 tuple42;
        String folder;
        TensorResources t = new TensorResources();
        String tmpFolder = ((Object)Files.createTempDirectory(new StringBuilder(4).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append("_ner").toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        String string = folder = zipped ? ZipArchiveUtil$.MODULE$.unzip(new File(file), (Option<String>)new Some((Object)tmpFolder)) : file;
        if (loadSP) {
            LoadSentencepiece$.MODULE$.loadSPToTensorflowLocally();
            LoadSentencepiece$.MODULE$.loadSPToTensorflow();
        }
        if (useBundle) {
            SavedModelBundle model = this.withSafeSavedModelBundleLoader(tags, folder);
            Tuple4<Graph, Session, java.nio.file.Path, java.nio.file.Path> tuple43 = this.unpackFromBundle(folder, model);
            if (tuple43 == null) {
                throw new MatchError(tuple43);
            }
            Graph graph = (Graph)tuple43._1();
            Session session = (Session)tuple43._2();
            java.nio.file.Path varPath = (java.nio.file.Path)tuple43._3();
            java.nio.file.Path idxPath = (java.nio.file.Path)tuple43._4();
            Tuple4 tuple44 = new Tuple4((Object)graph, (Object)session, (Object)varPath, (Object)idxPath);
            Tuple4 tuple45 = tuple44;
            Graph graph2 = (Graph)tuple45._1();
            Session session2 = (Session)tuple45._2();
            java.nio.file.Path varPath2 = (java.nio.file.Path)tuple45._3();
            java.nio.file.Path idxPath2 = (java.nio.file.Path)tuple45._4();
            Object object = initAllTables ? session2.runner().addTarget(this.InitAllTableOP()) : BoxedUnit.UNIT;
            tuple42 = new Tuple4((Object)graph2, (Object)session2, (Object)varPath2, (Object)idxPath2);
        } else {
            Tuple4<Graph, Session, java.nio.file.Path, java.nio.file.Path> tuple46 = this.unpackWithoutBundle(folder);
            if (tuple46 == null) {
                throw new MatchError(tuple46);
            }
            Graph graph = (Graph)tuple46._1();
            Session session = (Session)tuple46._2();
            java.nio.file.Path varPath = (java.nio.file.Path)tuple46._3();
            java.nio.file.Path idxPath = (java.nio.file.Path)tuple46._4();
            Tuple4 tuple47 = new Tuple4((Object)graph, (Object)session, (Object)varPath, (Object)idxPath);
            Tuple4 tuple48 = tuple47;
            Graph graph3 = (Graph)tuple48._1();
            Session session3 = (Session)tuple48._2();
            java.nio.file.Path varPath3 = (java.nio.file.Path)tuple48._3();
            java.nio.file.Path idxPath3 = (java.nio.file.Path)tuple48._4();
            this.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$processInitAllTableOp(initAllTables, t, session3, folder, this.processInitAllTableOp$default$5(), this.processInitAllTableOp$default$6());
            tuple42 = tuple4 = new Tuple4((Object)graph3, (Object)session3, (Object)varPath3, (Object)idxPath3);
        }
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Graph graph = (Graph)tuple4._1();
        Session session = (Session)tuple4._2();
        java.nio.file.Path varPath = (java.nio.file.Path)tuple4._3();
        java.nio.file.Path idxPath = (java.nio.file.Path)tuple4._4();
        Tuple4 tuple49 = new Tuple4((Object)graph, (Object)session, (Object)varPath, (Object)idxPath);
        Tuple4 tuple410 = tuple49;
        Graph graph4 = (Graph)tuple410._1();
        Session session4 = (Session)tuple410._2();
        java.nio.file.Path varPath4 = (java.nio.file.Path)tuple410._3();
        java.nio.file.Path idxPath4 = (java.nio.file.Path)tuple410._4();
        byte[][] varBytes = ChunkBytes$.MODULE$.readFileInByteChunks(varPath4, this.BUFFER_SIZE());
        byte[] idxBytes = Files.readAllBytes(idxPath4);
        FileHelper$.MODULE$.delete(tmpFolder, FileHelper$.MODULE$.delete$default$2());
        t.clearTensors();
        TensorflowWrapper tfWrapper = new TensorflowWrapper(new Variables(varBytes, idxBytes), graph4.toGraphDef().toByteArray());
        tfWrapper.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$m_session_$eq(session4);
        return tfWrapper;
    }

    public boolean readWithSP$default$2() {
        return true;
    }

    public boolean readWithSP$default$3() {
        return false;
    }

    public String[] readWithSP$default$4() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean readWithSP$default$5() {
        return false;
    }

    public boolean readWithSP$default$6() {
        return false;
    }

    public TensorflowWrapper readZippedSavedModel(String rootDir, String fileName, String[] tags, boolean initAllTables) {
        TensorResources tensorResources = new TensorResources();
        Seq<String> listFiles = ResourceHelper$.MODULE$.listResourceDirectory(rootDir);
        String path = listFiles.length() > 1 ? new StringBuilder(1).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)listFiles.head()).split("/"))).head()).append("/").append(fileName).toString() : (String)listFiles.head();
        URI uri = new URI(new StringOps(Predef$.MODULE$.augmentString(path)).replaceAllLiterally("\\", "/"));
        InputStream inputStream = ResourceHelper$.MODULE$.getResourceStream(uri.toString());
        String tmpFolder = ((Object)Files.createTempDirectory(new StringBuilder(18).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append("_classifier_dl_zip").toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        File zipFile = new File(tmpFolder, "tmp_classifier_dl.zip");
        Files.copy(inputStream, zipFile.toPath(), new CopyOption[0]);
        String folder = ZipArchiveUtil$.MODULE$.unzip(zipFile, (Option<String>)new Some((Object)tmpFolder));
        String finalFolder = ((Object)Files.createTempDirectory(new StringBuilder(14).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append("_classifier_dl").toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        java.nio.file.Path variablesFile = Paths.get(finalFolder, this.VariablesKey()).toAbsolutePath();
        Files.createDirectory(variablesFile, new FileAttribute[0]);
        InputStream savedModelInputStream = ResourceHelper$.MODULE$.getResourceStream(new Path(folder, this.SavedModelPB()).toString());
        File savedModelFile = new File(finalFolder, this.SavedModelPB());
        Files.copy(savedModelInputStream, savedModelFile.toPath(), new CopyOption[0]);
        InputStream varIndexInputStream = ResourceHelper$.MODULE$.getResourceStream(new Path(folder, this.VariablesIdxValue()).toString());
        File varIndexFile = new File(((Object)variablesFile).toString(), this.VariablesIdxValue());
        Files.copy(varIndexInputStream, varIndexFile.toPath(), new CopyOption[0]);
        InputStream varDataInputStream = ResourceHelper$.MODULE$.getResourceStream(new Path(folder, this.VariablesPathValue()).toString());
        File varDataFile = new File(((Object)variablesFile).toString(), this.VariablesPathValue());
        Files.copy(varDataInputStream, varDataFile.toPath(), new CopyOption[0]);
        SavedModelBundle model = this.withSafeSavedModelBundleLoader(tags, finalFolder);
        Tuple4<Graph, Session, java.nio.file.Path, java.nio.file.Path> tuple4 = this.unpackFromBundle(finalFolder, model);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Graph graph = (Graph)tuple4._1();
        Session session = (Session)tuple4._2();
        java.nio.file.Path varPath = (java.nio.file.Path)tuple4._3();
        java.nio.file.Path idxPath = (java.nio.file.Path)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)graph, (Object)session, (Object)varPath, (Object)idxPath);
        Tuple4 tuple43 = tuple42;
        Graph graph2 = (Graph)tuple43._1();
        Session session2 = (Session)tuple43._2();
        java.nio.file.Path varPath2 = (java.nio.file.Path)tuple43._3();
        java.nio.file.Path idxPath2 = (java.nio.file.Path)tuple43._4();
        Object object = initAllTables ? session2.runner().addTarget(this.InitAllTableOP()) : BoxedUnit.UNIT;
        byte[][] varBytes = ChunkBytes$.MODULE$.readFileInByteChunks(varPath2, this.BUFFER_SIZE());
        byte[] idxBytes = Files.readAllBytes(idxPath2);
        FileHelper$.MODULE$.delete(tmpFolder, FileHelper$.MODULE$.delete$default$2());
        FileHelper$.MODULE$.delete(finalFolder, FileHelper$.MODULE$.delete$default$2());
        FileHelper$.MODULE$.delete(folder, FileHelper$.MODULE$.delete$default$2());
        tensorResources.clearTensors();
        TensorflowWrapper tfWrapper = new TensorflowWrapper(new Variables(varBytes, idxBytes), graph2.toGraphDef().toByteArray());
        tfWrapper.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$m_session_$eq(session2);
        return tfWrapper;
    }

    public String readZippedSavedModel$default$1() {
        return "";
    }

    public String readZippedSavedModel$default$2() {
        return "";
    }

    public String[] readZippedSavedModel$default$3() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean readZippedSavedModel$default$4() {
        return false;
    }

    public TensorflowWrapper readChkPoints(String file, boolean zipped, String[] tags, boolean initAllTables) {
        TensorResources t = new TensorResources();
        String tmpFolder = ((Object)Files.createTempDirectory(new StringBuilder(4).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append("_ner").toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        String folder = zipped ? ZipArchiveUtil$.MODULE$.unzip(new File(file), (Option<String>)new Some((Object)tmpFolder)) : file;
        LoadsContrib$.MODULE$.loadContribToTensorflow();
        Object[] tfChkPointsVars = FileUtils.listFilesAndDirs((File)new File(folder), (IOFileFilter)new WildcardFileFilter("part*"), (IOFileFilter)new WildcardFileFilter("variables*")).toArray();
        String variablesDir = tfChkPointsVars[1].toString();
        String variablesData = tfChkPointsVars[2].toString();
        String variablesIndex = tfChkPointsVars[3].toString();
        Graph graph = this.readGraph(((Object)Paths.get(folder, this.SavedModelPB())).toString());
        Session session = new Session(graph, ConfigProto.parseFrom((byte[])this.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$TFSessionConfig()));
        java.nio.file.Path varPath = Paths.get(variablesData, new String[0]);
        java.nio.file.Path idxPath = Paths.get(variablesIndex, new String[0]);
        this.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$processInitAllTableOp(initAllTables, t, session, variablesDir, "part-00000-of-00001", this.processInitAllTableOp$default$6());
        byte[][] varBytes = ChunkBytes$.MODULE$.readFileInByteChunks(varPath, this.BUFFER_SIZE());
        byte[] idxBytes = Files.readAllBytes(idxPath);
        FileHelper$.MODULE$.delete(tmpFolder, FileHelper$.MODULE$.delete$default$2());
        t.clearTensors();
        TensorflowWrapper tfWrapper = new TensorflowWrapper(new Variables(varBytes, idxBytes), graph.toGraphDef().toByteArray());
        tfWrapper.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$m_session_$eq(session);
        return tfWrapper;
    }

    public boolean readChkPoints$default$2() {
        return true;
    }

    public String[] readChkPoints$default$3() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean readChkPoints$default$4() {
        return false;
    }

    public Variables extractVariablesSavedModel(Session session) {
        TensorResources t = new TensorResources();
        String folder = ((Object)Files.createTempDirectory(new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append(this.TFVarsSuffix()).toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        String variablesFile = ((Object)Paths.get(folder, this.VariablesKey())).toString();
        session.runner().addTarget(this.SaveControlDependenciesOP()).feed(this.SaveConstOP(), t.createTensor(variablesFile)).run();
        java.nio.file.Path varPath = Paths.get(folder, this.VariablesPathValue());
        byte[][] varBytes = ChunkBytes$.MODULE$.readFileInByteChunks(varPath, this.BUFFER_SIZE());
        java.nio.file.Path idxPath = Paths.get(folder, this.VariablesIdxValue());
        byte[] idxBytes = Files.readAllBytes(idxPath);
        Variables vars = new Variables(varBytes, idxBytes);
        FileHelper$.MODULE$.delete(folder, FileHelper$.MODULE$.delete$default$2());
        return vars;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final /* synthetic */ Session.Runner legacySessionRunner$lzycompute$1(LazyRef legacySessionRunner$lzy$1, Session session$1, TensorResources tensorResources$1, String variablesDir$1, String variablesKey$1) {
        Session.Runner runner;
        LazyRef lazyRef = legacySessionRunner$lzy$1;
        synchronized (lazyRef) {
            runner = legacySessionRunner$lzy$1.initialized() ? (Session.Runner)legacySessionRunner$lzy$1.value() : (Session.Runner)legacySessionRunner$lzy$1.initialize((Object)session$1.runner().addTarget(this.SaveRestoreAllOP()).feed(this.SaveConstOP(), tensorResources$1.createTensor(((Object)Paths.get(variablesDir$1, variablesKey$1)).toString())));
        }
        return runner;
    }

    private final Session.Runner legacySessionRunner$1(LazyRef legacySessionRunner$lzy$1, Session session$1, TensorResources tensorResources$1, String variablesDir$1, String variablesKey$1) {
        return legacySessionRunner$lzy$1.initialized() ? (Session.Runner)legacySessionRunner$lzy$1.value() : this.legacySessionRunner$lzycompute$1(legacySessionRunner$lzy$1, session$1, tensorResources$1, variablesDir$1, variablesKey$1);
    }

    private static final /* synthetic */ Session.Runner newSessionRunner$lzycompute$1(LazyRef newSessionRunner$lzy$1, Session session$1, Map _tfSignatures$2, TensorResources tensorResources$1, String variablesDir$1, String variablesKey$1) {
        Session.Runner runner;
        LazyRef lazyRef = newSessionRunner$lzy$1;
        synchronized (lazyRef) {
            runner = newSessionRunner$lzy$1.initialized() ? (Session.Runner)newSessionRunner$lzy$1.value() : (Session.Runner)newSessionRunner$lzy$1.initialize((Object)session$1.runner().addTarget((String)_tfSignatures$2.getOrElse((Object)"restoreOpName_", (Function0 & Serializable & scala.Serializable)() -> "StatefulPartitionedCall_2")).feed((String)_tfSignatures$2.getOrElse((Object)"filenameTensorName_", (Function0 & Serializable & scala.Serializable)() -> "saver_filename"), tensorResources$1.createTensor(((Object)Paths.get(variablesDir$1, variablesKey$1)).toString())));
        }
        return runner;
    }

    private static final Session.Runner newSessionRunner$1(LazyRef newSessionRunner$lzy$1, Session session$1, Map _tfSignatures$2, TensorResources tensorResources$1, String variablesDir$1, String variablesKey$1) {
        return newSessionRunner$lzy$1.initialized() ? (Session.Runner)newSessionRunner$lzy$1.value() : TensorflowWrapper$.newSessionRunner$lzycompute$1(newSessionRunner$lzy$1, session$1, _tfSignatures$2, tensorResources$1, variablesDir$1, variablesKey$1);
    }

    private static final List runRestoreNewNoInit$1(LazyRef newSessionRunner$lzy$1, Session session$1, Map _tfSignatures$2, TensorResources tensorResources$1, String variablesDir$1, String variablesKey$1) {
        return TensorflowWrapper$.newSessionRunner$1(newSessionRunner$lzy$1, session$1, _tfSignatures$2, tensorResources$1, variablesDir$1, variablesKey$1).run();
    }

    private final List runRestoreNewInit$1(LazyRef newSessionRunner$lzy$1, Session session$1, Map _tfSignatures$2, TensorResources tensorResources$1, String variablesDir$1, String variablesKey$1) {
        return TensorflowWrapper$.newSessionRunner$1(newSessionRunner$lzy$1, session$1, _tfSignatures$2, tensorResources$1, variablesDir$1, variablesKey$1).addTarget(this.InitAllTableOP()).run();
    }

    private final List runRestoreLegacyNoInit$1(LazyRef legacySessionRunner$lzy$1, Session session$1, TensorResources tensorResources$1, String variablesDir$1, String variablesKey$1) {
        return this.legacySessionRunner$1(legacySessionRunner$lzy$1, session$1, tensorResources$1, variablesDir$1, variablesKey$1).run();
    }

    private final List runRestoreLegacyInit$1(LazyRef legacySessionRunner$lzy$1, Session session$1, TensorResources tensorResources$1, String variablesDir$1, String variablesKey$1) {
        return this.legacySessionRunner$1(legacySessionRunner$lzy$1, session$1, tensorResources$1, variablesDir$1, variablesKey$1).addTarget(this.InitAllTableOP()).run();
    }

    private TensorflowWrapper$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"TensorflowWrapper");
        this.com$johnsnowlabs$ml$tensorflow$TensorflowWrapper$$TFSessionConfig = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{50, 2, 32, 1, 56, 1}), ClassTag$.MODULE$.Byte());
        this.VariablesKey = "variables";
        this.VariablesPathValue = "variables.data-00000-of-00001";
        this.VariablesIdxValue = "variables.index";
        this.InitAllTableOP = "init_all_tables";
        this.SaveRestoreAllOP = "save/restore_all";
        this.SaveConstOP = "save/Const";
        this.SaveControlDependenciesOP = "save/control_dependency";
        this.SavedModelPB = "saved_model.pb";
        this.TFVarsSuffix = "_tf_vars";
        this.BUFFER_SIZE = 0x100000;
    }
}

