/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep;

import com.johnsnowlabs.nlp.annotators.parser.typdep.util.DictionarySet;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;

public class DependencyInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int length;
    private String[] forms;
    private String[] lemmas;
    private String[] xPosTags;
    private String[] uPosTags;
    private SpecialPos[] specialPos;
    private String[][] feats;
    private int[] heads;
    private String[] depRels;
    private int[] begins;
    private int[] ends;
    private int[] formIds;
    private int[] lemmaIds;
    private int[] uPosTagIds;
    private int[] xPosTagIds;
    private int[] depRelIds;
    private int[][] featIds;
    private int[] wordVecIds;
    private int[] dependencyLabelIds;
    private static Pattern puncRegex = Pattern.compile("[\\p{Punct}]+", 256);

    public int[] getBegins() {
        return this.begins;
    }

    public int[] getEnds() {
        return this.ends;
    }

    public int getLength() {
        return this.length;
    }

    public String[] getForms() {
        return this.forms;
    }

    public String[] getLemmas() {
        return this.lemmas;
    }

    public String[] getXPosTags() {
        return this.xPosTags;
    }

    public String[] getUPosTags() {
        return this.uPosTags;
    }

    public int[] getHeads() {
        return this.heads;
    }

    public int[] getFormIds() {
        return this.formIds;
    }

    public int[] getLemmaIds() {
        return this.lemmaIds;
    }

    public int[] getUPosTagIds() {
        return this.uPosTagIds;
    }

    public int[] getXPosTagIds() {
        return this.xPosTagIds;
    }

    public int[][] getFeatIds() {
        return this.featIds;
    }

    public int[] getWordVecIds() {
        return this.wordVecIds;
    }

    public int[] getDependencyLabelIds() {
        return this.dependencyLabelIds;
    }

    public DependencyInstance() {
    }

    public DependencyInstance(int n) {
        this.length = n;
    }

    public DependencyInstance(String[] stringArray) {
        this.length = stringArray.length;
        this.forms = stringArray;
        this.feats = new String[this.length][];
        this.depRels = new String[this.length];
    }

    public DependencyInstance(String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray) {
        this.length = stringArray.length;
        this.forms = stringArray;
        this.heads = nArray;
        this.uPosTags = stringArray2;
        this.xPosTags = stringArray3;
    }

    public DependencyInstance(String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray, String[] stringArray4) {
        this(stringArray, stringArray2, stringArray3, nArray);
        this.depRels = stringArray4;
    }

    public DependencyInstance(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[][] stringArray5, int[] nArray, String[] stringArray6, int[] nArray2, int[] nArray3) {
        this(stringArray, stringArray3, stringArray4, nArray, stringArray6);
        this.lemmas = stringArray2;
        this.feats = stringArray5;
        this.xPosTags = stringArray4;
        this.uPosTags = stringArray3;
        this.begins = nArray2;
        this.ends = nArray3;
    }

    DependencyInstance(DependencyInstance dependencyInstance) {
        this.length = dependencyInstance.length;
        this.specialPos = dependencyInstance.specialPos;
        this.heads = dependencyInstance.heads;
        this.formIds = dependencyInstance.formIds;
        this.lemmaIds = dependencyInstance.lemmaIds;
        this.uPosTagIds = dependencyInstance.uPosTagIds;
        this.xPosTagIds = dependencyInstance.xPosTagIds;
        this.depRelIds = dependencyInstance.depRelIds;
        this.dependencyLabelIds = dependencyInstance.dependencyLabelIds;
        this.featIds = dependencyInstance.featIds;
        this.wordVecIds = dependencyInstance.wordVecIds;
    }

    void setInstIds(DictionarySet dictionarySet, HashMap<String, String> hashMap, HashSet<String> hashSet) {
        int n;
        int n2;
        this.formIds = new int[this.length];
        this.dependencyLabelIds = new int[this.length];
        this.uPosTagIds = new int[this.length];
        this.xPosTagIds = new int[this.length];
        for (n2 = 0; n2 < this.length; ++n2) {
            this.formIds[n2] = dictionarySet.lookupIndex(DictionarySet.DictionaryTypes.WORD, "form=" + this.normalize(this.forms[n2]));
            this.uPosTagIds[n2] = dictionarySet.lookupIndex(DictionarySet.DictionaryTypes.POS, "pos=" + this.uPosTags[n2]);
            this.xPosTagIds[n2] = dictionarySet.lookupIndex(DictionarySet.DictionaryTypes.POS, "cpos=" + this.xPosTags[n2]);
            this.dependencyLabelIds[n2] = dictionarySet.lookupIndex(DictionarySet.DictionaryTypes.DEP_LABEL, this.depRels[n2]) - 1;
        }
        if (this.lemmas != null) {
            this.lemmaIds = new int[this.length];
            for (n2 = 0; n2 < this.length; ++n2) {
                this.lemmaIds[n2] = dictionarySet.lookupIndex(DictionarySet.DictionaryTypes.WORD, "lemma=" + this.normalize(this.lemmas[n2]));
            }
        }
        this.featIds = new int[this.length][];
        for (n2 = 0; n2 < this.length; ++n2) {
            if (this.feats[n2] == null) continue;
            this.featIds[n2] = new int[this.feats[n2].length];
            for (n = 0; n < this.feats[n2].length; ++n) {
                this.featIds[n2][n] = dictionarySet.lookupIndex(DictionarySet.DictionaryTypes.POS, "feat=" + this.feats[n2][n]);
            }
        }
        if (dictionarySet.getDictionarySize(DictionarySet.DictionaryTypes.WORD_VEC) > 0) {
            this.wordVecIds = new int[this.length];
            for (n2 = 0; n2 < this.length; ++n2) {
                n = dictionarySet.lookupIndex(DictionarySet.DictionaryTypes.WORD_VEC, this.forms[n2]);
                if (n <= 0) {
                    n = dictionarySet.lookupIndex(DictionarySet.DictionaryTypes.WORD_VEC, this.forms[n2].toLowerCase());
                }
                this.wordVecIds[n2] = n > 0 ? n : -1;
            }
        }
        this.specialPos = new SpecialPos[this.length];
        for (n2 = 0; n2 < this.length; ++n2) {
            if (hashMap.containsKey(this.uPosTags[n2])) {
                String string = hashMap.get(this.uPosTags[n2]);
                if (string.equals("CONJ") && hashSet.contains(this.forms[n2])) {
                    this.specialPos[n2] = SpecialPos.C;
                    continue;
                }
                if (string.equals("ADP")) {
                    this.specialPos[n2] = SpecialPos.P;
                    continue;
                }
                if (string.equals(".")) {
                    this.specialPos[n2] = SpecialPos.PNX;
                    continue;
                }
                if (string.equals("VERB")) {
                    this.specialPos[n2] = SpecialPos.V;
                    continue;
                }
                this.specialPos[n2] = SpecialPos.OTHER;
                continue;
            }
            this.specialPos[n2] = this.getSpecialPos(this.forms[n2], this.uPosTags[n2]);
        }
    }

    private String normalize(String string) {
        if (string != null && string.matches("[0-9]+|[0-9]+\\.[0-9]+|[0-9]+[0-9,]+")) {
            return "<num>";
        }
        return string;
    }

    private SpecialPos getSpecialPos(String string, String string2) {
        if (string2.charAt(0) == 'v' || string2.charAt(0) == 'V') {
            return SpecialPos.V;
        }
        if (string2.charAt(0) == 'n' || string2.charAt(0) == 'N') {
            return SpecialPos.N;
        }
        if (string2.equalsIgnoreCase("cc") || string2.equalsIgnoreCase("conj") || string2.equalsIgnoreCase("kon") || string2.equalsIgnoreCase("conjunction")) {
            return SpecialPos.C;
        }
        if (string2.equalsIgnoreCase("prep") || string2.equalsIgnoreCase("preposition") || string2.equals("IN")) {
            return SpecialPos.P;
        }
        if (string2.equalsIgnoreCase("punc") || string2.equals("$,") || string2.equals("$.") || string2.equals(",") || string2.equals(";") || puncRegex.matcher(string).matches()) {
            return SpecialPos.PNX;
        }
        return SpecialPos.OTHER;
    }

    public static enum SpecialPos {
        C,
        P,
        PNX,
        V,
        N,
        OTHER;

    }
}

