/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep;

import com.johnsnowlabs.nlp.annotators.parser.typdep.MatEntry;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.Utils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowRankTensor {
    private Logger logger = LoggerFactory.getLogger((String)"TypedDependencyParser");
    private int dim;
    private int rank;
    private int[] N;
    private ArrayList<MatEntry> list;
    private static final int MAX_ITER = 1000;

    LowRankTensor(int[] nArray, int n) {
        this.N = (int[])nArray.clone();
        this.dim = nArray.length;
        this.rank = n;
        this.list = new ArrayList();
    }

    public void add(int[] nArray, float f) {
        this.list.add(new MatEntry(nArray, f));
    }

    void decompose(ArrayList<float[][]> arrayList) {
        Object object;
        int n;
        ArrayList<float[][]> arrayList2 = new ArrayList<float[][]>();
        for (float[][] fArray : arrayList) {
            n = fArray.length;
            arrayList2.add(new float[this.rank][n]);
        }
        double d = 1.0E-6;
        for (n = 0; n < this.rank; ++n) {
            int n2;
            int n3;
            object = new ArrayList<float[]>();
            for (n3 = 0; n3 < this.dim; ++n3) {
                ((ArrayList)object).add(Utils.getRandomUnitVector(this.N[n3]));
            }
            double d2 = 0.0;
            double d3 = Double.POSITIVE_INFINITY;
            for (n3 = 0; n3 < 1000; ++n3) {
                for (n2 = 0; n2 < this.dim; ++n2) {
                    int n4;
                    float[] fArray = (float[])((ArrayList)object).get(n2);
                    for (n4 = 0; n4 < this.N[n2]; ++n4) {
                        fArray[n4] = 0.0f;
                    }
                    for (MatEntry matEntry : this.list) {
                        double d4 = matEntry.val;
                        for (int i = 0; i < this.dim; ++i) {
                            if (i == n2) continue;
                            d4 *= (double)((float[])((ArrayList)object).get(i))[matEntry.x[i]];
                        }
                        int n5 = matEntry.x[n2];
                        fArray[n5] = (float)((double)fArray[n5] + d4);
                    }
                    for (n4 = 0; n4 < n; ++n4) {
                        int n6;
                        double d5 = 1.0;
                        for (n6 = 0; n6 < this.dim; ++n6) {
                            if (n6 == n2) continue;
                            d5 *= (double)Utils.dot((float[])((ArrayList)object).get(n6), ((float[][])arrayList2.get(n6))[n4]);
                        }
                        for (n6 = 0; n6 < this.N[n2]; ++n6) {
                            int n7 = n6;
                            fArray[n7] = (float)((double)fArray[n7] - d5 * (double)((float[][])arrayList2.get(n2))[n4][n6]);
                        }
                    }
                    if (n2 < this.dim - 1) {
                        Utils.normalize(fArray);
                        continue;
                    }
                    d2 = Math.sqrt(Utils.squaredSum(fArray));
                }
                if (d3 != Double.POSITIVE_INFINITY && Math.abs(d2 - d3) < d) break;
                d3 = d2;
            }
            if (n3 >= 1000) {
                this.logger.warn("Power method didn't converge.rankFirstOrderTensor=%d sigma=%f%n", (Object)n, (Object)d2);
            }
            if (Math.abs(d2) <= d && this.logger.isDebugEnabled()) {
                this.logger.warn(String.format("Power method has nearly-zero sigma. rankFirstOrderTensor=%d%n", n));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("norm: %.2f", d2));
            }
            for (n2 = 0; n2 < this.dim; ++n2) {
                ((float[][])arrayList2.get((int)n2))[n] = (float[])((ArrayList)object).get(n2);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = arrayList.get(n);
            float[][] fArray = (float[][])arrayList2.get(n);
            int n8 = ((Object)object).length;
            for (int i = 0; i < n8; ++i) {
                for (int j = 0; j < this.rank; ++j) {
                    object[i][j] = fArray[j][i];
                }
            }
        }
    }
}

