/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep.io;

import com.johnsnowlabs.nlp.annotators.parser.typdep.ConllData;
import com.johnsnowlabs.nlp.annotators.parser.typdep.DependencyInstance;
import com.johnsnowlabs.nlp.annotators.parser.typdep.io.Conll09Reader;
import com.johnsnowlabs.nlp.annotators.parser.typdep.io.ConllUReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public abstract class DependencyReader {
    private static final int END_OF_SENTENCE = -2;
    BufferedReader reader;

    public static DependencyReader createDependencyReader(String string) {
        if (string.equals("2009")) {
            return new Conll09Reader();
        }
        return new ConllUReader();
    }

    public abstract DependencyInstance nextInstance() throws IOException;

    public DependencyInstance nextSentence(ConllData[] conllDataArray) {
        if (conllDataArray[0].getHead() == -2) {
            return null;
        }
        int n = conllDataArray.length;
        String[] stringArray = new String[n + 1];
        String[] stringArray2 = new String[n + 1];
        String[] stringArray3 = new String[n + 1];
        String[] stringArray4 = new String[n + 1];
        String[][] stringArray5 = new String[n + 1][];
        String[] stringArray6 = new String[n + 1];
        int[] nArray = new int[n + 1];
        int[] nArray2 = new int[n + 1];
        int[] nArray3 = new int[n + 1];
        stringArray[0] = "<root>";
        stringArray2[0] = "<root-LEMMA>";
        stringArray3[0] = "<root-POS>";
        stringArray4[0] = "<root-POS>";
        stringArray6[0] = "<no-type>";
        nArray[0] = -1;
        nArray2[0] = -1;
        nArray3[0] = -1;
        boolean bl = false;
        for (int i = 1; i < n + 1; ++i) {
            ConllData conllData = conllDataArray[i - 1];
            nArray2[i] = conllData.getBegin();
            nArray3[i] = conllData.getEnd();
            stringArray[i] = conllData.getForm();
            if (!conllData.getLemma().equals("_")) {
                stringArray2[i] = conllData.getLemma();
                bl = true;
            }
            stringArray3[i] = conllData.getUPos();
            stringArray4[i] = conllData.getXPos();
            nArray[i] = conllData.getHead();
            stringArray6[i] = conllData.getDepRel();
        }
        if (!bl) {
            stringArray2 = null;
        }
        return new DependencyInstance(stringArray, stringArray2, stringArray3, stringArray4, stringArray5, nArray, stringArray6, nArray2, nArray3);
    }

    public void startReading(String string) throws IOException {
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), StandardCharsets.UTF_8));
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

