/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.johnsnowlabs.client.CloudResources$;
import com.johnsnowlabs.client.aws.AWSGateway;
import com.johnsnowlabs.client.aws.AWSGateway$;
import com.johnsnowlabs.client.util.CloudHelper$;
import com.johnsnowlabs.nlp.pretrained.RepositoryMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata$;
import com.johnsnowlabs.nlp.pretrained.ResourceRequest;
import com.johnsnowlabs.nlp.pretrained.S3ResourceDownloader$;
import com.johnsnowlabs.util.FileHelper$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\r\u001b\u0001\rB\u0001B\f\u0001\u0003\u0002\u0013\u0006Ia\f\u0005\t{\u0001\u0011\t\u0011*A\u0005_!Aa\b\u0001B\u0001J\u0003%q\u0006\u0003\u0005@\u0001\t\u0005I\u0015!\u00030\u0011!\u0001\u0005A!A!\u0002\u0013\u0011\u0004\"B!\u0001\t\u0003\u0011\u0005bB%\u0001\u0005\u0004%IA\u0013\u0005\u0007-\u0002\u0001\u000b\u0011B&\t\u000f]\u0003!\u0019!C\u00011\"1Q\r\u0001Q\u0001\neC\u0001B\u001a\u0001\t\u0006\u0004%\ta\u001a\u0005\u0006a\u0002!\t!\u001d\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002\u001e\u0001!\t!!\f\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\n\u0003g\u0002\u0011\u0013!C\u0005\u0003k:\u0011\"a#\u001b\u0003\u0003E\t!!$\u0007\u0011eQ\u0012\u0011!E\u0001\u0003\u001fCa!\u0011\f\u0005\u0002\u0005E\u0005\"CAJ-E\u0005I\u0011AAK\u0005Q\u00196GU3t_V\u00148-\u001a#po:dw.\u00193fe*\u00111\u0004H\u0001\u000baJ,GO]1j]\u0016$'BA\u000f\u001f\u0003\rqG\u000e\u001d\u0006\u0003?\u0001\nAB[8i]Ntwn\u001e7bENT\u0011!I\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,Y5\t!$\u0003\u0002.5\t\u0011\"+Z:pkJ\u001cW\rR8x]2|\u0017\rZ3s\u0003\u0019\u0011WoY6fiB\u0019Q\u0005\r\u001a\n\u0005E2#\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0005MRdB\u0001\u001b9!\t)d%D\u00017\u0015\t9$%\u0001\u0004=e>|GOP\u0005\u0003s\u0019\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011HJ\u0001\u0007gN\u0002\u0016\r\u001e5\u0002\u0017\r\f7\r[3G_2$WM]\u0001\u0010GJ,G-\u001a8uS\u0006d7\u000fV=qK\u00061!/Z4j_:\fa\u0001P5oSRtDCB\"E\u000b\u001a;\u0005\n\u0005\u0002,\u0001!1aF\u0002CA\u0002=Ba!\u0010\u0004\u0005\u0002\u0004y\u0003B\u0002 \u0007\t\u0003\u0007q\u0006\u0003\u0004@\r\u0011\u0005\ra\f\u0005\b\u0001\u001a\u0001\n\u00111\u00013\u0003M\u0011X\r]8G_2$WM\u001d\u001aNKR\fG-\u0019;b+\u0005Y\u0005\u0003\u0002'ReMk\u0011!\u0014\u0006\u0003\u001d>\u000bq!\\;uC\ndWM\u0003\u0002QM\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ik%aA'baB\u00111\u0006V\u0005\u0003+j\u0011!CU3q_NLGo\u001c:z\u001b\u0016$\u0018\rZ1uC\u0006!\"/\u001a9p\r>dG-\u001a:3\u001b\u0016$\u0018\rZ1uC\u0002\n\u0011bY1dQ\u0016\u0004\u0016\r\u001e5\u0016\u0003e\u0003\"AW2\u000e\u0003mS!\u0001X/\u0002\u0005\u0019\u001c(B\u00010`\u0003\u0019A\u0017\rZ8pa*\u0011\u0001-Y\u0001\u0007CB\f7\r[3\u000b\u0003\t\f1a\u001c:h\u0013\t!7L\u0001\u0003QCRD\u0017AC2bG\",\u0007+\u0019;iA\u0005Q\u0011m^:HCR,w/Y=\u0016\u0003!\u0004\"!\u001b8\u000e\u0003)T!a\u001b7\u0002\u0007\u0005<8O\u0003\u0002n=\u000511\r\\5f]RL!a\u001c6\u0003\u0015\u0005;6kR1uK^\f\u00170\u0001\fe_^tGn\\1e\u001b\u0016$\u0018\rZ1uC&3g*Z3e)\t\u0011h\u0010E\u0002tqnt!\u0001\u001e<\u000f\u0005U*\u0018\"A\u0014\n\u0005]4\u0013a\u00029bG.\fw-Z\u0005\u0003sj\u0014A\u0001T5ti*\u0011qO\n\t\u0003WqL!! \u000e\u0003!I+7o\\;sG\u0016lU\r^1eCR\f\u0007\"B@\r\u0001\u0004\u0011\u0014A\u00024pY\u0012,'/A\u0006sKN|GN^3MS:\\G\u0003BA\u0003\u0003\u0017\u0001B!JA\u0004w&\u0019\u0011\u0011\u0002\u0014\u0003\r=\u0003H/[8o\u0011\u001d\ti!\u0004a\u0001\u0003\u001f\tqA]3rk\u0016\u001cH\u000fE\u0002,\u0003#I1!a\u0005\u001b\u0005=\u0011Vm]8ve\u000e,'+Z9vKN$\u0018\u0001\u00033po:dw.\u00193\u0015\t\u0005e\u00111\u0004\t\u0005K\u0005\u001d!\u0007C\u0004\u0002\u000e9\u0001\r!a\u0004\u0002)\u0011|wO\u001c7pC\u0012\fe\u000eZ+ou&\u0004h)\u001b7f)!\tI\"!\t\u0002&\u0005%\u0002BBA\u0012\u001f\u0001\u0007\u0011,A\beKN$\u0018N\\1uS>tg)\u001b7f\u0011\u0019\t9c\u0004a\u0001w\u0006A!/Z:pkJ\u001cW\r\u0003\u0004\u0002,=\u0001\rAM\u0001\u000bgN2\u0015\u000e\\3QCRDGCBA\r\u0003_\t\t\u0004\u0003\u0004\u0002,A\u0001\rA\r\u0005\n\u0003g\u0001\u0002\u0013!a\u0001\u0003k\tQ!\u001e8{SB\u00042!JA\u001c\u0013\r\tID\n\u0002\b\u0005>|G.Z1o\u0003=9W\r\u001e#po:dw.\u00193TSj,G\u0003BA \u0003\u000f\u0002R!JA\u0004\u0003\u0003\u00022!JA\"\u0013\r\t)E\n\u0002\u0005\u0019>tw\rC\u0004\u0002\u000eE\u0001\r!a\u0004\u0002\u0015\rdW-\u0019:DC\u000eDW\r\u0006\u0003\u0002N\u0005M\u0003cA\u0013\u0002P%\u0019\u0011\u0011\u000b\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001b\u0011\u0002\u0019AA\b\u000319W\r\u001e+j[\u0016\u001cH/Y7q)\u0011\tI&!\u001b\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005\u00191/\u001d7\u000b\u0005\u0005\r\u0014\u0001\u00026bm\u0006LA!a\u001a\u0002^\tIA+[7fgR\fW\u000e\u001d\u0005\n\u0003W\u001a\u0002\u0013!a\u0001\u0003[\n!\"\u00193e\u001b&tW\u000f^3t!\r)\u0013qN\u0005\u0004\u0003c2#aA%oi\u00061r-\u001a;US6,7\u000f^1na\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002x)\"\u0011QNA=W\t\tY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\u0013Ut7\r[3dW\u0016$'bAACM\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0015q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F*4%\u0016\u001cx.\u001e:dK\u0012{wO\u001c7pC\u0012,'\u000f\u0005\u0002,-M\u0011a\u0003\n\u000b\u0003\u0003\u001b\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*TCAALU\r\u0011\u0014\u0011\u0010")
public class S3ResourceDownloader
implements ResourceDownloader {
    private AWSGateway awsGateway;
    private final Function0<String> bucket;
    private final Function0<String> s3Path;
    private final Function0<String> credentialsType;
    private final String region;
    private final Map<String, RepositoryMetadata> repoFolder2Metadata;
    private final Path cachePath;
    private final FileSystem fileSystem;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$5() {
        return S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public boolean downloadAndUnzipFile$default$2() {
        return ResourceDownloader.downloadAndUnzipFile$default$2$(this);
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public void com$johnsnowlabs$nlp$pretrained$ResourceDownloader$_setter_$fileSystem_$eq(FileSystem x$1) {
        this.fileSystem = x$1;
    }

    private Map<String, RepositoryMetadata> repoFolder2Metadata() {
        return this.repoFolder2Metadata;
    }

    public Path cachePath() {
        return this.cachePath;
    }

    private AWSGateway awsGateway$lzycompute() {
        S3ResourceDownloader s3ResourceDownloader = this;
        synchronized (s3ResourceDownloader) {
            if (!this.bitmap$0) {
                String x$1 = this.region;
                String x$2 = (String)this.credentialsType.apply();
                String x$3 = AWSGateway$.MODULE$.$lessinit$greater$default$1();
                String x$4 = AWSGateway$.MODULE$.$lessinit$greater$default$2();
                String x$5 = AWSGateway$.MODULE$.$lessinit$greater$default$3();
                String x$6 = AWSGateway$.MODULE$.$lessinit$greater$default$4();
                this.awsGateway = new AWSGateway(x$3, x$4, x$5, x$6, x$1, x$2);
                this.bitmap$0 = true;
            }
        }
        return this.awsGateway;
    }

    public AWSGateway awsGateway() {
        return !this.bitmap$0 ? this.awsGateway$lzycompute() : this.awsGateway;
    }

    @Override
    public List<ResourceMetadata> downloadMetadataIfNeed(String folder) {
        Option lastState = this.repoFolder2Metadata().get((Object)folder);
        Timestamp fiveMinsBefore = this.getTimestamp(-5);
        boolean needToRefresh = lastState.isEmpty() || ((RepositoryMetadata)lastState.get()).lastMetadataDownloaded().before(fiveMinsBefore);
        return !needToRefresh ? ((RepositoryMetadata)lastState.get()).metadata() : this.awsGateway().getMetadata((String)this.s3Path.apply(), folder, (String)this.bucket.apply());
    }

    public Option<ResourceMetadata> resolveLink(ResourceRequest request) {
        List<ResourceMetadata> metadata = this.downloadMetadataIfNeed(request.folder());
        return ResourceMetadata$.MODULE$.resolveResource(metadata, request);
    }

    @Override
    public Option<String> download(ResourceRequest request) {
        Option<ResourceMetadata> link = this.resolveLink(request);
        return link.flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            Option<String> option;
            String s3FilePath = this.awsGateway().getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)$this.s3Path.apply(), request.folder(), resource.fileName()}));
            if (!this.awsGateway().doesS3ObjectExist((String)$this.bucket.apply(), s3FilePath)) {
                option = None$.MODULE$;
            } else {
                Option<String> option2;
                String sourceS3URI = new StringBuilder(7).append("s3a://").append($this.bucket.apply()).append("/").append(s3FilePath).toString();
                String zipFile = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceS3URI.split("/"))).last();
                String modelName = zipFile.substring(0, zipFile.indexOf(".zip"));
                String string = this.cachePath().toString();
                if (CloudHelper$.MODULE$.isCloudPath(string)) {
                    option2 = CloudResources$.MODULE$.downloadModelFromCloud(this.awsGateway(), this.cachePath().toString(), modelName, sourceS3URI);
                } else {
                    Path destinationFile = new Path(this.cachePath().toString(), resource.fileName());
                    option2 = this.downloadAndUnzipFile(destinationFile, (ResourceMetadata)resource, s3FilePath);
                }
                option = option2;
            }
            return option;
        });
    }

    public Option<String> downloadAndUnzipFile(Path destinationFile, ResourceMetadata resource, String s3FilePath) {
        Some some;
        String splitPath = destinationFile.toString().substring(0, destinationFile.toString().length() - 4);
        if (!this.fileSystem().exists(destinationFile) && !this.fileSystem().exists(new Path(splitPath))) {
            String tmpFileName = ((Object)Files.createTempFile(resource.fileName(), "", new FileAttribute[0])).toString();
            File tmpFile = new File(tmpFileName);
            this.awsGateway().getS3Object((String)this.bucket.apply(), s3FilePath, tmpFile);
            if (!resource.checksum().equals("")) {
                Predef$.MODULE$.require(FileHelper$.MODULE$.generateChecksum(tmpFileName).equals(resource.checksum()), (Function0 & Serializable & scala.Serializable)() -> "Checksum validation failed!");
            }
            this.fileSystem().moveFromLocalFile(new Path(tmpFile.toString()), destinationFile);
        }
        if (resource.isZipped()) {
            Object object;
            if (!this.fileSystem().exists(new Path(splitPath))) {
                ZipInputStream zis = new ZipInputStream((InputStream)this.fileSystem().open(destinationFile));
                byte[] buf = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
                ZipEntry entry = zis.getNextEntry();
                String string = destinationFile.toString().substring(destinationFile.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Not a zip file.");
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        Path entryName = new Path(splitPath, entry.getName());
                        FSDataOutputStream outputStream = this.fileSystem().create(entryName);
                        int bytesRead = zis.read(buf, 0, 1024);
                        while (bytesRead > -1) {
                            outputStream.write(buf, 0, bytesRead);
                            bytesRead = zis.read(buf, 0, 1024);
                        }
                        outputStream.close();
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
                zis.close();
                object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(destinationFile, true));
            } else {
                object = BoxedUnit.UNIT;
            }
            some = new Some((Object)splitPath);
        } else {
            some = new Some((Object)destinationFile.getName());
        }
        return some;
    }

    @Override
    public Option<String> downloadAndUnzipFile(String s3FilePath, boolean unzip) {
        Object object;
        String newS3FilePath = CloudHelper$.MODULE$.isS3Path(s3FilePath) ? (String)CloudHelper$.MODULE$.parseS3URI(s3FilePath, CloudHelper$.MODULE$.parseS3URI$default$2())._2() : s3FilePath;
        String s3File = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newS3FilePath.split("/"))).last();
        Path destinationFile = new Path(new StringBuilder(1).append(this.cachePath().toString()).append("/").append(s3File).toString());
        String splitPath = destinationFile.toString().substring(0, destinationFile.toString().length() - 4);
        if (!this.fileSystem().exists(destinationFile) && !this.fileSystem().exists(new Path(splitPath))) {
            String tmpFileName = ((Object)Files.createTempFile(s3File, "", new FileAttribute[0])).toString();
            File tmpFile = new File(tmpFileName);
            String newStrfilePath = newS3FilePath;
            String mybucket = (String)this.bucket.apply();
            this.awsGateway().getS3Object(mybucket, newStrfilePath, tmpFile);
            this.fileSystem().moveFromLocalFile(new Path(tmpFile.toString()), destinationFile);
        }
        if (unzip) {
            if (!this.fileSystem().exists(new Path(splitPath))) {
                ZipInputStream zis = new ZipInputStream((InputStream)this.fileSystem().open(destinationFile));
                byte[] buf = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
                ZipEntry entry = zis.getNextEntry();
                String string = destinationFile.toString().substring(destinationFile.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Not a zip file.");
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        Path entryName = new Path(splitPath, entry.getName());
                        FSDataOutputStream outputStream = this.fileSystem().create(entryName);
                        int bytesRead = zis.read(buf, 0, 1024);
                        while (bytesRead > -1) {
                            outputStream.write(buf, 0, bytesRead);
                            bytesRead = zis.read(buf, 0, 1024);
                        }
                        outputStream.close();
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
                zis.close();
                object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(destinationFile, true));
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return new Some((Object)splitPath);
    }

    @Override
    public Option<Object> getDownloadSize(ResourceRequest request) {
        Option<ResourceMetadata> link = this.resolveLink(request);
        return link.flatMap((Function1 & Serializable & scala.Serializable)resource -> this.awsGateway().getS3DownloadSize((String)$this.s3Path.apply(), request.folder(), resource.fileName(), (String)$this.bucket.apply()));
    }

    @Override
    public void clearCache(ResourceRequest request) {
        List<ResourceMetadata> metadata = this.downloadMetadataIfNeed(request.folder());
        Option<ResourceMetadata> resources = ResourceMetadata$.MODULE$.resolveResource(metadata, request);
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            Object object;
            Path fileName = new Path(this.cachePath().toString(), resource.fileName());
            Object object2 = this.fileSystem().exists(fileName) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(fileName, true)) : BoxedUnit.UNIT;
            if (resource.isZipped()) {
                String string = fileName.toString().substring(fileName.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
                String unzipped = fileName.toString().substring(0, fileName.toString().length() - 4);
                Path unzippedFile = new Path(unzipped);
                object = this.fileSystem().exists(unzippedFile) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(unzippedFile, true)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Timestamp getTimestamp(int addMinutes) {
        void var3_3;
        Calendar cal = Calendar.getInstance();
        cal.add(12, addMinutes);
        Timestamp timestamp = new Timestamp(cal.getTime().getTime());
        cal.clear();
        return var3_3;
    }

    private int getTimestamp$default$1() {
        return 0;
    }

    public S3ResourceDownloader(Function0<String> bucket, Function0<String> s3Path, Function0<String> cacheFolder, Function0<String> credentialsType, String region) {
        this.bucket = bucket;
        this.s3Path = s3Path;
        this.credentialsType = credentialsType;
        this.region = region;
        ResourceDownloader.$init$(this);
        this.repoFolder2Metadata = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.cachePath = new Path((String)cacheFolder.apply());
        Object object = !CloudHelper$.MODULE$.isCloudPath((String)cacheFolder.apply()) && !this.fileSystem().exists(this.cachePath()) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().mkdirs(this.cachePath())) : BoxedUnit.UNIT;
    }
}

