Index.PACKAGES = {"scala.collection" : [], "com.johnsnowlabs.nlp.training" : [{"name" : "com.johnsnowlabs.nlp.training.CoNLL", "shortDescription" : "Helper class to load a CoNLL type dataset for training.", "members_case class" : [{"label" : "readDatasetFromLines", "tail" : "(lines: Array[String], spark: SparkSession): Dataset[_]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.readDatasetFromLines", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#readDatasetFromLines(lines:Array[String],spark:org.apache.spark.sql.SparkSession):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "readDataset", "tail" : "(spark: SparkSession, path: String, readAs: String, parallelism: Int, storageLevel: StorageLevel): Dataset[_]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.readDataset", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#readDataset(spark:org.apache.spark.sql.SparkSession,path:String,readAs:String,parallelism:Int,storageLevel:org.apache.spark.storage.StorageLevel):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "packDocs", "tail" : "(docs: Seq[CoNLLDocument], spark: SparkSession): Dataset[_]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.packDocs", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#packDocs(docs:Seq[com.johnsnowlabs.nlp.training.CoNLLDocument],spark:org.apache.spark.sql.SparkSession):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "schema", "tail" : "(): StructType", "member" : "com.johnsnowlabs.nlp.training.CoNLL.schema", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#schema:org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "getAnnotationType", "tail" : "(column: String, annotatorType: String, addMetadata: Boolean): StructField", "member" : "com.johnsnowlabs.nlp.training.CoNLL.getAnnotationType", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#getAnnotationType(column:String,annotatorType:String,addMetadata:Boolean):org.apache.spark.sql.types.StructField", "kind" : "def"}, {"label" : "annotationType", "tail" : ": ArrayType", "member" : "com.johnsnowlabs.nlp.training.CoNLL.annotationType", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#annotationType:org.apache.spark.sql.types.ArrayType", "kind" : "val"}, {"label" : "removeSurroundingHyphens", "tail" : "(text: String): String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.removeSurroundingHyphens", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#removeSurroundingHyphens(text:String):String", "kind" : "def"}, {"label" : "packPosTagged", "tail" : "(sentences: Seq[TaggedSentence]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.packPosTagged", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#packPosTagged(sentences:Seq[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "packTokenized", "tail" : "(text: String, sentences: Seq[TaggedSentence]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.packTokenized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#packTokenized(text:String,sentences:Seq[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "packSentence", "tail" : "(text: String, sentences: Seq[TaggedSentence]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.packSentence", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#packSentence(text:String,sentences:Seq[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "packAssembly", "tail" : "(text: String, isTraining: Boolean): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.packAssembly", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#packAssembly(text:String,isTraining:Boolean):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "packNerTagged", "tail" : "(sentences: Seq[NerTaggedSentence]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.packNerTagged", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#packNerTagged(sentences:Seq[com.johnsnowlabs.nlp.annotators.common.Annotated.NerTaggedSentence]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "readLines", "tail" : "(lines: Array[String]): Seq[CoNLLDocument]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.readLines", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#readLines(lines:Array[String]):Seq[com.johnsnowlabs.nlp.training.CoNLLDocument]", "kind" : "def"}, {"label" : "clearTokens", "tail" : "(tokens: Array[IndexedTaggedWord]): Array[IndexedTaggedWord]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.clearTokens", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#clearTokens(tokens:Array[com.johnsnowlabs.nlp.annotators.common.IndexedTaggedWord]):Array[com.johnsnowlabs.nlp.annotators.common.IndexedTaggedWord]", "kind" : "def"}, {"label" : "readDocs", "tail" : "(er: ExternalResource): Seq[CoNLLDocument]", "member" : "com.johnsnowlabs.nlp.training.CoNLL.readDocs", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#readDocs(er:com.johnsnowlabs.nlp.util.io.ExternalResource):Seq[com.johnsnowlabs.nlp.training.CoNLLDocument]", "kind" : "def"}, {"member" : "com.johnsnowlabs.nlp.training.CoNLL#<init>", "error" : "unsupported entity"}, {"label" : "includeDocId", "tail" : ": Boolean", "member" : "com.johnsnowlabs.nlp.training.CoNLL.includeDocId", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#includeDocId:Boolean", "kind" : "val"}, {"label" : "delimiter", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.delimiter", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#delimiter:String", "kind" : "val"}, {"label" : "explodeSentences", "tail" : ": Boolean", "member" : "com.johnsnowlabs.nlp.training.CoNLL.explodeSentences", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#explodeSentences:Boolean", "kind" : "val"}, {"label" : "labelCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.labelCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#labelCol:String", "kind" : "val"}, {"label" : "conllTextCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.conllTextCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#conllTextCol:String", "kind" : "val"}, {"label" : "conllDocIdCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.conllDocIdCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#conllDocIdCol:String", "kind" : "val"}, {"label" : "conllPosIndex", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.training.CoNLL.conllPosIndex", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#conllPosIndex:Int", "kind" : "val"}, {"label" : "conllLabelIndex", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.training.CoNLL.conllLabelIndex", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#conllLabelIndex:Int", "kind" : "val"}, {"label" : "posCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.posCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#posCol:String", "kind" : "val"}, {"label" : "tokenCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.tokenCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#tokenCol:String", "kind" : "val"}, {"label" : "sentenceCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.sentenceCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#sentenceCol:String", "kind" : "val"}, {"label" : "documentCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLL.documentCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#documentCol:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/training\/CoNLL.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.nlp.training.CoNLL2003NerReader", "shortDescription" : "Helper class for to work with CoNLL 2003 dataset for NER task Class is made for easy use fromJava", "members_class" : [{"label" : "readNerDataset", "tail" : "(er: ExternalResource, metadata: Option[DatasetMetadata]): CrfDataset", "member" : "com.johnsnowlabs.nlp.training.CoNLL2003NerReader.readNerDataset", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#readNerDataset(er:com.johnsnowlabs.nlp.util.io.ExternalResource,metadata:Option[com.johnsnowlabs.ml.crf.DatasetMetadata]):com.johnsnowlabs.ml.crf.CrfDataset", "kind" : "def"}, {"member" : "com.johnsnowlabs.nlp.training.CoNLL2003NerReader#<init>", "error" : "unsupported entity"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/training\/CoNLL2003NerReader.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.training.CoNLLDocument", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.nlp.training.CoNLLDocument#<init>", "error" : "unsupported entity"}, {"label" : "docId", "tail" : ": Option[String]", "member" : "com.johnsnowlabs.nlp.training.CoNLLDocument.docId", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#docId:Option[String]", "kind" : "val"}, {"label" : "posTagged", "tail" : ": Seq[PosTaggedSentence]", "member" : "com.johnsnowlabs.nlp.training.CoNLLDocument.posTagged", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#posTagged:Seq[com.johnsnowlabs.nlp.annotators.common.Annotated.PosTaggedSentence]", "kind" : "val"}, {"label" : "nerTagged", "tail" : ": Seq[NerTaggedSentence]", "member" : "com.johnsnowlabs.nlp.training.CoNLLDocument.nerTagged", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#nerTagged:Seq[com.johnsnowlabs.nlp.annotators.common.Annotated.NerTaggedSentence]", "kind" : "val"}, {"label" : "text", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLDocument.text", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#text:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/training\/CoNLLDocument.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.nlp.training.CoNLLHelper", "shortDescription" : "", "object" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html", "members_object" : [{"label" : "readLines", "tail" : "(lines: Array[String], explodeSentences: Boolean): Seq[CoNLLUDocument]", "member" : "com.johnsnowlabs.nlp.training.CoNLLHelper.readLines", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#readLines(lines:Array[String],explodeSentences:Boolean):Seq[com.johnsnowlabs.nlp.training.CoNLLUDocument]", "kind" : "def"}, {"label" : "CoNLLSentenceCols", "tail" : "", "member" : "com.johnsnowlabs.nlp.training.CoNLLHelper.CoNLLSentenceCols", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#CoNLLSentenceColsextendsProductwithSerializable", "kind" : "case class"}, {"label" : "CoNLLTokenCols", "tail" : "", "member" : "com.johnsnowlabs.nlp.training.CoNLLHelper.CoNLLTokenCols", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#CoNLLTokenColsextendsProductwithSerializable", "kind" : "case class"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLHelper$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.nlp.training.CoNLLU", "shortDescription" : "Instantiates the class to read a CoNLL-U dataset.", "members_case class" : [{"label" : "getAnnotationType", "tail" : "(column: String, annotatorType: String, addMetadata: Boolean): StructField", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.getAnnotationType", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#getAnnotationType(column:String,annotatorType:String,addMetadata:Boolean):org.apache.spark.sql.types.StructField", "kind" : "def"}, {"label" : "schema", "tail" : "(): StructType", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.schema", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#schema:org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "readDocs", "tail" : "(er: ExternalResource): Seq[CoNLLUDocument]", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.readDocs", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#readDocs(er:com.johnsnowlabs.nlp.util.io.ExternalResource):Seq[com.johnsnowlabs.nlp.training.CoNLLUDocument]", "kind" : "def"}, {"label" : "packPosTagged", "tail" : "(sentences: Seq[TaggedSentence]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.packPosTagged", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#packPosTagged(sentences:Seq[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "packTokenized", "tail" : "(sentences: Seq[TaggedSentence]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.packTokenized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#packTokenized(sentences:Seq[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "packSentence", "tail" : "(text: String, sentences: Seq[TaggedSentence]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.packSentence", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#packSentence(text:String,sentences:Seq[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "packAssembly", "tail" : "(text: String, isTraining: Boolean): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.packAssembly", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#packAssembly(text:String,isTraining:Boolean):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "packDocs", "tail" : "(docs: Seq[CoNLLUDocument], spark: SparkSession): Dataset[_]", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.packDocs", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#packDocs(docs:Seq[com.johnsnowlabs.nlp.training.CoNLLUDocument],spark:org.apache.spark.sql.SparkSession):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "readDataset", "tail" : "(spark: SparkSession, path: String, readAs: String): Dataset[_]", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.readDataset", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#readDataset(spark:org.apache.spark.sql.SparkSession,path:String,readAs:String):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "readDatasetFromLines", "tail" : "(lines: Array[String], spark: SparkSession): Dataset[_]", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.readDatasetFromLines", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#readDatasetFromLines(lines:Array[String],spark:org.apache.spark.sql.SparkSession):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"member" : "com.johnsnowlabs.nlp.training.CoNLLU#<init>", "error" : "unsupported entity"}, {"label" : "explodeSentences", "tail" : ": Boolean", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.explodeSentences", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#explodeSentences:Boolean", "kind" : "val"}, {"label" : "lemmaCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.lemmaCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#lemmaCol:String", "kind" : "val"}, {"label" : "xposCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.xposCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#xposCol:String", "kind" : "val"}, {"label" : "uposCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.uposCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#uposCol:String", "kind" : "val"}, {"label" : "formCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.formCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#formCol:String", "kind" : "val"}, {"label" : "sentenceCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.sentenceCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#sentenceCol:String", "kind" : "val"}, {"label" : "documentCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.documentCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#documentCol:String", "kind" : "val"}, {"label" : "conllTextCol", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLU.conllTextCol", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#conllTextCol:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/training\/CoNLLU.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.nlp.training.CoNLLUCols", "shortDescription" : "", "object" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html", "members_object" : [{"label" : "ValueSet", "tail" : "", "member" : "scala.Enumeration.ValueSet", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#ValueSet", "kind" : "object"}, {"label" : "ValueSet", "tail" : "", "member" : "scala.Enumeration.ValueSet", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#ValueSetextendsAbstractSet[Enumeration.this.Value]withSortedSet[Enumeration.this.Value]withSortedSetLike[Enumeration.this.Value,Enumeration.this.ValueSet]withSerializable", "kind" : "class"}, {"label" : "Val", "tail" : "", "member" : "scala.Enumeration.Val", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#ValextendsEnumeration.this.ValuewithSerializable", "kind" : "class"}, {"label" : "Value", "tail" : "", "member" : "scala.Enumeration.Value", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#ValueextendsOrdered[Enumeration.this.Value]withSerializable", "kind" : "abstract class"}, {"label" : "MISC", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.MISC", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#MISC:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "DEPS", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.DEPS", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#DEPS:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "DEPREL", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.DEPREL", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#DEPREL:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "HEAD", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.HEAD", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#HEAD:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "FEATS", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.FEATS", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#FEATS:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "XPOS", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.XPOS", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#XPOS:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "UPOS", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.UPOS", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#UPOS:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "LEMMA", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.LEMMA", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#LEMMA:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "FORM", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.FORM", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#FORM:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "ID", "tail" : ": Value", "member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.ID", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#ID:com.johnsnowlabs.nlp.training.CoNLLUCols.Value", "kind" : "val"}, {"label" : "Value", "tail" : "(i: Int, name: String): Value", "member" : "scala.Enumeration.Value", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#Value(i:Int,name:String):Enumeration.this.Value", "kind" : "final def"}, {"label" : "Value", "tail" : "(name: String): Value", "member" : "scala.Enumeration.Value", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#Value(name:String):Enumeration.this.Value", "kind" : "final def"}, {"label" : "Value", "tail" : "(i: Int): Value", "member" : "scala.Enumeration.Value", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#Value(i:Int):Enumeration.this.Value", "kind" : "final def"}, {"label" : "Value", "tail" : "(): Value", "member" : "scala.Enumeration.Value", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#Value:Enumeration.this.Value", "kind" : "final def"}, {"label" : "withName", "tail" : "(s: String): Value", "member" : "scala.Enumeration.withName", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#withName(s:String):Enumeration.this.Value", "kind" : "final def"}, {"label" : "apply", "tail" : "(x: Int): Value", "member" : "scala.Enumeration.apply", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#apply(x:Int):Enumeration.this.Value", "kind" : "final def"}, {"label" : "maxId", "tail" : "(): Int", "member" : "scala.Enumeration.maxId", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#maxId:Int", "kind" : "final def"}, {"label" : "nextName", "tail" : ": Iterator[String]", "member" : "scala.Enumeration.nextName", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#nextName:Iterator[String]", "kind" : "var"}, {"label" : "nextId", "tail" : ": Int", "member" : "scala.Enumeration.nextId", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#nextId:Int", "kind" : "var"}, {"label" : "values", "tail" : "(): ValueSet", "member" : "scala.Enumeration.values", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#values:Enumeration.this.ValueSet", "kind" : "def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.Enumeration.toString", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#toString():String", "kind" : "def"}, {"label" : "readResolve", "tail" : "(): AnyRef", "member" : "scala.Enumeration.readResolve", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#readResolve():AnyRef", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUCols$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}, {"member" : "com.johnsnowlabs.nlp.training.CoNLLUCols.Format", "error" : "unsupported entity"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.nlp.training.CoNLLUDocument", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.nlp.training.CoNLLUDocument#<init>", "error" : "unsupported entity"}, {"label" : "lemma", "tail" : ": Seq[PosTaggedSentence]", "member" : "com.johnsnowlabs.nlp.training.CoNLLUDocument.lemma", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#lemma:Seq[com.johnsnowlabs.nlp.annotators.common.Annotated.PosTaggedSentence]", "kind" : "val"}, {"label" : "xPosTagged", "tail" : ": Seq[PosTaggedSentence]", "member" : "com.johnsnowlabs.nlp.training.CoNLLUDocument.xPosTagged", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#xPosTagged:Seq[com.johnsnowlabs.nlp.annotators.common.Annotated.PosTaggedSentence]", "kind" : "val"}, {"label" : "uPosTagged", "tail" : ": Seq[PosTaggedSentence]", "member" : "com.johnsnowlabs.nlp.training.CoNLLUDocument.uPosTagged", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#uPosTagged:Seq[com.johnsnowlabs.nlp.annotators.common.Annotated.PosTaggedSentence]", "kind" : "val"}, {"label" : "text", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.training.CoNLLUDocument.text", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#text:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/training\/CoNLLUDocument.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.nlp.training.POS", "shortDescription" : "Helper class for creating DataFrames for training a part-of-speech tagger.", "members_case class" : [{"label" : "readFromDataframe", "tail" : "(posDataframe: DataFrame, tokensCol: String, labelsCol: String, outPutDocColName: String, outPutPosColName: String): DataFrame", "member" : "com.johnsnowlabs.nlp.training.POS.readFromDataframe", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#readFromDataframe(posDataframe:org.apache.spark.sql.DataFrame,tokensCol:String,labelsCol:String,outPutDocColName:String,outPutPosColName:String):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "readDataset", "tail" : "(sparkSession: SparkSession, path: String, delimiter: String, outputPosCol: String, outputDocumentCol: String, outputTextCol: String): DataFrame", "member" : "com.johnsnowlabs.nlp.training.POS.readDataset", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#readDataset(sparkSession:org.apache.spark.sql.SparkSession,path:String,delimiter:String,outputPosCol:String,outputDocumentCol:String,outputTextCol:String):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "wrapColumnMetadata", "tail" : "(col: Column, annotatorType: String, outPutColName: String): Column", "member" : "com.johnsnowlabs.nlp.training.POS.wrapColumnMetadata", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#wrapColumnMetadata(col:org.apache.spark.sql.Column,annotatorType:String,outPutColName:String):org.apache.spark.sql.Column", "kind" : "def"}, {"member" : "com.johnsnowlabs.nlp.training.POS#<init>", "error" : "unsupported entity"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/POS.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/training\/POS.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.nlp.training.PubTator", "shortDescription" : "The PubTator format includes medical papers’ titles, abstracts, and tagged chunks.", "members_case class" : [{"label" : "readDataset", "tail" : "(spark: SparkSession, path: String, isPaddedToken: Boolean): DataFrame", "member" : "com.johnsnowlabs.nlp.training.PubTator.readDataset", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#readDataset(spark:org.apache.spark.sql.SparkSession,path:String,isPaddedToken:Boolean):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"member" : "com.johnsnowlabs.nlp.training.PubTator#<init>", "error" : "unsupported entity"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/training\/PubTator.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.nlp.training.SpacyToAnnotation", "shortDescription" : "", "members_class" : [{"label" : "readJsonFile", "tail" : "(spark: SparkSession, jsonFilePath: String, params: Map[String, String]): Dataset[_]", "member" : "com.johnsnowlabs.nlp.training.SpacyToAnnotation.readJsonFile", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#readJsonFile(spark:org.apache.spark.sql.SparkSession,jsonFilePath:String,params:Map[String,String]):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "readJsonFileJava", "tail" : "(spark: SparkSession, jsonFilePath: String, params: Map[String, String]): Dataset[_]", "member" : "com.johnsnowlabs.nlp.training.SpacyToAnnotation.readJsonFileJava", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#readJsonFileJava(spark:org.apache.spark.sql.SparkSession,jsonFilePath:String,params:java.util.Map[String,String]):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"member" : "com.johnsnowlabs.nlp.training.SpacyToAnnotation#<init>", "error" : "unsupported entity"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/training\/SpacyToAnnotation.html", "kind" : "class"}], "com.johnsnowlabs.ml.ai.model" : [{"name" : "com.johnsnowlabs.ml.ai.model.Choice", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.ai.model.Choice#<init>", "error" : "unsupported entity"}, {"label" : "finish_reason", "tail" : ": String", "member" : "com.johnsnowlabs.ml.ai.model.Choice.finish_reason", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#finish_reason:String", "kind" : "val"}, {"label" : "logprobs", "tail" : ": Option[Float]", "member" : "com.johnsnowlabs.ml.ai.model.Choice.logprobs", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#logprobs:Option[Float]", "kind" : "val"}, {"label" : "index", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.model.Choice.index", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#index:Int", "kind" : "val"}, {"label" : "text", "tail" : ": String", "member" : "com.johnsnowlabs.ml.ai.model.Choice.text", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#text:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/ai\/model\/Choice.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.ai.model.CompletionResponse", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.ai.model.CompletionResponse#<init>", "error" : "unsupported entity"}, {"label" : "usage", "tail" : ": Usage", "member" : "com.johnsnowlabs.ml.ai.model.CompletionResponse.usage", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#usage:com.johnsnowlabs.ml.ai.model.Usage", "kind" : "val"}, {"label" : "choices", "tail" : ": List[Choice]", "member" : "com.johnsnowlabs.ml.ai.model.CompletionResponse.choices", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#choices:List[com.johnsnowlabs.ml.ai.model.Choice]", "kind" : "val"}, {"label" : "model", "tail" : ": String", "member" : "com.johnsnowlabs.ml.ai.model.CompletionResponse.model", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#model:String", "kind" : "val"}, {"label" : "created", "tail" : ": Long", "member" : "com.johnsnowlabs.ml.ai.model.CompletionResponse.created", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#created:Long", "kind" : "val"}, {"label" : "object", "tail" : ": String", "member" : "com.johnsnowlabs.ml.ai.model.CompletionResponse.object", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#object:String", "kind" : "val"}, {"label" : "id", "tail" : ": String", "member" : "com.johnsnowlabs.ml.ai.model.CompletionResponse.id", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#id:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/ai\/model\/CompletionResponse.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.ai.model.EmbeddingData", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.ai.model.EmbeddingData#<init>", "error" : "unsupported entity"}, {"label" : "index", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.model.EmbeddingData.index", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#index:Int", "kind" : "val"}, {"label" : "embedding", "tail" : ": List[Float]", "member" : "com.johnsnowlabs.ml.ai.model.EmbeddingData.embedding", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#embedding:List[Float]", "kind" : "val"}, {"label" : "object", "tail" : ": String", "member" : "com.johnsnowlabs.ml.ai.model.EmbeddingData.object", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#object:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/ai\/model\/EmbeddingData.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.ai.model.TextEmbeddingResponse", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.ai.model.TextEmbeddingResponse#<init>", "error" : "unsupported entity"}, {"label" : "usage", "tail" : ": UsageData", "member" : "com.johnsnowlabs.ml.ai.model.TextEmbeddingResponse.usage", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#usage:com.johnsnowlabs.ml.ai.model.UsageData", "kind" : "val"}, {"label" : "model", "tail" : ": String", "member" : "com.johnsnowlabs.ml.ai.model.TextEmbeddingResponse.model", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#model:String", "kind" : "val"}, {"label" : "data", "tail" : ": List[EmbeddingData]", "member" : "com.johnsnowlabs.ml.ai.model.TextEmbeddingResponse.data", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#data:List[com.johnsnowlabs.ml.ai.model.EmbeddingData]", "kind" : "val"}, {"label" : "object", "tail" : ": String", "member" : "com.johnsnowlabs.ml.ai.model.TextEmbeddingResponse.object", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#object:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/ai\/model\/TextEmbeddingResponse.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.ai.model.Usage", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.ai.model.Usage#<init>", "error" : "unsupported entity"}, {"label" : "total_tokens", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.model.Usage.total_tokens", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#total_tokens:Int", "kind" : "val"}, {"label" : "completion_tokens", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.model.Usage.completion_tokens", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#completion_tokens:Int", "kind" : "val"}, {"label" : "prompt_tokens", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.model.Usage.prompt_tokens", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#prompt_tokens:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/ai\/model\/Usage.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.ai.model.UsageData", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.ai.model.UsageData#<init>", "error" : "unsupported entity"}, {"label" : "total_tokens", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.model.UsageData.total_tokens", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#total_tokens:Int", "kind" : "val"}, {"label" : "prompt_tokens", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.model.UsageData.prompt_tokens", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#prompt_tokens:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/ai\/model\/UsageData.html", "kind" : "case class"}], "com.johnsnowlabs.ml.crf" : [{"name" : "com.johnsnowlabs.ml.crf.Attr", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.Attr#<init>", "error" : "unsupported entity"}, {"label" : "isNumerical", "tail" : ": Boolean", "member" : "com.johnsnowlabs.ml.crf.Attr.isNumerical", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#isNumerical:Boolean", "kind" : "val"}, {"label" : "name", "tail" : ": String", "member" : "com.johnsnowlabs.ml.crf.Attr.name", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#name:String", "kind" : "val"}, {"label" : "id", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.Attr.id", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#id:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/Attr.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/Attr.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.AttrFeature", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.AttrFeature#<init>", "error" : "unsupported entity"}, {"label" : "label", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.AttrFeature.label", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#label:Int", "kind" : "val"}, {"label" : "attrId", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.AttrFeature.attrId", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#attrId:Int", "kind" : "val"}, {"label" : "id", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.AttrFeature.id", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#id:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/AttrFeature.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.AttrStat", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.AttrStat#<init>", "error" : "unsupported entity"}, {"label" : "sum", "tail" : ": Float", "member" : "com.johnsnowlabs.ml.crf.AttrStat.sum", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#sum:Float", "kind" : "val"}, {"label" : "frequency", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.AttrStat.frequency", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#frequency:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/AttrStat.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.CrfDataset", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.CrfDataset#<init>", "error" : "unsupported entity"}, {"label" : "metadata", "tail" : ": DatasetMetadata", "member" : "com.johnsnowlabs.ml.crf.CrfDataset.metadata", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#metadata:com.johnsnowlabs.ml.crf.DatasetMetadata", "kind" : "val"}, {"label" : "instances", "tail" : ": Seq[(InstanceLabels, Instance)]", "member" : "com.johnsnowlabs.ml.crf.CrfDataset.instances", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#instances:Seq[(com.johnsnowlabs.ml.crf.InstanceLabels,com.johnsnowlabs.ml.crf.Instance)]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/CrfDataset.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.CrfParams", "shortDescription" : "Hyper Parameters and Setting for LinearChainCrf training", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.CrfParams#<init>", "error" : "unsupported entity"}, {"label" : "verbose", "tail" : ": nlp.annotators.ner.Verbose.Value", "member" : "com.johnsnowlabs.ml.crf.CrfParams.verbose", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#verbose:com.johnsnowlabs.nlp.annotators.ner.Verbose.Value", "kind" : "val"}, {"label" : "randomSeed", "tail" : ": Option[Int]", "member" : "com.johnsnowlabs.ml.crf.CrfParams.randomSeed", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#randomSeed:Option[Int]", "kind" : "val"}, {"label" : "lossEps", "tail" : ": Float", "member" : "com.johnsnowlabs.ml.crf.CrfParams.lossEps", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#lossEps:Float", "kind" : "val"}, {"label" : "c0", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.CrfParams.c0", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#c0:Int", "kind" : "val"}, {"label" : "l2", "tail" : ": Float", "member" : "com.johnsnowlabs.ml.crf.CrfParams.l2", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#l2:Float", "kind" : "val"}, {"label" : "maxEpochs", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.CrfParams.maxEpochs", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#maxEpochs:Int", "kind" : "val"}, {"label" : "minEpochs", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.CrfParams.minEpochs", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#minEpochs:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/CrfParams.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.DatasetEncoder", "shortDescription" : "", "members_class" : [{"label" : "getMetadata", "tail" : "(): DatasetMetadata", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.getMetadata", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#getMetadata:com.johnsnowlabs.ml.crf.DatasetMetadata", "kind" : "def"}, {"label" : "getFeatures", "tail" : "(prevLabel: String, label: String, binaryAttrs: Seq[String], numAttrs: Seq[Float]): (Int, SparseArray)", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.getFeatures", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#getFeatures(prevLabel:String,label:String,binaryAttrs:Seq[String],numAttrs:Seq[Float]):(Int,com.johnsnowlabs.ml.crf.SparseArray)", "kind" : "def"}, {"label" : "transitions", "tail" : "(): Seq[Transition]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.transitions", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#transitions:Seq[com.johnsnowlabs.ml.crf.Transition]", "kind" : "def"}, {"label" : "transFeaturesFreq", "tail" : ": Map[Transition, Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.transFeaturesFreq", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#transFeaturesFreq:scala.collection.mutable.Map[com.johnsnowlabs.ml.crf.Transition,Int]", "kind" : "val"}, {"label" : "attrFeaturesSum", "tail" : ": ArrayBuffer[Float]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.attrFeaturesSum", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#attrFeaturesSum:scala.collection.mutable.ArrayBuffer[Float]", "kind" : "val"}, {"label" : "attrFeaturesFreq", "tail" : ": ArrayBuffer[Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.attrFeaturesFreq", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#attrFeaturesFreq:scala.collection.mutable.ArrayBuffer[Int]", "kind" : "val"}, {"label" : "attrFeatures", "tail" : ": ArrayBuffer[AttrFeature]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.attrFeatures", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#attrFeatures:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.ml.crf.AttrFeature]", "kind" : "val"}, {"label" : "attrFeatures2Id", "tail" : ": Map[(Int, Int), Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.attrFeatures2Id", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#attrFeatures2Id:scala.collection.mutable.Map[(Int,Int),Int]", "kind" : "val"}, {"label" : "attributes", "tail" : ": ArrayBuffer[Attr]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.attributes", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#attributes:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.ml.crf.Attr]", "kind" : "val"}, {"label" : "label2Id", "tail" : ": Map[String, Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.label2Id", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#label2Id:scala.collection.mutable.Map[String,Int]", "kind" : "val"}, {"label" : "attr2Id", "tail" : ": Map[String, Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.attr2Id", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#attr2Id:scala.collection.mutable.Map[String,Int]", "kind" : "val"}, {"member" : "com.johnsnowlabs.ml.crf.DatasetEncoder#<init>", "error" : "unsupported entity"}, {"label" : "startLabel", "tail" : ": String", "member" : "com.johnsnowlabs.ml.crf.DatasetEncoder.startLabel", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#startLabel:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/ml\/crf\/DatasetEncoder.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.ml.crf.DatasetMetadata", "shortDescription" : "", "members_class" : [{"label" : "filterFeatures", "tail" : "(featureIds: Seq[Int]): DatasetMetadata", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.filterFeatures", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#filterFeatures(featureIds:Seq[Int]):com.johnsnowlabs.ml.crf.DatasetMetadata", "kind" : "def"}, {"label" : "serialize", "tail" : "(): SerializedAnnotatorComponent[_ <: WritableAnnotatorComponent]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.serialize", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#serialize:com.johnsnowlabs.nlp.annotators.param.SerializedAnnotatorComponent[_<:com.johnsnowlabs.nlp.annotators.param.WritableAnnotatorComponent]", "kind" : "def"}, {"label" : "attr2Features", "tail" : ": IndexedSeq[Array[AttrFeature]]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.attr2Features", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#attr2Features:IndexedSeq[Array[com.johnsnowlabs.ml.crf.AttrFeature]]", "kind" : "lazy val"}, {"label" : "transFeature2Id", "tail" : ": Map[Transition, Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.transFeature2Id", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#transFeature2Id:Map[com.johnsnowlabs.ml.crf.Transition,Int]", "kind" : "lazy val"}, {"label" : "attrFeatures2Id", "tail" : ": Map[(Int, Int), Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.attrFeatures2Id", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#attrFeatures2Id:Map[(Int,Int),Int]", "kind" : "lazy val"}, {"label" : "attr2Id", "tail" : ": Map[String, Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.attr2Id", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#attr2Id:Map[String,Int]", "kind" : "lazy val"}, {"label" : "label2Id", "tail" : ": Map[String, Int]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.label2Id", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#label2Id:Map[String,Int]", "kind" : "lazy val"}, {"member" : "com.johnsnowlabs.ml.crf.DatasetMetadata#<init>", "error" : "unsupported entity"}, {"label" : "featuresStat", "tail" : ": Array[AttrStat]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.featuresStat", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#featuresStat:Array[com.johnsnowlabs.ml.crf.AttrStat]", "kind" : "val"}, {"label" : "transitions", "tail" : ": Array[Transition]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.transitions", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#transitions:Array[com.johnsnowlabs.ml.crf.Transition]", "kind" : "val"}, {"label" : "attrFeatures", "tail" : ": Array[AttrFeature]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.attrFeatures", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#attrFeatures:Array[com.johnsnowlabs.ml.crf.AttrFeature]", "kind" : "val"}, {"label" : "attrs", "tail" : ": Array[Attr]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.attrs", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#attrs:Array[com.johnsnowlabs.ml.crf.Attr]", "kind" : "val"}, {"label" : "labels", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.ml.crf.DatasetMetadata.labels", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#labels:Array[String]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/ml\/crf\/DatasetMetadata.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.ml.crf.DatasetReader", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html", "members_object" : [{"label" : "readAndEncode", "tail" : "(file: String, skipLines: Int, metadata: DatasetMetadata): TraversableOnce[(InstanceLabels, Instance)]", "member" : "com.johnsnowlabs.ml.crf.DatasetReader.readAndEncode", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#readAndEncode(file:String,skipLines:Int,metadata:com.johnsnowlabs.ml.crf.DatasetMetadata):scala.collection.TraversableOnce[(com.johnsnowlabs.ml.crf.InstanceLabels,com.johnsnowlabs.ml.crf.Instance)]", "kind" : "def"}, {"label" : "readAndEncode", "tail" : "(file: String, skipLines: Int): CrfDataset", "member" : "com.johnsnowlabs.ml.crf.DatasetReader.readAndEncode", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#readAndEncode(file:String,skipLines:Int):com.johnsnowlabs.ml.crf.CrfDataset", "kind" : "def"}, {"label" : "encodeSentence", "tail" : "(sentence: TextSentenceAttrs, metadata: DatasetMetadata): Instance", "member" : "com.johnsnowlabs.ml.crf.DatasetReader.encodeSentence", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#encodeSentence(sentence:com.johnsnowlabs.ml.crf.TextSentenceAttrs,metadata:com.johnsnowlabs.ml.crf.DatasetMetadata):com.johnsnowlabs.ml.crf.Instance", "kind" : "def"}, {"label" : "encodeDataset", "tail" : "(source: TraversableOnce[(TextSentenceLabels, TextSentenceAttrs)]): CrfDataset", "member" : "com.johnsnowlabs.ml.crf.DatasetReader.encodeDataset", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#encodeDataset(source:scala.collection.TraversableOnce[(com.johnsnowlabs.ml.crf.TextSentenceLabels,com.johnsnowlabs.ml.crf.TextSentenceAttrs)]):com.johnsnowlabs.ml.crf.CrfDataset", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/DatasetReader$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.crf.EdgeCalculator", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html", "members_object" : [{"label" : "fillLogEdges", "tail" : "(values: Seq[(Int, Float)], weights: Array[Float], scale: Float, metadata: DatasetMetadata, matrix: Matrix): Unit", "member" : "com.johnsnowlabs.ml.crf.EdgeCalculator.fillLogEdges", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#fillLogEdges(values:Seq[(Int,Float)],weights:Array[Float],scale:Float,metadata:com.johnsnowlabs.ml.crf.DatasetMetadata,matrix:com.johnsnowlabs.ml.crf.VectorMath.Matrix):Unit", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/EdgeCalculator$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.crf.FbCalculator", "shortDescription" : "", "members_class" : [{"label" : "addModelExpectations", "tail" : "(weights: Vector, sentence: Instance, const: Float): Unit", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.addModelExpectations", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#addModelExpectations(weights:com.johnsnowlabs.ml.crf.VectorMath.Vector,sentence:com.johnsnowlabs.ml.crf.Instance,const:Float):Unit", "kind" : "def"}, {"label" : "addObservedExpectations", "tail" : "(weights: Vector, instance: Instance, instanceLabels: InstanceLabels, c: Float): Unit", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.addObservedExpectations", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#addObservedExpectations(weights:com.johnsnowlabs.ml.crf.VectorMath.Vector,instance:com.johnsnowlabs.ml.crf.Instance,instanceLabels:com.johnsnowlabs.ml.crf.InstanceLabels,c:Float):Unit", "kind" : "def"}, {"label" : "calculate", "tail" : "(sentence: Instance, weights: Array[Float], scale: Float): Unit", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.calculate", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#calculate(sentence:com.johnsnowlabs.ml.crf.Instance,weights:Array[Float],scale:Float):Unit", "kind" : "def"}, {"label" : "c", "tail" : ": Array[Float]", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.c", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#c:Array[Float]", "kind" : "val"}, {"label" : "beta", "tail" : ": Array[Vector]", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.beta", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#beta:Array[com.johnsnowlabs.ml.crf.VectorMath.Vector]", "kind" : "val"}, {"label" : "alpha", "tail" : ": Array[Vector]", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.alpha", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#alpha:Array[com.johnsnowlabs.ml.crf.VectorMath.Vector]", "kind" : "val"}, {"label" : "phi", "tail" : ": Array[Matrix]", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.phi", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#phi:Array[com.johnsnowlabs.ml.crf.VectorMath.Matrix]", "kind" : "val"}, {"label" : "logPhi", "tail" : ": Array[Matrix]", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.logPhi", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#logPhi:Array[com.johnsnowlabs.ml.crf.VectorMath.Matrix]", "kind" : "val"}, {"label" : "labels", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.labels", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#labels:Int", "kind" : "val"}, {"member" : "com.johnsnowlabs.ml.crf.FbCalculator#<init>", "error" : "unsupported entity"}, {"label" : "metadata", "tail" : ": DatasetMetadata", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.metadata", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#metadata:com.johnsnowlabs.ml.crf.DatasetMetadata", "kind" : "val"}, {"label" : "maxLength", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.FbCalculator.maxLength", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#maxLength:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/ml\/crf\/FbCalculator.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.ml.crf.Instance", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.Instance#<init>", "error" : "unsupported entity"}, {"label" : "items", "tail" : ": Seq[SparseArray]", "member" : "com.johnsnowlabs.ml.crf.Instance.items", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#items:Seq[com.johnsnowlabs.ml.crf.SparseArray]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/Instance.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/Instance.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.InstanceLabels", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.InstanceLabels#<init>", "error" : "unsupported entity"}, {"label" : "labels", "tail" : ": Seq[Int]", "member" : "com.johnsnowlabs.ml.crf.InstanceLabels.labels", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#labels:Seq[Int]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/InstanceLabels.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.L2DecayStrategy", "shortDescription" : "", "members_class" : [{"label" : "reset", "tail" : "(weights: Vector): Unit", "member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy.reset", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#reset(weights:com.johnsnowlabs.ml.crf.VectorMath.Vector):Unit", "kind" : "def"}, {"label" : "nextStep", "tail" : "(): Unit", "member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy.nextStep", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#nextStep():Unit", "kind" : "def"}, {"label" : "eta", "tail" : "(): Float", "member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy.eta", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#eta:Float", "kind" : "def"}, {"label" : "alpha", "tail" : "(): Float", "member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy.alpha", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#alpha:Float", "kind" : "def"}, {"label" : "getScale", "tail" : "(): Float", "member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy.getScale", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#getScale:Float", "kind" : "def"}, {"member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy#<init>", "error" : "unsupported entity"}, {"label" : "c0", "tail" : ": Float", "member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy.c0", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#c0:Float", "kind" : "val"}, {"label" : "l2", "tail" : ": Float", "member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy.l2", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#l2:Float", "kind" : "val"}, {"label" : "instances", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.L2DecayStrategy.instances", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#instances:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/ml\/crf\/L2DecayStrategy.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.ml.crf.LinearChainCrf", "shortDescription" : "", "members_class" : [{"label" : "doSgdStep", "tail" : "(sentence: Instance, labels: InstanceLabels, a: Float, weights: Array[Float], context: FbCalculator): Unit", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrf.doSgdStep", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#doSgdStep(sentence:com.johnsnowlabs.ml.crf.Instance,labels:com.johnsnowlabs.ml.crf.InstanceLabels,a:Float,weights:Array[Float],context:com.johnsnowlabs.ml.crf.FbCalculator):Unit", "kind" : "def"}, {"label" : "trainSGD", "tail" : "(dataset: CrfDataset): LinearChainCrfModel", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrf.trainSGD", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#trainSGD(dataset:com.johnsnowlabs.ml.crf.CrfDataset):com.johnsnowlabs.ml.crf.LinearChainCrfModel", "kind" : "def"}, {"label" : "log", "tail" : "(value: ⇒ String, minLevel: Level): Unit", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrf.log", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#log(value:=>String,minLevel:com.johnsnowlabs.nlp.annotators.ner.Verbose.Level):Unit", "kind" : "def"}, {"member" : "com.johnsnowlabs.ml.crf.LinearChainCrf#<init>", "error" : "unsupported entity"}, {"label" : "params", "tail" : ": CrfParams", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrf.params", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#params:com.johnsnowlabs.ml.crf.CrfParams", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrf.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.ml.crf.LinearChainCrfModel", "shortDescription" : "", "members_class" : [{"label" : "shrink", "tail" : "(minW: Float): LinearChainCrfModel", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrfModel.shrink", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#shrink(minW:Float):com.johnsnowlabs.ml.crf.LinearChainCrfModel", "kind" : "def"}, {"label" : "serialize", "tail" : "(): SerializedLinearChainCrfModel", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrfModel.serialize", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#serialize:com.johnsnowlabs.ml.crf.SerializedLinearChainCrfModel", "kind" : "def"}, {"label" : "predict", "tail" : "(instance: Instance): InstanceLabels", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrfModel.predict", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#predict(instance:com.johnsnowlabs.ml.crf.Instance):com.johnsnowlabs.ml.crf.InstanceLabels", "kind" : "def"}, {"label" : "labels", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrfModel.labels", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#labels:Int", "kind" : "val"}, {"member" : "com.johnsnowlabs.ml.crf.LinearChainCrfModel#<init>", "error" : "unsupported entity"}, {"label" : "metadata", "tail" : ": DatasetMetadata", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrfModel.metadata", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#metadata:com.johnsnowlabs.ml.crf.DatasetMetadata", "kind" : "val"}, {"label" : "weights", "tail" : ": Array[Float]", "member" : "com.johnsnowlabs.ml.crf.LinearChainCrfModel.weights", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#weights:Array[Float]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/ml\/crf\/LinearChainCrfModel.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.ml.crf.SerializedDatasetMetadata", "shortDescription" : "", "members_case class" : [{"label" : "deserialize", "tail" : "(): DatasetMetadata", "member" : "com.johnsnowlabs.ml.crf.SerializedDatasetMetadata.deserialize", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#deserialize:com.johnsnowlabs.ml.crf.DatasetMetadata", "kind" : "def"}, {"member" : "com.johnsnowlabs.ml.crf.SerializedDatasetMetadata#<init>", "error" : "unsupported entity"}, {"label" : "featuresStat", "tail" : ": Seq[AttrStat]", "member" : "com.johnsnowlabs.ml.crf.SerializedDatasetMetadata.featuresStat", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#featuresStat:Seq[com.johnsnowlabs.ml.crf.AttrStat]", "kind" : "val"}, {"label" : "transitions", "tail" : ": Seq[Transition]", "member" : "com.johnsnowlabs.ml.crf.SerializedDatasetMetadata.transitions", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#transitions:Seq[com.johnsnowlabs.ml.crf.Transition]", "kind" : "val"}, {"label" : "attrFeatures", "tail" : ": Seq[AttrFeature]", "member" : "com.johnsnowlabs.ml.crf.SerializedDatasetMetadata.attrFeatures", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#attrFeatures:Seq[com.johnsnowlabs.ml.crf.AttrFeature]", "kind" : "val"}, {"label" : "attrs", "tail" : ": Seq[Attr]", "member" : "com.johnsnowlabs.ml.crf.SerializedDatasetMetadata.attrs", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#attrs:Seq[com.johnsnowlabs.ml.crf.Attr]", "kind" : "val"}, {"label" : "labels", "tail" : ": Seq[String]", "member" : "com.johnsnowlabs.ml.crf.SerializedDatasetMetadata.labels", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#labels:Seq[String]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/SerializedDatasetMetadata.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.SerializedLinearChainCrfModel", "shortDescription" : "", "members_case class" : [{"label" : "deserialize", "tail" : "(): LinearChainCrfModel", "member" : "com.johnsnowlabs.ml.crf.SerializedLinearChainCrfModel.deserialize", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#deserialize:com.johnsnowlabs.ml.crf.LinearChainCrfModel", "kind" : "def"}, {"member" : "com.johnsnowlabs.ml.crf.SerializedLinearChainCrfModel#<init>", "error" : "unsupported entity"}, {"label" : "metadata", "tail" : ": SerializedDatasetMetadata", "member" : "com.johnsnowlabs.ml.crf.SerializedLinearChainCrfModel.metadata", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#metadata:com.johnsnowlabs.ml.crf.SerializedDatasetMetadata", "kind" : "val"}, {"label" : "weights", "tail" : ": Seq[Float]", "member" : "com.johnsnowlabs.ml.crf.SerializedLinearChainCrfModel.weights", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#weights:Seq[Float]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/SerializedLinearChainCrfModel.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.SparseArray", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html", "members_class" : [{"label" : "apply", "tail" : "(idx: Int): Float", "member" : "com.johnsnowlabs.ml.crf.SparseArray.apply", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#apply(idx:Int):Float", "kind" : "def"}, {"label" : "prev", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.SparseArray.prev", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#prev:Int", "kind" : "var"}, {"member" : "com.johnsnowlabs.ml.crf.SparseArray#<init>", "error" : "unsupported entity"}, {"label" : "values", "tail" : ": Array[(Int, Float)]", "member" : "com.johnsnowlabs.ml.crf.SparseArray.values", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#values:Array[(Int,Float)]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_object" : [{"label" : "SeqWrapper", "tail" : "", "member" : "com.johnsnowlabs.ml.crf.SparseArray.SeqWrapper", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#SeqWrapperextendsAnyRef", "kind" : "implicit class"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/SparseArray$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/ml\/crf\/SparseArray.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.ml.crf.TextSentenceAttrs", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.TextSentenceAttrs#<init>", "error" : "unsupported entity"}, {"label" : "words", "tail" : ": Seq[WordAttrs]", "member" : "com.johnsnowlabs.ml.crf.TextSentenceAttrs.words", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#words:Seq[com.johnsnowlabs.ml.crf.WordAttrs]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceAttrs.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.TextSentenceLabels", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.TextSentenceLabels#<init>", "error" : "unsupported entity"}, {"label" : "labels", "tail" : ": Seq[String]", "member" : "com.johnsnowlabs.ml.crf.TextSentenceLabels.labels", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#labels:Seq[String]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/TextSentenceLabels.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.Transition", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.Transition#<init>", "error" : "unsupported entity"}, {"label" : "stateTo", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.Transition.stateTo", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#stateTo:Int", "kind" : "val"}, {"label" : "stateFrom", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.crf.Transition.stateFrom", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#stateFrom:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/Transition.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/Transition.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.ml.crf.VectorMath", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html", "members_object" : [{"label" : "mult", "tail" : "(a: Matrix, b: Matrix): Matrix", "member" : "com.johnsnowlabs.ml.crf.VectorMath.mult", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#mult(a:com.johnsnowlabs.ml.crf.VectorMath.Matrix,b:com.johnsnowlabs.ml.crf.VectorMath.Matrix):com.johnsnowlabs.ml.crf.VectorMath.Matrix", "kind" : "def"}, {"label" : "copy", "tail" : "(from: Vector, to: Vector): Unit", "member" : "com.johnsnowlabs.ml.crf.VectorMath.copy", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#copy(from:com.johnsnowlabs.ml.crf.VectorMath.Vector,to:com.johnsnowlabs.ml.crf.VectorMath.Vector):Unit", "kind" : "def"}, {"label" : "copy", "tail" : "(from: Matrix, to: Matrix): Unit", "member" : "com.johnsnowlabs.ml.crf.VectorMath.copy", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#copy(from:com.johnsnowlabs.ml.crf.VectorMath.Matrix,to:com.johnsnowlabs.ml.crf.VectorMath.Matrix):Unit", "kind" : "def"}, {"label" : "multiply", "tail" : "(vector: Vector, a: Float): Unit", "member" : "com.johnsnowlabs.ml.crf.VectorMath.multiply", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#multiply(vector:com.johnsnowlabs.ml.crf.VectorMath.Vector,a:Float):Unit", "kind" : "def"}, {"label" : "fillVector", "tail" : "(vector: Vector, value: Float): Unit", "member" : "com.johnsnowlabs.ml.crf.VectorMath.fillVector", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#fillVector(vector:com.johnsnowlabs.ml.crf.VectorMath.Vector,value:Float):Unit", "kind" : "def"}, {"label" : "fillMatrix", "tail" : "(matrix: Matrix, value: Float): Unit", "member" : "com.johnsnowlabs.ml.crf.VectorMath.fillMatrix", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#fillMatrix(matrix:com.johnsnowlabs.ml.crf.VectorMath.Matrix,value:Float):Unit", "kind" : "def"}, {"label" : "fillMatrises", "tail" : "(matrixes: Array[Matrix], value: Float): Unit", "member" : "com.johnsnowlabs.ml.crf.VectorMath.fillMatrises", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#fillMatrises(matrixes:Array[com.johnsnowlabs.ml.crf.VectorMath.Matrix],value:Float):Unit", "kind" : "def"}, {"label" : "exp", "tail" : "(matrixes: Array[Matrix]): Unit", "member" : "com.johnsnowlabs.ml.crf.VectorMath.exp", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#exp(matrixes:Array[com.johnsnowlabs.ml.crf.VectorMath.Matrix]):Unit", "kind" : "def"}, {"label" : "exp", "tail" : "(matrix: Matrix): Unit", "member" : "com.johnsnowlabs.ml.crf.VectorMath.exp", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#exp(matrix:com.johnsnowlabs.ml.crf.VectorMath.Matrix):Unit", "kind" : "def"}, {"label" : "Vector", "tail" : "(n: Int, value: Float): Vector", "member" : "com.johnsnowlabs.ml.crf.VectorMath.Vector", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#Vector(n:Int,value:Float):com.johnsnowlabs.ml.crf.VectorMath.Vector", "kind" : "def"}, {"label" : "I", "tail" : "(n: Int): Matrix", "member" : "com.johnsnowlabs.ml.crf.VectorMath.I", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#I(n:Int):com.johnsnowlabs.ml.crf.VectorMath.Matrix", "kind" : "def"}, {"label" : "Matrix", "tail" : "(n1: Int, n2: Int): Matrix", "member" : "com.johnsnowlabs.ml.crf.VectorMath.Matrix", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#Matrix(n1:Int,n2:Int):com.johnsnowlabs.ml.crf.VectorMath.Matrix", "kind" : "def"}, {"label" : "Vector", "tail" : "", "member" : "com.johnsnowlabs.ml.crf.VectorMath.Vector", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#Vector=Array[Float]", "kind" : "type"}, {"label" : "Matrix", "tail" : "", "member" : "com.johnsnowlabs.ml.crf.VectorMath.Matrix", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#Matrix=Array[Array[Float]]", "kind" : "type"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/VectorMath$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.crf.WordAttrs", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.crf.WordAttrs#<init>", "error" : "unsupported entity"}, {"label" : "numAttrs", "tail" : ": Array[Float]", "member" : "com.johnsnowlabs.ml.crf.WordAttrs.numAttrs", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#numAttrs:Array[Float]", "kind" : "val"}, {"label" : "strAttrs", "tail" : ": Seq[(String, String)]", "member" : "com.johnsnowlabs.ml.crf.WordAttrs.strAttrs", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#strAttrs:Seq[(String,String)]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/crf\/WordAttrs.html", "kind" : "case class"}], "com.johnsnowlabs.nlp.annotators.spell.context" : [{"name" : "com.johnsnowlabs.nlp.annotators.spell.context.CandidateStrategy", "shortDescription" : "", "object" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html", "members_object" : [{"label" : "ALL", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.CandidateStrategy.ALL", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#ALL:Int", "kind" : "val"}, {"label" : "FIRST_LETTER_CAPITALIZED", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.CandidateStrategy.FIRST_LETTER_CAPITALIZED", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#FIRST_LETTER_CAPITALIZED:Int", "kind" : "val"}, {"label" : "ALL_UPPER_CASE", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.CandidateStrategy.ALL_UPPER_CASE", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#ALL_UPPER_CASE:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/CandidateStrategy$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach", "shortDescription" : "Trains a deep-learning based Noisy Channel Model Spell Algorithm.", "members_class" : [{"label" : "outputAnnotatorType", "tail" : ": AnnotatorType", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#outputAnnotatorType:ContextSpellCheckerApproach.this.AnnotatorType", "kind" : "val"}, {"label" : "inputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#inputAnnotatorTypes:Array[String]", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach#<init>", "error" : "unsupported entity"}, {"label" : "ArrayHelper", "tail" : "", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.ArrayHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#ArrayHelperextendsAnyRef", "kind" : "implicit class"}, {"label" : "genVocab", "tail" : "(dataset: Dataset[_]): (HashMap[String, Double], Map[String, (Int, Int)])", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.genVocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#genVocab(dataset:org.apache.spark.sql.Dataset[_]):(scala.collection.mutable.HashMap[String,Double],Map[String,(Int,Int)])", "kind" : "def"}, {"label" : "computeClasses", "tail" : "(vocab: HashMap[String, Double], total: Double, k: Int): Map[String, (Int, Int)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.computeClasses", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#computeClasses(vocab:scala.collection.mutable.HashMap[String,Double],total:Double,k:Int):Map[String,(Int,Int)]", "kind" : "def"}, {"label" : "train", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.train", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#train(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "addRegexClass", "tail" : "(usrLabel: String, usrRegex: String, userDist: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.addRegexClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#addRegexClass(usrLabel:String,usrRegex:String,userDist:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "addVocabClass", "tail" : "(usrLabel: String, vocabList: ArrayList[String], userDist: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.addVocabClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#addVocabClass(usrLabel:String,vocabList:java.util.ArrayList[String],userDist:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "setGraphFolder", "tail" : "(path: String): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setGraphFolder", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setGraphFolder(path:String):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "graphFolder", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.graphFolder", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#graphFolder:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "maxSentLen", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.maxSentLen", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#maxSentLen:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getConfigProtoBytes", "tail" : "(): Option[Array[Byte]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.getConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#getConfigProtoBytes:Option[Array[Byte]]", "kind" : "def"}, {"label" : "setConfigProtoBytes", "tail" : "(bytes: Array[Int]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setConfigProtoBytes(bytes:Array[Int]):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "configProtoBytes", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.configProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#configProtoBytes:org.apache.spark.ml.param.IntArrayParam", "kind" : "val"}, {"label" : "setMaxWindowLen", "tail" : "(w: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setMaxWindowLen", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setMaxWindowLen(w:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "maxWindowLen", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.maxWindowLen", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#maxWindowLen:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setWeightedDistPath", "tail" : "(filePath: String): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setWeightedDistPath", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setWeightedDistPath(filePath:String):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "weightedDistPath", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.weightedDistPath", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#weightedDistPath:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "setClassCount", "tail" : "(t: Double): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setClassCount", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setClassCount(t:Double):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "classCount", "tail" : ": Param[Double]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.classCount", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#classCount:org.apache.spark.ml.param.Param[Double]", "kind" : "val"}, {"label" : "setTradeoff", "tail" : "(alpha: Float): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setTradeoff", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setTradeoff(alpha:Float):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "tradeoff", "tail" : ": Param[Float]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.tradeoff", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#tradeoff:org.apache.spark.ml.param.Param[Float]", "kind" : "val"}, {"label" : "setCompoundCount", "tail" : "(k: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setCompoundCount", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setCompoundCount(k:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "compoundCount", "tail" : ": Param[Int]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.compoundCount", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#compoundCount:org.apache.spark.ml.param.Param[Int]", "kind" : "val"}, {"label" : "setMinCount", "tail" : "(threshold: Double): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setMinCount", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setMinCount(threshold:Double):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "minCount", "tail" : ": Param[Double]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.minCount", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#minCount:org.apache.spark.ml.param.Param[Double]", "kind" : "val"}, {"label" : "setValidationFraction", "tail" : "(r: Float): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setValidationFraction", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setValidationFraction(r:Float):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "validationFraction", "tail" : ": FloatParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.validationFraction", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#validationFraction:org.apache.spark.ml.param.FloatParam", "kind" : "val"}, {"label" : "setFinalRate", "tail" : "(r: Float): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setFinalRate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setFinalRate(r:Float):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "finalRate", "tail" : ": FloatParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.finalRate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#finalRate:org.apache.spark.ml.param.FloatParam", "kind" : "val"}, {"label" : "setInitialRate", "tail" : "(r: Float): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setInitialRate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setInitialRate(r:Float):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "initialRate", "tail" : ": FloatParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.initialRate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#initialRate:org.apache.spark.ml.param.FloatParam", "kind" : "val"}, {"label" : "setBatchSize", "tail" : "(k: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setBatchSize(k:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "batchSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.batchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#batchSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setEpochs", "tail" : "(k: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setEpochs", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setEpochs(k:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "epochs", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.epochs", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#epochs:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setErrorThreshold", "tail" : "(t: Float): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setErrorThreshold", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setErrorThreshold(t:Float):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "errorThreshold", "tail" : ": FloatParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.errorThreshold", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#errorThreshold:org.apache.spark.ml.param.FloatParam", "kind" : "val"}, {"label" : "setCaseStrategy", "tail" : "(k: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setCaseStrategy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setCaseStrategy(k:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "caseStrategy", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.caseStrategy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#caseStrategy:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setMaxCandidates", "tail" : "(k: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setMaxCandidates", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setMaxCandidates(k:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "maxCandidates", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.maxCandidates", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#maxCandidates:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setWordMaxDistance", "tail" : "(k: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setWordMaxDistance", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setWordMaxDistance(k:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "wordMaxDistance", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.wordMaxDistance", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#wordMaxDistance:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setLanguageModelClasses", "tail" : "(k: Int): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setLanguageModelClasses", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setLanguageModelClasses(k:Int):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "languageModelClasses", "tail" : ": Param[Int]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.languageModelClasses", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#languageModelClasses:org.apache.spark.ml.param.Param[Int]", "kind" : "val"}, {"label" : "setSpecialClasses", "tail" : "(parsers: List[SpecialClassParser]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.setSpecialClasses", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setSpecialClasses(parsers:List[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]):ContextSpellCheckerApproach.this.type", "kind" : "def"}, {"label" : "specialClasses", "tail" : ": Param[List[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.specialClasses", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#specialClasses:org.apache.spark.ml.param.Param[List[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]]", "kind" : "val"}, {"label" : "description", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.description", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#description:String", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerApproach.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#uid:String", "kind" : "val"}, {"label" : "backTrack", "tail" : "(dist: Array[Array[Float]], s2: String, s1: String, j: Int, i: Int, acc: Seq[(String, String)]): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.backTrack", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#backTrack(dist:Array[Array[Float]],s2:String,s1:String,j:Int,i:Int,acc:Seq[(String,String)]):Seq[(String,String)]", "kind" : "def"}, {"label" : "learnDist", "tail" : "(s1: String, s2: String): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.learnDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#learnDist(s1:String,s2:String):Seq[(String,String)]", "kind" : "def"}, {"label" : "loadWeights", "tail" : "(filename: String): Map[String, Map[String, Float]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.loadWeights", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#loadWeights(filename:String):Map[String,Map[String,Float]]", "kind" : "def"}, {"label" : "wLevenshteinDist", "tail" : "(s1: String, s2: String, weights: Map[String, Map[String, Float]]): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.wLevenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#wLevenshteinDist(s1:String,s2:String,weights:Map[String,Map[String,Float]]):Float", "kind" : "def"}, {"label" : "levenshteinDist", "tail" : "(s11: String, s22: String)(cost: (String, String) ⇒ Float): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.levenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#levenshteinDist(s11:String,s22:String)(cost:(String,String)=>Float):Float", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: StructFeature[T]): T", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):T", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: MapFeature[K, V]): Map[K, V]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#$$[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Map[K,V]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: SetFeature[T]): Set[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Set[T]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: ArrayFeature[T]): Array[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Array[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: StructFeature[T]): Option[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#get[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):Option[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: MapFeature[K, V]): Option[Map[K, V]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#get[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Option[Map[K,V]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: SetFeature[T]): Option[Set[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#get[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Option[Set[T]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: ArrayFeature[T]): Option[Array[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#get[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Option[Array[T]]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: StructFeature[T], value: () ⇒ T): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:()=>T):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: MapFeature[K, V], value: () ⇒ Map[K, V]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setDefault[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:()=>Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: SetFeature[T], value: () ⇒ Set[T]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:()=>Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: ArrayFeature[T], value: () ⇒ Array[T]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:()=>Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: StructFeature[T], value: T): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#set[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:T):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: MapFeature[K, V], value: Map[K, V]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#set[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: SetFeature[T], value: Set[T]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#set[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: ArrayFeature[T], value: Array[T]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#set[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "features", "tail" : ": ArrayBuffer[Feature[_, _, _]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.features", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#features:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.nlp.serialization.Feature[_,_,_]]", "kind" : "val"}, {"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "final def"}, {"label" : "copy", "tail" : "(extra: ParamMap): Estimator[ContextSpellCheckerModel]", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.copy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#copy(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.Estimator[M]", "kind" : "final def"}, {"label" : "fit", "tail" : "(dataset: Dataset[_]): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#fit(dataset:org.apache.spark.sql.Dataset[_]):M", "kind" : "final def"}, {"label" : "_fit", "tail" : "(dataset: Dataset[_], recursiveStages: Option[PipelineModel]): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach._fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#_fit(dataset:org.apache.spark.sql.Dataset[_],recursiveStages:Option[org.apache.spark.ml.PipelineModel]):M", "kind" : "def"}, {"label" : "validate", "tail" : "(schema: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.validate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#validate(schema:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "onTrained", "tail" : "(model: ContextSpellCheckerModel, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.onTrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#onTrained(model:M,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "beforeTraining", "tail" : "(spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.beforeTraining", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#beforeTraining(spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "getLazyAnnotator", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.CanBeLazy.getLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#getLazyAnnotator:Boolean", "kind" : "def"}, {"label" : "setLazyAnnotator", "tail" : "(value: Boolean): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.CanBeLazy.setLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setLazyAnnotator(value:Boolean):<refinement>.type", "kind" : "def"}, {"label" : "lazyAnnotator", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.CanBeLazy.lazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#lazyAnnotator:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "org.apache.spark.ml.util.DefaultParamsWritable.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#save(path:String):Unit", "kind" : "def"}, {"label" : "AnnotatorType", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotatorType.AnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#AnnotatorType=String", "kind" : "type"}, {"label" : "getOutputCol", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.getOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#getOutputCol:String", "kind" : "final def"}, {"label" : "setOutputCol", "tail" : "(value: String): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.setOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setOutputCol(value:String):HasOutputAnnotationCol.this.type", "kind" : "final def"}, {"label" : "outputCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.outputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#outputCol:org.apache.spark.ml.param.Param[String]", "kind" : "final val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setInputCols(value:String*):HasInputAnnotationCols.this.type", "kind" : "final def"}, {"label" : "checkSchema", "tail" : "(schema: StructType, inputAnnotatorType: String): Boolean", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.checkSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#checkSchema(schema:org.apache.spark.sql.types.StructType,inputAnnotatorType:String):Boolean", "kind" : "final def"}, {"label" : "msgHelper", "tail" : "(schema: StructType): String", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.msgHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#msgHelper(schema:org.apache.spark.sql.types.StructType):String", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): ContextSpellCheckerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setInputCols(value:Array[String]):HasInputAnnotationCols.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.inputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "final val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "fit", "tail" : "(dataset: Dataset[_], paramMaps: Seq[ParamMap]): Seq[ContextSpellCheckerModel]", "member" : "org.apache.spark.ml.Estimator.fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#fit(dataset:org.apache.spark.sql.Dataset[_],paramMaps:Seq[org.apache.spark.ml.param.ParamMap]):Seq[M]", "kind" : "def"}, {"label" : "fit", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): ContextSpellCheckerModel", "member" : "org.apache.spark.ml.Estimator.fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#fit(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):M", "kind" : "def"}, {"label" : "fit", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): ContextSpellCheckerModel", "member" : "org.apache.spark.ml.Estimator.fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#fit(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):M", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): ContextSpellCheckerApproach.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): ContextSpellCheckerApproach.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): ContextSpellCheckerApproach.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): ContextSpellCheckerApproach.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): ContextSpellCheckerApproach.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): ContextSpellCheckerApproach.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerApproach.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "shortDescription" : "Implements a deep-learning based Noisy Channel Model Spell Algorithm.", "object" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html", "members_class" : [{"label" : "onWrite", "tail" : "(path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.onWrite", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#onWrite(path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "outputAnnotatorType", "tail" : ": AnnotatorType", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#outputAnnotatorType:ContextSpellCheckerModel.this.AnnotatorType", "kind" : "val"}, {"label" : "inputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#inputAnnotatorTypes:Array[String]", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel#<init>", "error" : "unsupported entity"}, {"label" : "computeTrellis", "tail" : "(annotations: Seq[Annotation], mask: Seq[Boolean]): Array[Array[(String, Double, String)]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.computeTrellis", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#computeTrellis(annotations:Seq[com.johnsnowlabs.nlp.Annotation],mask:Seq[Boolean]):Array[Array[(String,Double,String)]]", "kind" : "def"}, {"label" : "computeMask", "tail" : "(annotations: Seq[Annotation]): Array[Boolean]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.computeMask", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#computeMask(annotations:Seq[com.johnsnowlabs.nlp.Annotation]):Array[Boolean]", "kind" : "def"}, {"label" : "toOption", "tail" : "(boolean: Boolean): Option[Boolean]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.toOption", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#toOption(boolean:Boolean):Option[Boolean]", "kind" : "def"}, {"label" : "annotate", "tail" : "(annotations: Seq[Annotation]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.annotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#annotate(annotations:Seq[com.johnsnowlabs.nlp.Annotation]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "beforeAnnotate", "tail" : "(dataset: Dataset[_]): Dataset[_]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.beforeAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#beforeAnnotate(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "StringTools", "tail" : "", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.StringTools", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#StringToolsextendsAnyRef", "kind" : "implicit class"}, {"label" : "getVocabCandidates", "tail" : "(token: String, maxDist: Int): List[(String, String, Float)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.getVocabCandidates", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getVocabCandidates(token:String,maxDist:Int):List[(String,String,Float)]", "kind" : "def"}, {"label" : "getClassCandidates", "tail" : "(transducer: ITransducer[Candidate], token: String, label: String, maxDist: Int, limit: Int): Seq[(String, String, Float)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.getClassCandidates", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getClassCandidates(transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate],token:String,label:String,maxDist:Int,limit:Int):Seq[(String,String,Float)]", "kind" : "def"}, {"label" : "decodeViterbi", "tail" : "(trellis: Array[Array[(String, Double, String)]]): (Array[String], Double)", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.decodeViterbi", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#decodeViterbi(trellis:Array[Array[(String,Double,String)]]):(Array[String],Double)", "kind" : "def"}, {"label" : "setModelIfNotSet", "tail" : "(spark: SparkSession, tensorflow: TensorflowWrapper): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setModelIfNotSet(spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "getModelIfNotSet", "tail" : "(): TensorflowSpell", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.getModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getModelIfNotSet:com.johnsnowlabs.ml.tensorflow.TensorflowSpell", "kind" : "def"}, {"label" : "updateVocabClass", "tail" : "(label: String, vocabList: ArrayList[String], append: Boolean): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.updateVocabClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#updateVocabClass(label:String,vocabList:java.util.ArrayList[String],append:Boolean):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "updateRegexClass", "tail" : "(label: String, regex: String): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.updateRegexClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#updateRegexClass(label:String,regex:String):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "getWordClasses", "tail" : "(): Seq[(String, AnnotatorType)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.getWordClasses", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getWordClasses:Seq[(String,ContextSpellCheckerModel.this.AnnotatorType)]", "kind" : "def"}, {"label" : "setCompareLowcase", "tail" : "(value: Boolean): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setCompareLowcase", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setCompareLowcase(value:Boolean):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "compareLowcase", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.compareLowcase", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#compareLowcase:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "setCorrectSymbols", "tail" : "(value: Boolean): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setCorrectSymbols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setCorrectSymbols(value:Boolean):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "correctSymbols", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.correctSymbols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#correctSymbols:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "getConfigProtoBytes", "tail" : "(): Option[Array[Byte]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.getConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getConfigProtoBytes:Option[Array[Byte]]", "kind" : "def"}, {"label" : "setConfigProtoBytes", "tail" : "(bytes: Array[Int]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setConfigProtoBytes(bytes:Array[Int]):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "configProtoBytes", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.configProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#configProtoBytes:org.apache.spark.ml.param.IntArrayParam", "kind" : "val"}, {"label" : "setMaxWindowLen", "tail" : "(w: Int): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setMaxWindowLen", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setMaxWindowLen(w:Int):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "maxWindowLen", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.maxWindowLen", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#maxWindowLen:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setUseNewLines", "tail" : "(useIt: Boolean): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setUseNewLines", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setUseNewLines(useIt:Boolean):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "useNewLines", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.useNewLines", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#useNewLines:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "setWeights", "tail" : "(w: HashMap[String, HashMap[String, Double]]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setWeights", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setWeights(w:java.util.HashMap[String,java.util.HashMap[String,Double]]):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "setWeights", "tail" : "(w: Map[String, Map[String, Float]]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setWeights", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setWeights(w:Map[String,Map[String,Float]]):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "weights", "tail" : ": MapFeature[String, Map[String, Float]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.weights", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#weights:com.johnsnowlabs.nlp.serialization.MapFeature[String,Map[String,Float]]", "kind" : "val"}, {"label" : "setGamma", "tail" : "(g: Float): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setGamma", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setGamma(g:Float):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "gamma", "tail" : ": FloatParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.gamma", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#gamma:org.apache.spark.ml.param.FloatParam", "kind" : "val"}, {"label" : "setTradeOff", "tail" : "(lambda: Float): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setTradeOff", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setTradeOff(lambda:Float):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "tradeoff", "tail" : ": FloatParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.tradeoff", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#tradeoff:org.apache.spark.ml.param.FloatParam", "kind" : "val"}, {"label" : "setErrorThreshold", "tail" : "(t: Float): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setErrorThreshold", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setErrorThreshold(t:Float):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "errorThreshold", "tail" : ": FloatParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.errorThreshold", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#errorThreshold:org.apache.spark.ml.param.FloatParam", "kind" : "val"}, {"label" : "setCaseStrategy", "tail" : "(k: Int): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setCaseStrategy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setCaseStrategy(k:Int):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "caseStrategy", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.caseStrategy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#caseStrategy:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setMaxCandidates", "tail" : "(k: Int): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setMaxCandidates", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setMaxCandidates(k:Int):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "maxCandidates", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.maxCandidates", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#maxCandidates:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setWordMaxDistance", "tail" : "(k: Int): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setWordMaxDistance", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setWordMaxDistance(k:Int):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "wordMaxDistance", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.wordMaxDistance", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#wordMaxDistance:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setClasses", "tail" : "(c: Map[Int, (Int, Int)]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setClasses", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setClasses(c:Map[Int,(Int,Int)]):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "classes", "tail" : ": MapFeature[Int, (Int, Int)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.classes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#classes:com.johnsnowlabs.nlp.serialization.MapFeature[Int,(Int,Int)]", "kind" : "val"}, {"label" : "setVocabIds", "tail" : "(v: Map[String, Int]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setVocabIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setVocabIds(v:Map[String,Int]):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "vocabIds", "tail" : ": MapFeature[String, Int]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.vocabIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#vocabIds:com.johnsnowlabs.nlp.serialization.MapFeature[String,Int]", "kind" : "val"}, {"label" : "idsVocab", "tail" : ": MapFeature[Int, String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.idsVocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#idsVocab:com.johnsnowlabs.nlp.serialization.MapFeature[Int,String]", "kind" : "val"}, {"label" : "setVocabFreq", "tail" : "(v: Map[String, Double]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setVocabFreq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setVocabFreq(v:Map[String,Double]):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "vocabFreq", "tail" : ": MapFeature[String, Double]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.vocabFreq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#vocabFreq:com.johnsnowlabs.nlp.serialization.MapFeature[String,Double]", "kind" : "val"}, {"label" : "setSpecialClassesTransducers", "tail" : "(transducers: Seq[SpecialClassParser]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setSpecialClassesTransducers", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setSpecialClassesTransducers(transducers:Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "specialTransducers", "tail" : ": TransducerSeqFeature", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.specialTransducers", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#specialTransducers:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature", "kind" : "val"}, {"label" : "setVocabTransducer", "tail" : "(trans: ITransducer[Candidate]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.setVocabTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setVocabTransducer(trans:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):ContextSpellCheckerModel.this.type", "kind" : "def"}, {"label" : "transducer", "tail" : ": TransducerFeature", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#transducer:com.johnsnowlabs.nlp.serialization.TransducerFeature", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#uid:String", "kind" : "val"}, {"label" : "getEngine", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasEngine.getEngine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getEngine:String", "kind" : "def"}, {"label" : "engine", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasEngine.engine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#engine:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "$$", "tail" : "(feature: TransducerSeqFeature): Seq[SpecialClassParser]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#$$(feature:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature):Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: TransducerFeature): VocabParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#$$(feature:com.johnsnowlabs.nlp.serialization.TransducerFeature):com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser", "kind" : "def"}, {"label" : "get", "tail" : "(feature: TransducerSeqFeature): Option[Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#get(feature:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature):Option[Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: TransducerFeature): Option[VocabParser]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#get(feature:com.johnsnowlabs.nlp.serialization.TransducerFeature):Option[com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: TransducerSeqFeature, value: () ⇒ Seq[SpecialClassParser]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setDefault(feature:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature,value:()=>Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]):HasTransducerFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: TransducerFeature, value: () ⇒ VocabParser): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setDefault(feature:com.johnsnowlabs.nlp.serialization.TransducerFeature,value:()=>com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser):HasTransducerFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: TransducerSeqFeature, value: Seq[SpecialClassParser]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set(feature:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature,value:Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]):HasTransducerFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: TransducerFeature, value: VocabParser): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set(feature:com.johnsnowlabs.nlp.serialization.TransducerFeature,value:com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser):HasTransducerFeatures.this.type", "kind" : "def"}, {"label" : "writeTensorflowHub", "tail" : "(path: String, tfPath: String, spark: SparkSession, suffix: String): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#writeTensorflowHub(path:String,tfPath:String,spark:org.apache.spark.sql.SparkSession,suffix:String):Unit", "kind" : "def"}, {"label" : "writeTensorflowModelV2", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]], savedSignatures: Option[Map[String, String]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModelV2", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#writeTensorflowModelV2(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]],savedSignatures:Option[Map[String,String]]):Unit", "kind" : "def"}, {"label" : "writeTensorflowModel", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#writeTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]]):Unit", "kind" : "def"}, {"label" : "backTrack", "tail" : "(dist: Array[Array[Float]], s2: String, s1: String, j: Int, i: Int, acc: Seq[(String, String)]): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.backTrack", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#backTrack(dist:Array[Array[Float]],s2:String,s1:String,j:Int,i:Int,acc:Seq[(String,String)]):Seq[(String,String)]", "kind" : "def"}, {"label" : "learnDist", "tail" : "(s1: String, s2: String): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.learnDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#learnDist(s1:String,s2:String):Seq[(String,String)]", "kind" : "def"}, {"label" : "loadWeights", "tail" : "(filename: String): Map[String, Map[String, Float]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.loadWeights", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#loadWeights(filename:String):Map[String,Map[String,Float]]", "kind" : "def"}, {"label" : "wLevenshteinDist", "tail" : "(s1: String, s2: String, weights: Map[String, Map[String, Float]]): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.wLevenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#wLevenshteinDist(s1:String,s2:String,weights:Map[String,Map[String,Float]]):Float", "kind" : "def"}, {"label" : "levenshteinDist", "tail" : "(s11: String, s22: String)(cost: (String, String) ⇒ Float): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.levenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#levenshteinDist(s11:String,s22:String)(cost:(String,String)=>Float):Float", "kind" : "def"}, {"label" : "dfAnnotate", "tail" : "(): UserDefinedFunction", "member" : "com.johnsnowlabs.nlp.HasSimpleAnnotate.dfAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#dfAnnotate:org.apache.spark.sql.expressions.UserDefinedFunction", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#transform(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.DataFrame", "kind" : "final def"}, {"label" : "_transform", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel._transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#_transform(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "afterAnnotate", "tail" : "(dataset: DataFrame): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.afterAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#afterAnnotate(dataset:org.apache.spark.sql.DataFrame):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "AnnotationContent", "tail" : "", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.AnnotationContent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#AnnotationContent=Seq[org.apache.spark.sql.Row]", "kind" : "type"}, {"label" : "getLazyAnnotator", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.CanBeLazy.getLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getLazyAnnotator:Boolean", "kind" : "def"}, {"label" : "setLazyAnnotator", "tail" : "(value: Boolean): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.CanBeLazy.setLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setLazyAnnotator(value:Boolean):<refinement>.type", "kind" : "def"}, {"label" : "lazyAnnotator", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.CanBeLazy.lazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#lazyAnnotator:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "copy", "tail" : "(extra: ParamMap): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.RawAnnotator.copy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#copy(extra:org.apache.spark.ml.param.ParamMap):M", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.RawAnnotator.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "final def"}, {"label" : "extraValidate", "tail" : "(structType: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#extraValidate(structType:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "extraValidateMsg", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidateMsg", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#extraValidateMsg:String", "kind" : "def"}, {"label" : "validate", "tail" : "(schema: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.validate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#validate(schema:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "wrapColumnMetadata", "tail" : "(col: Column): Column", "member" : "com.johnsnowlabs.nlp.RawAnnotator.wrapColumnMetadata", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#wrapColumnMetadata(col:org.apache.spark.sql.Column):org.apache.spark.sql.Column", "kind" : "def"}, {"label" : "getOutputCol", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.getOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getOutputCol:String", "kind" : "final def"}, {"label" : "setOutputCol", "tail" : "(value: String): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.setOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setOutputCol(value:String):HasOutputAnnotationCol.this.type", "kind" : "final def"}, {"label" : "outputCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.outputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#outputCol:org.apache.spark.ml.param.Param[String]", "kind" : "final val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setInputCols(value:String*):HasInputAnnotationCols.this.type", "kind" : "final def"}, {"label" : "checkSchema", "tail" : "(schema: StructType, inputAnnotatorType: String): Boolean", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.checkSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#checkSchema(schema:org.apache.spark.sql.types.StructType,inputAnnotatorType:String):Boolean", "kind" : "final def"}, {"label" : "msgHelper", "tail" : "(schema: StructType): String", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.msgHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#msgHelper(schema:org.apache.spark.sql.types.StructType):String", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setInputCols(value:Array[String]):HasInputAnnotationCols.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.inputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "final val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "AnnotatorType", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotatorType.AnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#AnnotatorType=String", "kind" : "type"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesWritable.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: StructFeature[T]): T", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):T", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: MapFeature[K, V]): Map[K, V]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#$$[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Map[K,V]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: SetFeature[T]): Set[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Set[T]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: ArrayFeature[T]): Array[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Array[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: StructFeature[T]): Option[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#get[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):Option[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: MapFeature[K, V]): Option[Map[K, V]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#get[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Option[Map[K,V]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: SetFeature[T]): Option[Set[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#get[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Option[Set[T]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: ArrayFeature[T]): Option[Array[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#get[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Option[Array[T]]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: StructFeature[T], value: () ⇒ T): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:()=>T):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: MapFeature[K, V], value: () ⇒ Map[K, V]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setDefault[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:()=>Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: SetFeature[T], value: () ⇒ Set[T]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:()=>Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: ArrayFeature[T], value: () ⇒ Array[T]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:()=>Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: StructFeature[T], value: T): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:T):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: MapFeature[K, V], value: Map[K, V]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: SetFeature[T], value: Set[T]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: ArrayFeature[T], value: Array[T]): ContextSpellCheckerModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "features", "tail" : ": ArrayBuffer[Feature[_, _, _]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.features", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#features:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.nlp.serialization.Feature[_,_,_]]", "kind" : "val"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#save(path:String):Unit", "kind" : "def"}, {"label" : "hasParent", "tail" : "(): Boolean", "member" : "org.apache.spark.ml.Model.hasParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#hasParent:Boolean", "kind" : "def"}, {"label" : "setParent", "tail" : "(parent: Estimator[ContextSpellCheckerModel]): ContextSpellCheckerModel", "member" : "org.apache.spark.ml.Model.setParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setParent(parent:org.apache.spark.ml.Estimator[M]):M", "kind" : "def"}, {"label" : "parent", "tail" : ": Estimator[ContextSpellCheckerModel]", "member" : "org.apache.spark.ml.Model.parent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#parent:org.apache.spark.ml.Estimator[M]", "kind" : "var"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#transform(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#transform(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): ContextSpellCheckerModel.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): ContextSpellCheckerModel.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): ContextSpellCheckerModel.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): ContextSpellCheckerModel.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): ContextSpellCheckerModel.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): ContextSpellCheckerModel.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_object" : [{"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#pretrained():com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#defaultLang:String", "kind" : "val"}, {"label" : "readLanguageModelGraph", "tail" : "(instance: ContextSpellCheckerModel, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadsLanguageModelGraph.readLanguageModelGraph", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#readLanguageModelGraph(instance:com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadsLanguageModelGraph.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#tfFile:String", "kind" : "val"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "read", "tail" : "(): MLReader[ContextSpellCheckerModel]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (ContextSpellCheckerModel, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): ContextSpellCheckerModel", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ContextSpellCheckerModel.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures", "members_trait" : [{"label" : "$$", "tail" : "(feature: TransducerSeqFeature): Seq[SpecialClassParser]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#$$(feature:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature):Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: TransducerFeature): VocabParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#$$(feature:com.johnsnowlabs.nlp.serialization.TransducerFeature):com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser", "kind" : "def"}, {"label" : "get", "tail" : "(feature: TransducerSeqFeature): Option[Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#get(feature:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature):Option[Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: TransducerFeature): Option[VocabParser]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#get(feature:com.johnsnowlabs.nlp.serialization.TransducerFeature):Option[com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: TransducerSeqFeature, value: () ⇒ Seq[SpecialClassParser]): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#setDefault(feature:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature,value:()=>Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]):HasTransducerFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: TransducerFeature, value: () ⇒ VocabParser): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#setDefault(feature:com.johnsnowlabs.nlp.serialization.TransducerFeature,value:()=>com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser):HasTransducerFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: TransducerSeqFeature, value: Seq[SpecialClassParser]): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#set(feature:com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature,value:Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]):HasTransducerFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: TransducerFeature, value: VocabParser): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.HasTransducerFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#set(feature:com.johnsnowlabs.nlp.serialization.TransducerFeature,value:com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser):HasTransducerFeatures.this.type", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: StructFeature[T]): T", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):T", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: MapFeature[K, V]): Map[K, V]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#$$[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Map[K,V]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: SetFeature[T]): Set[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Set[T]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: ArrayFeature[T]): Array[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Array[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: StructFeature[T]): Option[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#get[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):Option[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: MapFeature[K, V]): Option[Map[K, V]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#get[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Option[Map[K,V]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: SetFeature[T]): Option[Set[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#get[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Option[Set[T]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: ArrayFeature[T]): Option[Array[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#get[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Option[Array[T]]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: StructFeature[T], value: () ⇒ T): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:()=>T):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: MapFeature[K, V], value: () ⇒ Map[K, V]): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#setDefault[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:()=>Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: SetFeature[T], value: () ⇒ Set[T]): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:()=>Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: ArrayFeature[T], value: () ⇒ Array[T]): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:()=>Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: StructFeature[T], value: T): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#set[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:T):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: MapFeature[K, V], value: Map[K, V]): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#set[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: SetFeature[T], value: Set[T]): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#set[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: ArrayFeature[T], value: Array[T]): HasTransducerFeatures.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#set[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "features", "tail" : ": ArrayBuffer[Feature[_, _, _]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.features", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#features:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.nlp.serialization.Feature[_,_,_]]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/HasTransducerFeatures.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.LangModelSentence", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.nlp.annotators.spell.context.LangModelSentence#<init>", "error" : "unsupported entity"}, {"label" : "len", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.LangModelSentence.len", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#len:Int", "kind" : "val"}, {"label" : "cwids", "tail" : ": Array[Int]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.LangModelSentence.cwids", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#cwids:Array[Int]", "kind" : "val"}, {"label" : "cids", "tail" : ": Array[Int]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.LangModelSentence.cids", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#cids:Array[Int]", "kind" : "val"}, {"label" : "ids", "tail" : ": Array[Int]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.LangModelSentence.ids", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#ids:Array[Int]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/LangModelSentence.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell", "members_trait" : [{"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): ContextSpellCheckerModel", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#pretrained():com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel", "kind" : "def"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadablePretrainedContextSpell.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#defaultLang:String", "kind" : "val"}, {"label" : "readLanguageModelGraph", "tail" : "(instance: ContextSpellCheckerModel, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadsLanguageModelGraph.readLanguageModelGraph", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#readLanguageModelGraph(instance:com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadsLanguageModelGraph.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#tfFile:String", "kind" : "val"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "read", "tail" : "(): MLReader[ContextSpellCheckerModel]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (ContextSpellCheckerModel, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): ContextSpellCheckerModel", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadablePretrainedContextSpell.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadsLanguageModelGraph", "members_trait" : [{"label" : "readLanguageModelGraph", "tail" : "(instance: ContextSpellCheckerModel, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadsLanguageModelGraph.readLanguageModelGraph", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#readLanguageModelGraph(instance:com.johnsnowlabs.nlp.annotators.spell.context.ContextSpellCheckerModel,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.ReadsLanguageModelGraph.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#tfFile:String", "kind" : "val"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "read", "tail" : "(): MLReader[ContextSpellCheckerModel]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (ContextSpellCheckerModel, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): ContextSpellCheckerModel", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/ReadsLanguageModelGraph.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein", "members_trait" : [{"label" : "backTrack", "tail" : "(dist: Array[Array[Float]], s2: String, s1: String, j: Int, i: Int, acc: Seq[(String, String)]): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.backTrack", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#backTrack(dist:Array[Array[Float]],s2:String,s1:String,j:Int,i:Int,acc:Seq[(String,String)]):Seq[(String,String)]", "kind" : "def"}, {"label" : "learnDist", "tail" : "(s1: String, s2: String): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.learnDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#learnDist(s1:String,s2:String):Seq[(String,String)]", "kind" : "def"}, {"label" : "loadWeights", "tail" : "(filename: String): Map[String, Map[String, Float]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.loadWeights", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#loadWeights(filename:String):Map[String,Map[String,Float]]", "kind" : "def"}, {"label" : "wLevenshteinDist", "tail" : "(s1: String, s2: String, weights: Map[String, Map[String, Float]]): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.wLevenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#wLevenshteinDist(s1:String,s2:String,weights:Map[String,Map[String,Float]]):Float", "kind" : "def"}, {"label" : "levenshteinDist", "tail" : "(s11: String, s22: String)(cost: (String, String) ⇒ Float): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.levenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#levenshteinDist(s11:String,s22:String)(cost:(String,String)=>Float):Float", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/WeightedLevenshtein.html", "kind" : "trait"}], "com.johnsnowlabs.ml.ai.util.Generation" : [{"name" : "com.johnsnowlabs.ml.ai.util.Generation.Generate", "members_trait" : [{"label" : "getCDF", "tail" : "(probs: Array[Float]): Array[Float]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.getCDF", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#getCDF(probs:Array[Float]):Array[Float]", "kind" : "def"}, {"label" : "softmax", "tail" : "(logitValues: Array[Float]): Array[Float]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.softmax", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#softmax(logitValues:Array[Float]):Array[Float]", "kind" : "def"}, {"label" : "sample", "tail" : "(logits: Seq[Float], k: Int, seed: Long): Array[Int]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.sample", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#sample(logits:Seq[Float],k:Int,seed:Long):Array[Int]", "kind" : "def"}, {"label" : "multinomialSampling", "tail" : "(logitValues: Array[Float], k: Int, seed: Option[Long]): Array[Int]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.multinomialSampling", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#multinomialSampling(logitValues:Array[Float],k:Int,seed:Option[Long]):Array[Int]", "kind" : "def"}, {"label" : "reshapeArray", "tail" : "(inputArray: Array[Array[Float]], numRows: Int, numCols: Int): Array[Array[Float]]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.reshapeArray", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#reshapeArray(inputArray:Array[Array[Float]],numRows:Int,numCols:Int):Array[Array[Float]]", "kind" : "def"}, {"label" : "logSoftmax", "tail" : "(values: Array[Float]): Array[Float]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.logSoftmax", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#logSoftmax(values:Array[Float]):Array[Float]", "kind" : "def"}, {"label" : "beamSearch", "tail" : "(encoderInputIdsVals: Seq[Array[Int]], inputIdsVal: Seq[Array[Int]], decoderEncoderStateTensors: Tensor, encoderAttentionMaskTensors: Tensor, beamScorer: BeamScorer, logitProcessor: LogitProcessorList, maxLength: Int, padTokenId: Int, eosTokenId: Int, doSample: Boolean, randomSeed: Option[Long], session: Session, applySoftmax: Boolean): Array[Array[Int]]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.beamSearch", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#beamSearch(encoderInputIdsVals:Seq[Array[Int]],inputIdsVal:Seq[Array[Int]],decoderEncoderStateTensors:org.tensorflow.Tensor,encoderAttentionMaskTensors:org.tensorflow.Tensor,beamScorer:com.johnsnowlabs.ml.ai.util.Generation.Search.BeamScorer,logitProcessor:com.johnsnowlabs.ml.ai.util.Generation.Logit.LogitProcessorList,maxLength:Int,padTokenId:Int,eosTokenId:Int,doSample:Boolean,randomSeed:Option[Long],session:org.tensorflow.Session,applySoftmax:Boolean):Array[Array[Int]]", "kind" : "def"}, {"label" : "generate", "tail" : "(inputIds: Seq[Array[Int]], decoderEncoderStateTensors: Tensor, encoderAttentionMaskTensors: Tensor, decoderInputs: Array[Array[Int]], maxOutputLength: Int, minOutputLength: Int, doSample: Boolean, beamSize: Int, numReturnSequences: Int, temperature: Double, topK: Int, topP: Double, repetitionPenalty: Double, noRepeatNgramSize: Int, vocabSize: Int, eosTokenId: Int, paddingTokenId: Int, randomSeed: Option[Long], ignoreTokenIds: Array[Int], session: Session, applySoftmax: Boolean): Array[Array[Int]]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.generate", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#generate(inputIds:Seq[Array[Int]],decoderEncoderStateTensors:org.tensorflow.Tensor,encoderAttentionMaskTensors:org.tensorflow.Tensor,decoderInputs:Array[Array[Int]],maxOutputLength:Int,minOutputLength:Int,doSample:Boolean,beamSize:Int,numReturnSequences:Int,temperature:Double,topK:Int,topP:Double,repetitionPenalty:Double,noRepeatNgramSize:Int,vocabSize:Int,eosTokenId:Int,paddingTokenId:Int,randomSeed:Option[Long],ignoreTokenIds:Array[Int],session:org.tensorflow.Session,applySoftmax:Boolean):Array[Array[Int]]", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}, {"label" : "getModelOutput", "tail" : "(encoderInputIds: Seq[Array[Int]], decoderInputIds: Seq[Array[Int]], decoderEncoderStateTensors: Tensor, encoderAttentionMaskTensors: Tensor, maxLength: Int, session: Session): Array[Array[Float]]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.Generate.getModelOutput", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html#getModelOutput(encoderInputIds:Seq[Array[Int]],decoderInputIds:Seq[Array[Int]],decoderEncoderStateTensors:org.tensorflow.Tensor,encoderAttentionMaskTensors:org.tensorflow.Tensor,maxLength:Int,session:org.tensorflow.Session):Array[Array[Float]]", "kind" : "abstract def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/Generate.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig#<init>", "error" : "unsupported entity"}, {"label" : "forcedDecoderIds", "tail" : ": Option[Array[(Int, Int)]]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig.forcedDecoderIds", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#forcedDecoderIds:Option[Array[(Int,Int)]]", "kind" : "val"}, {"label" : "suppressTokenIds", "tail" : ": Option[Array[Int]]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig.suppressTokenIds", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#suppressTokenIds:Option[Array[Int]]", "kind" : "val"}, {"label" : "beginSuppressTokens", "tail" : ": Option[Array[Int]]", "member" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig.beginSuppressTokens", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#beginSuppressTokens:Option[Array[Int]]", "kind" : "val"}, {"label" : "vocabSize", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig.vocabSize", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#vocabSize:Int", "kind" : "val"}, {"label" : "eosId", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig.eosId", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#eosId:Int", "kind" : "val"}, {"label" : "padId", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig.padId", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#padId:Int", "kind" : "val"}, {"label" : "bosId", "tail" : ": Int", "member" : "com.johnsnowlabs.ml.ai.util.Generation.GenerationConfig.bosId", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#bosId:Int", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/ml\/ai\/util\/Generation\/GenerationConfig.html", "kind" : "case class"}], "com.johnsnowlabs.nlp.annotators.classifier" : [], "com.johnsnowlabs.nlp.annotators.keyword" : [], "com.johnsnowlabs.nlp.finisher" : [{"name" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher", "shortDescription" : "", "object" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html", "members_object" : [{"label" : "read", "tail" : "(): MLReader[DocumentSimilarityRankerFinisher]", "member" : "org.apache.spark.ml.util.DefaultParamsReadable.read", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): DocumentSimilarityRankerFinisher", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_case class" : [{"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "copy", "tail" : "(extra: ParamMap): Transformer", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.copy", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#copy(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.Transformer", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_]): DataFrame", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.transform", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#transform(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "getExtractNearestNeighbor", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.getExtractNearestNeighbor", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#getExtractNearestNeighbor:Boolean", "kind" : "def"}, {"label" : "setExtractNearestNeighbor", "tail" : "(value: Boolean): DocumentSimilarityRankerFinisher.this.type", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.setExtractNearestNeighbor", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#setExtractNearestNeighbor(value:Boolean):DocumentSimilarityRankerFinisher.this.type", "kind" : "def"}, {"label" : "extractNearestNeighbor", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.extractNearestNeighbor", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#extractNearestNeighbor:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "getOutputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.getOutputCols", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#getOutputCols:Array[String]", "kind" : "def"}, {"label" : "setOutputCols", "tail" : "(value: String*): DocumentSimilarityRankerFinisher.this.type", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.setOutputCols", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#setOutputCols(value:String*):DocumentSimilarityRankerFinisher.this.type", "kind" : "def"}, {"label" : "setOutputCols", "tail" : "(value: Array[String]): DocumentSimilarityRankerFinisher.this.type", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.setOutputCols", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#setOutputCols(value:Array[String]):DocumentSimilarityRankerFinisher.this.type", "kind" : "def"}, {"label" : "outputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.outputCols", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#outputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): DocumentSimilarityRankerFinisher.this.type", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#setInputCols(value:String*):DocumentSimilarityRankerFinisher.this.type", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): DocumentSimilarityRankerFinisher.this.type", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#setInputCols(value:Array[String]):DocumentSimilarityRankerFinisher.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.inputCols", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "val"}, {"label" : "FINISHED_DOC_SIM_RANKER_NEIGHBORS_DEFAULT", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.FINISHED_DOC_SIM_RANKER_NEIGHBORS_DEFAULT", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#FINISHED_DOC_SIM_RANKER_NEIGHBORS_DEFAULT:String", "kind" : "val"}, {"label" : "FINISHED_DOC_SIM_RANKER_ID_DEFAULT", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.FINISHED_DOC_SIM_RANKER_ID_DEFAULT", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#FINISHED_DOC_SIM_RANKER_ID_DEFAULT:String", "kind" : "val"}, {"label" : "LSH_NEIGHBORS_COL_NAME", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.LSH_NEIGHBORS_COL_NAME", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#LSH_NEIGHBORS_COL_NAME:String", "kind" : "val"}, {"label" : "LSH_ID_COL_NAME", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.LSH_ID_COL_NAME", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#LSH_ID_COL_NAME:String", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher#<init>", "error" : "unsupported entity"}, {"member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.finisher.DocumentSimilarityRankerFinisher.uid", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#uid:String", "kind" : "val"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "org.apache.spark.ml.util.DefaultParamsWritable.write", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#save(path:String):Unit", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#transform(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#transform(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): DocumentSimilarityRankerFinisher.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): DocumentSimilarityRankerFinisher.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): DocumentSimilarityRankerFinisher.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): DocumentSimilarityRankerFinisher.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): DocumentSimilarityRankerFinisher.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): DocumentSimilarityRankerFinisher.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/finisher\/DocumentSimilarityRankerFinisher.html", "kind" : "case class"}], "com.johnsnowlabs.ml.util" : [{"name" : "com.johnsnowlabs.ml.util.LinAlg", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html", "members_object" : [{"label" : "lpNormalizeArray", "tail" : "(array: Array[Float], p: Int): Array[Float]", "member" : "com.johnsnowlabs.ml.util.LinAlg.lpNormalizeArray", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#lpNormalizeArray(array:Array[Float],p:Int):Array[Float]", "kind" : "def"}, {"label" : "denseMatrixToArray", "tail" : "(matrix: DenseMatrix[Float]): Array[Array[Float]]", "member" : "com.johnsnowlabs.ml.util.LinAlg.denseMatrixToArray", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#denseMatrixToArray(matrix:breeze.linalg.DenseMatrix[Float]):Array[Array[Float]]", "kind" : "def"}, {"label" : "l2Normalize", "tail" : "(embeddings: DenseMatrix[Float]): DenseMatrix[Float]", "member" : "com.johnsnowlabs.ml.util.LinAlg.l2Normalize", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#l2Normalize(embeddings:breeze.linalg.DenseMatrix[Float]):breeze.linalg.DenseMatrix[Float]", "kind" : "def"}, {"label" : "avgPooling", "tail" : "(flattenEmbeddings: Array[Float], attentionMask: Array[Array[Long]], shape: Array[Long]): DenseMatrix[Float]", "member" : "com.johnsnowlabs.ml.util.LinAlg.avgPooling", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#avgPooling(flattenEmbeddings:Array[Float],attentionMask:Array[Array[Long]],shape:Array[Long]):breeze.linalg.DenseMatrix[Float]", "kind" : "def"}, {"label" : "argmax", "tail" : "(scores: Array[Float]): Int", "member" : "com.johnsnowlabs.ml.util.LinAlg.argmax", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#argmax(scores:Array[Float]):Int", "kind" : "def"}, {"label" : "softmax", "tail" : "(logitValues: Array[Float]): Array[Float]", "member" : "com.johnsnowlabs.ml.util.LinAlg.softmax", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#softmax(logitValues:Array[Float]):Array[Float]", "kind" : "def"}, {"label" : "implicits", "tail" : "", "member" : "com.johnsnowlabs.ml.util.LinAlg.implicits", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#implicits", "kind" : "object"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/LinAlg$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.util.LoadExternalModel", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html", "members_object" : [{"label" : "loadJsonStringAsset", "tail" : "(assetPath: String, assetName: String): String", "member" : "com.johnsnowlabs.ml.util.LoadExternalModel.loadJsonStringAsset", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#loadJsonStringAsset(assetPath:String,assetName:String):String", "kind" : "def"}, {"label" : "loadSentencePieceAsset", "tail" : "(assetPath: String, assetName: String): SentencePieceWrapper", "member" : "com.johnsnowlabs.ml.util.LoadExternalModel.loadSentencePieceAsset", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#loadSentencePieceAsset(assetPath:String,assetName:String):com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper", "kind" : "def"}, {"label" : "loadTextAsset", "tail" : "(assetPath: String, assetName: String): Array[String]", "member" : "com.johnsnowlabs.ml.util.LoadExternalModel.loadTextAsset", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#loadTextAsset(assetPath:String,assetName:String):Array[String]", "kind" : "def"}, {"label" : "modelSanityCheck", "tail" : "(path: String, isEncoderDecoder: Boolean, withPast: Boolean): (String, String)", "member" : "com.johnsnowlabs.ml.util.LoadExternalModel.modelSanityCheck", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#modelSanityCheck(path:String,isEncoderDecoder:Boolean,withPast:Boolean):(String,String)", "kind" : "def"}, {"label" : "detectEngine", "tail" : "(modelPath: String, isEncoderDecoder: Boolean, withPast: Boolean): String", "member" : "com.johnsnowlabs.ml.util.LoadExternalModel.detectEngine", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#detectEngine(modelPath:String,isEncoderDecoder:Boolean,withPast:Boolean):String", "kind" : "def"}, {"label" : "isOnnxModel", "tail" : "(modelPath: String, isEncoderDecoder: Boolean, withPast: Boolean): Boolean", "member" : "com.johnsnowlabs.ml.util.LoadExternalModel.isOnnxModel", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#isOnnxModel(modelPath:String,isEncoderDecoder:Boolean,withPast:Boolean):Boolean", "kind" : "def"}, {"label" : "isTensorFlowModel", "tail" : "(modelPath: String): Boolean", "member" : "com.johnsnowlabs.ml.util.LoadExternalModel.isTensorFlowModel", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#isTensorFlowModel(modelPath:String):Boolean", "kind" : "def"}, {"label" : "notSupportedEngineError", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.LoadExternalModel.notSupportedEngineError", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#notSupportedEngineError:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/LoadExternalModel$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.util.ModelArch", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html", "members_object" : [{"label" : "zeroShotClassifier", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ModelArch.zeroShotClassifier", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#zeroShotClassifier:String", "kind" : "val"}, {"label" : "questionAnswering", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ModelArch.questionAnswering", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#questionAnswering:String", "kind" : "val"}, {"label" : "sequenceClassifier", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ModelArch.sequenceClassifier", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#sequenceClassifier:String", "kind" : "val"}, {"label" : "tokenClassifier", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ModelArch.tokenClassifier", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#tokenClassifier:String", "kind" : "val"}, {"label" : "sentenceEmbeddings", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ModelArch.sentenceEmbeddings", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#sentenceEmbeddings:String", "kind" : "val"}, {"label" : "wordEmbeddings", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ModelArch.wordEmbeddings", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#wordEmbeddings:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/ModelArch$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.util.ModelEngine", "members_trait" : [{"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/ml\/util\/ModelEngine.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.ml.util.ONNX", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html", "members_object" : [{"label" : "decoderWithPastModel", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ONNX.decoderWithPastModel", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#decoderWithPastModel:String", "kind" : "val"}, {"label" : "decoderModel", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ONNX.decoderModel", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#decoderModel:String", "kind" : "val"}, {"label" : "encoderModel", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ONNX.encoderModel", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#encoderModel:String", "kind" : "val"}, {"label" : "modelName", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ONNX.modelName", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#modelName:String", "kind" : "val"}, {"label" : "name", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.ONNX.name", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#name:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/ONNX$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.util.PyTorch", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html", "members_object" : [{"label" : "name", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.PyTorch.name", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#name:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/PyTorch$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.util.TensorFlow", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html", "members_object" : [{"label" : "modelName", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.TensorFlow.modelName", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#modelName:String", "kind" : "val"}, {"label" : "name", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.TensorFlow.name", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#name:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/TensorFlow$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.ml.util.Unknown", "shortDescription" : "", "object" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html", "members_object" : [{"label" : "name", "tail" : ": String", "member" : "com.johnsnowlabs.ml.util.Unknown.name", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#name:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/ml\/util\/Unknown$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}], "com.johnsnowlabs.nlp.annotators.pos" : [], "com.johnsnowlabs.nlp.annotators.ws" : [{"name" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter", "members_trait" : [{"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#pretrained():com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#defaultLang:String", "kind" : "val"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "read", "tail" : "(): MLReader[WordSegmenterModel]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (WordSegmenterModel, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): WordSegmenterModel", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/ReadablePretrainedWordSegmenter.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.ws.TagsType", "shortDescription" : "", "object" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html", "members_object" : [{"label" : "SINGLE_WORD", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.TagsType.SINGLE_WORD", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#SINGLE_WORD:String", "kind" : "val"}, {"label" : "MIDDLE", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.TagsType.MIDDLE", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#MIDDLE:String", "kind" : "val"}, {"label" : "RIGHT_BOUNDARY", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.TagsType.RIGHT_BOUNDARY", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#RIGHT_BOUNDARY:String", "kind" : "val"}, {"label" : "LEFT_BOUNDARY", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.TagsType.LEFT_BOUNDARY", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#LEFT_BOUNDARY:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/TagsType$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "kind" : "object"}, {"name" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach", "shortDescription" : "Trains a WordSegmenter which tokenizes non-english or non-whitespace separated texts.", "object" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html", "members_class" : [{"label" : "inputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#inputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "outputAnnotatorType", "tail" : ": AnnotatorType", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#outputAnnotatorType:WordSegmenterApproach.this.AnnotatorType", "kind" : "val"}, {"label" : "train", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.train", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#train(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "getNIterations", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.getNIterations", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#getNIterations:Int", "kind" : "def"}, {"label" : "setPattern", "tail" : "(value: String): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.setPattern", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setPattern(value:String):WordSegmenterApproach.this.type", "kind" : "def"}, {"label" : "setToLowercase", "tail" : "(value: Boolean): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.setToLowercase", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setToLowercase(value:Boolean):WordSegmenterApproach.this.type", "kind" : "def"}, {"label" : "setEnableRegexTokenizer", "tail" : "(value: Boolean): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.setEnableRegexTokenizer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setEnableRegexTokenizer(value:Boolean):WordSegmenterApproach.this.type", "kind" : "def"}, {"label" : "setAmbiguityThreshold", "tail" : "(value: Double): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.setAmbiguityThreshold", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setAmbiguityThreshold(value:Double):WordSegmenterApproach.this.type", "kind" : "def"}, {"label" : "setFrequencyThreshold", "tail" : "(value: Int): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.setFrequencyThreshold", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setFrequencyThreshold(value:Int):WordSegmenterApproach.this.type", "kind" : "def"}, {"label" : "setNIterations", "tail" : "(value: Int): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.setNIterations", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setNIterations(value:Int):WordSegmenterApproach.this.type", "kind" : "def"}, {"label" : "setPosColumn", "tail" : "(value: String): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.setPosColumn", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setPosColumn(value:String):WordSegmenterApproach.this.type", "kind" : "def"}, {"label" : "pattern", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.pattern", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#pattern:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "toLowercase", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.toLowercase", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#toLowercase:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "enableRegexTokenizer", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.enableRegexTokenizer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#enableRegexTokenizer:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "ambiguityThreshold", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.ambiguityThreshold", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#ambiguityThreshold:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "frequencyThreshold", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.frequencyThreshold", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#frequencyThreshold:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "nIterations", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.nIterations", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#nIterations:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "posCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.posCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#posCol:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "description", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.description", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#description:String", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach#<init>", "error" : "unsupported entity"}, {"member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterApproach.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#uid:String", "kind" : "val"}, {"label" : "trainPerceptron", "tail" : "(nIterations: Int, initialModel: TrainingPerceptronLegacy, taggedSentences: Array[TaggedSentence], taggedWordBook: Map[String, String]): AveragedPerceptron", "member" : "com.johnsnowlabs.nlp.annotators.pos.perceptron.PerceptronTrainingUtils.trainPerceptron", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#trainPerceptron(nIterations:Int,initialModel:com.johnsnowlabs.nlp.annotators.pos.perceptron.TrainingPerceptronLegacy,taggedSentences:Array[com.johnsnowlabs.nlp.annotators.common.TaggedSentence],taggedWordBook:Map[String,String]):com.johnsnowlabs.nlp.annotators.pos.perceptron.AveragedPerceptron", "kind" : "def"}, {"label" : "buildTagBook", "tail" : "(taggedSentences: Array[TaggedSentence], frequencyThreshold: Int, ambiguityThreshold: Double): Map[String, String]", "member" : "com.johnsnowlabs.nlp.annotators.pos.perceptron.PerceptronTrainingUtils.buildTagBook", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#buildTagBook(taggedSentences:Array[com.johnsnowlabs.nlp.annotators.common.TaggedSentence],frequencyThreshold:Int,ambiguityThreshold:Double):Map[String,String]", "kind" : "def"}, {"label" : "generatesTagBook", "tail" : "(dataset: Dataset[_]): Array[TaggedSentence]", "member" : "com.johnsnowlabs.nlp.annotators.pos.perceptron.PerceptronTrainingUtils.generatesTagBook", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#generatesTagBook(dataset:org.apache.spark.sql.Dataset[_]):Array[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "final def"}, {"label" : "copy", "tail" : "(extra: ParamMap): Estimator[WordSegmenterModel]", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.copy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#copy(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.Estimator[M]", "kind" : "final def"}, {"label" : "fit", "tail" : "(dataset: Dataset[_]): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#fit(dataset:org.apache.spark.sql.Dataset[_]):M", "kind" : "final def"}, {"label" : "_fit", "tail" : "(dataset: Dataset[_], recursiveStages: Option[PipelineModel]): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach._fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#_fit(dataset:org.apache.spark.sql.Dataset[_],recursiveStages:Option[org.apache.spark.ml.PipelineModel]):M", "kind" : "def"}, {"label" : "validate", "tail" : "(schema: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.validate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#validate(schema:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "onTrained", "tail" : "(model: WordSegmenterModel, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.onTrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#onTrained(model:M,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "beforeTraining", "tail" : "(spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.AnnotatorApproach.beforeTraining", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#beforeTraining(spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "getLazyAnnotator", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.CanBeLazy.getLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#getLazyAnnotator:Boolean", "kind" : "def"}, {"label" : "setLazyAnnotator", "tail" : "(value: Boolean): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.CanBeLazy.setLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setLazyAnnotator(value:Boolean):<refinement>.type", "kind" : "def"}, {"label" : "lazyAnnotator", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.CanBeLazy.lazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#lazyAnnotator:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "org.apache.spark.ml.util.DefaultParamsWritable.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#save(path:String):Unit", "kind" : "def"}, {"label" : "AnnotatorType", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotatorType.AnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#AnnotatorType=String", "kind" : "type"}, {"label" : "getOutputCol", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.getOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#getOutputCol:String", "kind" : "final def"}, {"label" : "setOutputCol", "tail" : "(value: String): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.setOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setOutputCol(value:String):HasOutputAnnotationCol.this.type", "kind" : "final def"}, {"label" : "outputCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.outputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#outputCol:org.apache.spark.ml.param.Param[String]", "kind" : "final val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setInputCols(value:String*):HasInputAnnotationCols.this.type", "kind" : "final def"}, {"label" : "checkSchema", "tail" : "(schema: StructType, inputAnnotatorType: String): Boolean", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.checkSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#checkSchema(schema:org.apache.spark.sql.types.StructType,inputAnnotatorType:String):Boolean", "kind" : "final def"}, {"label" : "msgHelper", "tail" : "(schema: StructType): String", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.msgHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#msgHelper(schema:org.apache.spark.sql.types.StructType):String", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): WordSegmenterApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setInputCols(value:Array[String]):HasInputAnnotationCols.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.inputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "final val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "fit", "tail" : "(dataset: Dataset[_], paramMaps: Seq[ParamMap]): Seq[WordSegmenterModel]", "member" : "org.apache.spark.ml.Estimator.fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#fit(dataset:org.apache.spark.sql.Dataset[_],paramMaps:Seq[org.apache.spark.ml.param.ParamMap]):Seq[M]", "kind" : "def"}, {"label" : "fit", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): WordSegmenterModel", "member" : "org.apache.spark.ml.Estimator.fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#fit(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):M", "kind" : "def"}, {"label" : "fit", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): WordSegmenterModel", "member" : "org.apache.spark.ml.Estimator.fit", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#fit(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):M", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): WordSegmenterApproach.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): WordSegmenterApproach.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): WordSegmenterApproach.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): WordSegmenterApproach.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): WordSegmenterApproach.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): WordSegmenterApproach.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_object" : [{"label" : "read", "tail" : "(): MLReader[WordSegmenterApproach]", "member" : "org.apache.spark.ml.util.DefaultParamsReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): WordSegmenterApproach", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterApproach.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "shortDescription" : "WordSegmenter which tokenizes non-english or non-whitespace separated texts.", "object" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html", "members_class" : [{"label" : "inputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#inputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "outputAnnotatorType", "tail" : ": AnnotatorType", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#outputAnnotatorType:WordSegmenterModel.this.AnnotatorType", "kind" : "val"}, {"label" : "buildWordSegments", "tail" : "(taggedSentences: Array[TaggedSentence]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.buildWordSegments", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#buildWordSegments(taggedSentences:Array[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "annotate", "tail" : "(annotations: Seq[Annotation]): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.annotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#annotate(annotations:Seq[com.johnsnowlabs.nlp.Annotation]):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "setPattern", "tail" : "(value: String): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.setPattern", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setPattern(value:String):WordSegmenterModel.this.type", "kind" : "def"}, {"label" : "setToLowercase", "tail" : "(value: Boolean): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.setToLowercase", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setToLowercase(value:Boolean):WordSegmenterModel.this.type", "kind" : "def"}, {"label" : "setEnableRegexTokenizer", "tail" : "(value: Boolean): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.setEnableRegexTokenizer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setEnableRegexTokenizer(value:Boolean):WordSegmenterModel.this.type", "kind" : "def"}, {"label" : "setModel", "tail" : "(targetModel: AveragedPerceptron): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.setModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setModel(targetModel:com.johnsnowlabs.nlp.annotators.pos.perceptron.AveragedPerceptron):WordSegmenterModel.this.type", "kind" : "def"}, {"label" : "getModel", "tail" : "(): AveragedPerceptron", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.getModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#getModel:com.johnsnowlabs.nlp.annotators.pos.perceptron.AveragedPerceptron", "kind" : "def"}, {"label" : "pattern", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.pattern", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#pattern:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "toLowercase", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.toLowercase", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#toLowercase:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "enableRegexTokenizer", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.enableRegexTokenizer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#enableRegexTokenizer:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "model", "tail" : ": StructFeature[AveragedPerceptron]", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.model", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#model:com.johnsnowlabs.nlp.serialization.StructFeature[com.johnsnowlabs.nlp.annotators.pos.perceptron.AveragedPerceptron]", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel#<init>", "error" : "unsupported entity"}, {"member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#uid:String", "kind" : "val"}, {"label" : "tag", "tail" : "(model: AveragedPerceptron, tokenizedSentences: Array[TokenizedSentence]): Array[TaggedSentence]", "member" : "com.johnsnowlabs.nlp.annotators.pos.perceptron.PerceptronPredictionUtils.tag", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#tag(model:com.johnsnowlabs.nlp.annotators.pos.perceptron.AveragedPerceptron,tokenizedSentences:Array[com.johnsnowlabs.nlp.annotators.common.TokenizedSentence]):Array[com.johnsnowlabs.nlp.annotators.common.TaggedSentence]", "kind" : "def"}, {"label" : "dfAnnotate", "tail" : "(): UserDefinedFunction", "member" : "com.johnsnowlabs.nlp.HasSimpleAnnotate.dfAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#dfAnnotate:org.apache.spark.sql.expressions.UserDefinedFunction", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#transform(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.DataFrame", "kind" : "final def"}, {"label" : "_transform", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel._transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#_transform(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "afterAnnotate", "tail" : "(dataset: DataFrame): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.afterAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#afterAnnotate(dataset:org.apache.spark.sql.DataFrame):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "beforeAnnotate", "tail" : "(dataset: Dataset[_]): Dataset[_]", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.beforeAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#beforeAnnotate(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "AnnotationContent", "tail" : "", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.AnnotationContent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#AnnotationContent=Seq[org.apache.spark.sql.Row]", "kind" : "type"}, {"label" : "getLazyAnnotator", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.CanBeLazy.getLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#getLazyAnnotator:Boolean", "kind" : "def"}, {"label" : "setLazyAnnotator", "tail" : "(value: Boolean): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.CanBeLazy.setLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setLazyAnnotator(value:Boolean):<refinement>.type", "kind" : "def"}, {"label" : "lazyAnnotator", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.CanBeLazy.lazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#lazyAnnotator:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "copy", "tail" : "(extra: ParamMap): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.RawAnnotator.copy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#copy(extra:org.apache.spark.ml.param.ParamMap):M", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.RawAnnotator.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "final def"}, {"label" : "extraValidate", "tail" : "(structType: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#extraValidate(structType:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "extraValidateMsg", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidateMsg", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#extraValidateMsg:String", "kind" : "def"}, {"label" : "validate", "tail" : "(schema: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.validate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#validate(schema:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "wrapColumnMetadata", "tail" : "(col: Column): Column", "member" : "com.johnsnowlabs.nlp.RawAnnotator.wrapColumnMetadata", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#wrapColumnMetadata(col:org.apache.spark.sql.Column):org.apache.spark.sql.Column", "kind" : "def"}, {"label" : "getOutputCol", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.getOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#getOutputCol:String", "kind" : "final def"}, {"label" : "setOutputCol", "tail" : "(value: String): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.setOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setOutputCol(value:String):HasOutputAnnotationCol.this.type", "kind" : "final def"}, {"label" : "outputCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.outputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#outputCol:org.apache.spark.ml.param.Param[String]", "kind" : "final val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setInputCols(value:String*):HasInputAnnotationCols.this.type", "kind" : "final def"}, {"label" : "checkSchema", "tail" : "(schema: StructType, inputAnnotatorType: String): Boolean", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.checkSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#checkSchema(schema:org.apache.spark.sql.types.StructType,inputAnnotatorType:String):Boolean", "kind" : "final def"}, {"label" : "msgHelper", "tail" : "(schema: StructType): String", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.msgHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#msgHelper(schema:org.apache.spark.sql.types.StructType):String", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setInputCols(value:Array[String]):HasInputAnnotationCols.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.inputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "final val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "AnnotatorType", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotatorType.AnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#AnnotatorType=String", "kind" : "type"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesWritable.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "onWrite", "tail" : "(path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesWritable.onWrite", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#onWrite(path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: StructFeature[T]): T", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):T", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: MapFeature[K, V]): Map[K, V]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#$$[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Map[K,V]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: SetFeature[T]): Set[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Set[T]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: ArrayFeature[T]): Array[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Array[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: StructFeature[T]): Option[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#get[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):Option[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: MapFeature[K, V]): Option[Map[K, V]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#get[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Option[Map[K,V]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: SetFeature[T]): Option[Set[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#get[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Option[Set[T]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: ArrayFeature[T]): Option[Array[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#get[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Option[Array[T]]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: StructFeature[T], value: () ⇒ T): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:()=>T):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: MapFeature[K, V], value: () ⇒ Map[K, V]): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setDefault[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:()=>Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: SetFeature[T], value: () ⇒ Set[T]): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:()=>Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: ArrayFeature[T], value: () ⇒ Array[T]): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:()=>Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: StructFeature[T], value: T): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#set[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:T):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: MapFeature[K, V], value: Map[K, V]): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#set[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: SetFeature[T], value: Set[T]): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#set[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: ArrayFeature[T], value: Array[T]): WordSegmenterModel.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#set[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "features", "tail" : ": ArrayBuffer[Feature[_, _, _]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.features", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#features:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.nlp.serialization.Feature[_,_,_]]", "kind" : "val"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#save(path:String):Unit", "kind" : "def"}, {"label" : "hasParent", "tail" : "(): Boolean", "member" : "org.apache.spark.ml.Model.hasParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#hasParent:Boolean", "kind" : "def"}, {"label" : "setParent", "tail" : "(parent: Estimator[WordSegmenterModel]): WordSegmenterModel", "member" : "org.apache.spark.ml.Model.setParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setParent(parent:org.apache.spark.ml.Estimator[M]):M", "kind" : "def"}, {"label" : "parent", "tail" : ": Estimator[WordSegmenterModel]", "member" : "org.apache.spark.ml.Model.parent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#parent:org.apache.spark.ml.Estimator[M]", "kind" : "var"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#transform(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#transform(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): WordSegmenterModel.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): WordSegmenterModel.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): WordSegmenterModel.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): WordSegmenterModel.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): WordSegmenterModel.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): WordSegmenterModel.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_object" : [{"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): WordSegmenterModel", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#pretrained():com.johnsnowlabs.nlp.annotators.ws.WordSegmenterModel", "kind" : "def"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#defaultLang:String", "kind" : "val"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.ws.ReadablePretrainedWordSegmenter.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "read", "tail" : "(): MLReader[WordSegmenterModel]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (WordSegmenterModel, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): WordSegmenterModel", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/ws\/WordSegmenterModel.html", "kind" : "class"}], "com.johnsnowlabs.ml.ai.util" : [], "com.johnsnowlabs.nlp.annotators.spell.context.parser" : [{"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.AgeToken", "shortDescription" : "", "members_class" : [{"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.AgeToken.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.AgeToken.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#label:String", "kind" : "var"}, {"label" : "regex", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.AgeToken.regex", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#regex:String", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.AgeToken#<init>", "error" : "unsupported entity"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.RegexParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/AgeToken.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.DateToken", "shortDescription" : "", "members_class" : [{"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.DateToken.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "separate", "tail" : "(word: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.DateToken.separate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#separate(word:String):String", "kind" : "def"}, {"label" : "dateRegex", "tail" : ": Regex", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.DateToken.dateRegex", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#dateRegex:scala.util.matching.Regex", "kind" : "val"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.DateToken.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.DateToken.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#label:String", "kind" : "var"}, {"label" : "regex", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.DateToken.regex", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#regex:String", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.DateToken#<init>", "error" : "unsupported entity"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "backTrack", "tail" : "(dist: Array[Array[Float]], s2: String, s1: String, j: Int, i: Int, acc: Seq[(String, String)]): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.backTrack", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#backTrack(dist:Array[Array[Float]],s2:String,s1:String,j:Int,i:Int,acc:Seq[(String,String)]):Seq[(String,String)]", "kind" : "def"}, {"label" : "learnDist", "tail" : "(s1: String, s2: String): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.learnDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#learnDist(s1:String,s2:String):Seq[(String,String)]", "kind" : "def"}, {"label" : "loadWeights", "tail" : "(filename: String): Map[String, Map[String, Float]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.loadWeights", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#loadWeights(filename:String):Map[String,Map[String,Float]]", "kind" : "def"}, {"label" : "wLevenshteinDist", "tail" : "(s1: String, s2: String, weights: Map[String, Map[String, Float]]): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.wLevenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#wLevenshteinDist(s1:String,s2:String,weights:Map[String,Map[String,Float]]):Float", "kind" : "def"}, {"label" : "levenshteinDist", "tail" : "(s11: String, s22: String)(cost: (String, String) ⇒ Float): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.levenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#levenshteinDist(s11:String,s22:String)(cost:(String,String)=>Float):Float", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.RegexParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/DateToken.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericRegexParser", "shortDescription" : "", "members_class" : [{"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericRegexParser#<init>", "error" : "unsupported entity"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericRegexParser.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericRegexParser.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#label:String", "kind" : "var"}, {"label" : "regex", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericRegexParser.regex", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#regex:String", "kind" : "var"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "backTrack", "tail" : "(dist: Array[Array[Float]], s2: String, s1: String, j: Int, i: Int, acc: Seq[(String, String)]): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.backTrack", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#backTrack(dist:Array[Array[Float]],s2:String,s1:String,j:Int,i:Int,acc:Seq[(String,String)]):Seq[(String,String)]", "kind" : "def"}, {"label" : "learnDist", "tail" : "(s1: String, s2: String): Seq[(String, String)]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.learnDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#learnDist(s1:String,s2:String):Seq[(String,String)]", "kind" : "def"}, {"label" : "loadWeights", "tail" : "(filename: String): Map[String, Map[String, Float]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.loadWeights", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#loadWeights(filename:String):Map[String,Map[String,Float]]", "kind" : "def"}, {"label" : "wLevenshteinDist", "tail" : "(s1: String, s2: String, weights: Map[String, Map[String, Float]]): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.wLevenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#wLevenshteinDist(s1:String,s2:String,weights:Map[String,Map[String,Float]]):Float", "kind" : "def"}, {"label" : "levenshteinDist", "tail" : "(s11: String, s22: String)(cost: (String, String) ⇒ Float): Float", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.WeightedLevenshtein.levenshteinDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#levenshteinDist(s11:String,s22:String)(cost:(String,String)=>Float):Float", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.RegexParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericRegexParser.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericVocabParser", "shortDescription" : "", "members_class" : [{"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericVocabParser#<init>", "error" : "unsupported entity"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericVocabParser.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericVocabParser.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#label:String", "kind" : "var"}, {"label" : "vocab", "tail" : ": Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.GenericVocabParser.vocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#vocab:scala.collection.mutable.Set[String]", "kind" : "var"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "loadDataset", "tail" : "(path: String, col: Option[String]): Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.loadDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#loadDataset(path:String,col:Option[String]):scala.collection.mutable.Set[String]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/GenericVocabParser.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.LocationClass", "shortDescription" : "", "members_class" : [{"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.LocationClass#<init>", "error" : "unsupported entity"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.LocationClass.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.LocationClass.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#label:String", "kind" : "var"}, {"label" : "vocab", "tail" : ": Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.LocationClass.vocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#vocab:scala.collection.mutable.Set[String]", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.LocationClass#<init>", "error" : "unsupported entity"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "loadDataset", "tail" : "(path: String, col: Option[String]): Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.loadDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#loadDataset(path:String,col:Option[String]):scala.collection.mutable.Set[String]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/LocationClass.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MainVocab", "shortDescription" : "", "members_class" : [{"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MainVocab#<init>", "error" : "unsupported entity"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MainVocab.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MainVocab.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#label:String", "kind" : "var"}, {"label" : "vocab", "tail" : ": Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MainVocab.vocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#vocab:scala.collection.mutable.Set[String]", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MainVocab#<init>", "error" : "unsupported entity"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "loadDataset", "tail" : "(path: String, col: Option[String]): Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.loadDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#loadDataset(path:String,col:Option[String]):scala.collection.mutable.Set[String]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MainVocab.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MedicationClass", "shortDescription" : "", "members_class" : [{"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MedicationClass#<init>", "error" : "unsupported entity"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MedicationClass.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MedicationClass.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#label:String", "kind" : "var"}, {"label" : "vocab", "tail" : ": Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MedicationClass.vocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#vocab:scala.collection.mutable.Set[String]", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.MedicationClass#<init>", "error" : "unsupported entity"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "loadDataset", "tail" : "(path: String, col: Option[String]): Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.loadDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#loadDataset(path:String,col:Option[String]):scala.collection.mutable.Set[String]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/MedicationClass.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NamesClass", "shortDescription" : "", "members_class" : [{"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NamesClass#<init>", "error" : "unsupported entity"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NamesClass.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NamesClass.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#label:String", "kind" : "var"}, {"label" : "vocab", "tail" : ": Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NamesClass.vocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#vocab:scala.collection.mutable.Set[String]", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NamesClass#<init>", "error" : "unsupported entity"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "loadDataset", "tail" : "(path: String, col: Option[String]): Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.loadDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#loadDataset(path:String,col:Option[String]):scala.collection.mutable.Set[String]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NamesClass.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NumberToken", "shortDescription" : "", "members_class" : [{"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NumberToken.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "separate", "tail" : "(word: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NumberToken.separate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#separate(word:String):String", "kind" : "def"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NumberToken.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NumberToken.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#label:String", "kind" : "var"}, {"label" : "regex", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NumberToken.regex", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#regex:String", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.NumberToken#<init>", "error" : "unsupported entity"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.RegexParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/NumberToken.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.RegexParser", "members_trait" : [{"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.RegexParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}, {"label" : "regex", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.RegexParser.regex", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#regex:String", "kind" : "abstract val"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#maxDist:Int", "kind" : "abstract val"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html#label:String", "kind" : "abstract val"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/RegexParser.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass", "members_trait" : [{"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SerializableClass.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "members_trait" : [{"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "abstract def"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#maxDist:Int", "kind" : "abstract val"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html#label:String", "kind" : "abstract val"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/SpecialClassParser.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature", "shortDescription" : "", "members_class" : [{"label" : "deserializeDataset", "tail" : "(spark: SparkSession, path: String, field: String): Option[Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature.deserializeDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#deserializeDataset(spark:org.apache.spark.sql.SparkSession,path:String,field:String):Option[Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]]", "kind" : "def"}, {"label" : "serializeDataset", "tail" : "(spark: SparkSession, path: String, field: String, specialClasses: Seq[SpecialClassParser]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature.serializeDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#serializeDataset(spark:org.apache.spark.sql.SparkSession,path:String,field:String,specialClasses:Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]):Unit", "kind" : "def"}, {"label" : "deserializeObject", "tail" : "(spark: SparkSession, path: String, field: String): Option[Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature.deserializeObject", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#deserializeObject(spark:org.apache.spark.sql.SparkSession,path:String,field:String):Option[Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]]", "kind" : "def"}, {"label" : "serializeObject", "tail" : "(spark: SparkSession, path: String, field: String, specialClasses: Seq[SpecialClassParser]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature.serializeObject", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#serializeObject(spark:org.apache.spark.sql.SparkSession,path:String,field:String,specialClasses:Seq[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]):Unit", "kind" : "def"}, {"label" : "encoder", "tail" : ": Encoder[SpecialClassParser]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature.encoder", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#encoder:org.apache.spark.sql.Encoder[com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser]", "kind" : "implicit val"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature#<init>", "error" : "unsupported entity"}, {"label" : "name", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.TransducerSeqFeature.name", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#name:String", "kind" : "val"}, {"label" : "setProtected", "tail" : "(): TransducerSeqFeature.this.type", "member" : "com.johnsnowlabs.nlp.serialization.Feature.setProtected", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#setProtected():Feature.this.type", "kind" : "final def"}, {"label" : "isSet", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.serialization.Feature.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#isSet:Boolean", "kind" : "final def"}, {"label" : "setFallback", "tail" : "(v: Option[() ⇒ Seq[SpecialClassParser]]): HasFeatures", "member" : "com.johnsnowlabs.nlp.serialization.Feature.setFallback", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#setFallback(v:Option[()=>TComplete]):com.johnsnowlabs.nlp.HasFeatures", "kind" : "def"}, {"label" : "setValue", "tail" : "(value: Option[Any]): HasFeatures", "member" : "com.johnsnowlabs.nlp.serialization.Feature.setValue", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#setValue(value:Option[Any]):com.johnsnowlabs.nlp.HasFeatures", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(): Seq[SpecialClassParser]", "member" : "com.johnsnowlabs.nlp.serialization.Feature.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#getOrDefault:TComplete", "kind" : "final def"}, {"label" : "orDefault", "tail" : "(): Option[Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.serialization.Feature.orDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#orDefault:Option[TComplete]", "kind" : "final def"}, {"label" : "get", "tail" : "(): Option[Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.serialization.Feature.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#get:Option[TComplete]", "kind" : "final def"}, {"label" : "getFieldPath", "tail" : "(path: String, field: String): Path", "member" : "com.johnsnowlabs.nlp.serialization.Feature.getFieldPath", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#getFieldPath(path:String,field:String):org.apache.hadoop.fs.Path", "kind" : "final def"}, {"label" : "deserialize", "tail" : "(spark: SparkSession, path: String, field: String): Option[_]", "member" : "com.johnsnowlabs.nlp.serialization.Feature.deserialize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#deserialize(spark:org.apache.spark.sql.SparkSession,path:String,field:String):Option[_]", "kind" : "final def"}, {"label" : "serializeInfer", "tail" : "(spark: SparkSession, path: String, field: String, value: Any): Unit", "member" : "com.johnsnowlabs.nlp.serialization.Feature.serializeInfer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#serializeInfer(spark:org.apache.spark.sql.SparkSession,path:String,field:String,value:Any):Unit", "kind" : "final def"}, {"label" : "serialize", "tail" : "(spark: SparkSession, path: String, field: String, value: Seq[SpecialClassParser]): Unit", "member" : "com.johnsnowlabs.nlp.serialization.Feature.serialize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#serialize(spark:org.apache.spark.sql.SparkSession,path:String,field:String,value:TComplete):Unit", "kind" : "final def"}, {"label" : "isProtected", "tail" : ": Boolean", "member" : "com.johnsnowlabs.nlp.serialization.Feature.isProtected", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#isProtected:Boolean", "kind" : "final var"}, {"label" : "fallbackLazyValue", "tail" : ": Option[() ⇒ Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.serialization.Feature.fallbackLazyValue", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#fallbackLazyValue:Option[()=>TComplete]", "kind" : "final var"}, {"label" : "fallbackRawValue", "tail" : ": Option[Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.serialization.Feature.fallbackRawValue", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#fallbackRawValue:Option[TComplete]", "kind" : "final var"}, {"label" : "rawValue", "tail" : ": Option[Seq[SpecialClassParser]]", "member" : "com.johnsnowlabs.nlp.serialization.Feature.rawValue", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#rawValue:Option[TComplete]", "kind" : "final var"}, {"label" : "broadcastValue", "tail" : ": Option[Broadcast[Seq[SpecialClassParser]]]", "member" : "com.johnsnowlabs.nlp.serialization.Feature.broadcastValue", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#broadcastValue:Option[org.apache.spark.broadcast.Broadcast[TComplete]]", "kind" : "final var"}, {"label" : "useBroadcast", "tail" : ": Boolean", "member" : "com.johnsnowlabs.nlp.serialization.Feature.useBroadcast", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#useBroadcast:Boolean", "kind" : "val"}, {"label" : "serializationMode", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.serialization.Feature.serializationMode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#serializationMode:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/TransducerSeqFeature.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.UnitToken", "shortDescription" : "", "members_class" : [{"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.UnitToken.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#maxDist:Int", "kind" : "var"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.UnitToken.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#label:String", "kind" : "var"}, {"label" : "vocab", "tail" : ": Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.UnitToken.vocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#vocab:scala.collection.mutable.Set[String]", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.UnitToken#<init>", "error" : "unsupported entity"}, {"label" : "read", "tail" : "(kryo: Kryo, input: Input): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#read(kryo:com.esotericsoftware.kryo.Kryo,input:com.esotericsoftware.kryo.io.Input):Unit", "kind" : "def"}, {"label" : "write", "tail" : "(kryo: Kryo, output: Output): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#write(kryo:com.esotericsoftware.kryo.Kryo,output:com.esotericsoftware.kryo.io.Output):Unit", "kind" : "def"}, {"label" : "serializeTransducer", "tail" : "(aOutputStream: ObjectOutputStream, t: ITransducer[Candidate]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.serializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#serializeTransducer(aOutputStream:java.io.ObjectOutputStream,t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):Unit", "kind" : "def"}, {"label" : "deserializeTransducer", "tail" : "(aInputStream: ObjectInputStream): Transducer[DawgNode, Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SerializableClass.deserializeTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#deserializeTransducer(aInputStream:java.io.ObjectInputStream):com.github.liblevenshtein.transducer.Transducer[com.github.liblevenshtein.proto.LibLevenshteinProtos.DawgNode,com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "loadDataset", "tail" : "(path: String, col: Option[String]): Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.loadDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#loadDataset(path:String,col:Option[String]):scala.collection.mutable.Set[String]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/UnitToken.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser", "members_trait" : [{"label" : "loadDataset", "tail" : "(path: String, col: Option[String]): Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.loadDataset", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#loadDataset(path:String,col:Option[String]):scala.collection.mutable.Set[String]", "kind" : "def"}, {"label" : "generateTransducer", "tail" : "(): ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.generateTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#generateTransducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "def"}, {"label" : "inVocabulary", "tail" : "(word: String): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.inVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#inVocabulary(word:String):Boolean", "kind" : "def"}, {"label" : "setTransducer", "tail" : "(t: ITransducer[Candidate]): SpecialClassParser", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.setTransducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#setTransducer(t:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]):com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser", "kind" : "def"}, {"label" : "replaceWithLabel", "tail" : "(tmp: String): String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.replaceWithLabel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#replaceWithLabel(tmp:String):String", "kind" : "def"}, {"label" : "transducer", "tail" : ": ITransducer[Candidate]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.transducer", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#transducer:com.github.liblevenshtein.transducer.ITransducer[com.github.liblevenshtein.transducer.Candidate]", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}, {"label" : "vocab", "tail" : ": Set[String]", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.VocabParser.vocab", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#vocab:scala.collection.mutable.Set[String]", "kind" : "abstract val"}, {"label" : "maxDist", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.maxDist", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#maxDist:Int", "kind" : "abstract val"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.spell.context.parser.SpecialClassParser.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html#label:String", "kind" : "abstract val"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/spell\/context\/parser\/VocabParser.html", "kind" : "trait"}], "com.johnsnowlabs.nlp.annotators.seq2seq" : [{"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "shortDescription" : "BART: Denoising Sequence-to-Sequence Pre-training for Natural Language Generation,Translation, and Comprehension Transformer", "object" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html", "members_class" : [{"label" : "onWrite", "tail" : "(path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.onWrite", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#onWrite(path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "batchAnnotate", "tail" : "(batchedAnnotations: Seq[Array[Annotation]]): Seq[Seq[Annotation]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.batchAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#batchAnnotate(batchedAnnotations:Seq[Array[com.johnsnowlabs.nlp.Annotation]]):Seq[Seq[com.johnsnowlabs.nlp.Annotation]]", "kind" : "def"}, {"label" : "getModelIfNotSet", "tail" : "(): Bart", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.getModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getModelIfNotSet:com.johnsnowlabs.ml.ai.Bart", "kind" : "def"}, {"label" : "setModelIfNotSet", "tail" : "(spark: SparkSession, tfWrapper: TensorflowWrapper, useCache: Boolean): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.setModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setModelIfNotSet(spark:org.apache.spark.sql.SparkSession,tfWrapper:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,useCache:Boolean):BartTransformer.this.type", "kind" : "def"}, {"label" : "getUseCache", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.getUseCache", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getUseCache:Boolean", "kind" : "def"}, {"label" : "setUseCache", "tail" : "(value: Boolean): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.setUseCache", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setUseCache(value:Boolean):BartTransformer.this.type", "kind" : "def"}, {"label" : "useCache", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.useCache", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#useCache:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "setMerges", "tail" : "(value: Map[(String, String), Int]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.setMerges", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setMerges(value:Map[(String,String),Int]):BartTransformer.this.type", "kind" : "def"}, {"label" : "merges", "tail" : ": MapFeature[(String, String), Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.merges", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#merges:com.johnsnowlabs.nlp.serialization.MapFeature[(String,String),Int]", "kind" : "val"}, {"label" : "setVocabulary", "tail" : "(value: Map[String, Int]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.setVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setVocabulary(value:Map[String,Int]):BartTransformer.this.type", "kind" : "def"}, {"label" : "vocabulary", "tail" : ": MapFeature[String, Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.vocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#vocabulary:com.johnsnowlabs.nlp.serialization.MapFeature[String,Int]", "kind" : "val"}, {"label" : "getSignatures", "tail" : "(): Option[Map[String, String]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.getSignatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getSignatures:Option[Map[String,String]]", "kind" : "def"}, {"label" : "setSignatures", "tail" : "(value: Map[String, String]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.setSignatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setSignatures(value:Map[String,String]):BartTransformer.this.type", "kind" : "def"}, {"label" : "signatures", "tail" : ": MapFeature[String, String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.signatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#signatures:com.johnsnowlabs.nlp.serialization.MapFeature[String,String]", "kind" : "val"}, {"label" : "getIgnoreTokenIds", "tail" : "(): Array[Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.getIgnoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getIgnoreTokenIds:Array[Int]", "kind" : "def"}, {"label" : "setIgnoreTokenIds", "tail" : "(tokenIds: Array[Int]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.setIgnoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setIgnoreTokenIds(tokenIds:Array[Int]):BartTransformer.this.type", "kind" : "def"}, {"label" : "ignoreTokenIds", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.ignoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#ignoreTokenIds:org.apache.spark.ml.param.IntArrayParam", "kind" : "var"}, {"label" : "getConfigProtoBytes", "tail" : "(): Option[Array[Byte]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.getConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getConfigProtoBytes:Option[Array[Byte]]", "kind" : "def"}, {"label" : "setConfigProtoBytes", "tail" : "(bytes: Array[Int]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.setConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setConfigProtoBytes(bytes:Array[Int]):BartTransformer.this.type", "kind" : "def"}, {"label" : "configProtoBytes", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.configProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#configProtoBytes:org.apache.spark.ml.param.IntArrayParam", "kind" : "val"}, {"label" : "outputAnnotatorType", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#outputAnnotatorType:String", "kind" : "val"}, {"label" : "inputAnnotatorTypes", "tail" : ": Array[AnnotatorType]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#inputAnnotatorTypes:Array[BartTransformer.this.AnnotatorType]", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer#<init>", "error" : "unsupported entity"}, {"member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#uid:String", "kind" : "val"}, {"label" : "getNReturnSequences", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getNReturnSequences", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getNReturnSequences:Int", "kind" : "def"}, {"label" : "setNReturnSequences", "tail" : "(beamNum: Int): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setNReturnSequences", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setNReturnSequences(beamNum:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "nReturnSequences", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.nReturnSequences", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#nReturnSequences:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getBeamSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getBeamSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getBeamSize:Int", "kind" : "def"}, {"label" : "setBeamSize", "tail" : "(beamNum: Int): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setBeamSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setBeamSize(beamNum:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "beamSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.beamSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#beamSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getRandomSeed", "tail" : "(): Option[Long]", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getRandomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getRandomSeed:Option[Long]", "kind" : "def"}, {"label" : "setRandomSeed", "tail" : "(value: Long): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setRandomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setRandomSeed(value:Long):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "randomSeed", "tail" : ": Option[Long]", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.randomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#randomSeed:Option[Long]", "kind" : "val"}, {"label" : "getNoRepeatNgramSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getNoRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getNoRepeatNgramSize:Int", "kind" : "def"}, {"label" : "setNoRepeatNgramSize", "tail" : "(value: Int): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setNoRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setNoRepeatNgramSize(value:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "noRepeatNgramSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.noRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#noRepeatNgramSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getRepetitionPenalty", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getRepetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getRepetitionPenalty:Double", "kind" : "def"}, {"label" : "setRepetitionPenalty", "tail" : "(value: Double): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setRepetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setRepetitionPenalty(value:Double):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "repetitionPenalty", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.repetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#repetitionPenalty:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getTopP", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getTopP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getTopP:Double", "kind" : "def"}, {"label" : "setTopP", "tail" : "(value: Double): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setTopP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setTopP(value:Double):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "topP", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.topP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#topP:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getTopK", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getTopK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getTopK:Int", "kind" : "def"}, {"label" : "setTopK", "tail" : "(value: Int): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setTopK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setTopK(value:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "topK", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.topK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#topK:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getTemperature", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getTemperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getTemperature:Double", "kind" : "def"}, {"label" : "setTemperature", "tail" : "(value: Double): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setTemperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setTemperature(value:Double):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "temperature", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.temperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#temperature:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getDoSample", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getDoSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getDoSample:Boolean", "kind" : "def"}, {"label" : "setDoSample", "tail" : "(value: Boolean): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setDoSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setDoSample(value:Boolean):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "doSample", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.doSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#doSample:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "getMaxOutputLength", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getMaxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getMaxOutputLength:Int", "kind" : "def"}, {"label" : "setMaxOutputLength", "tail" : "(value: Int): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setMaxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setMaxOutputLength(value:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "maxOutputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.maxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#maxOutputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getMinOutputLength", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getMinOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getMinOutputLength:Int", "kind" : "def"}, {"label" : "setMinOutputLength", "tail" : "(value: Int): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setMinOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setMinOutputLength(value:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "minOutputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.minOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#minOutputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setMaxInputLength", "tail" : "(value: Int): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setMaxInputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setMaxInputLength(value:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "maxInputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.maxInputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#maxInputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getTask", "tail" : "(): Option[String]", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.getTask", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getTask:Option[String]", "kind" : "def"}, {"label" : "setTask", "tail" : "(value: String): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.setTask", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setTask(value:String):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "task", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasGeneratorProperties.task", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#task:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "getEngine", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasEngine.getEngine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getEngine:String", "kind" : "def"}, {"label" : "engine", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasEngine.engine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#engine:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "writeTensorflowHub", "tail" : "(path: String, tfPath: String, spark: SparkSession, suffix: String): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#writeTensorflowHub(path:String,tfPath:String,spark:org.apache.spark.sql.SparkSession,suffix:String):Unit", "kind" : "def"}, {"label" : "writeTensorflowModelV2", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]], savedSignatures: Option[Map[String, String]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModelV2", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#writeTensorflowModelV2(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]],savedSignatures:Option[Map[String,String]]):Unit", "kind" : "def"}, {"label" : "writeTensorflowModel", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#writeTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]]):Unit", "kind" : "def"}, {"label" : "batchProcess", "tail" : "(rows: Iterator[_]): Iterator[Row]", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.batchProcess", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#batchProcess(rows:Iterator[_]):Iterator[org.apache.spark.sql.Row]", "kind" : "def"}, {"label" : "getBatchSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.getBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getBatchSize:Int", "kind" : "def"}, {"label" : "setBatchSize", "tail" : "(size: Int): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.setBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setBatchSize(size:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "batchSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.batchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#batchSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "transform", "tail" : "(dataset: Dataset[_]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#transform(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.DataFrame", "kind" : "final def"}, {"label" : "_transform", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel._transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#_transform(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "afterAnnotate", "tail" : "(dataset: DataFrame): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.afterAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#afterAnnotate(dataset:org.apache.spark.sql.DataFrame):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "beforeAnnotate", "tail" : "(dataset: Dataset[_]): Dataset[_]", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.beforeAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#beforeAnnotate(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "AnnotationContent", "tail" : "", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.AnnotationContent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#AnnotationContent=Seq[org.apache.spark.sql.Row]", "kind" : "type"}, {"label" : "getLazyAnnotator", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.CanBeLazy.getLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getLazyAnnotator:Boolean", "kind" : "def"}, {"label" : "setLazyAnnotator", "tail" : "(value: Boolean): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.CanBeLazy.setLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setLazyAnnotator(value:Boolean):<refinement>.type", "kind" : "def"}, {"label" : "lazyAnnotator", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.CanBeLazy.lazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#lazyAnnotator:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "copy", "tail" : "(extra: ParamMap): BartTransformer", "member" : "com.johnsnowlabs.nlp.RawAnnotator.copy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#copy(extra:org.apache.spark.ml.param.ParamMap):M", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.RawAnnotator.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "final def"}, {"label" : "extraValidate", "tail" : "(structType: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#extraValidate(structType:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "extraValidateMsg", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidateMsg", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#extraValidateMsg:String", "kind" : "def"}, {"label" : "validate", "tail" : "(schema: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.validate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#validate(schema:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "wrapColumnMetadata", "tail" : "(col: Column): Column", "member" : "com.johnsnowlabs.nlp.RawAnnotator.wrapColumnMetadata", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#wrapColumnMetadata(col:org.apache.spark.sql.Column):org.apache.spark.sql.Column", "kind" : "def"}, {"label" : "getOutputCol", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.getOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getOutputCol:String", "kind" : "final def"}, {"label" : "setOutputCol", "tail" : "(value: String): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.setOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setOutputCol(value:String):HasOutputAnnotationCol.this.type", "kind" : "final def"}, {"label" : "outputCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.outputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#outputCol:org.apache.spark.ml.param.Param[String]", "kind" : "final val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setInputCols(value:String*):HasInputAnnotationCols.this.type", "kind" : "final def"}, {"label" : "checkSchema", "tail" : "(schema: StructType, inputAnnotatorType: String): Boolean", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.checkSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#checkSchema(schema:org.apache.spark.sql.types.StructType,inputAnnotatorType:String):Boolean", "kind" : "final def"}, {"label" : "msgHelper", "tail" : "(schema: StructType): String", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.msgHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#msgHelper(schema:org.apache.spark.sql.types.StructType):String", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setInputCols(value:Array[String]):HasInputAnnotationCols.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.inputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "final val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "AnnotatorType", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotatorType.AnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#AnnotatorType=String", "kind" : "type"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesWritable.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: StructFeature[T]): T", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):T", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: MapFeature[K, V]): Map[K, V]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#$$[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Map[K,V]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: SetFeature[T]): Set[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Set[T]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: ArrayFeature[T]): Array[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Array[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: StructFeature[T]): Option[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):Option[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: MapFeature[K, V]): Option[Map[K, V]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#get[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Option[Map[K,V]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: SetFeature[T]): Option[Set[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Option[Set[T]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: ArrayFeature[T]): Option[Array[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Option[Array[T]]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: StructFeature[T], value: () ⇒ T): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:()=>T):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: MapFeature[K, V], value: () ⇒ Map[K, V]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setDefault[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:()=>Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: SetFeature[T], value: () ⇒ Set[T]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:()=>Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: ArrayFeature[T], value: () ⇒ Array[T]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:()=>Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: StructFeature[T], value: T): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:T):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: MapFeature[K, V], value: Map[K, V]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#set[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: SetFeature[T], value: Set[T]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: ArrayFeature[T], value: Array[T]): BartTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "features", "tail" : ": ArrayBuffer[Feature[_, _, _]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.features", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#features:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.nlp.serialization.Feature[_,_,_]]", "kind" : "val"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#save(path:String):Unit", "kind" : "def"}, {"label" : "hasParent", "tail" : "(): Boolean", "member" : "org.apache.spark.ml.Model.hasParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#hasParent:Boolean", "kind" : "def"}, {"label" : "setParent", "tail" : "(parent: Estimator[BartTransformer]): BartTransformer", "member" : "org.apache.spark.ml.Model.setParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setParent(parent:org.apache.spark.ml.Estimator[M]):M", "kind" : "def"}, {"label" : "parent", "tail" : ": Estimator[BartTransformer]", "member" : "org.apache.spark.ml.Model.parent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#parent:org.apache.spark.ml.Estimator[M]", "kind" : "var"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#transform(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#transform(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): BartTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): BartTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): BartTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): BartTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): BartTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): BartTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_object" : [{"label" : "loadSavedModel", "tail" : "(modelPath: String, spark: SparkSession, useCache: Boolean): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadBartTransformerDLModel.loadSavedModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#loadSavedModel(modelPath:String,spark:org.apache.spark.sql.SparkSession,useCache:Boolean):com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "readModel", "tail" : "(instance: BartTransformer, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadBartTransformerDLModel.readModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#readModel(instance:com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadBartTransformerDLModel.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#tfFile:String", "kind" : "val"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#pretrained():com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#defaultLang:String", "kind" : "val"}, {"label" : "read", "tail" : "(): MLReader[BartTransformer]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (BartTransformer, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): BartTransformer", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/BartTransformer.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "shortDescription" : "GPT-2: the OpenAI Text-To-Text Transformer", "object" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html", "members_class" : [{"label" : "onWrite", "tail" : "(path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.onWrite", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#onWrite(path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "batchAnnotate", "tail" : "(batchedAnnotations: Seq[Array[Annotation]]): Seq[Seq[Annotation]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.batchAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#batchAnnotate(batchedAnnotations:Seq[Array[com.johnsnowlabs.nlp.Annotation]]):Seq[Seq[com.johnsnowlabs.nlp.Annotation]]", "kind" : "def"}, {"label" : "getModelIfNotSet", "tail" : "(): GPT2", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getModelIfNotSet:com.johnsnowlabs.ml.ai.GPT2", "kind" : "def"}, {"label" : "setModelIfNotSet", "tail" : "(spark: SparkSession, tfWrapper: TensorflowWrapper): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setModelIfNotSet(spark:org.apache.spark.sql.SparkSession,tfWrapper:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "setMerges", "tail" : "(value: Map[(String, String), Int]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setMerges", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setMerges(value:Map[(String,String),Int]):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "merges", "tail" : ": MapFeature[(String, String), Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.merges", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#merges:com.johnsnowlabs.nlp.serialization.MapFeature[(String,String),Int]", "kind" : "val"}, {"label" : "setVocabulary", "tail" : "(value: Map[String, Int]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setVocabulary(value:Map[String,Int]):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "vocabulary", "tail" : ": MapFeature[String, Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.vocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#vocabulary:com.johnsnowlabs.nlp.serialization.MapFeature[String,Int]", "kind" : "val"}, {"label" : "getConfigProtoBytes", "tail" : "(): Option[Array[Byte]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getConfigProtoBytes:Option[Array[Byte]]", "kind" : "def"}, {"label" : "setConfigProtoBytes", "tail" : "(bytes: Array[Int]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setConfigProtoBytes(bytes:Array[Int]):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "configProtoBytes", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.configProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#configProtoBytes:org.apache.spark.ml.param.IntArrayParam", "kind" : "val"}, {"label" : "getIgnoreTokenIds", "tail" : "(): Array[Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getIgnoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getIgnoreTokenIds:Array[Int]", "kind" : "def"}, {"label" : "setIgnoreTokenIds", "tail" : "(tokenIds: Array[Int]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setIgnoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setIgnoreTokenIds(tokenIds:Array[Int]):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "ignoreTokenIds", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.ignoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#ignoreTokenIds:org.apache.spark.ml.param.IntArrayParam", "kind" : "var"}, {"label" : "getRandomSeed", "tail" : "(): Option[Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getRandomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getRandomSeed:Option[Int]", "kind" : "def"}, {"label" : "setRandomSeed", "tail" : "(value: Int): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setRandomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setRandomSeed(value:Int):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "randomSeed", "tail" : ": Option[Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.randomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#randomSeed:Option[Int]", "kind" : "var"}, {"label" : "getNoRepeatNgramSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getNoRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getNoRepeatNgramSize:Int", "kind" : "def"}, {"label" : "setNoRepeatNgramSize", "tail" : "(value: Int): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setNoRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setNoRepeatNgramSize(value:Int):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "noRepeatNgramSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.noRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#noRepeatNgramSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getRepetitionPenalty", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getRepetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getRepetitionPenalty:Double", "kind" : "def"}, {"label" : "setRepetitionPenalty", "tail" : "(value: Double): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setRepetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setRepetitionPenalty(value:Double):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "repetitionPenalty", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.repetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#repetitionPenalty:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getTopP", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getTopP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getTopP:Double", "kind" : "def"}, {"label" : "setTopP", "tail" : "(value: Double): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setTopP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setTopP(value:Double):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "topP", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.topP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#topP:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getTopK", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getTopK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getTopK:Int", "kind" : "def"}, {"label" : "setTopK", "tail" : "(value: Int): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setTopK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setTopK(value:Int):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "topK", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.topK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#topK:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getTemperature", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getTemperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getTemperature:Double", "kind" : "def"}, {"label" : "setTemperature", "tail" : "(value: Double): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setTemperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setTemperature(value:Double):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "temperature", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.temperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#temperature:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getDoSample", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getDoSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getDoSample:Boolean", "kind" : "def"}, {"label" : "setDoSample", "tail" : "(value: Boolean): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setDoSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setDoSample(value:Boolean):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "doSample", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.doSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#doSample:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "getMaxOutputLength", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getMaxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getMaxOutputLength:Int", "kind" : "def"}, {"label" : "setMaxOutputLength", "tail" : "(value: Int): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setMaxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setMaxOutputLength(value:Int):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "maxOutputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.maxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#maxOutputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getMinOutputLength", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.getMinOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getMinOutputLength:Int", "kind" : "def"}, {"label" : "setMinOutputLength", "tail" : "(value: Int): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setMinOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setMinOutputLength(value:Int):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "minOutputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.minOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#minOutputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setTask", "tail" : "(value: String): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.setTask", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setTask(value:String):GPT2Transformer.this.type", "kind" : "def"}, {"label" : "task", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.task", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#task:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "outputAnnotatorType", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#outputAnnotatorType:String", "kind" : "val"}, {"label" : "inputAnnotatorTypes", "tail" : ": Array[AnnotatorType]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#inputAnnotatorTypes:Array[GPT2Transformer.this.AnnotatorType]", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer#<init>", "error" : "unsupported entity"}, {"member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#uid:String", "kind" : "val"}, {"label" : "getEngine", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasEngine.getEngine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getEngine:String", "kind" : "def"}, {"label" : "engine", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasEngine.engine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#engine:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "writeTensorflowHub", "tail" : "(path: String, tfPath: String, spark: SparkSession, suffix: String): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#writeTensorflowHub(path:String,tfPath:String,spark:org.apache.spark.sql.SparkSession,suffix:String):Unit", "kind" : "def"}, {"label" : "writeTensorflowModelV2", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]], savedSignatures: Option[Map[String, String]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModelV2", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#writeTensorflowModelV2(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]],savedSignatures:Option[Map[String,String]]):Unit", "kind" : "def"}, {"label" : "writeTensorflowModel", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#writeTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]]):Unit", "kind" : "def"}, {"label" : "batchProcess", "tail" : "(rows: Iterator[_]): Iterator[Row]", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.batchProcess", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#batchProcess(rows:Iterator[_]):Iterator[org.apache.spark.sql.Row]", "kind" : "def"}, {"label" : "getBatchSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.getBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getBatchSize:Int", "kind" : "def"}, {"label" : "setBatchSize", "tail" : "(size: Int): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.setBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setBatchSize(size:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "batchSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.batchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#batchSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "transform", "tail" : "(dataset: Dataset[_]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#transform(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.DataFrame", "kind" : "final def"}, {"label" : "_transform", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel._transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#_transform(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "afterAnnotate", "tail" : "(dataset: DataFrame): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.afterAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#afterAnnotate(dataset:org.apache.spark.sql.DataFrame):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "beforeAnnotate", "tail" : "(dataset: Dataset[_]): Dataset[_]", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.beforeAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#beforeAnnotate(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "AnnotationContent", "tail" : "", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.AnnotationContent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#AnnotationContent=Seq[org.apache.spark.sql.Row]", "kind" : "type"}, {"label" : "getLazyAnnotator", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.CanBeLazy.getLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getLazyAnnotator:Boolean", "kind" : "def"}, {"label" : "setLazyAnnotator", "tail" : "(value: Boolean): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.CanBeLazy.setLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setLazyAnnotator(value:Boolean):<refinement>.type", "kind" : "def"}, {"label" : "lazyAnnotator", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.CanBeLazy.lazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#lazyAnnotator:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "copy", "tail" : "(extra: ParamMap): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.RawAnnotator.copy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#copy(extra:org.apache.spark.ml.param.ParamMap):M", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.RawAnnotator.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "final def"}, {"label" : "extraValidate", "tail" : "(structType: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#extraValidate(structType:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "extraValidateMsg", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidateMsg", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#extraValidateMsg:String", "kind" : "def"}, {"label" : "validate", "tail" : "(schema: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.validate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#validate(schema:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "wrapColumnMetadata", "tail" : "(col: Column): Column", "member" : "com.johnsnowlabs.nlp.RawAnnotator.wrapColumnMetadata", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#wrapColumnMetadata(col:org.apache.spark.sql.Column):org.apache.spark.sql.Column", "kind" : "def"}, {"label" : "getOutputCol", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.getOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getOutputCol:String", "kind" : "final def"}, {"label" : "setOutputCol", "tail" : "(value: String): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.setOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setOutputCol(value:String):HasOutputAnnotationCol.this.type", "kind" : "final def"}, {"label" : "outputCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.outputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#outputCol:org.apache.spark.ml.param.Param[String]", "kind" : "final val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setInputCols(value:String*):HasInputAnnotationCols.this.type", "kind" : "final def"}, {"label" : "checkSchema", "tail" : "(schema: StructType, inputAnnotatorType: String): Boolean", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.checkSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#checkSchema(schema:org.apache.spark.sql.types.StructType,inputAnnotatorType:String):Boolean", "kind" : "final def"}, {"label" : "msgHelper", "tail" : "(schema: StructType): String", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.msgHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#msgHelper(schema:org.apache.spark.sql.types.StructType):String", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setInputCols(value:Array[String]):HasInputAnnotationCols.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.inputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "final val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "AnnotatorType", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotatorType.AnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#AnnotatorType=String", "kind" : "type"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesWritable.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: StructFeature[T]): T", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):T", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: MapFeature[K, V]): Map[K, V]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#$$[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Map[K,V]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: SetFeature[T]): Set[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Set[T]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: ArrayFeature[T]): Array[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Array[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: StructFeature[T]): Option[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):Option[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: MapFeature[K, V]): Option[Map[K, V]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#get[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Option[Map[K,V]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: SetFeature[T]): Option[Set[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Option[Set[T]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: ArrayFeature[T]): Option[Array[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Option[Array[T]]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: StructFeature[T], value: () ⇒ T): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:()=>T):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: MapFeature[K, V], value: () ⇒ Map[K, V]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setDefault[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:()=>Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: SetFeature[T], value: () ⇒ Set[T]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:()=>Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: ArrayFeature[T], value: () ⇒ Array[T]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:()=>Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: StructFeature[T], value: T): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:T):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: MapFeature[K, V], value: Map[K, V]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#set[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: SetFeature[T], value: Set[T]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: ArrayFeature[T], value: Array[T]): GPT2Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "features", "tail" : ": ArrayBuffer[Feature[_, _, _]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.features", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#features:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.nlp.serialization.Feature[_,_,_]]", "kind" : "val"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#save(path:String):Unit", "kind" : "def"}, {"label" : "hasParent", "tail" : "(): Boolean", "member" : "org.apache.spark.ml.Model.hasParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#hasParent:Boolean", "kind" : "def"}, {"label" : "setParent", "tail" : "(parent: Estimator[GPT2Transformer]): GPT2Transformer", "member" : "org.apache.spark.ml.Model.setParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setParent(parent:org.apache.spark.ml.Estimator[M]):M", "kind" : "def"}, {"label" : "parent", "tail" : ": Estimator[GPT2Transformer]", "member" : "org.apache.spark.ml.Model.parent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#parent:org.apache.spark.ml.Estimator[M]", "kind" : "var"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#transform(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#transform(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): GPT2Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): GPT2Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): GPT2Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): GPT2Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): GPT2Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): GPT2Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_object" : [{"label" : "loadSavedModel", "tail" : "(modelPath: String, spark: SparkSession): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadGPT2TransformerDLModel.loadSavedModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#loadSavedModel(modelPath:String,spark:org.apache.spark.sql.SparkSession):com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "readModel", "tail" : "(instance: GPT2Transformer, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadGPT2TransformerDLModel.readModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#readModel(instance:com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadGPT2TransformerDLModel.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#tfFile:String", "kind" : "val"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#pretrained():com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#defaultLang:String", "kind" : "val"}, {"label" : "read", "tail" : "(): MLReader[GPT2Transformer]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (GPT2Transformer, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): GPT2Transformer", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/GPT2Transformer.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "shortDescription" : "MarianTransformer: Fast Neural Machine Translation", "object" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html", "members_class" : [{"label" : "ProtectedParam", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasProtectedParams.ProtectedParam", "link" : "com\/johnsnowlabs\/nlp\/HasProtectedParams.html#ProtectedParam[T]extendsParam[T]", "kind" : "implicit class"}, {"label" : "onWrite", "tail" : "(path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.onWrite", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#onWrite(path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "batchAnnotate", "tail" : "(batchedAnnotations: Seq[Array[Annotation]]): Seq[Seq[Annotation]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.batchAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#batchAnnotate(batchedAnnotations:Seq[Array[com.johnsnowlabs.nlp.Annotation]]):Seq[Seq[com.johnsnowlabs.nlp.Annotation]]", "kind" : "def"}, {"label" : "getVocabulary", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getVocabulary:Array[String]", "kind" : "def"}, {"label" : "getModelIfNotSet", "tail" : "(): MarianEncoderDecoder", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getModelIfNotSet:com.johnsnowlabs.ml.ai.seq2seq.MarianEncoderDecoder", "kind" : "def"}, {"label" : "setModelIfNotSet", "tail" : "(spark: SparkSession, encoder: OnnxWrapper, decoder: OnnxWrapper, sppSrc: SentencePieceWrapper, sppTrg: SentencePieceWrapper): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setModelIfNotSet(spark:org.apache.spark.sql.SparkSession,encoder:com.johnsnowlabs.ml.onnx.OnnxWrapper,decoder:com.johnsnowlabs.ml.onnx.OnnxWrapper,sppSrc:com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper,sppTrg:com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper):MarianTransformer.this.type", "kind" : "def"}, {"label" : "setModelIfNotSet", "tail" : "(spark: SparkSession, tensorflow: TensorflowWrapper, sppSrc: SentencePieceWrapper, sppTrg: SentencePieceWrapper): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setModelIfNotSet(spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,sppSrc:com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper,sppTrg:com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper):MarianTransformer.this.type", "kind" : "def"}, {"label" : "getRandomSeed", "tail" : "(): Option[Long]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getRandomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getRandomSeed:Option[Long]", "kind" : "def"}, {"label" : "setRandomSeed", "tail" : "(value: Long): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setRandomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setRandomSeed(value:Long):MarianTransformer.this.type", "kind" : "def"}, {"label" : "randomSeed", "tail" : ": Option[Long]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.randomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#randomSeed:Option[Long]", "kind" : "var"}, {"label" : "getNoRepeatNgramSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getNoRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getNoRepeatNgramSize:Int", "kind" : "def"}, {"label" : "setNoRepeatNgramSize", "tail" : "(value: Int): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setNoRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setNoRepeatNgramSize(value:Int):MarianTransformer.this.type", "kind" : "def"}, {"label" : "noRepeatNgramSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.noRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#noRepeatNgramSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getRepetitionPenalty", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getRepetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getRepetitionPenalty:Double", "kind" : "def"}, {"label" : "setRepetitionPenalty", "tail" : "(value: Double): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setRepetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setRepetitionPenalty(value:Double):MarianTransformer.this.type", "kind" : "def"}, {"label" : "repetitionPenalty", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.repetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#repetitionPenalty:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getTopP", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getTopP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getTopP:Double", "kind" : "def"}, {"label" : "setTopP", "tail" : "(value: Double): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setTopP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setTopP(value:Double):MarianTransformer.this.type", "kind" : "def"}, {"label" : "topP", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.topP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#topP:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getTopK", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getTopK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getTopK:Int", "kind" : "def"}, {"label" : "setTopK", "tail" : "(value: Int): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setTopK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setTopK(value:Int):MarianTransformer.this.type", "kind" : "def"}, {"label" : "topK", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.topK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#topK:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getTemperature", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getTemperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getTemperature:Double", "kind" : "def"}, {"label" : "setTemperature", "tail" : "(value: Double): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setTemperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setTemperature(value:Double):MarianTransformer.this.type", "kind" : "def"}, {"label" : "temperature", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.temperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#temperature:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getDoSample", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getDoSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getDoSample:Boolean", "kind" : "def"}, {"label" : "setDoSample", "tail" : "(value: Boolean): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setDoSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setDoSample(value:Boolean):MarianTransformer.this.type", "kind" : "def"}, {"label" : "doSample", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.doSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#doSample:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "getSignatures", "tail" : "(): Option[Map[String, String]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getSignatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getSignatures:Option[Map[String,String]]", "kind" : "def"}, {"label" : "setSignatures", "tail" : "(value: Map[String, String]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setSignatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setSignatures(value:Map[String,String]):MarianTransformer.this.type", "kind" : "def"}, {"label" : "signatures", "tail" : ": MapFeature[String, String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.signatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#signatures:com.johnsnowlabs.nlp.serialization.MapFeature[String,String]", "kind" : "val"}, {"label" : "getConfigProtoBytes", "tail" : "(): Option[Array[Byte]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getConfigProtoBytes:Option[Array[Byte]]", "kind" : "def"}, {"label" : "setConfigProtoBytes", "tail" : "(bytes: Array[Int]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setConfigProtoBytes(bytes:Array[Int]):MarianTransformer.this.type", "kind" : "def"}, {"label" : "configProtoBytes", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.configProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#configProtoBytes:org.apache.spark.ml.param.IntArrayParam", "kind" : "val"}, {"label" : "getIgnoreTokenIds", "tail" : "(): Array[Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getIgnoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getIgnoreTokenIds:Array[Int]", "kind" : "def"}, {"label" : "setIgnoreTokenIds", "tail" : "(tokenIds: Array[Int]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setIgnoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setIgnoreTokenIds(tokenIds:Array[Int]):MarianTransformer.this.type", "kind" : "def"}, {"label" : "ignoreTokenIds", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.ignoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#ignoreTokenIds:org.apache.spark.ml.param.IntArrayParam", "kind" : "var"}, {"label" : "getLangId", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getLangId", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getLangId:String", "kind" : "def"}, {"label" : "setLangId", "tail" : "(lang: String): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setLangId", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setLangId(lang:String):MarianTransformer.this.type", "kind" : "def"}, {"label" : "langId", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.langId", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#langId:org.apache.spark.ml.param.Param[String]", "kind" : "var"}, {"label" : "getMaxOutputLength", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getMaxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getMaxOutputLength:Int", "kind" : "def"}, {"label" : "setMaxOutputLength", "tail" : "(value: Int): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setMaxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setMaxOutputLength(value:Int):MarianTransformer.this.type", "kind" : "def"}, {"label" : "maxOutputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.maxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#maxOutputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getMaxInputLength", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.getMaxInputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getMaxInputLength:Int", "kind" : "def"}, {"label" : "setMaxInputLength", "tail" : "(value: Int): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setMaxInputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setMaxInputLength(value:Int):MarianTransformer.this.type", "kind" : "def"}, {"label" : "maxInputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.maxInputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#maxInputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "setVocabulary", "tail" : "(value: Array[String]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.setVocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setVocabulary(value:Array[String]):MarianTransformer.this.type", "kind" : "def"}, {"label" : "vocabulary", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.vocabulary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#vocabulary:org.apache.spark.ml.param.StringArrayParam", "kind" : "val"}, {"label" : "outputAnnotatorType", "tail" : ": AnnotatorType", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#outputAnnotatorType:MarianTransformer.this.AnnotatorType", "kind" : "val"}, {"label" : "inputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#inputAnnotatorTypes:Array[String]", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer#<init>", "error" : "unsupported entity"}, {"member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#uid:String", "kind" : "val"}, {"label" : "set", "tail" : "(param: ProtectedParam[T], value: T): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasProtectedParams.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#set[T](param:HasProtectedParams.this.ProtectedParam[T],value:T):<refinement>.type", "kind" : "def"}, {"label" : "getEngine", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasEngine.getEngine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getEngine:String", "kind" : "def"}, {"label" : "engine", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasEngine.engine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#engine:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "writeSentencePieceModel", "tail" : "(path: String, spark: SparkSession, spp: SentencePieceWrapper, suffix: String, filename: String): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.sentencepiece.WriteSentencePieceModel.writeSentencePieceModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#writeSentencePieceModel(path:String,spark:org.apache.spark.sql.SparkSession,spp:com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper,suffix:String,filename:String):Unit", "kind" : "def"}, {"label" : "writeOnnxModel", "tail" : "(path: String, spark: SparkSession, onnxWrapper: OnnxWrapper, suffix: String, fileName: String): Unit", "member" : "com.johnsnowlabs.ml.onnx.WriteOnnxModel.writeOnnxModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#writeOnnxModel(path:String,spark:org.apache.spark.sql.SparkSession,onnxWrapper:com.johnsnowlabs.ml.onnx.OnnxWrapper,suffix:String,fileName:String):Unit", "kind" : "def"}, {"label" : "writeOnnxModels", "tail" : "(path: String, spark: SparkSession, onnxWrappersWithNames: Seq[(OnnxWrapper, String)], suffix: String): Unit", "member" : "com.johnsnowlabs.ml.onnx.WriteOnnxModel.writeOnnxModels", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#writeOnnxModels(path:String,spark:org.apache.spark.sql.SparkSession,onnxWrappersWithNames:Seq[(com.johnsnowlabs.ml.onnx.OnnxWrapper,String)],suffix:String):Unit", "kind" : "def"}, {"label" : "writeTensorflowHub", "tail" : "(path: String, tfPath: String, spark: SparkSession, suffix: String): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#writeTensorflowHub(path:String,tfPath:String,spark:org.apache.spark.sql.SparkSession,suffix:String):Unit", "kind" : "def"}, {"label" : "writeTensorflowModelV2", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]], savedSignatures: Option[Map[String, String]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModelV2", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#writeTensorflowModelV2(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]],savedSignatures:Option[Map[String,String]]):Unit", "kind" : "def"}, {"label" : "writeTensorflowModel", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#writeTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]]):Unit", "kind" : "def"}, {"label" : "batchProcess", "tail" : "(rows: Iterator[_]): Iterator[Row]", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.batchProcess", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#batchProcess(rows:Iterator[_]):Iterator[org.apache.spark.sql.Row]", "kind" : "def"}, {"label" : "getBatchSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.getBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getBatchSize:Int", "kind" : "def"}, {"label" : "setBatchSize", "tail" : "(size: Int): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.setBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setBatchSize(size:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "batchSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.batchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#batchSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "transform", "tail" : "(dataset: Dataset[_]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#transform(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.DataFrame", "kind" : "final def"}, {"label" : "_transform", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel._transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#_transform(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "afterAnnotate", "tail" : "(dataset: DataFrame): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.afterAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#afterAnnotate(dataset:org.apache.spark.sql.DataFrame):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "beforeAnnotate", "tail" : "(dataset: Dataset[_]): Dataset[_]", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.beforeAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#beforeAnnotate(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "AnnotationContent", "tail" : "", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.AnnotationContent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#AnnotationContent=Seq[org.apache.spark.sql.Row]", "kind" : "type"}, {"label" : "getLazyAnnotator", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.CanBeLazy.getLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getLazyAnnotator:Boolean", "kind" : "def"}, {"label" : "setLazyAnnotator", "tail" : "(value: Boolean): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.CanBeLazy.setLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setLazyAnnotator(value:Boolean):<refinement>.type", "kind" : "def"}, {"label" : "lazyAnnotator", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.CanBeLazy.lazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#lazyAnnotator:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "copy", "tail" : "(extra: ParamMap): MarianTransformer", "member" : "com.johnsnowlabs.nlp.RawAnnotator.copy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#copy(extra:org.apache.spark.ml.param.ParamMap):M", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.RawAnnotator.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "final def"}, {"label" : "extraValidate", "tail" : "(structType: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#extraValidate(structType:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "extraValidateMsg", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidateMsg", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#extraValidateMsg:String", "kind" : "def"}, {"label" : "validate", "tail" : "(schema: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.validate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#validate(schema:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "wrapColumnMetadata", "tail" : "(col: Column): Column", "member" : "com.johnsnowlabs.nlp.RawAnnotator.wrapColumnMetadata", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#wrapColumnMetadata(col:org.apache.spark.sql.Column):org.apache.spark.sql.Column", "kind" : "def"}, {"label" : "getOutputCol", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.getOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getOutputCol:String", "kind" : "final def"}, {"label" : "setOutputCol", "tail" : "(value: String): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.setOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setOutputCol(value:String):HasOutputAnnotationCol.this.type", "kind" : "final def"}, {"label" : "outputCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.outputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#outputCol:org.apache.spark.ml.param.Param[String]", "kind" : "final val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setInputCols(value:String*):HasInputAnnotationCols.this.type", "kind" : "final def"}, {"label" : "checkSchema", "tail" : "(schema: StructType, inputAnnotatorType: String): Boolean", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.checkSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#checkSchema(schema:org.apache.spark.sql.types.StructType,inputAnnotatorType:String):Boolean", "kind" : "final def"}, {"label" : "msgHelper", "tail" : "(schema: StructType): String", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.msgHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#msgHelper(schema:org.apache.spark.sql.types.StructType):String", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setInputCols(value:Array[String]):HasInputAnnotationCols.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.inputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "final val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "AnnotatorType", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotatorType.AnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#AnnotatorType=String", "kind" : "type"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesWritable.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: StructFeature[T]): T", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):T", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: MapFeature[K, V]): Map[K, V]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#$$[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Map[K,V]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: SetFeature[T]): Set[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Set[T]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: ArrayFeature[T]): Array[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Array[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: StructFeature[T]): Option[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):Option[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: MapFeature[K, V]): Option[Map[K, V]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#get[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Option[Map[K,V]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: SetFeature[T]): Option[Set[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Option[Set[T]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: ArrayFeature[T]): Option[Array[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Option[Array[T]]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: StructFeature[T], value: () ⇒ T): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:()=>T):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: MapFeature[K, V], value: () ⇒ Map[K, V]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setDefault[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:()=>Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: SetFeature[T], value: () ⇒ Set[T]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:()=>Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: ArrayFeature[T], value: () ⇒ Array[T]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:()=>Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: StructFeature[T], value: T): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:T):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: MapFeature[K, V], value: Map[K, V]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#set[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: SetFeature[T], value: Set[T]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: ArrayFeature[T], value: Array[T]): MarianTransformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "features", "tail" : ": ArrayBuffer[Feature[_, _, _]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.features", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#features:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.nlp.serialization.Feature[_,_,_]]", "kind" : "val"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#save(path:String):Unit", "kind" : "def"}, {"label" : "hasParent", "tail" : "(): Boolean", "member" : "org.apache.spark.ml.Model.hasParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#hasParent:Boolean", "kind" : "def"}, {"label" : "setParent", "tail" : "(parent: Estimator[MarianTransformer]): MarianTransformer", "member" : "org.apache.spark.ml.Model.setParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setParent(parent:org.apache.spark.ml.Estimator[M]):M", "kind" : "def"}, {"label" : "parent", "tail" : ": Estimator[MarianTransformer]", "member" : "org.apache.spark.ml.Model.parent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#parent:org.apache.spark.ml.Estimator[M]", "kind" : "var"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#transform(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#transform(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): MarianTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): MarianTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): MarianTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): MarianTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): MarianTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): MarianTransformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_object" : [{"label" : "loadSavedModel", "tail" : "(modelPath: String, spark: SparkSession): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.loadSavedModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#loadSavedModel(modelPath:String,spark:org.apache.spark.sql.SparkSession):com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "readModel", "tail" : "(instance: MarianTransformer, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.readModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#readModel(instance:com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "onnxFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.onnxFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#onnxFile:String", "kind" : "val"}, {"label" : "onnxDecoderFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.onnxDecoderFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#onnxDecoderFile:String", "kind" : "val"}, {"label" : "onnxEncoderFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.onnxEncoderFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#onnxEncoderFile:String", "kind" : "val"}, {"label" : "sppFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.sppFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#sppFile:String", "kind" : "val"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#tfFile:String", "kind" : "val"}, {"label" : "readOnnxModels", "tail" : "(path: String, spark: SparkSession, modelNames: Seq[String], suffix: String, zipped: Boolean, useBundle: Boolean): Map[String, OnnxWrapper]", "member" : "com.johnsnowlabs.ml.onnx.ReadOnnxModel.readOnnxModels", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#readOnnxModels(path:String,spark:org.apache.spark.sql.SparkSession,modelNames:Seq[String],suffix:String,zipped:Boolean,useBundle:Boolean):Map[String,com.johnsnowlabs.ml.onnx.OnnxWrapper]", "kind" : "def"}, {"label" : "readOnnxModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, sessionOptions: Option[SessionOptions]): OnnxWrapper", "member" : "com.johnsnowlabs.ml.onnx.ReadOnnxModel.readOnnxModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#readOnnxModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,sessionOptions:Option[ai.onnxruntime.OrtSession.SessionOptions]):com.johnsnowlabs.ml.onnx.OnnxWrapper", "kind" : "def"}, {"label" : "readSentencePieceModel", "tail" : "(path: String, spark: SparkSession, suffix: String, filename: String): SentencePieceWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.sentencepiece.ReadSentencePieceModel.readSentencePieceModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#readSentencePieceModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,filename:String):com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper", "kind" : "def"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#pretrained():com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#defaultLang:String", "kind" : "val"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "read", "tail" : "(): MLReader[MarianTransformer]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (MarianTransformer, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): MarianTransformer", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/MarianTransformer.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel", "members_trait" : [{"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#pretrained():com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedBartTransformerModel.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#defaultLang:String", "kind" : "val"}, {"label" : "read", "tail" : "(): MLReader[BartTransformer]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (BartTransformer, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): BartTransformer", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedBartTransformerModel.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel", "members_trait" : [{"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#pretrained():com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedGPT2TransformerModel.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#defaultLang:String", "kind" : "val"}, {"label" : "read", "tail" : "(): MLReader[GPT2Transformer]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (GPT2Transformer, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): GPT2Transformer", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedGPT2TransformerModel.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel", "members_trait" : [{"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#pretrained():com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#defaultLang:String", "kind" : "val"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedMarianMTModel.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "read", "tail" : "(): MLReader[MarianTransformer]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (MarianTransformer, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): MarianTransformer", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedMarianMTModel.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel", "members_trait" : [{"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#pretrained():com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#defaultLang:String", "kind" : "val"}, {"label" : "read", "tail" : "(): MLReader[T5Transformer]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (T5Transformer, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): T5Transformer", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadablePretrainedT5TransformerModel.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadBartTransformerDLModel", "members_trait" : [{"label" : "loadSavedModel", "tail" : "(modelPath: String, spark: SparkSession, useCache: Boolean): BartTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadBartTransformerDLModel.loadSavedModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#loadSavedModel(modelPath:String,spark:org.apache.spark.sql.SparkSession,useCache:Boolean):com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer", "kind" : "def"}, {"label" : "readModel", "tail" : "(instance: BartTransformer, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadBartTransformerDLModel.readModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#readModel(instance:com.johnsnowlabs.nlp.annotators.seq2seq.BartTransformer,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadBartTransformerDLModel.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#tfFile:String", "kind" : "val"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadBartTransformerDLModel.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadGPT2TransformerDLModel", "members_trait" : [{"label" : "loadSavedModel", "tail" : "(modelPath: String, spark: SparkSession): GPT2Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadGPT2TransformerDLModel.loadSavedModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#loadSavedModel(modelPath:String,spark:org.apache.spark.sql.SparkSession):com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer", "kind" : "def"}, {"label" : "readModel", "tail" : "(instance: GPT2Transformer, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadGPT2TransformerDLModel.readModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#readModel(instance:com.johnsnowlabs.nlp.annotators.seq2seq.GPT2Transformer,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadGPT2TransformerDLModel.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#tfFile:String", "kind" : "val"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadGPT2TransformerDLModel.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel", "members_trait" : [{"label" : "loadSavedModel", "tail" : "(modelPath: String, spark: SparkSession): MarianTransformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.loadSavedModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#loadSavedModel(modelPath:String,spark:org.apache.spark.sql.SparkSession):com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer", "kind" : "def"}, {"label" : "readModel", "tail" : "(instance: MarianTransformer, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.readModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#readModel(instance:com.johnsnowlabs.nlp.annotators.seq2seq.MarianTransformer,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "onnxFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.onnxFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#onnxFile:String", "kind" : "val"}, {"label" : "onnxDecoderFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.onnxDecoderFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#onnxDecoderFile:String", "kind" : "val"}, {"label" : "onnxEncoderFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.onnxEncoderFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#onnxEncoderFile:String", "kind" : "val"}, {"label" : "sppFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.sppFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#sppFile:String", "kind" : "val"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadMarianMTDLModel.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#tfFile:String", "kind" : "val"}, {"label" : "readOnnxModels", "tail" : "(path: String, spark: SparkSession, modelNames: Seq[String], suffix: String, zipped: Boolean, useBundle: Boolean): Map[String, OnnxWrapper]", "member" : "com.johnsnowlabs.ml.onnx.ReadOnnxModel.readOnnxModels", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#readOnnxModels(path:String,spark:org.apache.spark.sql.SparkSession,modelNames:Seq[String],suffix:String,zipped:Boolean,useBundle:Boolean):Map[String,com.johnsnowlabs.ml.onnx.OnnxWrapper]", "kind" : "def"}, {"label" : "readOnnxModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, sessionOptions: Option[SessionOptions]): OnnxWrapper", "member" : "com.johnsnowlabs.ml.onnx.ReadOnnxModel.readOnnxModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#readOnnxModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,sessionOptions:Option[ai.onnxruntime.OrtSession.SessionOptions]):com.johnsnowlabs.ml.onnx.OnnxWrapper", "kind" : "def"}, {"label" : "readSentencePieceModel", "tail" : "(path: String, spark: SparkSession, suffix: String, filename: String): SentencePieceWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.sentencepiece.ReadSentencePieceModel.readSentencePieceModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#readSentencePieceModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,filename:String):com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper", "kind" : "def"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadMarianMTDLModel.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel", "members_trait" : [{"label" : "loadSavedModel", "tail" : "(modelPath: String, spark: SparkSession): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.loadSavedModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#loadSavedModel(modelPath:String,spark:org.apache.spark.sql.SparkSession):com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "readModel", "tail" : "(instance: T5Transformer, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.readModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#readModel(instance:com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "onnxFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.onnxFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#onnxFile:String", "kind" : "val"}, {"label" : "onnxDecoderFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.onnxDecoderFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#onnxDecoderFile:String", "kind" : "val"}, {"label" : "onnxEncoderFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.onnxEncoderFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#onnxEncoderFile:String", "kind" : "val"}, {"label" : "sppFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.sppFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#sppFile:String", "kind" : "val"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#tfFile:String", "kind" : "val"}, {"label" : "readOnnxModels", "tail" : "(path: String, spark: SparkSession, modelNames: Seq[String], suffix: String, zipped: Boolean, useBundle: Boolean): Map[String, OnnxWrapper]", "member" : "com.johnsnowlabs.ml.onnx.ReadOnnxModel.readOnnxModels", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#readOnnxModels(path:String,spark:org.apache.spark.sql.SparkSession,modelNames:Seq[String],suffix:String,zipped:Boolean,useBundle:Boolean):Map[String,com.johnsnowlabs.ml.onnx.OnnxWrapper]", "kind" : "def"}, {"label" : "readOnnxModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, sessionOptions: Option[SessionOptions]): OnnxWrapper", "member" : "com.johnsnowlabs.ml.onnx.ReadOnnxModel.readOnnxModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#readOnnxModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,sessionOptions:Option[ai.onnxruntime.OrtSession.SessionOptions]):com.johnsnowlabs.ml.onnx.OnnxWrapper", "kind" : "def"}, {"label" : "readSentencePieceModel", "tail" : "(path: String, spark: SparkSession, suffix: String, filename: String): SentencePieceWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.sentencepiece.ReadSentencePieceModel.readSentencePieceModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#readSentencePieceModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,filename:String):com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper", "kind" : "def"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "shortDescription" : "", "trait" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/ReadT5TransformerDLModel.html", "kind" : "trait"}, {"name" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "shortDescription" : "T5: the Text-To-Text Transfer Transformer", "object" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html", "members_class" : [{"label" : "ProtectedParam", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasProtectedParams.ProtectedParam", "link" : "com\/johnsnowlabs\/nlp\/HasProtectedParams.html#ProtectedParam[T]extendsParam[T]", "kind" : "implicit class"}, {"label" : "onWrite", "tail" : "(path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.onWrite", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#onWrite(path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "batchAnnotate", "tail" : "(batchedAnnotations: Seq[Array[Annotation]]): Seq[Seq[Annotation]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.batchAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#batchAnnotate(batchedAnnotations:Seq[Array[com.johnsnowlabs.nlp.Annotation]]):Seq[Seq[com.johnsnowlabs.nlp.Annotation]]", "kind" : "def"}, {"label" : "getModelIfNotSet", "tail" : "(): T5EncoderDecoder", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getModelIfNotSet:com.johnsnowlabs.ml.ai.seq2seq.T5EncoderDecoder", "kind" : "def"}, {"label" : "setModelIfNotSet", "tail" : "(spark: SparkSession, encoder: OnnxWrapper, decoder: OnnxWrapper, spp: SentencePieceWrapper): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setModelIfNotSet(spark:org.apache.spark.sql.SparkSession,encoder:com.johnsnowlabs.ml.onnx.OnnxWrapper,decoder:com.johnsnowlabs.ml.onnx.OnnxWrapper,spp:com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper):T5Transformer.this.type", "kind" : "def"}, {"label" : "setModelIfNotSet", "tail" : "(spark: SparkSession, tfWrapper: TensorflowWrapper, spp: SentencePieceWrapper, useCache: Boolean): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setModelIfNotSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setModelIfNotSet(spark:org.apache.spark.sql.SparkSession,tfWrapper:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,spp:com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper,useCache:Boolean):T5Transformer.this.type", "kind" : "def"}, {"label" : "getSignatures", "tail" : "(): Option[Map[String, String]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getSignatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getSignatures:Option[Map[String,String]]", "kind" : "def"}, {"label" : "setSignatures", "tail" : "(value: Map[String, String]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setSignatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setSignatures(value:Map[String,String]):T5Transformer.this.type", "kind" : "def"}, {"label" : "signatures", "tail" : ": MapFeature[String, String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.signatures", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#signatures:com.johnsnowlabs.nlp.serialization.MapFeature[String,String]", "kind" : "val"}, {"label" : "getConfigProtoBytes", "tail" : "(): Option[Array[Byte]]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getConfigProtoBytes:Option[Array[Byte]]", "kind" : "def"}, {"label" : "setConfigProtoBytes", "tail" : "(bytes: Array[Int]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setConfigProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setConfigProtoBytes(bytes:Array[Int]):T5Transformer.this.type", "kind" : "def"}, {"label" : "configProtoBytes", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.configProtoBytes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#configProtoBytes:org.apache.spark.ml.param.IntArrayParam", "kind" : "val"}, {"label" : "getIgnoreTokenIds", "tail" : "(): Array[Int]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getIgnoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getIgnoreTokenIds:Array[Int]", "kind" : "def"}, {"label" : "setIgnoreTokenIds", "tail" : "(tokenIds: Array[Int]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setIgnoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setIgnoreTokenIds(tokenIds:Array[Int]):T5Transformer.this.type", "kind" : "def"}, {"label" : "ignoreTokenIds", "tail" : ": IntArrayParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.ignoreTokenIds", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#ignoreTokenIds:org.apache.spark.ml.param.IntArrayParam", "kind" : "var"}, {"label" : "getRandomSeed", "tail" : "(): Option[Long]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getRandomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getRandomSeed:Option[Long]", "kind" : "def"}, {"label" : "setRandomSeed", "tail" : "(value: Long): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setRandomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setRandomSeed(value:Long):T5Transformer.this.type", "kind" : "def"}, {"label" : "randomSeed", "tail" : ": Option[Long]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.randomSeed", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#randomSeed:Option[Long]", "kind" : "var"}, {"label" : "getNoRepeatNgramSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getNoRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getNoRepeatNgramSize:Int", "kind" : "def"}, {"label" : "setNoRepeatNgramSize", "tail" : "(value: Int): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setNoRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setNoRepeatNgramSize(value:Int):T5Transformer.this.type", "kind" : "def"}, {"label" : "noRepeatNgramSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.noRepeatNgramSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#noRepeatNgramSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getRepetitionPenalty", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getRepetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getRepetitionPenalty:Double", "kind" : "def"}, {"label" : "setRepetitionPenalty", "tail" : "(value: Double): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setRepetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setRepetitionPenalty(value:Double):T5Transformer.this.type", "kind" : "def"}, {"label" : "repetitionPenalty", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.repetitionPenalty", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#repetitionPenalty:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getTopP", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getTopP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getTopP:Double", "kind" : "def"}, {"label" : "setTopP", "tail" : "(value: Double): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setTopP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setTopP(value:Double):T5Transformer.this.type", "kind" : "def"}, {"label" : "topP", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.topP", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#topP:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getTopK", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getTopK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getTopK:Int", "kind" : "def"}, {"label" : "setTopK", "tail" : "(value: Int): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setTopK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setTopK(value:Int):T5Transformer.this.type", "kind" : "def"}, {"label" : "topK", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.topK", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#topK:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getTemperature", "tail" : "(): Double", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getTemperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getTemperature:Double", "kind" : "def"}, {"label" : "setTemperature", "tail" : "(value: Double): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setTemperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setTemperature(value:Double):T5Transformer.this.type", "kind" : "def"}, {"label" : "temperature", "tail" : ": DoubleParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.temperature", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#temperature:org.apache.spark.ml.param.DoubleParam", "kind" : "val"}, {"label" : "getDoSample", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getDoSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getDoSample:Boolean", "kind" : "def"}, {"label" : "setDoSample", "tail" : "(value: Boolean): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setDoSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setDoSample(value:Boolean):T5Transformer.this.type", "kind" : "def"}, {"label" : "doSample", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.doSample", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#doSample:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "getMaxNewTokens", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getMaxNewTokens", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getMaxNewTokens:Int", "kind" : "def"}, {"label" : "setMaxNewTokens", "tail" : "(value: Int): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setMaxNewTokens", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setMaxNewTokens(value:Int):T5Transformer.this.type", "kind" : "def"}, {"label" : "maxNewTokens", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.maxNewTokens", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#maxNewTokens:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getMaxOutputLength", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getMaxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getMaxOutputLength:Int", "kind" : "def"}, {"label" : "setMaxOutputLength", "tail" : "(value: Int): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setMaxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setMaxOutputLength(value:Int):T5Transformer.this.type", "kind" : "def"}, {"label" : "maxOutputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.maxOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#maxOutputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getMinOutputLength", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getMinOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getMinOutputLength:Int", "kind" : "def"}, {"label" : "setMinOutputLength", "tail" : "(value: Int): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setMinOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setMinOutputLength(value:Int):T5Transformer.this.type", "kind" : "def"}, {"label" : "minOutputLength", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.minOutputLength", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#minOutputLength:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "getStopAtEos", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.getStopAtEos", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getStopAtEos:Boolean", "kind" : "def"}, {"label" : "setStopAtEos", "tail" : "(value: Boolean): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setStopAtEos", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setStopAtEos(value:Boolean):T5Transformer.this.type", "kind" : "def"}, {"label" : "stopAtEos", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.stopAtEos", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#stopAtEos:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "setTask", "tail" : "(value: String): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.setTask", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setTask(value:String):T5Transformer.this.type", "kind" : "def"}, {"label" : "task", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.task", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#task:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "outputAnnotatorType", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#outputAnnotatorType:String", "kind" : "val"}, {"label" : "inputAnnotatorTypes", "tail" : ": Array[AnnotatorType]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#inputAnnotatorTypes:Array[T5Transformer.this.AnnotatorType]", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer#<init>", "error" : "unsupported entity"}, {"member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#uid:String", "kind" : "val"}, {"label" : "getEngine", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasEngine.getEngine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getEngine:String", "kind" : "def"}, {"label" : "engine", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasEngine.engine", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#engine:org.apache.spark.ml.param.Param[String]", "kind" : "val"}, {"label" : "set", "tail" : "(param: ProtectedParam[T], value: T): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasProtectedParams.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#set[T](param:HasProtectedParams.this.ProtectedParam[T],value:T):<refinement>.type", "kind" : "def"}, {"label" : "writeSentencePieceModel", "tail" : "(path: String, spark: SparkSession, spp: SentencePieceWrapper, suffix: String, filename: String): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.sentencepiece.WriteSentencePieceModel.writeSentencePieceModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#writeSentencePieceModel(path:String,spark:org.apache.spark.sql.SparkSession,spp:com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper,suffix:String,filename:String):Unit", "kind" : "def"}, {"label" : "setCaseSensitive", "tail" : "(value: Boolean): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasCaseSensitiveProperties.setCaseSensitive", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setCaseSensitive(value:Boolean):HasCaseSensitiveProperties.this.type", "kind" : "def"}, {"label" : "getCaseSensitive", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.HasCaseSensitiveProperties.getCaseSensitive", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getCaseSensitive:Boolean", "kind" : "def"}, {"label" : "caseSensitive", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.HasCaseSensitiveProperties.caseSensitive", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#caseSensitive:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "writeOnnxModel", "tail" : "(path: String, spark: SparkSession, onnxWrapper: OnnxWrapper, suffix: String, fileName: String): Unit", "member" : "com.johnsnowlabs.ml.onnx.WriteOnnxModel.writeOnnxModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#writeOnnxModel(path:String,spark:org.apache.spark.sql.SparkSession,onnxWrapper:com.johnsnowlabs.ml.onnx.OnnxWrapper,suffix:String,fileName:String):Unit", "kind" : "def"}, {"label" : "writeOnnxModels", "tail" : "(path: String, spark: SparkSession, onnxWrappersWithNames: Seq[(OnnxWrapper, String)], suffix: String): Unit", "member" : "com.johnsnowlabs.ml.onnx.WriteOnnxModel.writeOnnxModels", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#writeOnnxModels(path:String,spark:org.apache.spark.sql.SparkSession,onnxWrappersWithNames:Seq[(com.johnsnowlabs.ml.onnx.OnnxWrapper,String)],suffix:String):Unit", "kind" : "def"}, {"label" : "writeTensorflowHub", "tail" : "(path: String, tfPath: String, spark: SparkSession, suffix: String): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#writeTensorflowHub(path:String,tfPath:String,spark:org.apache.spark.sql.SparkSession,suffix:String):Unit", "kind" : "def"}, {"label" : "writeTensorflowModelV2", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]], savedSignatures: Option[Map[String, String]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModelV2", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#writeTensorflowModelV2(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]],savedSignatures:Option[Map[String,String]]):Unit", "kind" : "def"}, {"label" : "writeTensorflowModel", "tail" : "(path: String, spark: SparkSession, tensorflow: TensorflowWrapper, suffix: String, filename: String, configProtoBytes: Option[Array[Byte]]): Unit", "member" : "com.johnsnowlabs.ml.tensorflow.WriteTensorflowModel.writeTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#writeTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,tensorflow:com.johnsnowlabs.ml.tensorflow.TensorflowWrapper,suffix:String,filename:String,configProtoBytes:Option[Array[Byte]]):Unit", "kind" : "def"}, {"label" : "batchProcess", "tail" : "(rows: Iterator[_]): Iterator[Row]", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.batchProcess", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#batchProcess(rows:Iterator[_]):Iterator[org.apache.spark.sql.Row]", "kind" : "def"}, {"label" : "getBatchSize", "tail" : "(): Int", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.getBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getBatchSize:Int", "kind" : "def"}, {"label" : "setBatchSize", "tail" : "(size: Int): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.setBatchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setBatchSize(size:Int):com.johnsnowlabs.nlp.<refinement>.type", "kind" : "def"}, {"label" : "batchSize", "tail" : ": IntParam", "member" : "com.johnsnowlabs.nlp.HasBatchedAnnotate.batchSize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#batchSize:org.apache.spark.ml.param.IntParam", "kind" : "val"}, {"label" : "transform", "tail" : "(dataset: Dataset[_]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#transform(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.DataFrame", "kind" : "final def"}, {"label" : "_transform", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel._transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#_transform(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "afterAnnotate", "tail" : "(dataset: DataFrame): DataFrame", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.afterAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#afterAnnotate(dataset:org.apache.spark.sql.DataFrame):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "beforeAnnotate", "tail" : "(dataset: Dataset[_]): Dataset[_]", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.beforeAnnotate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#beforeAnnotate(dataset:org.apache.spark.sql.Dataset[_]):org.apache.spark.sql.Dataset[_]", "kind" : "def"}, {"label" : "AnnotationContent", "tail" : "", "member" : "com.johnsnowlabs.nlp.AnnotatorModel.AnnotationContent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#AnnotationContent=Seq[org.apache.spark.sql.Row]", "kind" : "type"}, {"label" : "getLazyAnnotator", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.CanBeLazy.getLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getLazyAnnotator:Boolean", "kind" : "def"}, {"label" : "setLazyAnnotator", "tail" : "(value: Boolean): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.CanBeLazy.setLazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setLazyAnnotator(value:Boolean):<refinement>.type", "kind" : "def"}, {"label" : "lazyAnnotator", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.CanBeLazy.lazyAnnotator", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#lazyAnnotator:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "copy", "tail" : "(extra: ParamMap): T5Transformer", "member" : "com.johnsnowlabs.nlp.RawAnnotator.copy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#copy(extra:org.apache.spark.ml.param.ParamMap):M", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType): StructType", "member" : "com.johnsnowlabs.nlp.RawAnnotator.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#transformSchema(schema:org.apache.spark.sql.types.StructType):org.apache.spark.sql.types.StructType", "kind" : "final def"}, {"label" : "extraValidate", "tail" : "(structType: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#extraValidate(structType:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "extraValidateMsg", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.RawAnnotator.extraValidateMsg", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#extraValidateMsg:String", "kind" : "def"}, {"label" : "validate", "tail" : "(schema: StructType): Boolean", "member" : "com.johnsnowlabs.nlp.RawAnnotator.validate", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#validate(schema:org.apache.spark.sql.types.StructType):Boolean", "kind" : "def"}, {"label" : "wrapColumnMetadata", "tail" : "(col: Column): Column", "member" : "com.johnsnowlabs.nlp.RawAnnotator.wrapColumnMetadata", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#wrapColumnMetadata(col:org.apache.spark.sql.Column):org.apache.spark.sql.Column", "kind" : "def"}, {"label" : "getOutputCol", "tail" : "(): String", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.getOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getOutputCol:String", "kind" : "final def"}, {"label" : "setOutputCol", "tail" : "(value: String): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.setOutputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setOutputCol(value:String):HasOutputAnnotationCol.this.type", "kind" : "final def"}, {"label" : "outputCol", "tail" : ": Param[String]", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotationCol.outputCol", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#outputCol:org.apache.spark.ml.param.Param[String]", "kind" : "final val"}, {"label" : "getInputCols", "tail" : "(): Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.getInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getInputCols:Array[String]", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: String*): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setInputCols(value:String*):HasInputAnnotationCols.this.type", "kind" : "final def"}, {"label" : "checkSchema", "tail" : "(schema: StructType, inputAnnotatorType: String): Boolean", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.checkSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#checkSchema(schema:org.apache.spark.sql.types.StructType,inputAnnotatorType:String):Boolean", "kind" : "final def"}, {"label" : "msgHelper", "tail" : "(schema: StructType): String", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.msgHelper", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#msgHelper(schema:org.apache.spark.sql.types.StructType):String", "kind" : "def"}, {"label" : "setInputCols", "tail" : "(value: Array[String]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.setInputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setInputCols(value:Array[String]):HasInputAnnotationCols.this.type", "kind" : "def"}, {"label" : "inputCols", "tail" : ": StringArrayParam", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.inputCols", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#inputCols:org.apache.spark.ml.param.StringArrayParam", "kind" : "final val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.HasInputAnnotationCols.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "AnnotatorType", "tail" : "", "member" : "com.johnsnowlabs.nlp.HasOutputAnnotatorType.AnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#AnnotatorType=String", "kind" : "type"}, {"label" : "write", "tail" : "(): MLWriter", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesWritable.write", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#write:org.apache.spark.ml.util.MLWriter", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: StructFeature[T]): T", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):T", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: MapFeature[K, V]): Map[K, V]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#$$[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Map[K,V]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: SetFeature[T]): Set[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Set[T]", "kind" : "def"}, {"label" : "$$", "tail" : "(feature: ArrayFeature[T]): Array[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.$$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#$$[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Array[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: StructFeature[T]): Option[T]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T]):Option[T]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: MapFeature[K, V]): Option[Map[K, V]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#get[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V]):Option[Map[K,V]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: SetFeature[T]): Option[Set[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T]):Option[Set[T]]", "kind" : "def"}, {"label" : "get", "tail" : "(feature: ArrayFeature[T]): Option[Array[T]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#get[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T]):Option[Array[T]]", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: StructFeature[T], value: () ⇒ T): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:()=>T):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: MapFeature[K, V], value: () ⇒ Map[K, V]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setDefault[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:()=>Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: SetFeature[T], value: () ⇒ Set[T]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:()=>Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "setDefault", "tail" : "(feature: ArrayFeature[T], value: () ⇒ Array[T]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setDefault[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:()=>Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: StructFeature[T], value: T): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.StructFeature[T],value:T):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: MapFeature[K, V], value: Map[K, V]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#set[K,V](feature:com.johnsnowlabs.nlp.serialization.MapFeature[K,V],value:Map[K,V]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: SetFeature[T], value: Set[T]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.SetFeature[T],value:Set[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "set", "tail" : "(feature: ArrayFeature[T], value: Array[T]): T5Transformer.this.type", "member" : "com.johnsnowlabs.nlp.HasFeatures.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#set[T](feature:com.johnsnowlabs.nlp.serialization.ArrayFeature[T],value:Array[T]):HasFeatures.this.type", "kind" : "def"}, {"label" : "features", "tail" : ": ArrayBuffer[Feature[_, _, _]]", "member" : "com.johnsnowlabs.nlp.HasFeatures.features", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#features:scala.collection.mutable.ArrayBuffer[com.johnsnowlabs.nlp.serialization.Feature[_,_,_]]", "kind" : "val"}, {"label" : "save", "tail" : "(path: String): Unit", "member" : "org.apache.spark.ml.util.MLWritable.save", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#save(path:String):Unit", "kind" : "def"}, {"label" : "hasParent", "tail" : "(): Boolean", "member" : "org.apache.spark.ml.Model.hasParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#hasParent:Boolean", "kind" : "def"}, {"label" : "setParent", "tail" : "(parent: Estimator[T5Transformer]): T5Transformer", "member" : "org.apache.spark.ml.Model.setParent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setParent(parent:org.apache.spark.ml.Estimator[M]):M", "kind" : "def"}, {"label" : "parent", "tail" : ": Estimator[T5Transformer]", "member" : "org.apache.spark.ml.Model.parent", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#parent:org.apache.spark.ml.Estimator[M]", "kind" : "var"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], paramMap: ParamMap): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#transform(dataset:org.apache.spark.sql.Dataset[_],paramMap:org.apache.spark.ml.param.ParamMap):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transform", "tail" : "(dataset: Dataset[_], firstParamPair: ParamPair[_], otherParamPairs: ParamPair[_]*): DataFrame", "member" : "org.apache.spark.ml.Transformer.transform", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#transform(dataset:org.apache.spark.sql.Dataset[_],firstParamPair:org.apache.spark.ml.param.ParamPair[_],otherParamPairs:org.apache.spark.ml.param.ParamPair[_]*):org.apache.spark.sql.DataFrame", "kind" : "def"}, {"label" : "transformSchema", "tail" : "(schema: StructType, logging: Boolean): StructType", "member" : "org.apache.spark.ml.PipelineStage.transformSchema", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#transformSchema(schema:org.apache.spark.sql.types.StructType,logging:Boolean):org.apache.spark.sql.types.StructType", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean, silent: Boolean): Boolean", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#initializeLogIfNecessary(isInterpreter:Boolean,silent:Boolean):Boolean", "kind" : "def"}, {"label" : "initializeLogIfNecessary", "tail" : "(isInterpreter: Boolean): Unit", "member" : "org.apache.spark.internal.Logging.initializeLogIfNecessary", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#initializeLogIfNecessary(isInterpreter:Boolean):Unit", "kind" : "def"}, {"label" : "isTraceEnabled", "tail" : "(): Boolean", "member" : "org.apache.spark.internal.Logging.isTraceEnabled", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#isTraceEnabled():Boolean", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logError(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logWarning(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logTrace(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logDebug(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String, throwable: Throwable): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logInfo(msg:=>String,throwable:Throwable):Unit", "kind" : "def"}, {"label" : "logError", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logError", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logError(msg:=>String):Unit", "kind" : "def"}, {"label" : "logWarning", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logWarning", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logWarning(msg:=>String):Unit", "kind" : "def"}, {"label" : "logTrace", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logTrace", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logTrace(msg:=>String):Unit", "kind" : "def"}, {"label" : "logDebug", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logDebug", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logDebug(msg:=>String):Unit", "kind" : "def"}, {"label" : "logInfo", "tail" : "(msg: ⇒ String): Unit", "member" : "org.apache.spark.internal.Logging.logInfo", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logInfo(msg:=>String):Unit", "kind" : "def"}, {"label" : "log", "tail" : "(): Logger", "member" : "org.apache.spark.internal.Logging.log", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#log:org.slf4j.Logger", "kind" : "def"}, {"label" : "logName", "tail" : "(): String", "member" : "org.apache.spark.internal.Logging.logName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#logName:String", "kind" : "def"}, {"label" : "copyValues", "tail" : "(to: T, extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.copyValues", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#copyValues[T<:org.apache.spark.ml.param.Params](to:T,extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "def"}, {"label" : "extractParamMap", "tail" : "(): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#extractParamMap():org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "extractParamMap", "tail" : "(extra: ParamMap): ParamMap", "member" : "org.apache.spark.ml.param.Params.extractParamMap", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#extractParamMap(extra:org.apache.spark.ml.param.ParamMap):org.apache.spark.ml.param.ParamMap", "kind" : "final def"}, {"label" : "defaultCopy", "tail" : "(extra: ParamMap): T", "member" : "org.apache.spark.ml.param.Params.defaultCopy", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#defaultCopy[T<:org.apache.spark.ml.param.Params](extra:org.apache.spark.ml.param.ParamMap):T", "kind" : "final def"}, {"label" : "hasDefault", "tail" : "(param: Param[T]): Boolean", "member" : "org.apache.spark.ml.param.Params.hasDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#hasDefault[T](param:org.apache.spark.ml.param.Param[T]):Boolean", "kind" : "final def"}, {"label" : "getDefault", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.getDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getDefault[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(paramPairs: ParamPair[_]*): T5Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setDefault(paramPairs:org.apache.spark.ml.param.ParamPair[_]*):Params.this.type", "kind" : "final def"}, {"label" : "setDefault", "tail" : "(param: Param[T], value: T): T5Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.setDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#setDefault[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "$", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.$", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#$[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "getOrDefault", "tail" : "(param: Param[T]): T", "member" : "org.apache.spark.ml.param.Params.getOrDefault", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getOrDefault[T](param:org.apache.spark.ml.param.Param[T]):T", "kind" : "final def"}, {"label" : "clear", "tail" : "(param: Param[_]): T5Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.clear", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#clear(param:org.apache.spark.ml.param.Param[_]):Params.this.type", "kind" : "final def"}, {"label" : "get", "tail" : "(param: Param[T]): Option[T]", "member" : "org.apache.spark.ml.param.Params.get", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#get[T](param:org.apache.spark.ml.param.Param[T]):Option[T]", "kind" : "final def"}, {"label" : "set", "tail" : "(paramPair: ParamPair[_]): T5Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#set(paramPair:org.apache.spark.ml.param.ParamPair[_]):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: String, value: Any): T5Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#set(param:String,value:Any):Params.this.type", "kind" : "final def"}, {"label" : "set", "tail" : "(param: Param[T], value: T): T5Transformer.this.type", "member" : "org.apache.spark.ml.param.Params.set", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#set[T](param:org.apache.spark.ml.param.Param[T],value:T):Params.this.type", "kind" : "final def"}, {"label" : "getParam", "tail" : "(paramName: String): Param[Any]", "member" : "org.apache.spark.ml.param.Params.getParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getParam(paramName:String):org.apache.spark.ml.param.Param[Any]", "kind" : "def"}, {"label" : "hasParam", "tail" : "(paramName: String): Boolean", "member" : "org.apache.spark.ml.param.Params.hasParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#hasParam(paramName:String):Boolean", "kind" : "def"}, {"label" : "isDefined", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isDefined", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#isDefined(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "isSet", "tail" : "(param: Param[_]): Boolean", "member" : "org.apache.spark.ml.param.Params.isSet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#isSet(param:org.apache.spark.ml.param.Param[_]):Boolean", "kind" : "final def"}, {"label" : "explainParams", "tail" : "(): String", "member" : "org.apache.spark.ml.param.Params.explainParams", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#explainParams():String", "kind" : "def"}, {"label" : "explainParam", "tail" : "(param: Param[_]): String", "member" : "org.apache.spark.ml.param.Params.explainParam", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#explainParam(param:org.apache.spark.ml.param.Param[_]):String", "kind" : "def"}, {"label" : "params", "tail" : ": Array[Param[_]]", "member" : "org.apache.spark.ml.param.Params.params", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#params:Array[org.apache.spark.ml.param.Param[_]]", "kind" : "lazy val"}, {"label" : "toString", "tail" : "(): String", "member" : "org.apache.spark.ml.util.Identifiable.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#toString():String", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "members_object" : [{"label" : "loadSavedModel", "tail" : "(modelPath: String, spark: SparkSession): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.loadSavedModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#loadSavedModel(modelPath:String,spark:org.apache.spark.sql.SparkSession):com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "readModel", "tail" : "(instance: T5Transformer, path: String, spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.readModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#readModel(instance:com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer,path:String,spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "onnxFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.onnxFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#onnxFile:String", "kind" : "val"}, {"label" : "onnxDecoderFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.onnxDecoderFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#onnxDecoderFile:String", "kind" : "val"}, {"label" : "onnxEncoderFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.onnxEncoderFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#onnxEncoderFile:String", "kind" : "val"}, {"label" : "sppFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.sppFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#sppFile:String", "kind" : "val"}, {"label" : "tfFile", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadT5TransformerDLModel.tfFile", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#tfFile:String", "kind" : "val"}, {"label" : "readOnnxModels", "tail" : "(path: String, spark: SparkSession, modelNames: Seq[String], suffix: String, zipped: Boolean, useBundle: Boolean): Map[String, OnnxWrapper]", "member" : "com.johnsnowlabs.ml.onnx.ReadOnnxModel.readOnnxModels", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#readOnnxModels(path:String,spark:org.apache.spark.sql.SparkSession,modelNames:Seq[String],suffix:String,zipped:Boolean,useBundle:Boolean):Map[String,com.johnsnowlabs.ml.onnx.OnnxWrapper]", "kind" : "def"}, {"label" : "readOnnxModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, sessionOptions: Option[SessionOptions]): OnnxWrapper", "member" : "com.johnsnowlabs.ml.onnx.ReadOnnxModel.readOnnxModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#readOnnxModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,sessionOptions:Option[ai.onnxruntime.OrtSession.SessionOptions]):com.johnsnowlabs.ml.onnx.OnnxWrapper", "kind" : "def"}, {"label" : "readSentencePieceModel", "tail" : "(path: String, spark: SparkSession, suffix: String, filename: String): SentencePieceWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.sentencepiece.ReadSentencePieceModel.readSentencePieceModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#readSentencePieceModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,filename:String):com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper", "kind" : "def"}, {"label" : "readTensorflowHub", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowHub", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#readTensorflowHub(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowChkPoints", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, tags: Array[String], initAllTables: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowChkPoints", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#readTensorflowChkPoints(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,tags:Array[String],initAllTables:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowWithSPModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, loadSP: Boolean): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowWithSPModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#readTensorflowWithSPModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,loadSP:Boolean):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "readTensorflowModel", "tail" : "(path: String, spark: SparkSession, suffix: String, zipped: Boolean, useBundle: Boolean, tags: Array[String], initAllTables: Boolean, savedSignatures: Option[Map[String, String]]): TensorflowWrapper", "member" : "com.johnsnowlabs.ml.tensorflow.ReadTensorflowModel.readTensorflowModel", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#readTensorflowModel(path:String,spark:org.apache.spark.sql.SparkSession,suffix:String,zipped:Boolean,useBundle:Boolean,tags:Array[String],initAllTables:Boolean,savedSignatures:Option[Map[String,String]]):com.johnsnowlabs.ml.tensorflow.TensorflowWrapper", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String, remoteLoc: String): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#pretrained(name:String,lang:String,remoteLoc:String):com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String, lang: String): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#pretrained(name:String,lang:String):com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(name: String): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#pretrained(name:String):com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "pretrained", "tail" : "(): T5Transformer", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.pretrained", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#pretrained():com.johnsnowlabs.nlp.annotators.seq2seq.T5Transformer", "kind" : "def"}, {"label" : "defaultModelName", "tail" : ": Some[String]", "member" : "com.johnsnowlabs.nlp.annotators.seq2seq.ReadablePretrainedT5TransformerModel.defaultModelName", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#defaultModelName:Some[String]", "kind" : "val"}, {"label" : "defaultLoc", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLoc", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#defaultLoc:String", "kind" : "lazy val"}, {"label" : "defaultLang", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.HasPretrained.defaultLang", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#defaultLang:String", "kind" : "val"}, {"label" : "read", "tail" : "(): MLReader[T5Transformer]", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.read", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#read:org.apache.spark.ml.util.MLReader[T]", "kind" : "def"}, {"label" : "addReader", "tail" : "(reader: (T5Transformer, String, SparkSession) ⇒ Unit): Unit", "member" : "com.johnsnowlabs.nlp.ParamsAndFeaturesReadable.addReader", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#addReader(reader:(T,String,org.apache.spark.sql.SparkSession)=>Unit):Unit", "kind" : "def"}, {"label" : "load", "tail" : "(path: String): T5Transformer", "member" : "org.apache.spark.ml.util.MLReadable.load", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#load(path:String):T", "kind" : "def"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer$.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/seq2seq\/T5Transformer.html", "kind" : "class"}], "com.johnsnowlabs.nlp.annotators.er" : [{"name" : "com.johnsnowlabs.nlp.annotators.er.AhoCorasickAutomaton", "shortDescription" : "Aho-Corasick Algorithm: https:\/\/dl.acm.org\/doi\/10.1145\/360825.360855 A simple, efficientalgorithm to locate all occurrences of any of a finite number of keywords in a string of text.", "members_class" : [{"label" : "buildAnnotation", "tail" : "(chunk: ArrayBuffer[(Char, Int)], entity: String, id: String, sentence: Sentence): Annotation", "member" : "com.johnsnowlabs.nlp.annotators.er.AhoCorasickAutomaton.buildAnnotation", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#buildAnnotation(chunk:scala.collection.mutable.ArrayBuffer[(Char,Int)],entity:String,id:String,sentence:com.johnsnowlabs.nlp.annotators.common.Sentence):com.johnsnowlabs.nlp.Annotation", "kind" : "def"}, {"label" : "searchPatternsInText", "tail" : "(sentence: Sentence): Seq[Annotation]", "member" : "com.johnsnowlabs.nlp.annotators.er.AhoCorasickAutomaton.searchPatternsInText", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#searchPatternsInText(sentence:com.johnsnowlabs.nlp.annotators.common.Sentence):Seq[com.johnsnowlabs.nlp.Annotation]", "kind" : "def"}, {"label" : "Node", "tail" : "", "member" : "com.johnsnowlabs.nlp.annotators.er.AhoCorasickAutomaton.Node", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#NodeextendsSerializable", "kind" : "class"}, {"label" : "nodeCount", "tail" : ": Int", "member" : "com.johnsnowlabs.nlp.annotators.er.AhoCorasickAutomaton.nodeCount", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#nodeCount:Int", "kind" : "var"}, {"label" : "nodes", "tail" : ": Array[Option[Node]]", "member" : "com.johnsnowlabs.nlp.annotators.er.AhoCorasickAutomaton.nodes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#nodes:Array[Option[AhoCorasickAutomaton.this.Node]]", "kind" : "var"}, {"member" : "com.johnsnowlabs.nlp.annotators.er.AhoCorasickAutomaton#<init>", "error" : "unsupported entity"}, {"label" : "alphabet", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.er.AhoCorasickAutomaton.alphabet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#alphabet:String", "kind" : "var"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#notify():Unit", "kind" : "final def"}, {"label" : "toString", "tail" : "(): String", "member" : "scala.AnyRef.toString", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#toString():String", "kind" : "def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#clone():Object", "kind" : "def"}, {"label" : "equals", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.equals", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#equals(x$1:Any):Boolean", "kind" : "def"}, {"label" : "hashCode", "tail" : "(): Int", "member" : "scala.AnyRef.hashCode", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#hashCode():Int", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "class" : "com\/johnsnowlabs\/nlp\/annotators\/er\/AhoCorasickAutomaton.html", "kind" : "class"}, {"name" : "com.johnsnowlabs.nlp.annotators.er.EntityPattern", "shortDescription" : "", "members_case class" : [{"member" : "com.johnsnowlabs.nlp.annotators.er.EntityPattern#<init>", "error" : "unsupported entity"}, {"label" : "regex", "tail" : ": Option[Boolean]", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityPattern.regex", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#regex:Option[Boolean]", "kind" : "val"}, {"label" : "id", "tail" : ": Option[String]", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityPattern.id", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#id:Option[String]", "kind" : "val"}, {"label" : "patterns", "tail" : ": Seq[String]", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityPattern.patterns", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#patterns:Seq[String]", "kind" : "val"}, {"label" : "label", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityPattern.label", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#label:String", "kind" : "val"}, {"label" : "synchronized", "tail" : "(arg0: ⇒ T0): T0", "member" : "scala.AnyRef.synchronized", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#synchronized[T0](x$1:=>T0):T0", "kind" : "final def"}, {"label" : "##", "tail" : "(): Int", "member" : "scala.AnyRef.##", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html###():Int", "kind" : "final def"}, {"label" : "!=", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.!=", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#!=(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "==", "tail" : "(arg0: Any): Boolean", "member" : "scala.AnyRef.==", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#==(x$1:Any):Boolean", "kind" : "final def"}, {"label" : "ne", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.ne", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#ne(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "eq", "tail" : "(arg0: AnyRef): Boolean", "member" : "scala.AnyRef.eq", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#eq(x$1:AnyRef):Boolean", "kind" : "final def"}, {"label" : "finalize", "tail" : "(): Unit", "member" : "scala.AnyRef.finalize", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#finalize():Unit", "kind" : "def"}, {"label" : "wait", "tail" : "(): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#wait():Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long, arg1: Int): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#wait(x$1:Long,x$2:Int):Unit", "kind" : "final def"}, {"label" : "wait", "tail" : "(arg0: Long): Unit", "member" : "scala.AnyRef.wait", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#wait(x$1:Long):Unit", "kind" : "final def"}, {"label" : "notifyAll", "tail" : "(): Unit", "member" : "scala.AnyRef.notifyAll", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#notifyAll():Unit", "kind" : "final def"}, {"label" : "notify", "tail" : "(): Unit", "member" : "scala.AnyRef.notify", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#notify():Unit", "kind" : "final def"}, {"label" : "clone", "tail" : "(): AnyRef", "member" : "scala.AnyRef.clone", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#clone():Object", "kind" : "def"}, {"label" : "getClass", "tail" : "(): Class[_]", "member" : "scala.AnyRef.getClass", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#getClass():Class[_]", "kind" : "final def"}, {"label" : "asInstanceOf", "tail" : "(): T0", "member" : "scala.Any.asInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#asInstanceOf[T0]:T0", "kind" : "final def"}, {"label" : "isInstanceOf", "tail" : "(): Boolean", "member" : "scala.Any.isInstanceOf", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html#isInstanceOf[T0]:Boolean", "kind" : "final def"}], "case class" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityPattern.html", "kind" : "case class"}, {"name" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach", "shortDescription" : "Fits an Annotator to match exact strings or regex patterns provided in a file against aDocument and assigns them an named entity.", "members_class" : [{"label" : "databases", "tail" : ": Array[Name]", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.databases", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#databases:Array[com.johnsnowlabs.storage.Database.Name]", "kind" : "val"}, {"label" : "outputAnnotatorType", "tail" : ": AnnotatorType", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.outputAnnotatorType", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#outputAnnotatorType:EntityRulerApproach.this.AnnotatorType", "kind" : "val"}, {"label" : "optionalInputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.optionalInputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#optionalInputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "inputAnnotatorTypes", "tail" : ": Array[String]", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.inputAnnotatorTypes", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#inputAnnotatorTypes:Array[String]", "kind" : "val"}, {"label" : "indexStorage", "tail" : "(fitDataset: Dataset[_], resource: Option[ExternalResource]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.indexStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#indexStorage(fitDataset:org.apache.spark.sql.Dataset[_],resource:Option[com.johnsnowlabs.nlp.util.io.ExternalResource]):Unit", "kind" : "def"}, {"label" : "createWriter", "tail" : "(database: Name, connection: RocksDBConnection): StorageWriter[_]", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.createWriter", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#createWriter(database:com.johnsnowlabs.storage.Database.Name,connection:com.johnsnowlabs.storage.RocksDBConnection):com.johnsnowlabs.storage.StorageWriter[_]", "kind" : "def"}, {"label" : "index", "tail" : "(fitDataset: Dataset[_], storageSourcePath: Option[String], readAs: Option[util.io.ReadAs.Value], writers: Map[Name, StorageWriter[_]], readOptions: Option[Map[String, String]]): Unit", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.index", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#index(fitDataset:org.apache.spark.sql.Dataset[_],storageSourcePath:Option[String],readAs:Option[com.johnsnowlabs.nlp.util.io.ReadAs.Value],writers:Map[com.johnsnowlabs.storage.Database.Name,com.johnsnowlabs.storage.StorageWriter[_]],readOptions:Option[Map[String,String]]):Unit", "kind" : "def"}, {"label" : "train", "tail" : "(dataset: Dataset[_], recursivePipeline: Option[PipelineModel]): EntityRulerModel", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.train", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#train(dataset:org.apache.spark.sql.Dataset[_],recursivePipeline:Option[org.apache.spark.ml.PipelineModel]):com.johnsnowlabs.nlp.annotators.er.EntityRulerModel", "kind" : "def"}, {"label" : "beforeTraining", "tail" : "(spark: SparkSession): Unit", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.beforeTraining", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#beforeTraining(spark:org.apache.spark.sql.SparkSession):Unit", "kind" : "def"}, {"label" : "setAlphabetResource", "tail" : "(path: String): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.setAlphabetResource", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setAlphabetResource(path:String):EntityRulerApproach.this.type", "kind" : "def"}, {"label" : "setUseStorage", "tail" : "(value: Boolean): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.setUseStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setUseStorage(value:Boolean):EntityRulerApproach.this.type", "kind" : "def"}, {"label" : "setSentenceMatch", "tail" : "(value: Boolean): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.setSentenceMatch", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setSentenceMatch(value:Boolean):EntityRulerApproach.this.type", "kind" : "def"}, {"label" : "setPatternsResource", "tail" : "(path: String, readAs: Format, options: Map[String, String]): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.setPatternsResource", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setPatternsResource(path:String,readAs:com.johnsnowlabs.nlp.util.io.ReadAs.Format,options:Map[String,String]):EntityRulerApproach.this.type", "kind" : "def"}, {"label" : "alphabet", "tail" : ": ExternalResourceParam", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.alphabet", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#alphabet:com.johnsnowlabs.nlp.annotators.param.ExternalResourceParam", "kind" : "val"}, {"label" : "useStorage", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.useStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#useStorage:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "sentenceMatch", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.sentenceMatch", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#sentenceMatch:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "patternsResource", "tail" : ": ExternalResourceParam", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.patternsResource", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#patternsResource:com.johnsnowlabs.nlp.annotators.param.ExternalResourceParam", "kind" : "val"}, {"label" : "description", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.description", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#description:String", "kind" : "val"}, {"member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach#<init>", "error" : "unsupported entity"}, {"member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach#<init>", "error" : "unsupported entity"}, {"label" : "uid", "tail" : ": String", "member" : "com.johnsnowlabs.nlp.annotators.er.EntityRulerApproach.uid", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#uid:String", "kind" : "val"}, {"label" : "missingRefMsg", "tail" : ": String", "member" : "com.johnsnowlabs.storage.HasStorage.missingRefMsg", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#missingRefMsg:String", "kind" : "val"}, {"label" : "getStoragePath", "tail" : "(): Option[ExternalResource]", "member" : "com.johnsnowlabs.storage.HasStorage.getStoragePath", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#getStoragePath:Option[com.johnsnowlabs.nlp.util.io.ExternalResource]", "kind" : "def"}, {"label" : "setStoragePath", "tail" : "(path: String, readAs: util.io.ReadAs.Value): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.storage.HasStorage.setStoragePath", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setStoragePath(path:String,readAs:com.johnsnowlabs.nlp.util.io.ReadAs.Value):HasStorage.this.type", "kind" : "def"}, {"label" : "setStoragePath", "tail" : "(path: String, readAs: String): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.storage.HasStorage.setStoragePath", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setStoragePath(path:String,readAs:String):HasStorage.this.type", "kind" : "def"}, {"label" : "storagePath", "tail" : ": ExternalResourceParam", "member" : "com.johnsnowlabs.storage.HasStorage.storagePath", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#storagePath:com.johnsnowlabs.nlp.annotators.param.ExternalResourceParam", "kind" : "val"}, {"label" : "setCaseSensitive", "tail" : "(value: Boolean): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.nlp.HasCaseSensitiveProperties.setCaseSensitive", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setCaseSensitive(value:Boolean):HasCaseSensitiveProperties.this.type", "kind" : "def"}, {"label" : "getCaseSensitive", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.nlp.HasCaseSensitiveProperties.getCaseSensitive", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#getCaseSensitive:Boolean", "kind" : "def"}, {"label" : "caseSensitive", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.nlp.HasCaseSensitiveProperties.caseSensitive", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#caseSensitive:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "getEnableInMemoryStorage", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.storage.HasStorageOptions.getEnableInMemoryStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#getEnableInMemoryStorage:Boolean", "kind" : "def"}, {"label" : "setEnableInMemoryStorage", "tail" : "(value: Boolean): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.storage.HasStorageOptions.setEnableInMemoryStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setEnableInMemoryStorage(value:Boolean):HasStorageOptions.this.type", "kind" : "def"}, {"label" : "enableInMemoryStorage", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.storage.HasStorageOptions.enableInMemoryStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#enableInMemoryStorage:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "getIncludeStorage", "tail" : "(): Boolean", "member" : "com.johnsnowlabs.storage.HasStorageOptions.getIncludeStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#getIncludeStorage:Boolean", "kind" : "def"}, {"label" : "setIncludeStorage", "tail" : "(value: Boolean): EntityRulerApproach.this.type", "member" : "com.johnsnowlabs.storage.HasStorageOptions.setIncludeStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#setIncludeStorage(value:Boolean):HasStorageOptions.this.type", "kind" : "def"}, {"label" : "includeStorage", "tail" : ": BooleanParam", "member" : "com.johnsnowlabs.storage.HasStorageOptions.includeStorage", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#includeStorage:org.apache.spark.ml.param.BooleanParam", "kind" : "val"}, {"label" : "validateStorageRef", "tail" : "(dataset: Dataset[_], inputCols: Array[String], annotatorType: String): Unit", "member" : "com.johnsnowlabs.storage.HasStorageRef.validateStorageRef", "link" : "com\/johnsnowlabs\/nlp\/annotators\/er\/EntityRulerApproach.html#validateStorageRef(dataset:org.apache.spark.sql.Dataset[_],inputCols:Array[String],annotatorType:String):Unit", "kind" : "def"}, {"label" : "getStorageRef", "tail" : "(): String", "member" : "com.johnsnowlabs.storage.HasStora