package com.johnsnowlabs.ml.ai

import com.johnsnowlabs.ml.ai.model.TextEmbeddingResponse
import com.johnsnowlabs.nlp.AnnotatorType.DOCUMENT
import com.johnsnowlabs.nlp.{Annotation, AnnotatorModel, HasSimpleAnnotate}
import com.johnsnowlabs.util.{ConfigHelper, ConfigLoader, JsonBuilder, JsonParser}
import org.apache.http.client.methods.HttpPost
import org.apache.http.entity.{ContentType, StringEntity}
import org.apache.http.impl.client.{CloseableHttpClient, HttpClients}
import org.apache.http.util.EntityUtils
import org.apache.spark.broadcast.Broadcast
import org.apache.spark.ml.param.Param
import org.apache.spark.ml.util.Identifiable
import org.apache.spark.sql.{Dataset, SparkSession}

/** Transformer that makes a request for OpenAI Embeddings API for each executor.
  *
  * @see
  *   [[https://platform.openai.com/docs/api-reference/embeddings/create OpenAI API Doc]] for
  *   reference
  *
  * ==Example==
  * {{{
  * import spark.implicits._
  * import com.johnsnowlabs.nlp.base.DocumentAssembler
  * import com.johnsnowlabs.ml.ai.OpenAIEmbeddings
  * import org.apache.spark.ml.Pipeline
  *
  * val documentAssembler = new DocumentAssembler()
  *   .setInputCol("text")
  *   .setOutputCol("document")
  *
  * val openAIEmbeddings = new OpenAICompletion()
  *  .setInputCols("document")
  *  .setOutputCol("embeddings")
  *  .setModel("text-embedding-ada-002")
  *
  *
  * val pipeline = new Pipeline().setStages(Array(
  *   documentAssembler,
  *   openAIEmbeddings
  * ))
  *
  * val inputDF = Seq(
  *  "The food was delicious and the waiter...").toDS.toDF("text")
  * val embeddingsDF = pipeline.fit(inputDF).transform(inputDF)
  *
  * embeddingsDF.select("embeddings").show(false)
  * +-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
  * |embeddings                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
  * +-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
  * |[{document, 0, 40, The food was delicious and the waiter..., {}, [0.0023141683, -0.009301115, 0.015719837, -0.007821825, -0.0046727783, 0.014881784, -0.009821723, -0.038220283, -0.0069075855, -0.028773142, 0.025217766, 0.018170506, -0.0035648984, -0.025535211, 5.1227555E-4, -0.016278539, 0.028366813, 0.0053457604, 0.009605861, -0.016481703, -0.015351601, 0.00426645, 0.0070345635, -0.0070853545, -0.003907738, 0.018449856, 0.008710668, -0.022767097, 0.011478782, 0.023859106, 0.015567463, -0.0035807705, -0.034893464, -0.0041743913, -0.02610661, -0.02156081, -0.0057806587, 0.011726389, 0.008342434, 0.0040982044, 0.019237118, -0.014411966, 0.008939228, 0.0063679307, -0.045711964, 0.01780227, -0.005482261, -7.650405E-4, -0.02201793, -0.003771237, 0.021002108, -0.01752292, -0.011707342, -0.022513142, 0.016392818, 0.01718008, -0.0085329, 0.0015808721, 0.025039999, -0.02491302, 0.0077456385, 0.0058949385, -0.022170303, 0.0030442898, -0.0062219063, -0.02542093, -0.008082129, 0.0011189908, 2.2952703E-5, 0.004625162, 0.020633873, 0.01353582, 0.004612464, -0.01598649, 0.016621377, -0.008920182, -0.0075678695, 0.013637402, -0.0069837724, 0.0053616324, 0.009891561, -0.04583894, 0.003052226, 0.023960687, 0.022932168, 0.00705361, -0.023617849, 0.009961399, -0.006602839, -0.03326815, -0.0025522513, 0.019884704, 0.0017475303, 0.001142799, -0.022741701, 0.004971176, 0.015376997, 0.03161744, -0.00546004, -0.016011884, -0.005164817, 0.019859308, -0.009396348, -0.006786957, -0.031185718, -0.009428092, -0.015211926, -0.028849328, 0.021027504, -0.018348275, -0.002917312, 0.012646977, 0.00523148, -0.04954669, -0.043020036, -3.9819407E-4, 0.021459227, -0.016849937, 0.0065393504, -0.041420117, 9.2773064E-4, 0.033471316, 0.013078701, -0.010494705, -4.924353E-4, 0.018411763, 1.132879E-4, -0.013066003, 0.011866064, 0.0057965307, 0.0071742386, 0.008507504, 0.018411763, -7.575012E-4, -0.019122839, 0.021929044, -0.029788963, -0.0043140664, 0.0014657986, -0.0050822813, 0.015008762, 0.021332249, -0.01883079, 0.011008965, -0.007472636, 0.022538537, 0.019199025, 0.01495797, -0.0036379104, 0.0062726974, 0.025674887, -0.02775732, 0.036620364, -0.004574371, 0.013865963, 0.007974198, -0.0056695533, 0.010285192, -0.00580288, -0.008717017, 0.010640729, -5.2527095E-5, 0.032125354, -0.023744825, -0.0025411407, 0.030246083, 0.02963659, 0.016519796, 0.002155446, 9.1900094E-4, -0.011561317, 0.018564137, -0.007580567, 0.007548823, -0.0010975633, 0.004529929, 0.009929654, -0.007580567, -0.0062314295, -0.0057933563, -0.028239835, 0.0043140664, 0.029255657, 0.024963811, -0.015567463, -0.018246692, 0.0076377075, 0.008602737, -0.0116628995, -0.006301267, 0.0020062474, 0.036899712, -0.0024982858, -0.020798944, -0.68953955, -0.019605353, 0.003549026, 0.0066663283, 0.028316023, 0.023452777, 0.007180588, 0.010520101, 0.009529674, -0.009548721, -0.021281458, 6.5026456E-5, 0.019732332, 0.0021935394, -0.009516977, -0.002047515, -3.8410746E-4, 0.006679026, -0.041166164, 0.011256571, -0.013472332, 0.027782716, -0.011415293, 1.2787049E-4, 0.015389695, -4.6584936E-4, 0.014424664, -0.008551947, -0.018868882, -0.017726084, -0.009339208, 0.024582878, 0.012831095, -0.008837647, 0.035020445, -0.0051965616, -0.024189247, 0.024125759, -0.003749016, 0.030982554, -0.015034157, -0.023249613, 0.030093709, 0.006812352, 0.010088377, 0.011466084, 0.030296873, 0.017586408, 0.0021506844, -0.00671077, 0.009802677, 0.016659472, 0.003590294, 0.027884297, 0.004079158, 0.003080796, 0.029763568, -0.016811844, 0.0021379867, 0.023186123, 0.011808924, 0.0142976865, -0.019656144, -0.029433426, -0.001558651, 0.018246692, -0.0027808112, 0.01917363, 0.027528761, -0.008482109, 0.012386672, 0.0028919165, -0.0052029104, 0.0064314194, 0.009351906, 0.022538537, 0.023465475, 0.0010158215, 0.018957768, -0.0030347665, -0.0068821902, -0.010170912, -0.007878965, -0.0072377278, 0.020608477, 0.010818498, -0.029890545, -0.003799807, 0.0026951013, -0.01888158, 0.029890545, 0.024646368, -0.004425172, 0.026411356, 0.017548315, 0.041115373, -0.020202149, 0.014716713, 0.021535413, -0.02991594, -0.0015134152, 0.0033776062, 0.034156997, 0.03606166, 0.02803667, 0.018449856, 0.003160157, 0.009345557, 0.020748153, -0.012532697, 0.017091196, 0.011637504, -0.0075615207, 0.013167585, -0.0074027986, -0.02258933, 0.005933032, 0.025789166, -0.019059349, -0.018970465, -0.013281865, -0.0026316124, 0.022462351, -0.007910709, -7.5472356E-4, 0.028189044, 0.013891358, -0.01997359, -0.021116387, -0.0029696904, 0.013510425, 0.016011884, 0.011961297, -0.016875334, 0.0048251515, -0.012939026, 0.025928842, -0.030373061, 0.017561013, -0.022462351, -0.018856185, 0.0019729156, -0.006142545, 0.0020919573, -0.0015181769, -0.011281966, -0.005399726, -0.011351804, -0.021510018, 0.005085456, 0.005542576, -2.3133746E-4, -0.012577139, 0.0033871296, 0.024608273, -0.0019570435, 0.0012483493, -0.0054473425, -0.024773344, -0.030474642, -0.015973791, 0.01672296, -0.013332657, -0.008577342, 0.009377302, -0.007383752, 0.0070726564, -0.0055965413, -0.012151764, -0.02377022, 0.028798537, -0.015910303, -0.003339513, 0.005282271, -0.016773751, 0.0014840516, -0.021878254, -0.019414887, -0.0063044415, 0.016532494, 0.00876146, 0.004060111, -0.01387866, -0.012926328, 0.009523326, 0.005733042, 0.0014515136, 0.025344744, -0.017840363, 0.015427788, 0.002011009, -0.010964522, 0.007440892, 0.0014816708, 0.016011884, 0.01330726, -0.002599868, 0.002106242, 0.014069127, -0.0022157605, -0.004212484, -0.0065837926, 0.003145872, -0.004783884, 0.013231074, -0.017535618, -0.011085152, -0.02963659, 0.0038632958, 0.007529776, 0.01610077, -0.013840566, -0.017332453, -0.0038061559, 0.02139574, 0.017040404, 0.019211723, 0.0069139344, -0.013967545, -0.009186835, -0.0023554359, -0.020938618, -0.0051552937, -0.001572936, 0.006358407, 0.003096668, 0.0030696853, -0.007371054, 0.0012380324, -0.0021808415, -0.0019745028, 0.018589532, 7.039325E-4, 0.015084948, 0.0069710743, 0.0013451697, 0.016367422, -0.008818599, 0.016748356, -4.6465895E-4, -0.0077202427, 0.016735658, -7.9956255E-4, -0.027909694, 0.0109137315, 5.084067E-5, -0.0060155676, -0.011237524, -0.027477968, 0.008920182, 0.012932677, 0.016811844, -0.017637199, 0.014691317, -0.0040188436, 0.008063083, -0.0019062523, -0.018779999, 0.034030017, 0.021014806, 0.016532494, 0.022284582, 0.015491277, -0.0010269319, 0.0045013586, 5.733836E-4, -0.0076884986, -0.026182797, 0.009809026, -0.006717119, 0.014742108, -0.025916144, -0.0023046448, -0.0066980724, 0.006723468, -0.0012253346, -0.018678416, 0.002269726, -0.017878456, 0.0047870586, 0.003180791, -0.021814765, 0.02991594, 0.011916855, -0.002744305, -0.010964522, -0.017345151, 0.007428194, -0.012494603, 0.0033014196, 0.0072948677, 0.014411966, 0.0011118483, -0.00961221, 0.0141199175, 6.3409476E-4, 0.04614369, -0.020798944, 0.031541254, -0.005158468, 0.006571095, -0.025179673, -0.02816365, -0.023516266, 0.026258985, -0.013104096, -0.022360768, -5.8965257E-4, 0.023452777, -0.0077773826, 0.0065393504, -0.0060155676, -0.012488254, -0.002161795, 0.023782918, -0.0033077686, -0.02940803, 0.0019078396, 0.0077202427, -8.5233763E-4, -0.030449247, -0.017053101, -0.008805902, -0.013396145, 0.07816746, -0.0049299086, 0.015148437, 0.008469411, 0.03669655, 4.7457908E-4, -0.038931355, -0.0047521396, -0.005444168, -0.012069228, -0.006679026, 0.0095614195, 0.024989206, 0.007218681, 0.02628438, -0.0042569265, -0.0059742997, -0.024532087, 0.019287908, -0.023859106, -0.008215455, 0.01667217, 0.015948396, 0.027122432, -0.015123041, 0.004431521, 0.025649492, 0.026182797, -0.0011642266, -0.023503568, 0.0016284888, -0.0012070816, -0.004891815, -0.002255441, -0.015554765, 0.004834675, 4.948161E-4, -0.012183508, 0.0049267337, -0.006244127, 0.04050588, -0.008513853, 0.005034665, -0.017078498, 0.004761663, -0.0016411865, -0.027579552, 0.050816465, -0.030474642, -0.0028887421, 0.015465881, 0.027046245, 0.0023046448, -0.010513752, -0.00429502, 0.011161338, -0.006679026, -0.024189247, -0.013929451, 0.01632933, -0.014716713, -0.03766158, -0.005542576, -6.202066E-4, -0.025966935, -0.020430708, -0.01268507, -0.012545395, -0.002966516, -0.0029109633, -0.012329533, 0.0037553648, -0.012869188, -0.0070409123, 0.017345151, -0.0024617796, -0.0035331538, -0.009828072, -9.451901E-4, 0.0099550495, 6.217938E-4, -0.008202758, 0.0014253245, 0.003526805, -0.029154075, 0.022767097, 0.026462149, 0.011116896, 0.00546004, 0.0042569265, -0.0022030626, -0.0025887573, 0.005244178, -0.015491277, -0.0055108313, -0.021827463, -0.016240444, 0.02509079, -0.0084567135, -0.0032363436, -0.008107524, 0.0018935546, -0.009250324, 4.317241E-4, 0.04362953, -0.0083868755, -0.011370851, -0.025052696, 0.004015669, -0.011047058, 0.020557687, 0.014754806, -0.01899586, 0.0074535897, -0.012037484, 0.030296873, 0.01212002, 0.032277726, 0.003606166, -0.009110648, -0.0074599385, -0.0064917337, 0.025128882, -0.012329533, 0.00932651, -9.1344566E-4, 0.01239937, -0.013294563, -0.0015507148, -0.012786652, -0.0037045737, 0.007155192, -0.010482008, 0.009904259, -0.0043013687, -0.0026252635, -0.004164868, 0.010799452, -0.0255987, -0.024151154, -0.040124945, -0.015199228, 0.012875536, -0.01325647, -0.028544582, -0.023592452, -0.004920385, -0.008037687, -0.016062677, 0.05137517, 0.011789877, 0.00932651, -0.031719025, 0.039515454, 0.0047362675, -0.014170709, -0.014856388, -0.0064822105, 0.0045267544, 0.027173223, 0.021636996, -2.57725E-4, 0.019554563, 0.0037045737, -7.073054E-5, -0.006615537, -0.0108438935, -0.004533103, -0.030423852, 0.029611195, 0.02651294, 0.014780202, 0.0098471185, 0.009288417, -0.020773549, 0.0036220383, 0.004733093, -0.008805902, -0.009650303, -0.013853265, 0.01757371, -0.027477968, 0.005006095, 0.007155192, 0.03276024, -0.007605963, 0.022551235, 0.006269523, 0.016011884, -2.5375694E-4, 0.028646164, -0.014437362, 0.002636374, -0.0102026565, -0.01723087, 0.010405821, -0.0052187825, -0.015376997, -0.018360972, -3.408557E-4, 0.02775732, 0.0011134355, 0.0049616527, -0.0134088425, -0.007891662, 0.005056886, 0.013510425, -0.014411966, -0.0047299187, -0.026132006, -0.018741906, -0.019668842, -0.012640628, -0.02986515, -0.009916957, -0.0033966529, -0.041166164, 0.013040608, -0.009542372, -0.03816949, -7.6900853E-4, -0.003945831, -0.014208802, -0.0037966326, 0.016697565, -7.793255E-4, -0.017281663, -0.015567463, 0.029382635, -0.0043204157, -0.009675699, -8.779316E-5, 0.011491479, 0.025014602, -0.021878254, -0.018856185, 0.02144653, 0.009974097, -0.02291947, 0.013688194, -0.0046727783, 0.029535009, -0.0127676055, 0.018310182, 6.606807E-4, 0.012900932, -0.020951318, 0.0035426773, 0.0036887014, 0.0067933057, -0.029890545, -0.0020443406, -0.024265435, 0.02610661, -0.00984077, -0.0102026565, 0.008171014, -0.010151865, -0.013116794, 0.021687787, -0.010939127, 0.008399573, -0.00847576, 0.016405515, -0.0036315615, -0.009770933, 0.013396145, -0.007853569, 0.01809432, 0.01951647, -0.022449654, -0.02337659, 0.003641085, 0.009402697, 0.027427178, -0.007180588, -0.015199228, -0.016913427, -0.0045584985, -0.013688194, -0.005533052, 0.010374077, 0.004939432, 0.008177362, -7.1623345E-4, -0.032404702, -0.028112859, 0.004755314, 0.0062092086, -0.015884908, -0.02184016, -0.020913223, 0.0015705551, -0.0015451596, 0.024646368, -0.0020364046, -0.012380323, 0.015288113, -0.012761257, 0.0090979505, -0.01029789, 0.019097442, -0.02542093, 0.008399573, 0.0034220484, 0.013040608, 0.022436956, -0.008977322, -0.023224218, -0.016354725, 0.0011626394, -0.00429502, 0.018107018, -0.0056886, 0.02605582, 0.0052695735, 0.006780608, -0.006402849, -0.018132413, 0.019618051, -0.01775148, -0.0012832681, 0.027198618, -0.015897606, -0.020583082, 0.039794803, 0.008659878, -0.0022951216, -0.029484216, 0.009294766, -0.02156081, 0.035680726, -0.014284989, -0.014577038, -0.023313101, 0.011459735, -0.016557889, 0.02030373, 0.0064155473, -0.013510425, 0.016481703, 0.013192981, 0.01979582, -0.0014705602, 0.016113468, 0.004783884, -0.013840566, 0.0077392897, -0.03596008, -0.02707164, -0.009923305, 0.009701095, -0.0044664396, -0.009910608, -0.014361176, 0.00984077, -0.04304543, 0.024595575, -0.01069787, 0.0048854663, 0.011066104, 0.02149732, -0.02344008, 0.006812352, -0.03100795, 0.005853671, -0.0051362473, -0.013904056, -0.006409198, 3.2379307E-4, 0.0093138125, -0.009707443, -0.04243594, -0.011085152, 0.008786855, 0.0024681287, 0.011993041, -0.006761561, -0.014056429, -0.0071678897, 0.0017903852, 0.014513548, 0.033090383, 0.0051521193, -0.0017443559, -0.0128374435, -0.015313508, 0.01832288, -0.0057997056, -0.04817533, -0.017662594, 0.009250324, -0.010723265, 5.8479174E-5, -0.015669046, -0.028189044, 0.017687991, -0.017268965, -0.0025935192, -0.022475049, -0.017218173, 0.015211926, 0.00802499, -0.019072047, 0.007853569, -1.0123494E-4, -0.019605353, 0.0164944, 0.007104401, 1.1487512E-4, -0.009288417, -0.015897606, 0.0050124438, -0.005891764, -0.020887828, 0.0034442695, 0.0037680627, -0.0017015008, 0.004555324, 0.012653326, -0.014907179, 0.012431115, 0.0024522564, -0.0038759937, 4.5672283E-4, -0.008882089, 0.015884908, -0.017383244, -0.016799146, -0.0051521193, -0.022170303, -0.02059578, 0.018157808, 0.009301115, -0.0077456385, 0.025916144, 0.21921426, 0.011980344, -0.005006095, 0.03743302, -4.2021676E-4, 0.031236509, 0.0020173579, 0.0024522564, -0.017167382, 0.01325647, -0.011351804, -0.006485385, 0.0015316682, -0.0030141326, 0.0063330117, -0.0049299086, -0.02514158, -0.023782918, 3.3668923E-4, -0.03532519, 0.010786754, -0.016532494, 8.2773576E-4, -0.01729436, 0.03771237, 0.0021094168, -0.044061255, 0.0065837926, 0.013980242, 0.024303528, -0.019084744, -0.0086344825, 0.0057933563, 0.0016475354, -0.014462758, 0.013040608, 0.0069075855, 0.003920436, 0.005682251, -0.0038029815, 0.009878864, -0.013078701, 0.017281663, -0.016443608, 0.017218173, 0.024468599, -0.018754603, -0.027274804, 0.003239518, 0.036417197, -0.015250019, -0.018767301, 0.006609188, 0.010228052, 0.0055298777, 0.009148742, 0.02599233, -0.020189451, -0.019884704, -0.0059711253, 0.01063438, 0.0095614195, -0.01632933, 9.761409E-4, -0.030119104, 0.009821723, -0.014805597, 0.014284989, -0.0032220585, -0.015961094, -0.0013919928, -0.024951113, 2.1764767E-4, 0.022284582, -0.009078904, -0.010113772, 0.025039999, -0.0127295125, 0.019541865, 0.034969654, -0.0267415, 8.843797E-5, -0.006920283, -0.011243873, -0.016938822, -0.030144501, 0.0040982044, 0.014513548, -0.018868882, -0.02064657, 0.011402596, -0.012723164, -3.5241264E-5, -0.0014578624, 0.017700689, 0.0056790765, -0.0064568147, 0.010215354, 0.0032490413, -0.011326409, -0.010723265, -0.055108313, -0.009332859, -0.0048251515, -0.028569978, -0.003176029, 0.0028204916, 0.036721945, 0.003310943, -0.005615588, -0.002679229, -4.021621E-4, 0.017903853, -0.0014769092, 0.0024332097, -0.00273002, -0.016811844, 0.003641085, 0.030169897, -0.024049573, 0.018868882, -0.019199025, -0.0028443, 0.03344592, -0.020557687, -0.012913629, -0.011554969, 0.012043833, 0.025560606, -0.011942251, 0.038474236, -0.0036029916, -0.007866267, 0.019884704, -0.033649083, -0.018754603, 0.009675699, 0.01825939, -0.026665313, -0.012240648, 0.024900323, 8.2932296E-4, -9.5074537E-4, 0.006352058, -0.004933083, -0.03550296, 0.01234223, 0.007434543, -0.02991594, -0.018284785, -0.030753994, -0.014627828, -0.017091196, -0.017205475, 0.024963811, -0.020214846, -0.04459456, -0.0057076467, -0.0137643805, -8.483696E-4, -0.002945882, -0.0064917337, 0.05297509, -0.011599411, 0.008126572, 0.005580669, -0.16161719, 0.0092757195, -0.024557482, -0.01638012, 0.01580872, 6.086992E-4, 0.023173425, -0.0072440766, -0.018056225, 0.018906977, 0.0102026565, 0.010393123, -0.0329888, 0.0023395638, 0.019021256, 0.01643091, 1.3888183E-4, -0.014284989, 0.023135332, 0.019605353, 0.03829647, 0.002658595, 0.0010705806, -0.007529776, 0.0026839906, 0.030449247, -0.025471723, 0.0038029815, -0.011072453, 0.0018649846, 0.005898113, -0.002909376, 0.025497118, -0.008444016, 0.010247098, 0.005399726, 1.3124333E-4, -0.0066409325, 0.017675294, 0.035249002, 0.013205678, 0.027960485, -0.0012864426, 0.014919877, -0.009764584, 0.009910608, 0.009478884, -0.001576904, 0.023452777, -0.004783884, 0.009415395, -0.037179064, 0.016113468, 0.0011642266, 0.0022824237, 0.01695152, -0.014094522, 0.0013919928, -0.005904462, -7.301216E-4, -0.012310485, -0.011332758, -0.013281865, 0.0020776722, -0.0012808873, -0.004088681, -0.006428245, -0.014869086, 0.0064663384, 0.006040963, -0.0024078141, 0.0025395534, 0.0033141174, 0.0073456587, 1.8064558E-4, 0.023401987, -0.017637199, -0.0066663283, 0.021649694, -0.023198823, -0.015034157, 0.034385554, -0.025890749, 0.021344947, -0.015656348, 0.002177667, 0.0041236, 0.014970669, 0.0142215, -0.007447241, 0.007498032, -0.003555375, -0.009224928, -0.025700282, 0.01808162, 0.010996267, 0.009015415, 0.010355029, -0.005752089, -0.003606166, 0.00551718, -0.021522716, -0.028722351, 0.02548442, 0.01643091, 0.033547502, 0.0123041365, 0.026944663, 0.01951647, -0.0051394217, -0.020011682, 0.010374077, 0.019935496, 0.02537014, -0.010755009, 0.038778983, -0.014932575, -0.025395535, 0.030474642, -0.00904081, 0.046727784, 7.880552E-4, 0.0015054791, 0.012812047, -7.70199E-4, 0.0032918963, -0.10767707, -0.022982959, 0.020659268, 0.020506894, -0.006279046, -0.0051902127, 0.009123346, 0.013434238, -0.014399269, 0.0035871193, -0.011212129, -0.018018132, -0.015288113, -0.013675496, 0.023630546, 0.008520202, 0.025116185, -0.028696954, -6.0076313E-4, 0.0052187825, -6.817114E-4, 0.011453386, -0.005028316, 0.006736166, -0.0043140664, 0.0075107296, -0.009104299, 0.02991594, 0.007313914, 0.011218478, 0.024163852, -0.009948701, 0.017345151, -0.0041585187, -0.01172004, -5.309254E-4, -0.024735251, 0.0022205221, 0.014754806, -0.026970059, 0.01274221, -0.007320263, -0.0025236814, -0.04754044, 0.0068250503, -0.004533103, 3.1486497E-4, 0.018576834, 0.022970261, -0.0070155165, -0.0037458416, 0.025687585, -0.029661985, 0.004606115, 0.041496307, -0.005926683, 0.016570587, -0.0017062626, -0.009751885, -0.006558397, 0.0068758414, -0.0011920029, -0.020240242, 0.008044036, 0.008063083, 0.01587221, -0.011072453, -0.0023109936, 0.0050822813, -0.015161134, 0.012031135, -0.006459989, -0.016697565, -0.008913833, -0.010088377, -0.038575817, -0.034182392, 0.005552099, -1.3570739E-4, -0.022538537, 0.0019697412, -0.01012647, 0.007548823, -0.0012753321, -5.9123983E-4, -0.02013866, -0.010215354, -0.006761561, -0.007390101, -0.015796022, -0.0043204157, 0.011294665, 0.03105874, -0.013573914, -0.016926125, 0.018132413, -0.014488153, -0.0021665567, 0.017370546, -0.02371943, -0.0063393605, -0.01001219, -0.04015034, 0.006888539, -0.017764177, -0.0067552123, 0.008863042, -0.0100248875, 0.016710263, 0.010005841, -0.008202758, 0.01695152, -0.010678823, 0.01274221, 0.013726287, 0.007929756, -0.017116591, -0.008939228, 0.015440485, 0.0051203747, 0.022284582, -0.009237626, 0.022233792, 0.030119104, -0.0046442086, -7.205983E-4, -0.020341825, 0.021865556, -0.013243772, 0.016849937, -0.027452573, -0.010831196, 0.011535922, -0.02462097, 0.003276024, 0.026005028, -0.014450059, -0.030017523, -0.004129949, 0.012373975, 0.009624908, 0.002771288, -0.006558397, -0.03669655, 0.011123245, -0.02366864, -0.012043833, 0.014932575, -0.016265841, -0.004002971, 0.018805394, 0.0038950401, -0.008183711, 0.011072453, 0.010431216, -0.01917363, 0.015656348, 0.0013594547, 0.005967951, -0.011777179, 0.0049806996, -0.031160321, 0.03578231, -0.00899002, 0.008793204, -0.009180486, -0.004555324, -0.013573914, -0.01672296, -0.013573914, 0.01467862, -0.02986515, -0.018665718, 0.0052251313, 0.019783122, 0.0110216625, 0.039159916, -0.017840363, -0.00699647, -0.02849379, -0.008374178, 0.010989918, 0.013599309, 0.019872006, -0.024367016, 0.010926429, 0.010247098, 0.02479874, -0.016710263, -0.0013967544, 0.005558448, 0.004571196, -0.0046854764, -0.013332657, 0.011256571, -0.0016078549, 0.004012495, 0.025243163, -0.0029823883, -0.007834523, 0.017941946, 0.03105874, -0.005507657, 0.004618813, 0.002966516, -0.007212332, -0.011954948, -0.016189653, -0.03385225, -0.04284227, 0.009085253, 0.007478985, 0.018284785, 0.016761053, -0.0040061455, 0.022602027, 0.007440892, 0.012094623, -0.001454688, -0.0059584277, -0.019033954, 0.026817685, 0.0031522207, 0.012183508, 0.007942454, -0.020392615, 0.0061076265, 0.017205475, -0.0041553443, 1.2033119E-4, 0.0010840719, 0.005250527, -0.0014531008, 0.009370953, -0.01643091, -0.010259796, -0.014538944, 0.007161541, 0.015923, 0.018767301, -0.025154278, 0.037128273, 0.0044791377, 0.008799553, 0.004012495, -0.007878965, 0.0053679813, 0.028087461, -0.020100566, -0.0063298373, 0.0045172307, 0.02434162, 0.0076123117, 0.00580288, -0.012646977, -0.026132006, -0.002952231, 4.2815285E-4, 8.134507E-4, -0.028950911, -0.023389287, 0.008863042, 0.01865302, 0.014373873, 0.028138254, -0.013954847, -0.0031442847, 0.00197609, -0.0034410951, 0.012900932, -0.040912207, 0.0025824085, -0.0018935546, -0.049292736, -0.008894786, -0.004510882, -0.02178937, -0.01410722, -0.015516672, 0.0042061354, 0.0026681183, -0.031363487, 0.04106458, -0.01780227, -0.018576834, 0.014602433, 0.010374077, -0.015288113, -0.019389492, -0.0028141427]}]|
  * +-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+
  *
  * }}}
  *
  * @param uid
  *   required uid for storing annotator to disk
  * @groupname anno Annotator types
  * @groupdesc anno
  *   Required input and expected output annotator types
  * @groupname Ungrouped Members
  * @groupname param Parameters
  * @groupname setParam Parameter setters
  * @groupname getParam Parameter getters
  * @groupname Ungrouped Members
  * @groupprio param  1
  * @groupprio anno  2
  * @groupprio Ungrouped 3
  * @groupprio setParam  4
  * @groupprio getParam  5
  * @groupdesc param
  *   A list of (hyper-)parameter keys this annotator can take. Users can set and get the
  *   parameter values through setters and getters, respectively.
  */

class OpenAIEmbeddings(override val uid: String)
    extends AnnotatorModel[OpenAICompletion]
    with HasSimpleAnnotate[OpenAICompletion] {

  def this() = this(Identifiable.randomUID("OPENAI_EMBEDDINGS"))

  override val inputAnnotatorTypes: Array[AnnotatorType] = Array(DOCUMENT)
  override val outputAnnotatorType: AnnotatorType = DOCUMENT

  val model = new Param[String](this, "model", "ID of the OpenAI model to use")

  def setModel(value: String): this.type = set(model, value)

  val user = new Param[String](
    this,
    "user",
    "A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse.")

  def setUser(value: String): this.type = set(user, value)

  private var bearerToken: Option[Broadcast[String]] = None

  def setBearerTokenIfNotSet(spark: SparkSession, openAIKey: Option[String]): this.type = {
    if (bearerToken.isEmpty && openAIKey.isDefined) {
      bearerToken = Some(spark.sparkContext.broadcast(openAIKey.get))
    }
    this
  }

  def getBearerToken: String = {
    if (bearerToken.isDefined) bearerToken.get.value else ""
  }

  override def beforeAnnotate(dataset: Dataset[_]): Dataset[_] = {
    this.setBearerTokenIfNotSet(
      dataset.sparkSession,
      Some(ConfigLoader.getConfigStringValue(ConfigHelper.openAIAPIKey)))
    dataset
  }

  /** takes a document and annotations and produces new annotations of this annotator's annotation
    * type
    *
    * @param annotations
    *   Annotations that correspond to inputAnnotationCols generated by previous annotators if any
    * @return
    *   any number of annotations processed for every input annotation. Not necessary one to one
    *   relationship
    */
  override def annotate(annotations: Seq[Annotation]): Seq[Annotation] = {

    val inputs = annotations.map(annotation => annotation.result)
    val userJson = JsonBuilder.formatOptionalField("user", get(user))

    val jsonTemplate =
      """
        |{
        |    "model": "%s",
        |    "input": "%s"
        |    %s
        |}
        |""".stripMargin

    val jsons = inputs.map(input => (input, jsonTemplate.format($(model), input, userJson)))
    val openAIUrlEmbeddings = "https://api.openai.com/v1/embeddings"
    val annotationsEmbeddings = jsons.map { case (input, json) =>
      val response = post(openAIUrlEmbeddings, json)
      Annotation(DOCUMENT, 0, input.length, input, Map(), embeddings = response)
    }
    annotationsEmbeddings
  }

  private def post(url: String, jsonBody: String): Array[Float] = {
    val httpPost = new HttpPost(url)
    httpPost.setEntity(new StringEntity(jsonBody, ContentType.APPLICATION_JSON))
    val bearerToken = getBearerToken
    require(bearerToken.nonEmpty, "OpenAI API Key required")
    httpPost.setHeader("Authorization", s"Bearer $bearerToken")

    var embeddings: List[Float] = List.empty
    var responseBody: String = ""

    val httpclient: CloseableHttpClient = HttpClients.createDefault()
    try {
      val response = httpclient.execute(httpPost)
      responseBody = EntityUtils.toString(response.getEntity)
      val textEmbeddingResponse = JsonParser.parseObject[TextEmbeddingResponse](responseBody)
      embeddings = textEmbeddingResponse.data.head.embedding
    } catch {
      case ex: Exception =>
        if (responseBody.contains("error"))
          throw new Exception(responseBody)
        else ex.printStackTrace()
    } finally {
      httpclient.close()
    }

    embeddings.toArray
  }

}
