/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.client;

import com.amazonaws.services.s3.model.S3Object;
import com.johnsnowlabs.client.CloudClient;
import com.johnsnowlabs.client.CloudManager;
import com.johnsnowlabs.client.CloudManager$;
import com.johnsnowlabs.client.aws.AWSClient;
import com.johnsnowlabs.client.aws.AWSGateway;
import com.johnsnowlabs.client.azure.AzureClient;
import com.johnsnowlabs.client.gcp.GCPClient;
import com.johnsnowlabs.client.util.CloudHelper$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkFiles$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CloudResources$ {
    public static CloudResources$ MODULE$;

    static {
        new CloudResources$();
    }

    public Option<String> downloadModelFromCloud(AWSGateway awsGateway, String cachePath, String modelName, String sourceS3URI) {
        Option option;
        CloudClient clientInstance;
        Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseS3URI(sourceS3URI, CloudHelper$.MODULE$.parseS3URI$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String sourceBucketName = (String)tuple2._1();
        String sourceKey = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sourceBucketName, (Object)sourceKey);
        Tuple2 tuple23 = tuple22;
        String sourceBucketName2 = (String)tuple23._1();
        String sourceKey2 = (String)tuple23._2();
        S3Object zippedModel = awsGateway.getS3Object(sourceBucketName2, sourceKey2);
        CloudManager cloudManager = new CloudManager(CloudManager$.MODULE$.$lessinit$greater$default$1());
        CloudClient cloudClient = clientInstance = cloudManager.getClientInstance(cachePath);
        if (cloudClient instanceof AWSClient) {
            Option option2;
            AWSClient aWSClient = (AWSClient)cloudClient;
            String destinationS3URI = cachePath.replace("s3:", "s3a:");
            boolean modelExists = this.doesModelExistInExternalCloudStorage(modelName, destinationS3URI, aWSClient);
            if (!modelExists) {
                String destinationKey = this.unzipInExternalCloudStorage(sourceKey2, destinationS3URI, aWSClient, zippedModel);
                option2 = Option$.MODULE$.apply((Object)destinationKey);
            } else {
                option2 = Option$.MODULE$.apply((Object)new StringBuilder(1).append(destinationS3URI).append("/").append(modelName).toString());
            }
            option = option2;
        } else if (cloudClient instanceof GCPClient) {
            Option option3;
            GCPClient gCPClient = (GCPClient)cloudClient;
            boolean modelExists = this.doesModelExistInExternalCloudStorage(modelName, cachePath, gCPClient);
            if (!modelExists) {
                String destination = this.unzipInExternalCloudStorage(sourceS3URI, cachePath, gCPClient, zippedModel);
                option3 = Option$.MODULE$.apply((Object)destination);
            } else {
                option3 = Option$.MODULE$.apply((Object)new StringBuilder(1).append(cachePath).append("/").append(modelName).toString());
            }
            option = option3;
        } else if (cloudClient instanceof AzureClient) {
            AzureClient azureClient = (AzureClient)cloudClient;
            boolean modelExists = this.doesModelExistInExternalCloudStorage(modelName, cachePath, azureClient);
            None$ modelPath = None$.MODULE$;
            if (!modelExists) {
                String destination = this.unzipInExternalCloudStorage(sourceS3URI, cachePath, azureClient, zippedModel);
                modelPath = new Some((Object)CloudHelper$.MODULE$.transformURIToWASB(destination));
            } else {
                modelPath = new Some((Object)CloudHelper$.MODULE$.transformURIToWASB(new StringBuilder(1).append(cachePath).append("/").append(modelName).toString()));
            }
            option = modelPath;
        } else {
            throw new MatchError((Object)cloudClient);
        }
        return option;
    }

    private boolean doesModelExistInExternalCloudStorage(String modelName, String destinationURI, CloudClient cloudClient) {
        boolean bl;
        CloudClient cloudClient2 = cloudClient;
        if (cloudClient2 instanceof AWSClient) {
            AWSClient aWSClient = (AWSClient)cloudClient2;
            Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseS3URI(destinationURI, CloudHelper$.MODULE$.parseS3URI$default$2());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String destinationBucketName = (String)tuple2._1();
            String destinationKey = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)destinationBucketName, (Object)destinationKey);
            Tuple2 tuple23 = tuple22;
            String destinationBucketName2 = (String)tuple23._1();
            String destinationKey2 = (String)tuple23._2();
            String modelPath = new StringBuilder(1).append(destinationKey2).append("/").append(modelName).toString();
            bl = aWSClient.doesBucketPathExist(destinationBucketName2, modelPath);
        } else if (cloudClient2 instanceof GCPClient) {
            GCPClient gCPClient = (GCPClient)cloudClient2;
            Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseGCPStorageURI(destinationURI);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String destinationBucketName = (String)tuple2._1();
            String destinationStoragePath = (String)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)destinationBucketName, (Object)destinationStoragePath);
            Tuple2 tuple25 = tuple24;
            String destinationBucketName3 = (String)tuple25._1();
            String destinationStoragePath2 = (String)tuple25._2();
            String modelPath = new StringBuilder(1).append(destinationStoragePath2).append("/").append(modelName).toString();
            bl = gCPClient.doesBucketPathExist(destinationBucketName3, modelPath);
        } else if (cloudClient2 instanceof AzureClient) {
            AzureClient azureClient = (AzureClient)cloudClient2;
            Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseAzureBlobURI(destinationURI);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String destinationBucketName = (String)tuple2._1();
            String destinationStoragePath = (String)tuple2._2();
            Tuple2 tuple26 = new Tuple2((Object)destinationBucketName, (Object)destinationStoragePath);
            Tuple2 tuple27 = tuple26;
            String destinationBucketName4 = (String)tuple27._1();
            String destinationStoragePath3 = (String)tuple27._2();
            String modelPath = new StringBuilder(1).append(destinationStoragePath3).append("/").append(modelName).toString();
            bl = azureClient.doesBucketPathExist(destinationBucketName4, modelPath);
        } else {
            throw new MatchError((Object)cloudClient2);
        }
        return bl;
    }

    private String unzipInExternalCloudStorage(String sourceKey, String destinationStorageURI, CloudClient cloudClient, S3Object zippedModel) {
        ZipInputStream zipInputStream = new ZipInputStream((InputStream)zippedModel.getObjectContent());
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        String zipFile = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceKey.split("/"))).last();
        String modelName = zipFile.substring(0, zipFile.indexOf(".zip"));
        Predef$.MODULE$.println((Object)new StringBuilder(48).append("Uploading model ").append(modelName).append(" to external Cloud Storage URI: ").append(destinationStorageURI).toString());
        while (zipEntry != null) {
            if (!zipEntry.isDirectory()) {
                BoxedUnit boxedUnit;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                CloudClient cloudClient2 = cloudClient;
                if (cloudClient2 instanceof AWSClient) {
                    Tuple3<AWSClient, String, String> tuple3 = this.getS3Config(destinationStorageURI);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    AWSClient awsGatewayDestination = (AWSClient)tuple3._1();
                    String destinationBucketName = (String)tuple3._2();
                    String destinationKey = (String)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)awsGatewayDestination, (Object)destinationBucketName, (Object)destinationKey);
                    Tuple3 tuple33 = tuple32;
                    AWSClient awsGatewayDestination2 = (AWSClient)tuple33._1();
                    String destinationBucketName2 = (String)tuple33._2();
                    String destinationKey2 = (String)tuple33._3();
                    String fileName = new StringBuilder(1).append(modelName).append("/").append(zipEntry.getName()).toString();
                    String destinationS3Path = new StringBuilder(1).append(destinationKey2).append("/").append(fileName).toString();
                    awsGatewayDestination2.copyFileToBucket(destinationBucketName2, destinationS3Path, inputStream);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (cloudClient2 instanceof GCPClient) {
                    GCPClient gCPClient = (GCPClient)cloudClient2;
                    Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseGCPStorageURI(destinationStorageURI);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String destinationBucketName = (String)tuple2._1();
                    String destinationStoragePath = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)destinationBucketName, (Object)destinationStoragePath);
                    Tuple2 tuple23 = tuple22;
                    String destinationBucketName3 = (String)tuple23._1();
                    String destinationStoragePath2 = (String)tuple23._2();
                    String destinationGCPStoragePath = new StringBuilder(2).append(destinationStoragePath2).append("/").append(modelName).append("/").append(zipEntry.getName()).toString();
                    gCPClient.copyFileToBucket(destinationBucketName3, destinationGCPStoragePath, inputStream);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (cloudClient2 instanceof AzureClient) {
                    AzureClient azureClient = (AzureClient)cloudClient2;
                    Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseAzureBlobURI(destinationStorageURI);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    String destinationBucketName = (String)tuple2._1();
                    String destinationStoragePath = (String)tuple2._2();
                    Tuple2 tuple24 = new Tuple2((Object)destinationBucketName, (Object)destinationStoragePath);
                    Tuple2 tuple25 = tuple24;
                    String destinationBucketName4 = (String)tuple25._1();
                    String destinationStoragePath3 = (String)tuple25._2();
                    String destinationAzureStoragePath = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2).append(destinationStoragePath3).append("/").append(modelName).append("/").append(zipEntry.getName()).toString())).stripPrefix("/");
                    azureClient.copyFileToBucket(destinationBucketName4, destinationAzureStoragePath, inputStream);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)cloudClient2);
                }
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        return new StringBuilder(1).append(destinationStorageURI).append("/").append(modelName).toString();
    }

    private Tuple3<AWSClient, String, String> getS3Config(String destinationS3URI) {
        CloudManager cloudManager = new CloudManager(CloudManager$.MODULE$.$lessinit$greater$default$1());
        CloudClient clientInstance = cloudManager.getClientInstance(destinationS3URI);
        Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseS3URI(destinationS3URI, CloudHelper$.MODULE$.parseS3URI$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String destinationBucketName = (String)tuple2._1();
        String destinationKey = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)destinationBucketName, (Object)destinationKey);
        Tuple2 tuple23 = tuple22;
        String destinationBucketName2 = (String)tuple23._1();
        String destinationKey2 = (String)tuple23._2();
        return new Tuple3((Object)((AWSClient)clientInstance), (Object)destinationBucketName2, (Object)destinationKey2);
    }

    public void storeLogFileInCloudStorage(String outputLogsPath, String targetPath) {
        String logsPath;
        Map parameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"credentialsType"), (Object)"proprietary")}));
        CloudManager cloudManager = new CloudManager((Map<String, String>)parameters);
        CloudClient clientInstance = cloudManager.getClientInstance(logsPath = new StringOps(Predef$.MODULE$.augmentString(outputLogsPath)).nonEmpty() ? outputLogsPath : this.getLogsFolder());
        CloudClient cloudClient = clientInstance;
        if (cloudClient instanceof AWSClient) {
            AWSClient aWSClient = (AWSClient)cloudClient;
            this.storeLogFileInS3(outputLogsPath, targetPath, aWSClient);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cloudClient instanceof GCPClient) {
            GCPClient gCPClient = (GCPClient)cloudClient;
            this.storeLogFileInGCPStorage(outputLogsPath, targetPath, gCPClient);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (cloudClient instanceof AzureClient) {
            AzureClient azureClient = (AzureClient)cloudClient;
            this.storeLogFileInAzureStorage(outputLogsPath, targetPath, azureClient);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)cloudClient);
        }
    }

    private void storeLogFileInS3(String outputLogsPath, String targetPath, AWSClient awsClient) {
        Tuple2 tuple2;
        String logsPathSuffix = (String)new StringOps(Predef$.MODULE$.augmentString(outputLogsPath)).takeWhile((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)CloudResources$.$anonfun$storeLogFileInS3$1(BoxesRunTime.unboxToChar((Object)x$9))));
        String string = logsPathSuffix;
        boolean bl = "s3".equals(string) ? true : "s3a".equals(string);
        if (bl) {
            tuple2 = CloudHelper$.MODULE$.parseS3URI(outputLogsPath, true);
        } else if (this.getLogsFolder().startsWith("s3") || this.getLogsFolder().startsWith("s3a")) {
            tuple2 = CloudResources$.parseConfigS3Path$1();
        } else {
            throw new IllegalArgumentException("Unsupported outputLogsPath");
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String s3Bucket = (String)tuple22._1();
        String s3Path = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)s3Bucket, (Object)s3Path);
        Tuple2 tuple24 = tuple23;
        String s3Bucket2 = (String)tuple24._1();
        String s3Path2 = (String)tuple24._2();
        String s3FilePath = new StringBuilder(1).append(s3Path2.substring("s3://".length())).append("/").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetPath.split("/"))).last()).toString();
        awsClient.copyInputStreamToBucket(s3Bucket2, s3FilePath, targetPath);
    }

    private String getLogsFolder() {
        return ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.annotatorLogFolder());
    }

    private void storeLogFileInGCPStorage(String outputLogsPath, String targetPath, GCPClient gcpClient) {
        Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseGCPStorageURI(outputLogsPath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String gcpBucket = (String)tuple2._1();
        String storagePath = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)gcpBucket, (Object)storagePath);
        Tuple2 tuple23 = tuple22;
        String gcpBucket2 = (String)tuple23._1();
        String storagePath2 = (String)tuple23._2();
        String fileName = ((Object)Paths.get(targetPath, new String[0]).getFileName()).toString();
        String destinationPath = new StringBuilder(1).append(storagePath2).append("/").append(fileName).toString();
        gcpClient.copyInputStreamToBucket(gcpBucket2, destinationPath, targetPath);
    }

    private void storeLogFileInAzureStorage(String outputLogsPath, String targetPath, AzureClient azureClient) {
        Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseAzureBlobURI(outputLogsPath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String azureBucket = (String)tuple2._1();
        String storagePath = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)azureBucket, (Object)storagePath);
        Tuple2 tuple23 = tuple22;
        String azureBucket2 = (String)tuple23._1();
        String storagePath2 = (String)tuple23._2();
        String fileName = ((Object)Paths.get(targetPath, new String[0]).getFileName()).toString();
        String destinationPath = new StringBuilder(1).append(storagePath2).append("/").append(fileName).toString();
        azureClient.copyInputStreamToBucket(azureBucket2, destinationPath, targetPath);
    }

    public URI downloadBucketToLocalTmp(String bucketURI, String tempLocalPath, boolean isIndex) {
        URI uRI;
        CloudManager cloudManager = new CloudManager(CloudManager$.MODULE$.$lessinit$greater$default$1());
        CloudClient clientInstance = cloudManager.getClientInstanceFromConfigurationParams(bucketURI);
        String directory = tempLocalPath.isEmpty() ? SparkFiles$.MODULE$.getRootDirectory() : tempLocalPath;
        CloudClient cloudClient = clientInstance;
        if (cloudClient instanceof AWSClient) {
            AWSClient aWSClient = (AWSClient)cloudClient;
            Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseS3URI(bucketURI, CloudHelper$.MODULE$.parseS3URI$default$2());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String bucketName = (String)tuple2._1();
            String keyPrefix = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)bucketName, (Object)keyPrefix);
            Tuple2 tuple23 = tuple22;
            String bucketName2 = (String)tuple23._1();
            String keyPrefix2 = (String)tuple23._2();
            aWSClient.downloadFilesFromBucketToDirectory(bucketName2, keyPrefix2, directory, isIndex);
            uRI = Paths.get(directory, keyPrefix2).toUri();
        } else if (cloudClient instanceof GCPClient) {
            GCPClient gCPClient = (GCPClient)cloudClient;
            Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseGCPStorageURI(bucketURI);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String bucketName = (String)tuple2._1();
            String keyPrefix = (String)tuple2._2();
            Tuple2 tuple24 = new Tuple2((Object)bucketName, (Object)keyPrefix);
            Tuple2 tuple25 = tuple24;
            String bucketName3 = (String)tuple25._1();
            String keyPrefix3 = (String)tuple25._2();
            gCPClient.downloadFilesFromBucketToDirectory(bucketName3, keyPrefix3, directory, isIndex);
            uRI = Paths.get(directory, keyPrefix3).toUri();
        } else if (cloudClient instanceof AzureClient) {
            AzureClient azureClient = (AzureClient)cloudClient;
            Tuple2<String, String> tuple2 = CloudHelper$.MODULE$.parseAzureBlobURI(bucketURI);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String bucketName = (String)tuple2._1();
            String keyPrefix = (String)tuple2._2();
            Tuple2 tuple26 = new Tuple2((Object)bucketName, (Object)keyPrefix);
            Tuple2 tuple27 = tuple26;
            String bucketName4 = (String)tuple27._1();
            String keyPrefix4 = (String)tuple27._2();
            azureClient.downloadFilesFromBucketToDirectory(bucketName4, keyPrefix4, directory, isIndex);
            uRI = Paths.get(directory, keyPrefix4).toUri();
        } else {
            throw new MatchError((Object)cloudClient);
        }
        return uRI;
    }

    public String downloadBucketToLocalTmp$default$2() {
        return "";
    }

    public boolean downloadBucketToLocalTmp$default$3() {
        return false;
    }

    private static final Tuple2 parseConfigS3Path$1() {
        String s3Bucket = ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalS3BucketKey());
        String s3Path = new StringBuilder(1).append(ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.annotatorLogFolder())).append("/").toString();
        return new Tuple2((Object)s3Bucket, (Object)s3Path);
    }

    public static final /* synthetic */ boolean $anonfun$storeLogFileInS3$1(char x$9) {
        return x$9 != ':';
    }

    private CloudResources$() {
        MODULE$ = this;
    }
}

