/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.client.azure;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.johnsnowlabs.client.CloudStorage;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0003\u0006\u0001'!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003 \u0011\u0015Y\u0003\u0001\"\u0001-\u0011!\t\u0004\u0001#b\u0001\n\u0013\u0011\u0004\"\u0002\u001f\u0001\t\u0003j\u0004\"B#\u0001\t\u00032\u0005\"B,\u0001\t\u0003B\u0006\"B/\u0001\t\u0003r&\u0001D!{kJ,w)\u0019;fo\u0006L(BA\u0006\r\u0003\u0015\t'0\u001e:f\u0015\tia\"\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001fA\tAB[8i]Ntwn\u001e7bENT\u0011!E\u0001\u0004G>l7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c95\tA\"\u0003\u0002\u001e\u0019\ta1\t\\8vIN#xN]1hK\u0006\u00112\u000f^8sC\u001e,\u0017iY2pk:$h*Y7f!\t\u0001sE\u0004\u0002\"KA\u0011!EF\u0007\u0002G)\u0011AEE\u0001\u0007yI|w\u000e\u001e \n\u0005\u00192\u0012A\u0002)sK\u0012,g-\u0003\u0002)S\t11\u000b\u001e:j]\u001eT!A\n\f\u0002\u0015\u0005\u001c7m\\;oi.+\u00170\u0001\u0004=S:LGO\u0010\u000b\u0004[=\u0002\u0004C\u0001\u0018\u0001\u001b\u0005Q\u0001\"\u0002\u0010\u0004\u0001\u0004y\u0002\"\u0002\u0016\u0004\u0001\u0004y\u0012!\u00052m_\n\u001cVM\u001d<jG\u0016\u001cE.[3oiV\t1\u0007\u0005\u00025u5\tQG\u0003\u00027o\u0005!!\r\\8c\u0015\tA\u0014(A\u0004ti>\u0014\u0018mZ3\u000b\u0005-\u0001\u0012BA\u001e6\u0005E\u0011En\u001c2TKJ4\u0018nY3DY&,g\u000e^\u0001\u0014I>,7OQ;dW\u0016$\b+\u0019;i\u000bbL7\u000f\u001e\u000b\u0004}\u0005\u001b\u0005CA\u000b@\u0013\t\u0001eCA\u0004C_>dW-\u00198\t\u000b\t+\u0001\u0019A\u0010\u0002\u0015\t,8m[3u\u001d\u0006lW\rC\u0003E\u000b\u0001\u0007q$\u0001\u0005gS2,\u0007+\u0019;i\u0003A\u0019w\u000e]=GS2,Gk\u001c\"vG.,G\u000f\u0006\u0003H\u0015.k\u0005CA\u000bI\u0013\tIeC\u0001\u0003V]&$\b\"\u0002\"\u0007\u0001\u0004y\u0002\"\u0002'\u0007\u0001\u0004y\u0012a\u00043fgRLg.\u0019;j_:\u0004\u0016\r\u001e5\t\u000b93\u0001\u0019A(\u0002\u0017%t\u0007/\u001e;TiJ,\u0017-\u001c\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000b!![8\u000b\u0003Q\u000bAA[1wC&\u0011a+\u0015\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\fd_BL\u0018J\u001c9viN#(/Z1n)>\u0014UoY6fiR!q)\u0017.\\\u0011\u0015\u0011u\u00011\u0001 \u0011\u0015!u\u00011\u0001 \u0011\u0015av\u00011\u0001 \u00039\u0019x.\u001e:dK\u001aKG.\u001a)bi\"\f!\u0005Z8x]2|\u0017\r\u001a$jY\u0016\u001chI]8n\u0005V\u001c7.\u001a;U_\u0012K'/Z2u_JLH#B$`A\u0006\u001c\u0007\"\u0002\"\t\u0001\u0004y\u0002\"\u0002#\t\u0001\u0004y\u0002\"\u00022\t\u0001\u0004y\u0012!\u00043je\u0016\u001cGo\u001c:z!\u0006$\b\u000eC\u0003e\u0011\u0001\u0007a(A\u0004jg&sG-\u001a=")
public class AzureGateway
implements CloudStorage {
    private BlobServiceClient blobServiceClient;
    private final String storageAccountName;
    private final String accountKey;
    private volatile boolean bitmap$0;

    /*
     * WARNING - void declaration
     */
    private BlobServiceClient blobServiceClient$lzycompute() {
        AzureGateway azureGateway = this;
        synchronized (azureGateway) {
            if (!this.bitmap$0) {
                void var3_3;
                String connectionString = new StringBuilder(87).append("DefaultEndpointsProtocol=https;AccountName=").append(this.storageAccountName).append(";AccountKey=").append(this.accountKey).append(";EndpointSuffix=core.windows.net").toString();
                BlobServiceClient blobServiceClient = new BlobServiceClientBuilder().connectionString(connectionString).buildClient();
                this.blobServiceClient = var3_3;
                this.bitmap$0 = true;
            }
        }
        return this.blobServiceClient;
    }

    private BlobServiceClient blobServiceClient() {
        return !this.bitmap$0 ? this.blobServiceClient$lzycompute() : this.blobServiceClient;
    }

    @Override
    public boolean doesBucketPathExist(String bucketName, String filePath) {
        BlobContainerClient blobContainerClient = this.blobServiceClient().getBlobContainerClient(bucketName);
        String prefix = filePath.endsWith("/") ? filePath : new StringBuilder(1).append(filePath).append("/").toString();
        Iterator blobs = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(blobContainerClient.listBlobs().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AzureGateway.$anonfun$doesBucketPathExist$1(prefix, x$1)));
        return blobs.nonEmpty();
    }

    @Override
    public void copyFileToBucket(String bucketName, String destinationPath, InputStream inputStream) {
        BlockBlobClient blockBlobClient = this.blobServiceClient().getBlobContainerClient(bucketName).getBlobClient(destinationPath).getBlockBlobClient();
        int streamSize = inputStream.available();
        blockBlobClient.upload(inputStream, (long)streamSize);
    }

    @Override
    public void copyInputStreamToBucket(String bucketName, String filePath, String sourceFilePath) {
        FileSystem fileSystem = FileSystem.get((Configuration)ResourceHelper$.MODULE$.spark().sparkContext().hadoopConfiguration());
        FSDataInputStream inputStream = fileSystem.open(new Path(sourceFilePath));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)byteArrayOutputStream, (int)4096, (boolean)true);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BlockBlobClient blockBlobClient = this.blobServiceClient().getBlobContainerClient(bucketName).getBlobClient(filePath).getBlockBlobClient();
        int streamSize = byteArrayInputStream.available();
        blockBlobClient.upload((InputStream)byteArrayInputStream, (long)streamSize);
    }

    @Override
    public void downloadFilesFromBucketToDirectory(String bucketName, String filePath, String directoryPath, boolean isIndex) {
        try {
            BlobContainerClient blobContainerClient = this.blobServiceClient().getBlobContainerClient(bucketName);
            ListBlobsOptions blobOptions = new ListBlobsOptions().setPrefix(filePath);
            Seq blobs = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(blobContainerClient.listBlobs(blobOptions, null).iterator()).asScala()).toSeq();
            if (blobs.isEmpty()) {
                throw new Exception(new StringBuilder(81).append("Not found blob path ").append(filePath).append(" in container ").append(bucketName).append(" when downloading files from Azure Blob Storage").toString());
            }
            blobs.foreach((Function1 & Serializable & scala.Serializable)blobItem -> {
                Boolean bl;
                String blobName = blobItem.getName();
                BlobClient blobClient = blobContainerClient.getBlobClient(blobName);
                File file = new File(new StringBuilder(1).append(directoryPath).append("/").append(blobName).toString());
                if (blobName.endsWith("/")) {
                    bl = BoxesRunTime.boxToBoolean((boolean)file.mkdirs());
                } else {
                    file.getParentFile().mkdirs();
                    FileOutputStream outputStream = new FileOutputStream(file);
                    blobClient.downloadStream((OutputStream)outputStream);
                    outputStream.close();
                    bl = BoxedUnit.UNIT;
                }
                return bl;
            });
        }
        catch (Exception e) {
            throw new Exception(new StringBuilder(54).append("Error when downloading files from Azure Blob Storage: ").append(e.getMessage()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$doesBucketPathExist$1(String prefix$1, BlobItem x$1) {
        return x$1.getName().startsWith(prefix$1);
    }

    public AzureGateway(String storageAccountName, String accountKey) {
        this.storageAccountName = storageAccountName;
        this.accountKey = accountKey;
    }
}

