/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.client.gcp;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.johnsnowlabs.client.CloudStorage;
import com.johnsnowlabs.client.gcp.GCPGateway$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.sparkproject.guava.collect.Iterables;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0004\b\u0001/!A!\u0005\u0001B\u0001B\u0003%1\u0005C\u0003/\u0001\u0011\u0005q\u0006\u0003\u00054\u0001!\u0015\r\u0011\"\u00035\u0011\u0015y\u0004\u0001\"\u0011A\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u001dA\u0007!%A\u0005\u0002%<q\u0001\u001e\b\u0002\u0002#\u0005QOB\u0004\u000e\u001d\u0005\u0005\t\u0012\u0001<\t\u000b9RA\u0011A<\t\u000faT\u0011\u0013!C\u0001s\nQqi\u0011)HCR,w/Y=\u000b\u0005=\u0001\u0012aA4da*\u0011\u0011CE\u0001\u0007G2LWM\u001c;\u000b\u0005M!\u0012\u0001\u00046pQ:\u001chn\\<mC\n\u001c(\"A\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\u0001j\u0011\u0001E\u0005\u0003CA\u0011Ab\u00117pk\u0012\u001cFo\u001c:bO\u0016\f\u0011\u0002\u001d:pU\u0016\u001cG/\u00133\u0011\u0005\u0011ZcBA\u0013*!\t1#$D\u0001(\u0015\tAc#\u0001\u0004=e>|GOP\u0005\u0003Ui\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!FG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0012\u0004CA\u0019\u0001\u001b\u0005q\u0001b\u0002\u0012\u0003!\u0003\u0005\raI\u0001\u000egR|'/Y4f\u00072LWM\u001c;\u0016\u0003U\u0002\"AN\u001f\u000e\u0003]R!\u0001O\u001d\u0002\u000fM$xN]1hK*\u0011!hO\u0001\u0006G2|W\u000f\u001a\u0006\u0003yQ\taaZ8pO2,\u0017B\u0001 8\u0005\u001d\u0019Fo\u001c:bO\u0016\f1\u0003Z8fg\n+8m[3u!\u0006$\b.\u0012=jgR$2!\u0011#G!\tI\")\u0003\u0002D5\t9!i\\8mK\u0006t\u0007\"B#\u0005\u0001\u0004\u0019\u0013A\u00032vG.,GOT1nK\")q\t\u0002a\u0001G\u0005Aa-\u001b7f!\u0006$\b.\u0001\td_BLh)\u001b7f)>\u0014UoY6fiR!!*\u0014(Q!\tI2*\u0003\u0002M5\t!QK\\5u\u0011\u0015)U\u00011\u0001$\u0011\u0015yU\u00011\u0001$\u0003=!Wm\u001d;j]\u0006$\u0018n\u001c8QCRD\u0007\"B)\u0006\u0001\u0004\u0011\u0016aC5oaV$8\u000b\u001e:fC6\u0004\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\u0005%|'\"A,\u0002\t)\fg/Y\u0005\u00033R\u00131\"\u00138qkR\u001cFO]3b[\u000692m\u001c9z\u0013:\u0004X\u000f^*ue\u0016\fW\u000eV8Ck\u000e\\W\r\u001e\u000b\u0005\u0015rkf\fC\u0003F\r\u0001\u00071\u0005C\u0003H\r\u0001\u00071\u0005C\u0003`\r\u0001\u00071%\u0001\bt_V\u00148-\u001a$jY\u0016\u0004\u0016\r\u001e5\u0002E\u0011|wO\u001c7pC\u00124\u0015\u000e\\3t\rJ|WNQ;dW\u0016$Hk\u001c#je\u0016\u001cGo\u001c:z)\u0015Q%m\u00193g\u0011\u0015)u\u00011\u0001$\u0011\u00159u\u00011\u0001$\u0011\u0015)w\u00011\u0001$\u00035!\u0017N]3di>\u0014\u0018\u0010U1uQ\"9qm\u0002I\u0001\u0002\u0004\t\u0015aB5t\u0013:$W\r_\u0001-I><h\u000e\\8bI\u001aKG.Z:Ge>l')^2lKR$v\u000eR5sK\u000e$xN]=%I\u00164\u0017-\u001e7uIQ*\u0012A\u001b\u0016\u0003\u0003.\\\u0013\u0001\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005ET\u0012AC1o]>$\u0018\r^5p]&\u00111O\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AC$D!\u001e\u000bG/Z<bsB\u0011\u0011GC\n\u0003\u0015a!\u0012!^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003iT#aI6")
public class GCPGateway
implements CloudStorage {
    private Storage storageClient;
    private final String projectId;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$1() {
        return GCPGateway$.MODULE$.$lessinit$greater$default$1();
    }

    private Storage storageClient$lzycompute() {
        GCPGateway gCPGateway = this;
        synchronized (gCPGateway) {
            if (!this.bitmap$0) {
                if (this.projectId == null || this.projectId.isEmpty()) {
                    throw new UnsupportedOperationException("projectId argument is mandatory to create GCP Storage client.");
                }
                this.storageClient = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).build().getService();
                this.bitmap$0 = true;
            }
        }
        return this.storageClient;
    }

    private Storage storageClient() {
        return !this.bitmap$0 ? this.storageClient$lzycompute() : this.storageClient;
    }

    @Override
    public boolean doesBucketPathExist(String bucketName, String filePath) {
        Storage storage = (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(this.projectId)).build().getService();
        Page blobs = storage.list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)filePath), Storage.BlobListOption.currentDirectory()});
        int blobsSize = Iterables.size((Iterable)blobs.iterateAll());
        return blobsSize > 0;
    }

    @Override
    public void copyFileToBucket(String bucketName, String destinationPath, InputStream inputStream) {
        BlobId blobId = BlobId.of((String)bucketName, (String)destinationPath);
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).build();
        this.storageClient().createFrom(blobInfo, inputStream, new Storage.BlobWriteOption[0]);
    }

    @Override
    public void copyInputStreamToBucket(String bucketName, String filePath, String sourceFilePath) {
        FileSystem fileSystem = FileSystem.get((Configuration)ResourceHelper$.MODULE$.spark().sparkContext().hadoopConfiguration());
        FSDataInputStream inputStream = fileSystem.open(new Path(sourceFilePath));
        BlobInfo blobInfo = BlobInfo.newBuilder((String)bucketName, (String)filePath).build();
        this.storageClient().createFrom(blobInfo, (InputStream)inputStream, new Storage.BlobWriteOption[0]);
    }

    @Override
    public void downloadFilesFromBucketToDirectory(String bucketName, String filePath, String directoryPath, boolean isIndex) {
        try {
            Blob[] blobs = (Blob[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.storageClient().list(bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)filePath)}).getValues()).asScala()).toArray(ClassTag$.MODULE$.apply(Blob.class));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blobs)).foreach((Function1 & Serializable & scala.Serializable)blob -> {
                Boolean bl;
                String blobName = blob.getName();
                File file = new File(new StringBuilder(1).append(directoryPath).append("/").append(blobName).toString());
                if (blobName.endsWith("/")) {
                    bl = BoxesRunTime.boxToBoolean((boolean)file.mkdirs());
                } else {
                    file.getParentFile().mkdirs();
                    blob.downloadTo(file.toPath());
                    bl = BoxedUnit.UNIT;
                }
                return bl;
            });
        }
        catch (Exception e) {
            throw new Exception(new StringBuilder(57).append("Error when downloading files from GCP Storage directory: ").append(e.getMessage()).toString());
        }
    }

    public boolean downloadFilesFromBucketToDirectory$default$4() {
        return false;
    }

    public GCPGateway(String projectId) {
        this.projectId = projectId;
    }
}

