/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.client.util;

import com.johnsnowlabs.nlp.util.io.CloudStorageType$;
import java.net.URI;
import java.net.URL;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;

public final class CloudHelper$ {
    public static CloudHelper$ MODULE$;

    static {
        new CloudHelper$();
    }

    public Tuple2<String, String> parseS3URI(String s3URI, boolean includePrefixInKey) {
        String prefix = s3URI.startsWith("s3:") ? "s3://" : "s3a://";
        String bucketName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s3URI.substring(prefix.length()).split("/"))).head();
        String key = s3URI.substring(new StringBuilder(0).append(prefix).append(bucketName).toString().length() + 1);
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(bucketName)).nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "S3 bucket name is empty!");
        return new Tuple2((Object)bucketName, (Object)(includePrefixInKey ? new StringBuilder(0).append(prefix).append(key).toString() : key));
    }

    public boolean parseS3URI$default$2() {
        return false;
    }

    public Tuple2<String, String> parseGCPStorageURI(String gcpStorageURI) {
        String prefix = "gs://";
        String bucketName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gcpStorageURI.substring(prefix.length()).split("/"))).head();
        String storagePath = gcpStorageURI.substring(new StringBuilder(0).append(prefix).append(bucketName).toString().length() + 1);
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(bucketName)).nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "GCP Storage bucket name is empty!");
        return new Tuple2((Object)bucketName, (Object)storagePath);
    }

    public Tuple2<String, String> parseAzureBlobURI(String azureBlobURI) {
        URI uri = new URI(azureBlobURI);
        String[] parts = new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).stripPrefix("/").split("/", 2);
        String containerName = parts[0];
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(containerName)).nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "Azure container name is empty!");
        String blobPath = parts.length > 1 ? parts[1] : "";
        return new Tuple2((Object)containerName, (Object)blobPath);
    }

    public String getAccountNameFromAzureBlobURI(String azureBlobURI) {
        URI uri = new URI(azureBlobURI);
        String host = uri.getHost();
        String accountName = new StringOps(Predef$.MODULE$.augmentString(host)).stripSuffix(".blob.core.windows.net");
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(accountName)).nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "Azure storage account name is empty!");
        return accountName;
    }

    public String transformURIToWASB(String azureURI) {
        URL url = new URL(azureURI);
        String host = url.getHost();
        String[] pathParts = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])url.getPath().split("/"))).filter((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CloudHelper$.$anonfun$transformURIToWASB$1(x$1)));
        String container = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathParts)).nonEmpty() ? pathParts[0] : "";
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(container)).nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "Azure container name is empty!");
        String pathWithoutContainer = pathParts.length > 1 ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathParts)).drop(1))).mkString("/") : "";
        return new StringBuilder(11).append("wasbs://").append(container).append("@").append(host).append("/").append(pathWithoutContainer).append("/").toString();
    }

    public boolean isCloudPath(String uri) {
        return this.isS3Path(uri) || this.isGCPStoragePath(uri) || this.isAzureBlobPath(uri);
    }

    public boolean isS3Path(String uri) {
        return uri.startsWith("s3://") || uri.startsWith("s3a://");
    }

    private boolean isGCPStoragePath(String uri) {
        return uri.startsWith("gs://");
    }

    private boolean isAzureBlobPath(String uri) {
        return uri.startsWith("https://") && uri.contains(".blob.core.windows.net/");
    }

    public Enumeration.Value cloudType(String uri) {
        Enumeration.Value value;
        if (this.isS3Path(uri)) {
            value = CloudStorageType$.MODULE$.S3();
        } else if (this.isGCPStoragePath(uri)) {
            value = CloudStorageType$.MODULE$.GCP();
        } else if (this.isAzureBlobPath(uri)) {
            value = CloudStorageType$.MODULE$.Azure();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(24).append("Unsupported URI scheme: ").append(uri).toString());
        }
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$transformURIToWASB$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    private CloudHelper$() {
        MODULE$ = this;
    }
}

