/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.crf;

import com.johnsnowlabs.ml.crf.DatasetMetadata;
import com.johnsnowlabs.ml.crf.EdgeCalculator$;
import com.johnsnowlabs.ml.crf.Instance;
import com.johnsnowlabs.ml.crf.InstanceLabels;
import com.johnsnowlabs.ml.crf.SparseArray;
import com.johnsnowlabs.ml.crf.Transition;
import com.johnsnowlabs.ml.crf.VectorMath$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001\u0002\r\u001a\u0001\tB\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005W!Aq\u0006\u0001BC\u0002\u0013\u0005\u0001\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00032\u0011\u00151\u0004\u0001\"\u00018\u0011\u001dY\u0004A1A\u0005\u0002)Ba\u0001\u0010\u0001!\u0002\u0013Y\u0003bB\u001f\u0001\u0005\u0004%\tA\u0010\u0005\u0007)\u0002\u0001\u000b\u0011B \t\u000fU\u0003!\u0019!C\u0001}!1a\u000b\u0001Q\u0001\n}Bqa\u0016\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004^\u0001\u0001\u0006I!\u0017\u0005\b=\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019y\u0006\u0001)A\u00053\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007B\u00024\u0001A\u0003%!\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003v\u0001\u0011%a\u000fC\u0003{\u0001\u0011%1\u0010C\u0003~\u0001\u0011%a\u0010C\u0004\u0002\u0002\u0001!\t!a\u0001\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a\taaIY\"bY\u000e,H.\u0019;pe*\u0011!dG\u0001\u0004GJ4'B\u0001\u000f\u001e\u0003\tiGN\u0003\u0002\u001f?\u0005a!n\u001c5og:|w\u000f\\1cg*\t\u0001%A\u0002d_6\u001c\u0001a\u0005\u0002\u0001GA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\f\u0011\"\\1y\u0019\u0016tw\r\u001e5\u0016\u0003-\u0002\"\u0001\n\u0017\n\u00055*#aA%oi\u0006QQ.\u0019=MK:<G\u000f\u001b\u0011\u0002\u00115,G/\u00193bi\u0006,\u0012!\r\t\u0003eMj\u0011!G\u0005\u0003ie\u0011q\u0002R1uCN,G/T3uC\u0012\fG/Y\u0001\n[\u0016$\u0018\rZ1uC\u0002\na\u0001P5oSRtDc\u0001\u001d:uA\u0011!\u0007\u0001\u0005\u0006S\u0015\u0001\ra\u000b\u0005\u0006_\u0015\u0001\r!M\u0001\u0007Y\u0006\u0014W\r\\:\u0002\u000f1\f'-\u001a7tA\u00051An\\4QQ&,\u0012a\u0010\t\u0004I\u0001\u0013\u0015BA!&\u0005\u0015\t%O]1z!\t\u0019\u0015K\u0004\u0002E\u001f:\u0011QI\u0014\b\u0003\r6s!a\u0012'\u000f\u0005![U\"A%\u000b\u0005)\u000b\u0013A\u0002\u001fs_>$h(C\u0001!\u0013\tqr$\u0003\u0002\u001d;%\u0011!dG\u0005\u0003!f\t!BV3di>\u0014X*\u0019;i\u0013\t\u00116K\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0006\u0003!f\tq\u0001\\8h!\"L\u0007%A\u0002qQ&\fA\u0001\u001d5jA\u0005)\u0011\r\u001c9iCV\t\u0011\fE\u0002%\u0001j\u0003\"aQ.\n\u0005q\u001b&A\u0002,fGR|'/\u0001\u0004bYBD\u0017\rI\u0001\u0005E\u0016$\u0018-A\u0003cKR\f\u0007%A\u0001d+\u0005\u0011\u0007c\u0001\u0013AGB\u0011A\u0005Z\u0005\u0003K\u0016\u0012QA\u00127pCR\f!a\u0019\u0011\u0002\u0013\r\fGnY;mCR,G\u0003B5mcN\u0004\"\u0001\n6\n\u0005-,#\u0001B+oSRDQ!\u001c\nA\u00029\f\u0001b]3oi\u0016t7-\u001a\t\u0003e=L!\u0001]\r\u0003\u0011%s7\u000f^1oG\u0016DQA\u001d\nA\u0002\t\fqa^3jO\"$8\u000fC\u0003u%\u0001\u00071-A\u0003tG\u0006dW-A\u0004dC2\u001c\u0007\u000b[5\u0015\t%<\b0\u001f\u0005\u0006[N\u0001\rA\u001c\u0005\u0006eN\u0001\rA\u0019\u0005\u0006iN\u0001\raY\u0001\nG\u0006d7-\u00117qQ\u0006$\"!\u001b?\t\u000b5$\u0002\u0019\u00018\u0002\u0011\r\fGn\u0019\"fi\u0006$\"![@\t\u000b5,\u0002\u0019\u00018\u0002/\u0005$Gm\u00142tKJ4X\rZ#ya\u0016\u001cG/\u0019;j_:\u001cH#C5\u0002\u0006\u0005\u001d\u00111BA\u000b\u0011\u0015\u0011h\u00031\u0001[\u0011\u0019\tIA\u0006a\u0001]\u0006A\u0011N\\:uC:\u001cW\rC\u0004\u0002\u000eY\u0001\r!a\u0004\u0002\u001d%t7\u000f^1oG\u0016d\u0015MY3mgB\u0019!'!\u0005\n\u0007\u0005M\u0011D\u0001\bJ]N$\u0018M\\2f\u0019\u0006\u0014W\r\\:\t\u000b\u00014\u0002\u0019A2\u0002)\u0005$G-T8eK2,\u0005\u0010]3di\u0006$\u0018n\u001c8t)\u001dI\u00171DA\u000f\u0003?AQA]\fA\u0002iCQ!\\\fA\u00029Da!!\t\u0018\u0001\u0004\u0019\u0017!B2p]N$\b")
public class FbCalculator {
    private final int maxLength;
    private final DatasetMetadata metadata;
    private final int labels;
    private final float[][][] logPhi;
    private final float[][][] phi;
    private final float[][] alpha;
    private final float[][] beta;
    private final float[] c;

    public int maxLength() {
        return this.maxLength;
    }

    public DatasetMetadata metadata() {
        return this.metadata;
    }

    public int labels() {
        return this.labels;
    }

    public float[][][] logPhi() {
        return this.logPhi;
    }

    public float[][][] phi() {
        return this.phi;
    }

    public float[][] alpha() {
        return this.alpha;
    }

    public float[][] beta() {
        return this.beta;
    }

    public float[] c() {
        return this.c;
    }

    public void calculate(Instance sentence, float[] weights, float scale) {
        Predef$.MODULE$.require(sentence.items().length() <= this.maxLength());
        this.calcPhi(sentence, weights, scale);
        this.calcAlpha(sentence);
        this.calcBeta(sentence);
    }

    private void calcPhi(Instance sentence, float[] weights, float scale) {
        int length = sentence.items().length();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            EdgeCalculator$.MODULE$.fillLogEdges((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])((SparseArray)sentence.items().apply(i)).values()), weights, scale, this.metadata(), this.logPhi()[i]);
            VectorMath$.MODULE$.copy(this.logPhi()[i], this.phi()[i]);
            VectorMath$.MODULE$.exp(this.phi()[i]);
        });
    }

    private void calcAlpha(Instance sentence) {
        int length = sentence.items().length();
        Predef$.MODULE$.require(length <= this.phi().length);
        VectorMath$.MODULE$.fillMatrix(this.alpha(), 0.0f);
        VectorMath$.MODULE$.fillVector(this.c(), 1.0f);
        VectorMath$.MODULE$.copy(this.phi()[0][0], this.alpha()[0]);
        this.c()[0] = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.alpha()[0])).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
        VectorMath$.MODULE$.multiply(this.alpha()[0], 1.0f / this.c()[0]);
        ObjectRef prev = ObjectRef.create((Object)this.alpha()[0]);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.labels()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)from -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.labels()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)to -> {
                float[] fArray = this.alpha()[i];
                fArray[to] = fArray[to] + ((float[])prev$1.elem)[from] * this.phi()[i][from][to];
            }));
            $this.c()[i] = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.alpha()[i])).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
            Predef$.MODULE$.require(this.c()[i] != 0.0f);
            VectorMath$.MODULE$.multiply(this.alpha()[i], 1.0f / this.c()[i]);
            prev$1.elem = this.alpha()[i];
        });
    }

    private void calcBeta(Instance sentence) {
        int length = sentence.items().length();
        Predef$.MODULE$.require(length <= this.phi().length);
        VectorMath$.MODULE$.fillMatrix(this.beta(), 0.0f);
        VectorMath$.MODULE$.fillVector(this.beta()[length - 1], 1.0f / this.c()[length - 1]);
        ObjectRef next = ObjectRef.create((Object)this.beta()[length - 1]);
        package$.MODULE$.Range().inclusive(length - 2, 0, -1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.labels()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)from -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.labels()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)to -> {
                float[] fArray = this.beta()[i];
                fArray[from$2] = fArray[from] + this.phi()[i + 1][from][to] * ((float[])next$1.elem)[to];
            }));
            VectorMath$.MODULE$.multiply(this.beta()[i], 1.0f / this.c()[i]);
            next$1.elem = this.beta()[i];
        });
    }

    public void addObservedExpectations(float[] weights, Instance instance, InstanceLabels instanceLabels, float c) {
        int length = instance.items().length();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int label = BoxesRunTime.unboxToInt((Object)instanceLabels.labels().apply(i));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((SparseArray)instance.items().apply(i)).values())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addObservedExpectations$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                FbCalculator.$anonfun$addObservedExpectations$3(this, label, weights, c, x$1);
                return BoxedUnit.UNIT;
            });
            int fromLabel = i > 0 ? BoxesRunTime.unboxToInt((Object)instanceLabels.labels().apply(i - 1)) : 0;
            Transition meta = new Transition(fromLabel, label);
            this.metadata().transFeature2Id().get((Object)meta).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fid -> {
                weights$2[fid] = weights[fid] + c;
            });
        });
    }

    public void addModelExpectations(float[] weights, Instance sentence, float f) {
        int length = sentence.items().length();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((SparseArray)sentence.items().apply(i)).values())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addModelExpectations$2(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            FbCalculator.$anonfun$addModelExpectations$3(this, weights, f, i, x$2);
            return BoxedUnit.UNIT;
        }));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.metadata().transFeature2Id().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addModelExpectations$6(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            FbCalculator.$anonfun$addModelExpectations$7(this, weights, f, i, x$3);
            return BoxedUnit.UNIT;
        }));
        this.metadata().transFeature2Id().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addModelExpectations$8(check$ifrefutable$4))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FbCalculator.$anonfun$addModelExpectations$9(x$4))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            FbCalculator.$anonfun$addModelExpectations$10(this, weights, f, x$5);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$addObservedExpectations$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addObservedExpectations$3(FbCalculator $this, int label$1, float[] weights$2, float c$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int attrId = tuple2._1$mcI$sp();
        float value = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        $this.metadata().attrFeatures2Id().get((Object)new Tuple2.mcII.sp(attrId, label$1)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)fId -> {
            weights$2[fId] = weights$2[fId] + c$1 * value;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$addModelExpectations$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addModelExpectations$3(FbCalculator $this, float[] weights$3, float const$1, int i$3, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int attrId = tuple2._1$mcI$sp();
        float value = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.metadata().attr2Features().apply(attrId))).foreach((Function1 & Serializable & scala.Serializable)feature -> {
            weights$3[feature.id()] = weights$3[feature.id()] + const$1 * $this.c()[i$3] * $this.alpha()[i$3][feature.label()] * $this.beta()[i$3][feature.label()] * value;
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$addModelExpectations$6(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addModelExpectations$7(FbCalculator $this, float[] weights$3, float const$1, int i$4, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Transition feature = (Transition)tuple2._1();
        int fid = tuple2._2$mcI$sp();
        int from = feature.stateFrom();
        int to = feature.stateTo();
        weights$3[fid] = weights$3[fid] + const$1 * $this.alpha()[i$4 - 1][from] * $this.phi()[i$4][from][to] * $this.beta()[i$4][to];
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$addModelExpectations$8(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$addModelExpectations$9(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Transition feature = (Transition)tuple2._1();
        boolean bl = feature.stateFrom() == 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addModelExpectations$10(FbCalculator $this, float[] weights$3, float const$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Transition feature = (Transition)tuple2._1();
        int fid = tuple2._2$mcI$sp();
        int to = feature.stateTo();
        weights$3[fid] = weights$3[fid] + const$1 * $this.phi()[0][0][to] * $this.beta()[0][to];
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public FbCalculator(int maxLength, DatasetMetadata metadata) {
        this.maxLength = maxLength;
        this.metadata = metadata;
        this.labels = metadata.label2Id().size();
        this.logPhi = (float[][][])Array$.MODULE$.fill(maxLength, (Function0 & Serializable & scala.Serializable)() -> VectorMath$.MODULE$.Matrix(this.labels(), this.labels()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))));
        this.phi = (float[][][])Array$.MODULE$.fill(maxLength, (Function0 & Serializable & scala.Serializable)() -> VectorMath$.MODULE$.Matrix(this.labels(), this.labels()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))));
        this.alpha = (float[][])Array$.MODULE$.fill(maxLength, (Function0 & Serializable & scala.Serializable)() -> VectorMath$.MODULE$.Vector(this.labels(), VectorMath$.MODULE$.Vector$default$2()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        this.beta = (float[][])Array$.MODULE$.fill(maxLength, (Function0 & Serializable & scala.Serializable)() -> VectorMath$.MODULE$.Vector(this.labels(), VectorMath$.MODULE$.Vector$default$2()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        this.c = (float[])Array$.MODULE$.fill(maxLength, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 1.0f, ClassTag$.MODULE$.Float());
    }
}

