/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators;

import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class LookAroundManager$ {
    public static LookAroundManager$ MODULE$;
    private final String LOOKAHEAD_PATTERN;
    private final String LOOKBEHIND_PATTERN;
    private final String SEMI_COLON;
    private final String FULL_STOP;
    private final String EXCLAMATION_MARK;
    private final String QUESTION_MARK;
    private final String END_FULL_STOPS_REGEX;
    private final String EMPTY_STR;
    private final String OR_STR;

    static {
        new LookAroundManager$();
    }

    public String LOOKAHEAD_PATTERN() {
        return this.LOOKAHEAD_PATTERN;
    }

    public String LOOKBEHIND_PATTERN() {
        return this.LOOKBEHIND_PATTERN;
    }

    public String SEMI_COLON() {
        return this.SEMI_COLON;
    }

    public String FULL_STOP() {
        return this.FULL_STOP;
    }

    public String EXCLAMATION_MARK() {
        return this.EXCLAMATION_MARK;
    }

    public String QUESTION_MARK() {
        return this.QUESTION_MARK;
    }

    public String END_FULL_STOPS_REGEX() {
        return this.END_FULL_STOPS_REGEX;
    }

    public String EMPTY_STR() {
        return this.EMPTY_STR;
    }

    public String OR_STR() {
        return this.OR_STR;
    }

    public String withReplacement(String text, String replacement, Regex.Match m, int groupIdx) {
        return text.replace(m.group(groupIdx), replacement);
    }

    public int withReplacement$default$4() {
        return 1;
    }

    public String process(String text, String[] patterns, String replacement) {
        String lookaheadPattern = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])patterns)).head();
        Predef$.MODULE$.require(lookaheadPattern.contains(this.LOOKAHEAD_PATTERN()) || lookaheadPattern.contains(this.LOOKBEHIND_PATTERN()), (Function0 & java.io.Serializable & Serializable)() -> "First pattern with action lookaround must contain a lookaround symbol, i.e. (?=criteria) or (?<=criteria)");
        String fullStopsTrimmed = text.replaceAll(this.END_FULL_STOPS_REGEX(), this.EMPTY_STR());
        String[] separators = (String[])((Object[])new String[]{this.SEMI_COLON(), this.FULL_STOP(), this.EXCLAMATION_MARK(), this.QUESTION_MARK()});
        String[] detectedSeps = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])separators)).withFilter((Function1 & java.io.Serializable & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)text.contains(s.replace("\\", "")))).map((Function1 & java.io.Serializable & Serializable)s -> s.replace("\\", ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] chunks = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])detectedSeps)).isEmpty() ? fullStopsTrimmed.split(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])detectedSeps)).mkString(this.OR_STR())) : (String[])((Object[])new String[]{fullStopsTrimmed});
        Regex lookaheadRegex = new StringOps(Predef$.MODULE$.augmentString(lookaheadPattern)).r();
        ListBuffer replacedChunks = new ListBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])chunks)).foreach((Function1 & java.io.Serializable & Serializable)c -> {
            String string;
            Option option = lookaheadRegex.findFirstMatchIn((CharSequence)c);
            if (option instanceof Some) {
                Some some = (Some)option;
                Regex.Match m = (Regex.Match)some.value();
                string = MODULE$.withReplacement((String)c, replacement, m, MODULE$.withReplacement$default$4());
            } else {
                string = c;
            }
            String res = string;
            return replacedChunks.$plus$eq((Object)res);
        });
        return detectedSeps.length > 0 ? replacedChunks.mkString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])detectedSeps)).head()) : replacedChunks.mkString();
    }

    private LookAroundManager$() {
        MODULE$ = this;
        this.LOOKAHEAD_PATTERN = "(?=";
        this.LOOKBEHIND_PATTERN = "(?<=";
        this.SEMI_COLON = "\\;";
        this.FULL_STOP = "\\.(?!\\d+)";
        this.EXCLAMATION_MARK = "\\!";
        this.QUESTION_MARK = "\\?";
        this.END_FULL_STOPS_REGEX = "\\.$";
        this.EMPTY_STR = "";
        this.OR_STR = "|";
    }
}

