/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.cv.util.transform;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class ImageResizeUtils$ {
    public static ImageResizeUtils$ MODULE$;

    static {
        new ImageResizeUtils$();
    }

    public BufferedImage resizeBufferedImage(int width, int height, int resample, BufferedImage image) {
        double scaleX = (double)width / (double)image.getWidth();
        double scaleY = (double)height / (double)image.getHeight();
        AffineTransform transform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp transformOp = new AffineTransformOp(transform, resample);
        BufferedImage result = transformOp.filter(image, null);
        return result;
    }

    public float[][][] normalizeAndConvertBufferedImage(BufferedImage img, double[] mean, double[] std, boolean doNormalize, boolean doRescale, double rescaleFactor) {
        ArrayBuffer[] data = (ArrayBuffer[])((Object[])new ArrayBuffer[]{(ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$), (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)});
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), img.getHeight()).foreach((Function1 & Serializable & scala.Serializable)y -> ImageResizeUtils$.$anonfun$normalizeAndConvertBufferedImage$1(img, doRescale, rescaleFactor, doNormalize, mean, std, data, BoxesRunTime.unboxToInt((Object)y)));
        return (float[][][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data)).map((Function1 & Serializable & scala.Serializable)x$2 -> (float[][])x$2.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)))));
    }

    public BufferedImage resampleBufferedImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage scaledImage = new BufferedImage(w * 2, h * 2, 2);
        AffineTransform at = AffineTransform.getScaleInstance(2.0, 2.0);
        AffineTransformOp ato = new AffineTransformOp(at, 1);
        scaledImage = ato.filter(image, scaledImage);
        return scaledImage;
    }

    public BufferedImage cropBufferedImage(BufferedImage bufferedImage, int x, int y, int width, int height) {
        return bufferedImage.getSubimage(x, y, width, height);
    }

    public BufferedImage resizeAndCenterCropImage(BufferedImage img, int requestedSize, int resample, double cropPct) {
        Tuple2.mcII.sp sp2;
        int height;
        Tuple2.mcII.sp sp3;
        int width = img.getWidth();
        Tuple2.mcII.sp sp4 = sp3 = width <= (height = img.getHeight()) ? new Tuple2.mcII.sp(width, height) : new Tuple2.mcII.sp(height, width);
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int shortEdge = sp3._1$mcI$sp();
        int longEdge = sp3._2$mcI$sp();
        Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(shortEdge, longEdge);
        Tuple2.mcII.sp sp6 = sp5;
        int shortEdge2 = sp6._1$mcI$sp();
        int longEdge2 = sp6._2$mcI$sp();
        double sizeForCrop = (double)requestedSize / cropPct;
        int newShortEdge = (int)sizeForCrop;
        int newLongEdge = (int)(sizeForCrop * (double)((float)longEdge2 / (float)shortEdge2));
        Tuple2.mcII.sp sp7 = sp2 = width <= height ? new Tuple2.mcII.sp(newShortEdge, newLongEdge) : new Tuple2.mcII.sp(newLongEdge, newShortEdge);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int resizeWidth = sp2._1$mcI$sp();
        int resizeHeight = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp8 = new Tuple2.mcII.sp(resizeWidth, resizeHeight);
        Tuple2.mcII.sp sp9 = sp8;
        int resizeWidth2 = sp9._1$mcI$sp();
        int resizeHeight2 = sp9._2$mcI$sp();
        BufferedImage resizedImage = this.resizeBufferedImage(resizeWidth2, resizeHeight2, resample, img);
        return this.centerCrop(resizedImage, requestedSize);
    }

    private BufferedImage centerCrop(BufferedImage image, int requestedSize) {
        int cropLeft = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(image.getWidth() - requestedSize)) / 2;
        int cropTop = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(image.getHeight() - requestedSize)) / 2;
        return this.cropBufferedImage(image, cropLeft, cropTop, requestedSize, requestedSize);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$normalizeAndConvertBufferedImage$2(BufferedImage img$1, int y$1, boolean doRescale$1, double rescaleFactor$1, boolean doNormalize$1, double[] mean$1, double[] std$1, ArrayBuffer RedList$1, ArrayBuffer GreenList$1, ArrayBuffer BlueList$1, int x) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        double rescaledBlue;
        int pixel = img$1.getRGB(x, y$1);
        Color color = new Color(pixel, true);
        double rescaledRed = doRescale$1 ? (double)color.getRed() * rescaleFactor$1 : (double)color.getRed();
        double rescaledGreen = doRescale$1 ? (double)color.getGreen() * rescaleFactor$1 : (double)color.getGreen();
        double d = rescaledBlue = doRescale$1 ? (double)color.getBlue() * rescaleFactor$1 : (double)color.getBlue();
        if (doNormalize$1) {
            double normR = (rescaledRed - BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mean$1)).head())) / BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(std$1)).head());
            double normG = (rescaledGreen - mean$1[1]) / std$1[1];
            double normB = (rescaledBlue - mean$1[2]) / std$1[2];
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)normR), (Object)BoxesRunTime.boxToDouble((double)normG), (Object)BoxesRunTime.boxToDouble((double)normB));
        } else {
            tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)rescaledRed), (Object)BoxesRunTime.boxToDouble((double)rescaledGreen), (Object)BoxesRunTime.boxToDouble((double)rescaledBlue));
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double red = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double green = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double blue = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)red), (Object)BoxesRunTime.boxToDouble((double)green), (Object)BoxesRunTime.boxToDouble((double)blue));
        Tuple3 tuple34 = tuple33;
        double red2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
        double green2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
        double blue2 = BoxesRunTime.unboxToDouble((Object)tuple34._3());
        RedList$1.$plus$eq((Object)BoxesRunTime.boxToFloat((float)((float)red2)));
        GreenList$1.$plus$eq((Object)BoxesRunTime.boxToFloat((float)((float)green2)));
        return BlueList$1.$plus$eq((Object)BoxesRunTime.boxToFloat((float)((float)blue2)));
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$normalizeAndConvertBufferedImage$1(BufferedImage img$1, boolean doRescale$1, double rescaleFactor$1, boolean doNormalize$1, double[] mean$1, double[] std$1, ArrayBuffer[] data$1, int y) {
        ArrayBuffer RedList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer GreenList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer BlueList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), img$1.getWidth()).foreach((Function1 & Serializable & scala.Serializable)x -> ImageResizeUtils$.$anonfun$normalizeAndConvertBufferedImage$2(img$1, y, doRescale$1, rescaleFactor$1, doNormalize$1, mean$1, std$1, RedList, GreenList, BlueList, BoxesRunTime.unboxToInt((Object)x)));
        ((ArrayBuffer)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data$1)).head()).$plus$eq(RedList.toArray(ClassTag$.MODULE$.Float()));
        data$1[1].$plus$eq(GreenList.toArray(ClassTag$.MODULE$.Float()));
        return data$1[2].$plus$eq(BlueList.toArray(ClassTag$.MODULE$.Float()));
    }

    private ImageResizeUtils$() {
        MODULE$ = this;
    }
}

