/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep;

import com.johnsnowlabs.nlp.annotators.parser.typdep.DependencyInstance;
import com.johnsnowlabs.nlp.annotators.parser.typdep.DependencyPipe;
import com.johnsnowlabs.nlp.annotators.parser.typdep.Options;
import com.johnsnowlabs.nlp.annotators.parser.typdep.Parameters;
import com.johnsnowlabs.nlp.annotators.parser.typdep.TrainFile;
import com.johnsnowlabs.nlp.annotators.parser.typdep.TypedDependencyParser;
import java.io.IOException;
import java.io.Serializable;

public class TrainDependencies
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TrainFile trainFile;
    private DependencyPipe dependencyPipe;
    private TypedDependencyParser typedDependencyParser;
    private Options options;
    private Parameters parameters;

    public DependencyPipe getDependencyPipe() {
        return this.dependencyPipe;
    }

    public void setDependencyPipe(DependencyPipe dependencyPipe) {
        this.dependencyPipe = dependencyPipe;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public TrainDependencies(TrainFile trainFile, DependencyPipe dependencyPipe, TypedDependencyParser typedDependencyParser, Options options) {
        this.trainFile = trainFile;
        this.dependencyPipe = dependencyPipe;
        this.typedDependencyParser = typedDependencyParser;
        this.options = options;
    }

    public void startTraining() throws IOException {
        DependencyInstance[] dependencyInstanceArray = this.dependencyPipe.createInstances(this.trainFile.path(), this.trainFile.conllFormat());
        this.dependencyPipe.pruneLabel(dependencyInstanceArray);
        this.typedDependencyParser.setParameters(new Parameters(this.dependencyPipe, this.options));
        this.typedDependencyParser.train(dependencyInstanceArray);
        this.setOptions(this.typedDependencyParser.getOptions());
        this.setParameters(this.typedDependencyParser.getParameters());
        this.setDependencyPipe(this.typedDependencyParser.getDependencyPipe());
    }
}

