/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep.util;

import java.io.Serializable;
import java.util.HashMap;

public class Dictionary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Integer> map;
    private int numEntries;
    private boolean growthStopped = false;
    private String mapAsString;

    public HashMap<String, Integer> getMap() {
        return this.map;
    }

    public void setMap(HashMap<String, Integer> hashMap) {
        this.map = hashMap;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public boolean isGrowthStopped() {
        return this.growthStopped;
    }

    public void setNumEntries(int n) {
        this.numEntries = n;
    }

    public void setGrowthStopped(boolean bl) {
        this.growthStopped = bl;
    }

    public void setMapAsString(String string) {
        this.mapAsString = string;
    }

    public String getMapAsString() {
        return this.mapAsString;
    }

    private Dictionary(int n) {
        this.map = new HashMap(n);
        this.numEntries = 0;
    }

    Dictionary() {
        this(10000);
    }

    public int lookupIndex(String string) {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("Can't lookup \"null\" in an Alphabet.");
        }
        int n2 = n = this.map.get(string) == null ? 0 : this.map.get(string);
        if (n <= 0 && !this.growthStopped) {
            ++this.numEntries;
            n = this.numEntries;
            this.map.put(string, n);
        }
        return n;
    }

    public String[] newToArray() {
        return this.map.keySet().toArray(new String[0]);
    }

    public int dictionarySize() {
        return this.numEntries;
    }

    void stopGrowth() {
        this.growthStopped = true;
    }
}

