/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep.util;

import com.johnsnowlabs.nlp.annotators.parser.typdep.util.Dictionary;
import java.io.Serializable;
import java.util.HashMap;

public class DictionarySet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Dictionary[] dictionaries;
    private boolean isCounting = false;
    private HashMap<Integer, Integer>[] counters;

    public Dictionary[] getDictionaries() {
        return this.dictionaries;
    }

    public boolean isCounting() {
        return this.isCounting;
    }

    public DictionarySet() {
        int n = DictionaryTypes.TYPE_END.ordinal();
        this.dictionaries = new Dictionary[n];
        for (int i = 0; i < this.dictionaries.length; ++i) {
            this.dictionaries[i] = new Dictionary();
        }
    }

    public int lookupIndex(DictionaryTypes dictionaryTypes, String string) {
        int n = this.dictionaries[dictionaryTypes.ordinal()].lookupIndex(string);
        if (this.isCounting && n > 0) {
            this.counters[dictionaryTypes.ordinal()].putIfAbsent(n, 0);
            int n2 = this.counters[dictionaryTypes.ordinal()].get(n) + 1;
            this.counters[dictionaryTypes.ordinal()].put(n, n2);
        }
        return n <= 0 ? 1 : n;
    }

    public int getDictionarySize(DictionaryTypes dictionaryTypes) {
        int n = dictionaryTypes.ordinal();
        return this.dictionaries[n].dictionarySize();
    }

    public void stopGrowth(DictionaryTypes dictionaryTypes) {
        this.dictionaries[dictionaryTypes.ordinal()].stopGrowth();
    }

    public Dictionary getDictionary(DictionaryTypes dictionaryTypes) {
        return this.dictionaries[dictionaryTypes.ordinal()];
    }

    public void setCounters() {
        this.isCounting = true;
        this.counters = new HashMap[this.dictionaries.length];
        for (int i = 0; i < this.dictionaries.length; ++i) {
            this.counters[i] = new HashMap();
        }
    }

    public void closeCounters() {
        this.isCounting = false;
    }

    public static enum DictionaryTypes {
        POS,
        WORD,
        DEP_LABEL,
        WORD_VEC,
        TYPE_END;

    }
}

