/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep.util;

import com.johnsnowlabs.nlp.annotators.parser.typdep.util.Collector;
import java.util.HashMap;
import java.util.Iterator;

public class FeatureVector
implements Collector {
    private int size = 0;
    private int capacity;
    private int[] x;
    private float[] va;

    public FeatureVector() {
        this.initCapacity();
    }

    private void initCapacity() {
        this.capacity = 40;
        this.x = new int[40];
        this.va = new float[40];
    }

    private void grow() {
        int n = 5 > this.capacity ? 10 : this.capacity * 2;
        int[] nArray = new int[n];
        float[] fArray = new float[n];
        if (this.capacity > 0) {
            System.arraycopy(this.x, 0, nArray, 0, this.capacity);
            System.arraycopy(this.va, 0, fArray, 0, this.capacity);
        }
        this.x = nArray;
        this.va = fArray;
        this.capacity = n;
    }

    @Override
    public void addEntry(int n) {
        if (this.size == this.capacity) {
            this.grow();
        }
        this.x[this.size] = n;
        this.va[this.size] = 1.0f;
        ++this.size;
    }

    @Override
    public void addEntry(int n, float f) {
        if (f == 0.0f) {
            return;
        }
        if (this.size == this.capacity) {
            this.grow();
        }
        this.x[this.size] = n;
        this.va[this.size] = f;
        ++this.size;
    }

    public void addEntries(FeatureVector featureVector) {
        this.addEntries(featureVector, 1.0f);
    }

    public void addEntries(FeatureVector featureVector, float f) {
        if (f == 0.0f || featureVector.size == 0) {
            return;
        }
        for (int i = 0; i < featureVector.size; ++i) {
            this.addEntry(featureVector.x[i], featureVector.va[i] * f);
        }
    }

    public float squaredL2NormUnsafe() {
        double d;
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>(this.size << 1);
        for (int i = 0; i < this.size; ++i) {
            int n = this.x[i];
            d = this.va[i];
            double d2 = hashMap.get(n) == null ? d : (Double)hashMap.get(n) + d;
            hashMap.put(n, d2);
        }
        float f = 0.0f;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            d = (Double)iterator.next();
            f = (float)((double)f + d * d);
        }
        return f;
    }

    public int size() {
        return this.size;
    }

    public int x(int n) {
        return this.x[n];
    }

    public float value(int n) {
        return this.va[n];
    }

    public float dotProduct(float[] fArray) {
        return FeatureVector.dotProduct(this, fArray);
    }

    private static float dotProduct(FeatureVector featureVector, float[] fArray) {
        float f = 0.0f;
        for (int i = 0; i < featureVector.size; ++i) {
            f += featureVector.va[i] * fArray[featureVector.x[i]];
        }
        return f;
    }
}

