/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.util.io;

import com.amazonaws.AmazonServiceException;
import com.johnsnowlabs.client.CloudResources$;
import com.johnsnowlabs.client.util.CloudHelper$;
import com.johnsnowlabs.nlp.DocumentAssembler;
import com.johnsnowlabs.nlp.Finisher;
import com.johnsnowlabs.nlp.HasOutputAnnotationCol;
import com.johnsnowlabs.nlp.annotators.Tokenizer;
import com.johnsnowlabs.nlp.annotators.common.TaggedSentence;
import com.johnsnowlabs.nlp.annotators.common.TaggedSentence$;
import com.johnsnowlabs.nlp.annotators.common.TaggedWord;
import com.johnsnowlabs.nlp.util.io.ExternalResource;
import com.johnsnowlabs.nlp.util.io.OutputHelper$;
import com.johnsnowlabs.nlp.util.io.ReadAs$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import com.johnsnowlabs.util.ConfigHelper$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.CollectionAccumulator;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class ResourceHelper$ {
    public static ResourceHelper$ MODULE$;
    private SparkSession spark;
    private volatile boolean bitmap$0;

    static {
        new ResourceHelper$();
    }

    public SparkSession getActiveSparkSession() {
        return (SparkSession)SparkSession$.MODULE$.getActiveSession().getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkSession$.MODULE$.builder().appName("SparkNLP Default Session").master("local[*]").config("spark.driver.memory", "22G").config("spark.driver.maxResultSize", "0").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryoserializer.buffer.max", "1000m").getOrCreate());
    }

    public SparkSession getSparkSessionWithS3(String awsAccessKeyId, String awsSecretAccessKey, String hadoopAwsVersion, String AwsJavaSdkVersion, String region, String s3Impl, boolean pathStyleAccess, String credentialsProvider, Option<String> awsSessionToken) {
        BoxedUnit boxedUnit;
        Predef$.MODULE$.require(SparkSession$.MODULE$.getActiveSession().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Spark session already running, can't apply new configuration for S3.");
        SparkSession.Builder sparkSession = SparkSession$.MODULE$.builder().appName("SparkNLP Session with S3 Support").master("local[*]").config("spark.driver.memory", "22G").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryoserializer.buffer.max", "1000M").config("spark.driver.maxResultSize", "0").config("spark.hadoop.fs.s3a.access.key", awsAccessKeyId).config("spark.hadoop.fs.s3a.secret.key", awsSecretAccessKey).config(ConfigHelper$.MODULE$.awsExternalRegion(), region).config("spark.hadoop.fs.s3a.aws.credentials.provider", new StringBuilder(25).append("org.apache.hadoop.fs.s3a.").append(credentialsProvider).toString()).config("spark.hadoop.fs.s3a.impl", s3Impl).config("spark.jars.packages", new StringBuilder(57).append("org.apache.hadoop:hadoop-aws:").append(hadoopAwsVersion).append(",com.amazonaws:aws-java-sdk:").append(AwsJavaSdkVersion).toString()).config("spark.hadoop.fs.s3a.path.style.access", Boolean.toString(pathStyleAccess));
        String string = credentialsProvider;
        String string2 = "TemporaryAWSCredentialsProvider";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.require(awsSessionToken.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "AWS Session token needs to be provided for TemporaryAWSCredentialsProvider.");
            boxedUnit = sparkSession.config("spark.hadoop.fs.s3a.session.token", (String)awsSessionToken.get());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sparkSession.getOrCreate();
    }

    public String getSparkSessionWithS3$default$3() {
        return ConfigHelper$.MODULE$.hadoopAwsVersion();
    }

    public String getSparkSessionWithS3$default$4() {
        return ConfigHelper$.MODULE$.awsJavaSdkVersion();
    }

    public String getSparkSessionWithS3$default$5() {
        return "us-east-1";
    }

    public String getSparkSessionWithS3$default$6() {
        return "org.apache.hadoop.fs.s3a.S3AFileSystem";
    }

    public boolean getSparkSessionWithS3$default$7() {
        return true;
    }

    public String getSparkSessionWithS3$default$8() {
        return "TemporaryAWSCredentialsProvider";
    }

    public Option<String> getSparkSessionWithS3$default$9() {
        return None$.MODULE$;
    }

    private SparkSession spark$lzycompute() {
        ResourceHelper$ resourceHelper$ = this;
        synchronized (resourceHelper$) {
            if (!this.bitmap$0) {
                this.spark = this.getActiveSparkSession();
                this.bitmap$0 = true;
            }
        }
        return this.spark;
    }

    public SparkSession spark() {
        return !this.bitmap$0 ? this.spark$lzycompute() : this.spark;
    }

    private String fixTarget(String path) {
        String toSearch = new StringBuilder(31).append("^.*target\\").append(File.separator).append(".*scala-.*\\").append(File.separator).append(".*classes\\").append(File.separator).toString();
        return path.matches(new StringBuilder(2).append(toSearch).append(".*").toString()) ? path.replaceFirst(toSearch, "") : path;
    }

    public String copyToLocal(String path) {
        String string;
        try {
            URI uRI;
            if (CloudHelper$.MODULE$.isCloudPath(path)) {
                uRI = CloudResources$.MODULE$.downloadBucketToLocalTmp(path, CloudResources$.MODULE$.downloadBucketToLocalTmp$default$2(), CloudResources$.MODULE$.downloadBucketToLocalTmp$default$3());
            } else {
                String pathWithProtocol = URI.create(path).getScheme() == null ? new File(path).toURI().toURL().toString() : path;
                ResourceHelper.SourceStream resource = new ResourceHelper.SourceStream(pathWithProtocol);
                uRI = resource.copyToLocal(resource.copyToLocal$default$1());
            }
            URI localUri = uRI;
            string = new File(localUri).getAbsolutePath();
        }
        catch (AmazonServiceException awsE) {
            Predef$.MODULE$.println((Object)"Error while retrieving folder from S3. Make sure you have set the right access keys with proper permissions in your configuration. For an example please see https://github.com/JohnSnowLabs/spark-nlp/blob/master/examples/python/training/english/dl-ner/mfa_ner_graphs_s3.ipynb");
            throw awsE;
        }
        catch (Exception e) {
            String copyToLocalErrorMessage = "Please make sure the provided path exists and is accessible while keeping in mind only file:/, hdfs:/, dbfs:/ and s3:/ protocols are supported at the moment.";
            Predef$.MODULE$.println((Object)new StringBuilder(77).append(e).append(" \n Therefore, could not create temporary local directory for provided path ").append(path).append(". ").append(copyToLocalErrorMessage).toString());
            throw e;
        }
        return string;
    }

    public InputStream getResourceStream(String path) {
        return new File(path).exists() ? new FileInputStream(new File(path)) : (InputStream)Option$.MODULE$.apply((Object)this.getClass().getResourceAsStream(path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (InputStream)Option$.MODULE$.apply((Object)MODULE$.getClass().getClassLoader().getResourceAsStream(path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String arg$macro$1 = path;
            throw new IllegalArgumentException(new StringOps("Wrong resource path %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})));
        }));
    }

    /*
     * WARNING - void declaration
     */
    public URL getResourceFile(String path) {
        void var2_2;
        block0: {
            URL dirURL = this.getClass().getResource(path);
            if (dirURL != null) break block0;
            dirURL = this.getClass().getClassLoader().getResource(path);
        }
        return var2_2;
    }

    public Seq<String> listResourceDirectory(String path2) {
        URL dirURL = this.getResourceFile(path2);
        if (dirURL != null && dirURL.getProtocol().equals("file") && new File(dirURL.toURI()).exists()) {
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(dirURL.toURI()).listFiles())).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.fixTarget((String)path), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        if (dirURL == null) {
            throw new FileNotFoundException(path2);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            ArrayBuffer result = new ArrayBuffer();
            String pathToCheck = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path2)).stripPrefix(new StringOps(Predef$.MODULE$.augmentString(File.separator)).replaceAllLiterally("\\", "/")))).stripSuffix(File.separator)).append(new StringOps(Predef$.MODULE$.augmentString(File.separator)).replaceAllLiterally("\\", "/")).toString();
            while (entries.hasMoreElements()) {
                String name = new StringOps(Predef$.MODULE$.augmentString(((ZipEntry)entries.nextElement()).getName())).stripPrefix(File.separator);
                if (!name.startsWith(pathToCheck)) continue;
                String entry = name.substring(pathToCheck.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                if (!new StringOps(Predef$.MODULE$.augmentString(entry)).nonEmpty()) continue;
                result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(0).append(pathToCheck).append(entry).toString()}));
            }
            return (Seq)((SeqLike)result.distinct()).sorted((Ordering)Ordering.String$.MODULE$);
        }
        throw new UnsupportedOperationException(new StringBuilder(26).append("Cannot list files for URL ").append(dirURL).toString());
    }

    public scala.collection.immutable.Map<String, String> parseKeyValueText(ExternalResource er) {
        scala.collection.immutable.Map map;
        Enumeration.Value value = er.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
            scala.collection.immutable.Map res = ((TraversableOnce)sourceStream.content().flatMap((Function1 & Serializable & scala.Serializable)c -> c.map((Function1 & Serializable & scala.Serializable)line -> {
                String[] kv = line.split((String)er.options().apply((Object)"delimiter"));
                return new Tuple2((Object)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).head()).trim(), (Object)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).last()).trim());
            }), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            sourceStream.close();
            map = res;
        } else {
            Enumeration.Value value4 = ReadAs$.MODULE$.SPARK();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).options(er.options()).option("delimiter", (String)er.options().apply((Object)"delimiter")).load(er.path()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}));
                Map keyValueStore = Map$.MODULE$.empty();
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                public final class Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                    }

                    public Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$1() {
                    }
                }
                dataset.as(this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$1()))).foreach((Function1 & Serializable & scala.Serializable)kv -> {
                    keyValueStore.update(kv._1(), kv._2());
                    return BoxedUnit.UNIT;
                });
                map = keyValueStore.toMap(Predef$.MODULE$.$conforms());
            } else {
                throw new Exception("Unsupported readAs");
            }
        }
        return map;
    }

    public scala.collection.immutable.Map<String, List<String>> parseKeyListValues(ExternalResource externalResource) {
        Enumeration.Value value = externalResource.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            throw new MatchError((Object)value);
        }
        ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(externalResource.path());
        Map keyValueStore = Map$.MODULE$.empty();
        sourceStream.content().foreach((Function1 & Serializable & scala.Serializable)content -> {
            content.foreach((Function1 & Serializable & scala.Serializable)line -> {
                ResourceHelper$.$anonfun$parseKeyListValues$2(externalResource$1, keyValueStore$2, line);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        sourceStream.close();
        scala.collection.immutable.Map map = keyValueStore.toMap(Predef$.MODULE$.$conforms());
        return map;
    }

    public scala.collection.immutable.Map<String, float[]> parseKeyArrayValues(ExternalResource externalResource) {
        Enumeration.Value value = externalResource.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            throw new MatchError((Object)value);
        }
        ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(externalResource.path());
        Map keyValueStore = Map$.MODULE$.empty();
        sourceStream.content().foreach((Function1 & Serializable & scala.Serializable)content -> {
            content.foreach((Function1 & Serializable & scala.Serializable)line -> {
                ResourceHelper$.$anonfun$parseKeyArrayValues$2(externalResource$2, keyValueStore$3, line);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        sourceStream.close();
        scala.collection.immutable.Map map = keyValueStore.toMap(Predef$.MODULE$.$conforms());
        return map;
    }

    public String[] parseLines(ExternalResource er) {
        String[] stringArray;
        Enumeration.Value value = er.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
            String[] res = (String[])((TraversableOnce)sourceStream.content().flatten((Function1)Predef$.MODULE$.$conforms())).toArray(ClassTag$.MODULE$.apply(String.class));
            sourceStream.close();
            stringArray = res;
        } else {
            Enumeration.Value value4 = ReadAs$.MODULE$.SPARK();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                stringArray = (String[])this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path()).as(this.spark().implicits().newStringEncoder()).collect();
            } else {
                throw new Exception("Unsupported readAs");
            }
        }
        return stringArray;
    }

    public Seq<Iterator<String>> parseLinesIterator(ExternalResource er) {
        Enumeration.Value value = er.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            throw new Exception("Unsupported readAs");
        }
        ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
        Seq<Iterator<String>> seq = sourceStream.content();
        return seq;
    }

    public Tuple2<String, String>[] parseTupleText(ExternalResource er) {
        Tuple2[] tuple2Array;
        Enumeration.Value value = er.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
            Tuple2[] res = (Tuple2[])((TraversableOnce)sourceStream.content().flatMap((Function1 & Serializable & scala.Serializable)c -> c.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ResourceHelper$.$anonfun$parseTupleText$2(x$6))).map((Function1 & Serializable & scala.Serializable)line -> {
                String[] kv = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split((String)er.options().apply((Object)"delimiter")))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).head(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).last());
            }), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
            sourceStream.close();
            tuple2Array = res;
        } else {
            Enumeration.Value value4 = ReadAs$.MODULE$.SPARK();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
                CollectionAccumulator lineStore = this.spark().sparkContext().collectionAccumulator();
                dataset.as(this.spark().implicits().newStringEncoder()).foreach((Function1 & Serializable & scala.Serializable)l -> {
                    lineStore.add((Object)l);
                    return BoxedUnit.UNIT;
                });
                Tuple2[] result = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(lineStore.value().toArray())).map((Function1 & Serializable & scala.Serializable)line -> {
                    String[] kv = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.toString().split((String)er.options().apply((Object)"delimiter")))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).head(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv)).last());
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                lineStore.reset();
                tuple2Array = result;
            } else {
                throw new Exception("Unsupported readAs");
            }
        }
        return tuple2Array;
    }

    public TaggedSentence[] parseTupleSentences(ExternalResource er) {
        TaggedSentence[] taggedSentenceArray;
        Enumeration.Value value = er.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
            TaggedWord[][] result = (TaggedWord[][])((TraversableOnce)sourceStream.content().flatMap((Function1 & Serializable & scala.Serializable)c -> c.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ResourceHelper$.$anonfun$parseTupleSentences$2(x$9))).map((Function1 & Serializable & scala.Serializable)line -> (TaggedWord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)ResourceHelper$.$anonfun$parseTupleSentences$4(er, kv))))).map((Function1 & Serializable & scala.Serializable)kv -> {
                String[] p = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)er.options().apply((Object)"delimiter"))).head()));
                return new TaggedWord(p[0], p[1]);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedWord.class)))), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(TaggedWord.class)));
            sourceStream.close();
            taggedSentenceArray = (TaggedSentence[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).map((Function1 & Serializable & scala.Serializable)x$10 -> new TaggedSentence((TaggedWord[])x$10, TaggedSentence$.MODULE$.apply$default$2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedSentence.class)));
        } else {
            Enumeration.Value value4 = ReadAs$.MODULE$.SPARK();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                public final class Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("com.johnsnowlabs.nlp.annotators.common.TaggedWord").asType().toTypeConstructor();
                    }

                    public Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$2() {
                    }
                }
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                TaggedWord[][] result = (TaggedWord[][])dataset.as(this.spark().implicits().newStringEncoder()).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ResourceHelper$.$anonfun$parseTupleSentences$7(x$11))).map((Function1 & Serializable & scala.Serializable)line -> (TaggedWord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)ResourceHelper$.$anonfun$parseTupleSentences$9(er, kv))))).map((Function1 & Serializable & scala.Serializable)kv -> {
                    String[] p = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)er.options().apply((Object)"delimiter"))).head()));
                    return new TaggedWord(p[0], p[1]);
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedWord.class))), this.spark().implicits().newProductArrayEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$2()))).collect();
                taggedSentenceArray = (TaggedSentence[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result)).map((Function1 & Serializable & scala.Serializable)x$12 -> new TaggedSentence((TaggedWord[])x$12, TaggedSentence$.MODULE$.apply$default$2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedSentence.class)));
            } else {
                throw new Exception("Unsupported readAs");
            }
        }
        return taggedSentenceArray;
    }

    public Dataset<TaggedSentence> parseTupleSentencesDS(ExternalResource er) {
        public final class Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.johnsnowlabs.nlp.annotators.common.TaggedWord").asType().toTypeConstructor();
            }

            public Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$3() {
            }
        }
        Enumeration.Value value = er.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.SPARK();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            throw new Exception("Unsupported readAs. If you're training POS with large dataset, consider PerceptronApproachDistributed");
        }
        Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Dataset result = dataset.as(this.spark().implicits().newStringEncoder()).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ResourceHelper$.$anonfun$parseTupleSentencesDS$1(x$13))).map((Function1 & Serializable & scala.Serializable)line -> (TaggedWord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split("\\s+"))).filter((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)ResourceHelper$.$anonfun$parseTupleSentencesDS$3(er, kv))))).map((Function1 & Serializable & scala.Serializable)kv -> {
            String[] p = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)er.options().apply((Object)"delimiter"))).head()));
            return new TaggedWord(p[0], p[1]);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TaggedWord.class))), this.spark().implicits().newProductArrayEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator5$3())));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator14$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.johnsnowlabs.nlp.annotators.common.TaggedSentence").asType().toTypeConstructor();
            }

            public Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator14$1() {
            }
        }
        Dataset dataset2 = result.map((Function1 & Serializable & scala.Serializable)x$14 -> new TaggedSentence((TaggedWord[])x$14, TaggedSentence$.MODULE$.apply$default$2()), this.spark().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_johnsnowlabs_nlp_util_io_ResourceHelper$$typecreator14$1())));
        return dataset2;
    }

    public scala.collection.immutable.Map<String, String> flattenRevertValuesAsKeys(ExternalResource er) {
        scala.collection.immutable.Map map;
        Enumeration.Value value = er.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Map m = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(er.path());
            sourceStream.content().foreach((Function1 & Serializable & scala.Serializable)c -> {
                c.foreach((Function1 & Serializable & scala.Serializable)line -> {
                    ResourceHelper$.$anonfun$flattenRevertValuesAsKeys$2(er$5, m$1, line);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            sourceStream.close();
            map = m.toMap(Predef$.MODULE$.$conforms());
        } else {
            Enumeration.Value value4 = ReadAs$.MODULE$.SPARK();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Dataset dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
                Map valueAsKeys = Map$.MODULE$.empty();
                dataset.as(this.spark().implicits().newStringEncoder()).foreach((Function1 & Serializable & scala.Serializable)line -> {
                    ResourceHelper$.$anonfun$flattenRevertValuesAsKeys$6(er, valueAsKeys, line);
                    return BoxedUnit.UNIT;
                });
                map = valueAsKeys.toMap(Predef$.MODULE$.$conforms());
            } else {
                throw new Exception("Unsupported readAs");
            }
        }
        return map;
    }

    public Dataset<Row> readSparkDataFrame(ExternalResource er) {
        Dataset dataset;
        Enumeration.Value value = er.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.SPARK();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            throw new Exception("Unsupported readAs - only accepts SPARK");
        }
        Dataset dataset2 = dataset = this.spark().read().options(er.options()).format((String)er.options().apply((Object)"format")).load(er.path());
        return dataset2;
    }

    public Map<String, Object> getWordCount(ExternalResource externalResource, Map<String, Object> wordCount, Option<PipelineModel> pipeline) {
        Map map;
        Enumeration.Value value = externalResource.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(externalResource.path());
            Regex regex = new StringOps(Predef$.MODULE$.augmentString((String)externalResource.options().apply((Object)"tokenPattern"))).r();
            sourceStream.content().foreach((Function1 & Serializable & scala.Serializable)c -> {
                c.foreach((Function1 & Serializable & scala.Serializable)line -> {
                    ResourceHelper$.$anonfun$getWordCount$2(regex$1, wordCount$1, line);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            sourceStream.close();
            if (wordCount.isEmpty()) {
                throw new FileNotFoundException("Word count dictionary for spell checker does not exist or is empty");
            }
            map = wordCount;
        } else {
            Enumeration.Value value4 = ReadAs$.MODULE$.SPARK();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Dataset dataset;
                Dataset dataset2 = this.spark().read().options(externalResource.options()).format((String)externalResource.options().apply((Object)"format")).load(externalResource.path());
                if (pipeline.isDefined()) {
                    dataset = ((PipelineModel)pipeline.get()).transform(dataset2);
                } else {
                    DocumentAssembler documentAssembler = new DocumentAssembler().setInputCol("value");
                    Tokenizer tokenizer = ((Tokenizer)((HasOutputAnnotationCol)((Object)new Tokenizer().setInputCols((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"document"})))).setOutputCol("token")).setTargetPattern((String)externalResource.options().apply((Object)"tokenPattern"));
                    Finisher finisher = new Finisher().setInputCols((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"token"})).setOutputCols((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"finished"})).setAnnotationSplitSymbol("--");
                    dataset = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{documentAssembler, tokenizer, finisher})).fit(dataset2).transform(dataset2);
                }
                Dataset transformation = dataset;
                Map wordCount2 = Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToLong((long)0L));
                transformation.select("finished", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.spark().implicits().newStringEncoder()).foreach((Function1 & Serializable & scala.Serializable)text -> {
                    ResourceHelper$.$anonfun$getWordCount$5(wordCount2, text);
                    return BoxedUnit.UNIT;
                });
                map = wordCount2;
            } else {
                throw new IllegalArgumentException("format not available for word count");
            }
        }
        return map;
    }

    public Map<String, Object> getWordCount$default$2() {
        return Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToLong((long)0L));
    }

    public Option<PipelineModel> getWordCount$default$3() {
        return None$.MODULE$;
    }

    public Seq<Iterator<String>> getFilesContentBuffer(ExternalResource externalResource) {
        Enumeration.Value value = externalResource.readAs();
        Enumeration.Value value2 = ReadAs$.MODULE$.TEXT();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            throw new Exception("Unsupported readAs");
        }
        Seq<Iterator<String>> seq = new ResourceHelper.SourceStream(externalResource.path()).content();
        return seq;
    }

    public List<File> listLocalFiles(String path) {
        Option option;
        FileSystem fileSystem = OutputHelper$.MODULE$.getFileSystem(path);
        String string = fileSystem.getScheme();
        if ("hdfs".equals(string)) {
            Option option2;
            if (path.startsWith("file:")) {
                option2 = Option$.MODULE$.apply((Object)new File(path.replace("file:", "")).listFiles());
            } else {
                try {
                    RemoteIterator filesIterator = fileSystem.listFiles(new Path(path), false);
                    ArrayBuffer files = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    while (filesIterator.hasNext()) {
                        File file = new File(((FileStatus)filesIterator.next()).getPath().toString());
                        files.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file}));
                    }
                    option2 = Option$.MODULE$.apply(files.toArray(ClassTag$.MODULE$.apply(File.class)));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    option2 = Option$.MODULE$.apply((Object)new File(path).listFiles());
                }
            }
            option = option2;
        } else {
            option = "dbfs".equals(string) && path.startsWith("dbfs:") ? Option$.MODULE$.apply((Object)new File(path.replace("dbfs:", "/dbfs/")).listFiles()) : Option$.MODULE$.apply((Object)new File(path).listFiles());
        }
        Option filesPath = option;
        File[] files = (File[])filesPath.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(18).append("folder: ").append(path).append(" not found").toString());
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).toList();
    }

    public File getFileFromPath(String pathToFile) {
        FileSystem fileSystem = OutputHelper$.MODULE$.getFileSystem();
        String string = fileSystem.getScheme();
        File file = "hdfs".equals(string) ? (pathToFile.startsWith("file:") ? new File(pathToFile.replace("file:", "")) : new File(pathToFile)) : ("dbfs".equals(string) && pathToFile.startsWith("dbfs:") ? new File(pathToFile.replace("dbfs:", "/dbfs/")) : new File(pathToFile));
        File filePath = file;
        return filePath;
    }

    public boolean validFile(String path) {
        boolean bl;
        if (path.isEmpty()) {
            return false;
        }
        Try<Object> try_ = this.validLocalFile(path);
        if (try_ instanceof Success) {
            boolean value;
            Success success = (Success)try_;
            bl = value = BoxesRunTime.unboxToBoolean((Object)success.value());
        } else if (try_ instanceof Failure) {
            bl = false;
        } else {
            throw new MatchError(try_);
        }
        boolean isValid = bl;
        if (!isValid) {
            Try<Object> try_2 = this.validHadoopFile(path);
            if (try_2 instanceof Success) {
                boolean value;
                Success success = (Success)try_2;
                isValid = value = BoxesRunTime.unboxToBoolean((Object)success.value());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_2 instanceof Failure) {
                isValid = false;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(try_2);
            }
        }
        if (!isValid) {
            Try<Object> try_3 = this.validDbfsFile(path);
            if (try_3 instanceof Success) {
                boolean value;
                Success success = (Success)try_3;
                isValid = value = BoxesRunTime.unboxToBoolean((Object)success.value());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (try_3 instanceof Failure) {
                isValid = false;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(try_3);
            }
        }
        return isValid;
    }

    private Try<Object> validLocalFile(String path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.exists(Paths.get(path, new String[0]), new LinkOption[0]));
    }

    private Try<Object> validHadoopFile(String path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Path hadoopPath = new Path(path);
            FileSystem fileSystem = OutputHelper$.MODULE$.getFileSystem();
            return fileSystem.exists(hadoopPath);
        });
    }

    private Try<Object> validDbfsFile(String path) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> MODULE$.getFileFromPath(path).exists());
    }

    public static final /* synthetic */ void $anonfun$parseKeyListValues$2(ExternalResource externalResource$1, Map keyValueStore$2, String line) {
        String[] keyValues = line.split((String)externalResource$1.options().apply((Object)"delimiter"));
        String key = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyValues)).head();
        List value = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyValues)).drop(1))).toList();
        Option storedValue = keyValueStore$2.get((Object)key);
        if (storedValue.isDefined() && !storedValue.contains((Object)value)) {
            keyValueStore$2.update((Object)key, ((List)storedValue.get()).$plus$plus((GenTraversableOnce)value, List$.MODULE$.canBuildFrom()));
        } else {
            keyValueStore$2.update((Object)key, (Object)value);
        }
    }

    public static final /* synthetic */ float $anonfun$parseKeyArrayValues$3(String x) {
        return new StringOps(Predef$.MODULE$.augmentString(x)).toFloat();
    }

    public static final /* synthetic */ void $anonfun$parseKeyArrayValues$2(ExternalResource externalResource$2, Map keyValueStore$3, String line) {
        block0: {
            String[] keyValues = line.split((String)externalResource$2.options().apply((Object)"delimiter"));
            String key = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyValues)).head();
            float[] value = (float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keyValues)).drop(1))).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToFloat((float)ResourceHelper$.$anonfun$parseKeyArrayValues$3(x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
            if (value.length <= 1) break block0;
            keyValueStore$3.update((Object)key, (Object)value);
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseTupleText$2(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseTupleSentences$2(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseTupleSentences$4(ExternalResource er$3, String kv) {
        String[] s = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)er$3.options().apply((Object)"delimiter"))).head()));
        return s.length == 2 && new StringOps(Predef$.MODULE$.augmentString(s[0])).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(s[1])).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseTupleSentences$7(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseTupleSentences$9(ExternalResource er$3, String kv) {
        String[] s = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)er$3.options().apply((Object)"delimiter"))).head()));
        return s.length == 2 && new StringOps(Predef$.MODULE$.augmentString(s[0])).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(s[1])).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseTupleSentencesDS$1(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseTupleSentencesDS$3(ExternalResource er$4, String kv) {
        String[] s = new StringOps(Predef$.MODULE$.augmentString(kv)).split(BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)er$4.options().apply((Object)"delimiter"))).head()));
        return s.length == 2 && new StringOps(Predef$.MODULE$.augmentString(s[0])).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(s[1])).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$flattenRevertValuesAsKeys$2(ExternalResource er$5, Map m$1, String line) {
        block0: {
            String[] kv = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split((String)er$5.options().apply((Object)"keyDelimiter")))).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            if (kv.length <= 1) break block0;
            String key = kv[0];
            String[] values = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv[1].split((String)er$5.options().apply((Object)"valueDelimiter")))).map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
                m$1.update((Object)x$17, (Object)key);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$flattenRevertValuesAsKeys$6(ExternalResource er$5, Map valueAsKeys$1, String line) {
        block0: {
            String[] kv = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])line.split((String)er$5.options().apply((Object)"keyDelimiter")))).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            if (kv.length <= 1) break block0;
            String key = kv[0];
            String[] values = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])kv[1].split((String)er$5.options().apply((Object)"valueDelimiter")))).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable & scala.Serializable)v -> {
                valueAsKeys$1.update((Object)v, (Object)key);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$getWordCount$2(Regex regex$1, Map wordCount$1, String line) {
        List words = regex$1.findAllMatchIn((CharSequence)line).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.matched()).toList();
        words.foreach((Function1 & Serializable & scala.Serializable)w -> {
            wordCount$1.update((Object)w, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)wordCount$1.apply((Object)w)) + 1L)));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getWordCount$5(Map wordCount$2, String text) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])text.split("--"))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            wordCount$2.update((Object)t, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)wordCount$2.apply((Object)t)) + 1L)));
            return BoxedUnit.UNIT;
        });
    }

    private ResourceHelper$() {
        MODULE$ = this;
    }
}

