/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ZipArchiveUtil$ {
    public static ZipArchiveUtil$ MODULE$;

    static {
        new ZipArchiveUtil$();
    }

    public List<File> listFilesRecursive(File file) {
        .colon.colon colon2;
        File file2 = file;
        if (file2.isFile()) {
            colon2 = new .colon.colon((Object)new File(file2.getAbsoluteFile().toString()), (List)Nil$.MODULE$);
        } else if (file2.isDirectory()) {
            String[] fList = file2.list();
            colon2 = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fList)).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(pList, path) -> (List)pList.$plus$plus(MODULE$.listFilesRecursive(new File(file2, (String)path)), List$.MODULE$.canBuildFrom()));
        } else {
            throw new IOException("Bad path. No file or directory found.");
        }
        return colon2;
    }

    public ZipEntry addFileToZipEntry(File filename, File parentPath, boolean useRelativePath) {
        ZipEntry zipEntry;
        if (!useRelativePath) {
            zipEntry = new ZipEntry(filename.getName());
        } else {
            String relative = parentPath.toURI().relativize(filename.toURI()).getPath();
            zipEntry = new ZipEntry(relative);
        }
        return zipEntry;
    }

    public boolean addFileToZipEntry$default$3() {
        return false;
    }

    public void createZip(List<File> filePaths, File outputFilePath, File parentPath) {
        int Buffer2 = 2048;
        byte[] data = new byte[Buffer2];
        try {
            FileOutputStream zipFileOS = new FileOutputStream(outputFilePath);
            ZipOutputStream zip = new ZipOutputStream(zipFileOS);
            zip.setLevel(0);
            filePaths.foreach((Function1 & Serializable & scala.Serializable)file -> {
                ZipArchiveUtil$.$anonfun$createZip$1(parentPath, filePaths, zip, Buffer2, data, file);
                return BoxedUnit.UNIT;
            });
            zip.closeEntry();
            zip.close();
            zipFileOS.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void zipFile(File soureFile, File outputFilePath) {
        this.createZip((List<File>)new .colon.colon((Object)soureFile.getAbsoluteFile(), (List)Nil$.MODULE$), outputFilePath, null);
    }

    public void zipDir(File sourceDir, File outputFilePath) {
        List<File> filePaths = this.listFilesRecursive(sourceDir);
        this.createZip(filePaths, outputFilePath, sourceDir);
    }

    public void zip(String sourcePath, String outputFilePath) {
        File sourceFile = new File(sourcePath);
        File outputFile = new File(outputFilePath);
        if (sourceFile.equals(outputFile)) {
            throw new IllegalArgumentException("source path cannot be identical to target path");
        }
        if (!outputFile.getParentFile().exists()) {
            throw new IOException("the parent directory of output file doesn't exist");
        }
        if (!sourceFile.exists()) {
            throw new IOException("zip source path must exsit");
        }
        if (outputFile.exists()) {
            throw new IOException("zip target file exsits");
        }
        if (sourceFile.isDirectory()) {
            this.zipDir(sourceFile, outputFile);
        } else if (sourceFile.isFile()) {
            this.zipFile(sourceFile, outputFile);
        } else {
            throw new IllegalArgumentException("only folder and file input are valid");
        }
    }

    public String unzip(File file, Option<String> destDirPath) {
        String fileName = file.getName();
        String basename = fileName.indexOf(46) >= 0 ? fileName.substring(0, fileName.lastIndexOf(".")) : new StringBuilder(9).append(fileName).append("_unzipped").toString();
        File destDir = destDirPath.isEmpty() ? new File(file.getParentFile(), basename) : new File((String)destDirPath.get());
        destDir.mkdirs();
        ZipFile zip = new ZipFile(file);
        ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(zip.entries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ZipArchiveUtil$.$anonfun$unzip$1(basename, destDir, zip, entry);
            return BoxedUnit.UNIT;
        });
        return destDir.getPath();
    }

    public Option<String> unzip$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$createZip$1(File parentPath$1, List filePaths$1, ZipOutputStream zip$1, int Buffer$1, byte[] data$1, File file) {
        ZipEntry zipEntry = MODULE$.addFileToZipEntry(file, parentPath$1, filePaths$1.size() > 1);
        zip$1.putNextEntry(new ZipEntry(zipEntry));
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file), Buffer$1);
        int b = in.read(data$1, 0, Buffer$1);
        while (b != -1) {
            zip$1.write(data$1, 0, b);
            b = in.read(data$1, 0, Buffer$1);
        }
        in.close();
    }

    public static final /* synthetic */ void $anonfun$unzip$1(String basename$1, File destDir$1, ZipFile zip$2, ZipEntry entry) {
        String entryName = entry.getName();
        String entryPath = entryName.startsWith(basename$1) ? entryName.substring(basename$1.length()) : entryName;
        int toDrop = entry.isDirectory() ? 0 : 1;
        String[] splitPath = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])entryName.split(File.separator.replace("\\", "/")))).dropRight(toDrop);
        scala.collection.mutable.StringBuilder dirBuilder = new scala.collection.mutable.StringBuilder(destDir$1.getPath());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitPath)).foreach((Function1 & Serializable & scala.Serializable)part -> {
            dirBuilder.append(File.separator);
            dirBuilder.append(part);
            String path = dirBuilder.toString();
            return !new File(path).exists() ? BoxesRunTime.boxToBoolean((boolean)new File(path).mkdir()) : BoxedUnit.UNIT;
        });
        FileUtils.copyInputStreamToFile((InputStream)zip$2.getInputStream(entry), (File)new File(destDir$1, entryPath));
    }

    private ZipArchiveUtil$() {
        MODULE$ = this;
    }
}

