/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.client;

import com.johnsnowlabs.client.CloudClient;
import com.johnsnowlabs.client.CloudManager$;
import com.johnsnowlabs.client.aws.AWSClient;
import com.johnsnowlabs.client.azure.AzureClient;
import com.johnsnowlabs.client.gcp.GCPClient;
import com.johnsnowlabs.client.util.CloudHelper$;
import com.johnsnowlabs.nlp.util.io.CloudStorageType$;
import com.johnsnowlabs.util.ConfigHelper$;
import com.johnsnowlabs.util.ConfigLoader$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001M3Aa\u0003\u0007\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003*\u0001\u0011\u0005!\u0006C\u0004/\u0001\t\u0007I\u0011B\u0018\t\ra\u0002\u0001\u0015!\u00031\u0011\u0015I\u0004\u0001\"\u0001;\u0011\u0015\u0001\u0005\u0001\"\u0001B\u000f\u001d\u0019E\"!A\t\u0002\u00113qa\u0003\u0007\u0002\u0002#\u0005Q\tC\u0003*\u0011\u0011\u0005a\tC\u0004H\u0011E\u0005I\u0011\u0001%\u0003\u0019\rcw.\u001e3NC:\fw-\u001a:\u000b\u00055q\u0011AB2mS\u0016tGO\u0003\u0002\u0010!\u0005a!n\u001c5og:|w\u000f\\1cg*\t\u0011#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\f!\u0002]1sC6,G/\u001a:t!\u0011a2E\n\u0014\u000f\u0005u\t\u0003C\u0001\u0010\u0017\u001b\u0005y\"B\u0001\u0011\u0013\u0003\u0019a$o\\8u}%\u0011!EF\u0001\u0007!J,G-\u001a4\n\u0005\u0011*#aA'ba*\u0011!E\u0006\t\u00039\u001dJ!\u0001K\u0013\u0003\rM#(/\u001b8h\u0003\u0019a\u0014N\\5u}Q\u00111&\f\t\u0003Y\u0001i\u0011\u0001\u0004\u0005\b5\t\u0001\n\u00111\u0001\u001c\u0003\u0019awnZ4feV\t\u0001\u0007\u0005\u00022m5\t!G\u0003\u00024i\u0005)1\u000f\u001c45U*\tQ'A\u0002pe\u001eL!a\u000e\u001a\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0011cZ3u\u00072LWM\u001c;J]N$\u0018M\\2f)\tYd\b\u0005\u0002-y%\u0011Q\b\u0004\u0002\f\u00072|W\u000fZ\"mS\u0016tG\u000fC\u0003@\u000b\u0001\u0007a%A\u0002ve&\f\u0001fZ3u\u00072LWM\u001c;J]N$\u0018M\\2f\rJ|WnQ8oM&<WO]1uS>t\u0007+\u0019:b[N$\"a\u000f\"\t\u000b}2\u0001\u0019\u0001\u0014\u0002\u0019\rcw.\u001e3NC:\fw-\u001a:\u0011\u00051B1C\u0001\u0005\u0015)\u0005!\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'F\u0001JU\tY\"jK\u0001L!\ta\u0015+D\u0001N\u0015\tqu*A\u0005v]\u000eDWmY6fI*\u0011\u0001KF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001*N\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class CloudManager {
    private final Map<String, String> parameters;
    private final Logger logger;

    public static Map<String, String> $lessinit$greater$default$1() {
        return CloudManager$.MODULE$.$lessinit$greater$default$1();
    }

    private Logger logger() {
        return this.logger;
    }

    public CloudClient getClientInstance(String uri) {
        CloudClient cloudClient;
        Enumeration.Value value = CloudHelper$.MODULE$.cloudType(uri);
        Enumeration.Value value2 = CloudStorageType$.MODULE$.S3();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            cloudClient = new AWSClient(this.parameters);
        } else {
            Enumeration.Value value4 = CloudStorageType$.MODULE$.GCP();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                cloudClient = new GCPClient(this.parameters);
            } else {
                Enumeration.Value value6 = CloudStorageType$.MODULE$.Azure();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    String storageAccountName = CloudHelper$.MODULE$.getAccountNameFromAzureBlobURI(uri);
                    cloudClient = new AzureClient((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"storageAccountName"), (Object)storageAccountName)}))));
                } else {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Unsupported URI scheme: ").append(uri).toString());
                }
            }
        }
        return cloudClient;
    }

    public CloudClient getClientInstanceFromConfigurationParams(String uri) {
        CloudClient cloudClient;
        Enumeration.Value value = CloudHelper$.MODULE$.cloudType(uri);
        Enumeration.Value value2 = CloudStorageType$.MODULE$.S3();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Map map;
            boolean isS3Defined;
            Tuple3<String, String, String> tuple3 = ConfigHelper$.MODULE$.getHadoopS3Config();
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            String accessKey = (String)tuple3._1();
            String secretKey = (String)tuple3._2();
            String sessionToken = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)accessKey, (Object)secretKey, (Object)sessionToken);
            Tuple3 tuple33 = tuple32;
            String accessKey2 = (String)tuple33._1();
            String secretKey2 = (String)tuple33._2();
            String sessionToken2 = (String)tuple33._3();
            String region = ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.awsExternalRegion());
            boolean bl = isS3Defined = accessKey2 != null && secretKey2 != null && sessionToken2 != null && new StringOps(Predef$.MODULE$.augmentString(region)).nonEmpty();
            if (isS3Defined) {
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"accessKeyId"), (Object)accessKey2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"secretAccessKey"), (Object)secretKey2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sessionToken"), (Object)sessionToken2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"region"), (Object)region)}));
            } else {
                if (accessKey2 != null || secretKey2 != null || sessionToken2 != null) {
                    this.logger().info("Not all configs set for private S3 access. Defaulting to public downloader.");
                }
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"credentialsType"), (Object)"public")}));
            }
            Map configParameters = map;
            cloudClient = new AWSClient((Map<String, String>)configParameters);
        } else {
            Enumeration.Value value4 = CloudStorageType$.MODULE$.GCP();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                String projectId = ConfigLoader$.MODULE$.getConfigStringValue(ConfigHelper$.MODULE$.gcpProjectId());
                Map configParameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"projectId"), (Object)projectId)}));
                cloudClient = new GCPClient((Map<String, String>)configParameters);
            } else {
                Enumeration.Value value6 = CloudStorageType$.MODULE$.Azure();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    String storageAccountName = CloudHelper$.MODULE$.getAccountNameFromAzureBlobURI(uri);
                    Map configParameters = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"storageAccountName"), (Object)storageAccountName)}));
                    cloudClient = new AzureClient((Map<String, String>)configParameters);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Unsupported URI scheme: ").append(uri).toString());
                }
            }
        }
        return cloudClient;
    }

    public CloudManager(Map<String, String> parameters) {
        this.parameters = parameters;
        this.logger = LoggerFactory.getLogger((String)this.getClass().toString());
    }
}

