/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.ai.util;

import com.johnsnowlabs.ml.ai.util.Florence2Utils;
import com.johnsnowlabs.ml.ai.util.Florence2Utils$PolygonInstance$;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Base64;
import javax.imageio.ImageIO;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class Florence2Utils$ {
    public static Florence2Utils$ MODULE$;
    private final Map<String, String> taskPromptsWithoutInputs;
    private final Map<String, String> taskPromptsWithInput;
    private final Map<String, String> taskAnswerPostProcessingType;
    private final Color[] colorMap;

    static {
        new Florence2Utils$();
    }

    public Map<String, String> taskPromptsWithoutInputs() {
        return this.taskPromptsWithoutInputs;
    }

    public Map<String, String> taskPromptsWithInput() {
        return this.taskPromptsWithInput;
    }

    public Seq<String> constructPrompts(Seq<String> texts) {
        return (Seq)texts.map((Function1 & Serializable & scala.Serializable)text -> (String)MODULE$.taskPromptsWithoutInputs().collectFirst((PartialFunction)new scala.Serializable((String)text){
            public static final long serialVersionUID = 0L;
            private final String text$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String taskToken = (String)A1._1();
                    String taskPrompt = (String)A1._2();
                    String string = this.text$1;
                    String string2 = taskToken;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = taskPrompt;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                Tuple2<String, String> tuple2 = x1;
                if (tuple2 == null) return false;
                String taskToken = (String)tuple2._1();
                String string = this.text$1;
                String string2 = taskToken;
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
            {
                this.text$1 = text$1;
            }
        }).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.taskPromptsWithInput().collectFirst((PartialFunction)new scala.Serializable((String)text){
            public static final long serialVersionUID = 0L;
            private final String text$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    String taskToken = (String)A1._1();
                    String taskPrompt = (String)A1._2();
                    if (this.text$1.contains(taskToken)) {
                        object = taskPrompt.replace("{input}", this.text$1.replace(taskToken, "").trim());
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, String> x2) {
                String taskToken;
                Tuple2<String, String> tuple2 = x2;
                boolean bl = tuple2 != null && this.text$1.contains(taskToken = (String)tuple2._1());
                return bl;
            }
            {
                this.text$1 = text$1;
            }
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> text), Seq$.MODULE$.canBuildFrom());
    }

    public Florence2Utils.Florence2Result postProcessGeneration(String text, String task, Tuple2<Object, Object> imageSize) {
        Product product;
        String baseTask = this.getBaseTaskToken(task);
        String taskType = (String)this.taskAnswerPostProcessingType().getOrElse((Object)baseTask, (Function0 & Serializable & scala.Serializable)() -> "pure_text");
        String string = taskType;
        if ("pure_text".equals(string)) {
            product = new Florence2Utils.PureTextResult(text.replace("<s>", "").replace("</s>", ""));
        } else if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"od", "description_with_bboxes", "bboxes"}))).contains((Object)string)) {
            Seq<Florence2Utils.BBox> instances = this.parseOD(text, imageSize);
            product = new Florence2Utils.BBoxesResult(instances);
        } else if ("ocr".equals(string)) {
            Seq<Florence2Utils.OCRInstance> instances = this.parseOCR(text, imageSize);
            product = new Florence2Utils.OCRResult(instances);
        } else if ("phrase_grounding".equals(string)) {
            Seq<Florence2Utils.PhraseGroundingInstance> instances = this.parsePhraseGrounding(text, imageSize);
            product = new Florence2Utils.PhraseGroundingResult(instances);
        } else if (((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"description_with_polygons", "polygons"}))).contains((Object)string)) {
            Seq<Florence2Utils.PolygonInstance> instances = this.parsePolygons(text, imageSize);
            product = new Florence2Utils.PolygonsResult(instances);
        } else if ("description_with_bboxes_or_polygons".equals(string)) {
            Product product2;
            if (text.contains("<poly>")) {
                Seq<Florence2Utils.PolygonInstance> instances = this.parsePolygons(text, imageSize);
                product2 = new Florence2Utils.PolygonsResult(instances);
            } else {
                Seq<Florence2Utils.BBox> instances = this.parseOD(text, imageSize);
                product2 = new Florence2Utils.BBoxesResult(instances);
            }
            product = product2;
        } else {
            throw new IllegalArgumentException(new StringBuilder(42).append("Unknown task answer post processing type: ").append(taskType).toString());
        }
        return product;
    }

    public Map<String, String> taskAnswerPostProcessingType() {
        return this.taskAnswerPostProcessingType;
    }

    public Seq<Florence2Utils.BBox> parseOD(String text, Tuple2<Object, Object> imageSize) {
        Regex pattern = new Regex("([a-zA-Z0-9 ]+)<loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return pattern.findAllMatchIn((CharSequence)text).map((Function1 & Serializable & scala.Serializable)m -> {
            String cat = m.group(1).trim().toLowerCase();
            IndexedSeq bins = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 5).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> new StringOps(Predef$.MODULE$.augmentString(m.group(i))).toInt(), IndexedSeq$.MODULE$.canBuildFrom());
            Seq<Object> bbox = MODULE$.dequantizeBox((Seq<Object>)bins, imageSize);
            return new Florence2Utils.BBox(bbox, cat);
        }).toSeq();
    }

    public Seq<Florence2Utils.OCRInstance> parseOCR(String text, Tuple2<Object, Object> imageSize) {
        Regex pattern = new Regex("(.+?)<loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return pattern.findAllMatchIn((CharSequence)text.replace("<s>", "")).map((Function1 & Serializable & scala.Serializable)m -> {
            String ocrText = m.group(1).trim();
            IndexedSeq quadBoxBins = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), 9).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> new StringOps(Predef$.MODULE$.augmentString(m.group(i))).toInt(), IndexedSeq$.MODULE$.canBuildFrom());
            Seq<Object> quadBox = MODULE$.dequantizeCoordinates((Seq<Object>)quadBoxBins, imageSize);
            return new Florence2Utils.OCRInstance(quadBox, ocrText);
        }).toSeq();
    }

    public Seq<Florence2Utils.PhraseGroundingInstance> parsePhraseGrounding(String text, Tuple2<Object, Object> imageSize) {
        Regex phrasePattern = new Regex("([^<]+(?:<loc_\\d+>){4,})", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        Regex boxPattern = new Regex("<loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        return phrasePattern.findAllMatchIn((CharSequence)text.replace("<s>", "").replace("</s>", "").replace("<pad>", "")).flatMap((Function1 & Serializable & scala.Serializable)m -> {
            String phraseText = m.group(1);
            String phrase = ((String)new StringOps(Predef$.MODULE$.augmentString(phraseText)).takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Florence2Utils$.$anonfun$parsePhraseGrounding$2(BoxesRunTime.unboxToChar((Object)x$1))))).trim();
            Seq bboxes = boxPattern.findAllMatchIn((CharSequence)phraseText).map((Function1 & Serializable & scala.Serializable)b -> {
                IndexedSeq bins = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> new StringOps(Predef$.MODULE$.augmentString(b.group(i))).toInt(), IndexedSeq$.MODULE$.canBuildFrom());
                return MODULE$.dequantizeBox((Seq<Object>)bins, imageSize);
            }).toSeq();
            return new StringOps(Predef$.MODULE$.augmentString(phrase)).nonEmpty() && bboxes.nonEmpty() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Florence2Utils.PhraseGroundingInstance((Seq<Seq<Object>>)bboxes, phrase))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }).toSeq();
    }

    public Seq<Florence2Utils.PolygonInstance> parsePolygons(String text, Tuple2<Object, Object> imageSize) {
        Seq seq;
        String cleanedText = text.replace("<s>", "").replace("</s>", "").replace("<pad>", "").trim();
        if (cleanedText.startsWith("<loc_")) {
            Regex fallbackLocPattern = new Regex("<loc_([0-9]+)>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Seq locs = fallbackLocPattern.findAllMatchIn((CharSequence)cleanedText).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)Florence2Utils$.$anonfun$parsePolygons$1(x$2))).toSeq();
            if (locs.length() >= 4 && locs.length() % 2 == 0) {
                Seq<Object> polygon = this.dequantizeCoordinates((Seq<Object>)locs, imageSize);
                seq = (Seq)new .colon.colon((Object)new Florence2Utils.PolygonInstance((Seq<Seq<Object>>)((Seq)new .colon.colon(polygon, (List)Nil$.MODULE$)), "", Florence2Utils$PolygonInstance$.MODULE$.apply$default$3()), (List)Nil$.MODULE$);
            } else {
                seq = (Seq)Nil$.MODULE$;
            }
        } else {
            String polygonStart = "<poly>";
            String polygonEnd = "</poly>";
            String polygonSep = "<sep>";
            Regex phrasePattern = new Regex(new StringBuilder(27).append("([^<]+(?:<loc_\\d+>|").append(polygonSep).append("|").append(polygonStart).append("|").append(polygonEnd).append("){4,})").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Regex boxPattern = new Regex("<loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)><loc_([0-9]+)>", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Seq matches = phrasePattern.findAllMatchIn((CharSequence)cleanedText).toSeq();
            seq = (Seq)matches.flatMap((Function1 & Serializable & scala.Serializable)m -> {
                Seq polygons;
                String phraseText = m.group(1);
                String phrase = ((String)new StringOps(Predef$.MODULE$.augmentString(phraseText)).takeWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Florence2Utils$.$anonfun$parsePolygons$3(BoxesRunTime.unboxToChar((Object)x$3))))).trim();
                return new StringOps(Predef$.MODULE$.augmentString(phrase)).nonEmpty() ? ((polygons = boxPattern.findAllMatchIn((CharSequence)phraseText).map((Function1 & Serializable & scala.Serializable)b -> {
                    IndexedSeq bins = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> new StringOps(Predef$.MODULE$.augmentString(b.group(i))).toInt(), IndexedSeq$.MODULE$.canBuildFrom());
                    return MODULE$.dequantizeBox((Seq<Object>)bins, imageSize);
                }).toSeq()).nonEmpty() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Florence2Utils.PolygonInstance((Seq<Seq<Object>>)polygons, phrase, Florence2Utils$PolygonInstance$.MODULE$.apply$default$3()))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }, Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public Seq<Object> dequantizeBox(Seq<Object> bins, Tuple2<Object, Object> imageSize) {
        Tuple2<Object, Object> tuple2 = imageSize;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int w = tuple2._1$mcI$sp();
        int h = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(w, h);
        Tuple2.mcII.sp sp3 = sp2;
        int w2 = sp3._1$mcI$sp();
        int h2 = sp3._2$mcI$sp();
        double binsW = 1000.0;
        double binsH = 1000.0;
        double sizePerBinW = (double)w2 / binsW;
        double sizePerBinH = (double)h2 / binsH;
        int[] nArray = (int[])bins.toArray(ClassTag$.MODULE$.Int());
        Option option = Array$.MODULE$.unapplySeq((Object)nArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(4) != 0) {
            throw new MatchError((Object)nArray);
        }
        int xmin = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(0));
        int ymin = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(1));
        int xmax = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(2));
        int ymax = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(3));
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)xmin), (Object)BoxesRunTime.boxToInteger((int)ymin), (Object)BoxesRunTime.boxToInteger((int)xmax), (Object)BoxesRunTime.boxToInteger((int)ymax));
        Tuple4 tuple42 = tuple4;
        int xmin2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
        int ymin2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
        int xmax2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int ymax2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{((double)xmin2 + 0.5) * sizePerBinW, ((double)ymin2 + 0.5) * sizePerBinH, ((double)xmax2 + 0.5) * sizePerBinW, ((double)ymax2 + 0.5) * sizePerBinH}));
    }

    public Seq<Object> dequantizeCoordinates(Seq<Object> bins, Tuple2<Object, Object> imageSize) {
        Tuple2<Object, Object> tuple2 = imageSize;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int w = tuple2._1$mcI$sp();
        int h = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(w, h);
        Tuple2.mcII.sp sp3 = sp2;
        int w2 = sp3._1$mcI$sp();
        int h2 = sp3._2$mcI$sp();
        double binsW = 1000.0;
        double binsH = 1000.0;
        double sizePerBinW = (double)w2 / binsW;
        double sizePerBinH = (double)h2 / binsH;
        return bins.grouped(2).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            Seq seq2 = x0$1;
            Some some = Seq$.MODULE$.unapplySeq(seq2);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                int x = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(0));
                int y = BoxesRunTime.unboxToInt((Object)((SeqLike)some.get()).apply(1));
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{((double)x + 0.5) * sizePerBinW, ((double)y + 0.5) * sizePerBinH}));
            } else {
                seq = (Seq)Nil$.MODULE$;
            }
            return seq;
        }).toSeq();
    }

    public Color[] colorMap() {
        return this.colorMap;
    }

    public BufferedImage plotBBox(BufferedImage image, Seq<Seq<Object>> bboxes, Seq<String> labels) {
        BufferedImage out = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = out.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        int maxFontSize = 18;
        int minFontSize = 8;
        ((TraversableLike)((IterableLike)bboxes.zip(labels, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Florence2Utils$.$anonfun$plotBBox$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            Florence2Utils$.$anonfun$plotBBox$2(g, maxFontSize, out, minFontSize, x$7);
            return BoxedUnit.UNIT;
        });
        g.dispose();
        return out;
    }

    public BufferedImage drawPolygons(BufferedImage image, Seq<Seq<Seq<Object>>> polygons, Seq<String> labels, boolean fillMask) {
        BufferedImage out = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = out.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        int maxFontSize = 18;
        int minFontSize = 8;
        ((TraversableLike)((IterableLike)polygons.zip(labels, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Florence2Utils$.$anonfun$drawPolygons$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            Florence2Utils$.$anonfun$drawPolygons$2(g, fillMask, maxFontSize, out, minFontSize, x$8);
            return BoxedUnit.UNIT;
        });
        g.dispose();
        return out;
    }

    public boolean drawPolygons$default$4() {
        return false;
    }

    public BufferedImage drawOcrBBoxes(BufferedImage image, Seq<Seq<Object>> quadBoxes, Seq<String> labels) {
        BufferedImage out = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = out.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        int maxFontSize = 18;
        int minFontSize = 8;
        ((TraversableLike)((IterableLike)quadBoxes.zip(labels, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)Florence2Utils$.$anonfun$drawOcrBBoxes$1(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            Florence2Utils$.$anonfun$drawOcrBBoxes$2(g, maxFontSize, out, minFontSize, x$9);
            return BoxedUnit.UNIT;
        });
        g.dispose();
        return out;
    }

    public Map<String, Object> convertToODFormat(Florence2Utils.MixedResult mixed) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bboxes"), mixed.bboxes().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.bbox(), Seq$.MODULE$.canBuildFrom())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labels"), mixed.bboxesLabels())}));
    }

    public String bufferedImageToBase64PNG(BufferedImage image) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    public Option<String> postProcessImage(BufferedImage image, String task, Florence2Utils.Florence2Result result, Option<String> textInput) {
        None$ none$;
        String baseTask = this.getBaseTaskToken(task);
        String string = baseTask;
        boolean bl = "<OD>".equals(string) ? true : ("<DENSE_REGION_CAPTION>".equals(string) ? true : "<REGION_PROPOSAL>".equals(string));
        if (bl) {
            None$ none$2;
            Florence2Utils.BBoxesResult bBoxesResult;
            Seq<Florence2Utils.BBox> bboxes;
            Florence2Utils.Florence2Result florence2Result = result;
            if (florence2Result instanceof Florence2Utils.BBoxesResult && (bboxes = (bBoxesResult = (Florence2Utils.BBoxesResult)florence2Result).bboxes()).nonEmpty()) {
                BufferedImage img = this.plotBBox(image, (Seq<Seq<Object>>)((Seq)bboxes.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.bbox(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)bboxes.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.catName(), Seq$.MODULE$.canBuildFrom())));
                none$2 = new Some((Object)this.bufferedImageToBase64PNG(img));
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if ("<CAPTION_TO_PHRASE_GROUNDING>".equals(string)) {
            None$ none$3;
            Florence2Utils.PhraseGroundingResult phraseGroundingResult;
            Seq<Florence2Utils.PhraseGroundingInstance> instances;
            Florence2Utils.Florence2Result florence2Result = result;
            if (florence2Result instanceof Florence2Utils.PhraseGroundingResult && (instances = (phraseGroundingResult = (Florence2Utils.PhraseGroundingResult)florence2Result).instances()).nonEmpty()) {
                Seq allBBoxes = (Seq)instances.flatMap((Function1 & Serializable & scala.Serializable)x$13 -> x$13.bbox(), Seq$.MODULE$.canBuildFrom());
                Seq allLabels = (Seq)instances.flatMap((Function1 & Serializable & scala.Serializable)inst -> (List)List$.MODULE$.fill(inst.bbox().size(), (Function0 & Serializable & scala.Serializable)() -> inst.catName()), Seq$.MODULE$.canBuildFrom());
                BufferedImage img = this.plotBBox(image, (Seq<Seq<Object>>)allBBoxes, (Seq<String>)allLabels);
                none$3 = new Some((Object)this.bufferedImageToBase64PNG(img));
            } else {
                none$3 = None$.MODULE$;
            }
            none$ = none$3;
        } else {
            boolean bl2 = "<REFERRING_EXPRESSION_SEGMENTATION>".equals(string) ? true : "<REGION_TO_SEGMENTATION>".equals(string);
            if (bl2) {
                None$ none$4;
                Florence2Utils.PolygonsResult polygonsResult;
                Seq<Florence2Utils.PolygonInstance> instances;
                Florence2Utils.Florence2Result florence2Result = result;
                if (florence2Result instanceof Florence2Utils.PolygonsResult && (instances = (polygonsResult = (Florence2Utils.PolygonsResult)florence2Result).instances()).nonEmpty()) {
                    BufferedImage img = this.drawPolygons(image, (Seq<Seq<Seq<Object>>>)((Seq)instances.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.polygons(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)instances.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.catName(), Seq$.MODULE$.canBuildFrom())), true);
                    none$4 = new Some((Object)this.bufferedImageToBase64PNG(img));
                } else {
                    none$4 = None$.MODULE$;
                }
                none$ = none$4;
            } else if ("<OPEN_VOCABULARY_DETECTION>".equals(string)) {
                Florence2Utils.BBoxesResult bBoxesResult;
                Seq<Florence2Utils.BBox> bboxes;
                Florence2Utils.PolygonsResult polygonsResult;
                Seq<Florence2Utils.PolygonInstance> instances;
                None$ none$5;
                Florence2Utils.Florence2Result florence2Result = result;
                if (florence2Result instanceof Florence2Utils.MixedResult) {
                    None$ none$6;
                    Florence2Utils.MixedResult mixedResult = (Florence2Utils.MixedResult)florence2Result;
                    Seq<Florence2Utils.BBox> bboxes2 = mixedResult.bboxes();
                    Seq<String> bboxesLabels = mixedResult.bboxesLabels();
                    Seq<Seq<Object>> polygons = mixedResult.polygons();
                    Seq<String> polygonsLabels = mixedResult.polygonsLabels();
                    if (polygons.nonEmpty()) {
                        BufferedImage img = this.drawPolygons(image, (Seq<Seq<Seq<Object>>>)((Seq)polygons.map((Function1 & Serializable & scala.Serializable)x$16 -> (Seq)new .colon.colon(x$16, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())), polygonsLabels, true);
                        none$6 = new Some((Object)this.bufferedImageToBase64PNG(img));
                    } else if (bboxes2.nonEmpty()) {
                        BufferedImage img = this.plotBBox(image, (Seq<Seq<Object>>)((Seq)bboxes2.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.bbox(), Seq$.MODULE$.canBuildFrom())), bboxesLabels);
                        none$6 = new Some((Object)this.bufferedImageToBase64PNG(img));
                    } else {
                        none$6 = None$.MODULE$;
                    }
                    none$5 = none$6;
                } else if (florence2Result instanceof Florence2Utils.PolygonsResult && (instances = (polygonsResult = (Florence2Utils.PolygonsResult)florence2Result).instances()).nonEmpty()) {
                    BufferedImage img = this.drawPolygons(image, (Seq<Seq<Seq<Object>>>)((Seq)instances.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.polygons(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)instances.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.catName(), Seq$.MODULE$.canBuildFrom())), true);
                    none$5 = new Some((Object)this.bufferedImageToBase64PNG(img));
                } else if (florence2Result instanceof Florence2Utils.BBoxesResult && (bboxes = (bBoxesResult = (Florence2Utils.BBoxesResult)florence2Result).bboxes()).nonEmpty()) {
                    BufferedImage img = this.plotBBox(image, (Seq<Seq<Object>>)((Seq)bboxes.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.bbox(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)bboxes.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.catName(), Seq$.MODULE$.canBuildFrom())));
                    none$5 = new Some((Object)this.bufferedImageToBase64PNG(img));
                } else {
                    none$5 = None$.MODULE$;
                }
                none$ = none$5;
            } else if ("<OCR_WITH_REGION>".equals(string)) {
                None$ none$7;
                Florence2Utils.OCRResult oCRResult;
                Seq<Florence2Utils.OCRInstance> instances;
                Florence2Utils.Florence2Result florence2Result = result;
                if (florence2Result instanceof Florence2Utils.OCRResult && (instances = (oCRResult = (Florence2Utils.OCRResult)florence2Result).instances()).nonEmpty()) {
                    BufferedImage img = this.drawOcrBBoxes(image, (Seq<Seq<Object>>)((Seq)instances.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.quadBox(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)instances.map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.text(), Seq$.MODULE$.canBuildFrom())));
                    none$7 = new Some((Object)this.bufferedImageToBase64PNG(img));
                } else {
                    none$7 = None$.MODULE$;
                }
                none$ = none$7;
            } else {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public Option<String> postProcessImage$default$4() {
        return None$.MODULE$;
    }

    public String getBaseTaskToken(String task) {
        return (String)this.taskAnswerPostProcessingType().keys().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)task.startsWith(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> task);
    }

    public static final /* synthetic */ boolean $anonfun$parsePhraseGrounding$2(char x$1) {
        return x$1 != '<';
    }

    public static final /* synthetic */ int $anonfun$parsePolygons$1(Regex.Match x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.group(1))).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parsePolygons$3(char x$3) {
        return x$3 != '<';
    }

    public static final /* synthetic */ boolean $anonfun$plotBBox$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$plotBBox$2(Graphics2D g$1, int maxFontSize$1, BufferedImage out$1, int minFontSize$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Seq bbox = (Seq)tuple22._1();
        String label = (String)tuple22._2();
        Color color = MODULE$.colorMap()[idx % MODULE$.colorMap().length];
        g$1.setColor(color);
        int x1 = (int)BoxesRunTime.unboxToDouble((Object)bbox.apply(0));
        int y1 = (int)BoxesRunTime.unboxToDouble((Object)bbox.apply(1));
        int x2 = (int)BoxesRunTime.unboxToDouble((Object)bbox.apply(2));
        int y2 = (int)BoxesRunTime.unboxToDouble((Object)bbox.apply(3));
        g$1.setStroke(new BasicStroke(2.0f));
        g$1.drawRect(x1, y1, x2 - x1, y2 - y1);
        int fontSize = maxFontSize$1;
        int labelWidth = 0;
        int labelHeight = 0;
        Font font = null;
        FontMetrics metrics = null;
        do {
            font = new Font("Arial", 1, fontSize);
            g$1.setFont(font);
            metrics = g$1.getFontMetrics(font);
            labelWidth = metrics.stringWidth(label) + 8;
            labelHeight = metrics.getHeight();
        } while (labelWidth > RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(x2 - x1), out$1.getWidth() - 8) && --fontSize >= minFontSize$1);
        int labelX = x1;
        int labelY = y1 - labelHeight + metrics.getAscent();
        if (labelY < 0) {
            labelY = y1 + labelHeight;
        }
        if (labelX + labelWidth > out$1.getWidth()) {
            labelX = out$1.getWidth() - labelWidth - 1;
        }
        if (labelX < 0) {
            labelX = 0;
        }
        g$1.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 180));
        g$1.fillRect(labelX, labelY - metrics.getAscent(), labelWidth, labelHeight);
        g$1.setColor(Color.WHITE);
        g$1.drawString(label, labelX + 4, labelY);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$drawPolygons$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$2;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$drawPolygons$3(boolean fillMask$1, Graphics2D g$2, Color color$1, int maxFontSize$2, String label$1, BufferedImage out$2, int minFontSize$2, Seq polygon) {
        int n = polygon.length() / 2;
        int[] xPoints = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> (int)BoxesRunTime.unboxToDouble((Object)polygon.apply(2 * i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        int[] yPoints = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> (int)BoxesRunTime.unboxToDouble((Object)polygon.apply(2 * i + 1)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        if (fillMask$1) {
            g$2.setColor(new Color(color$1.getRed(), color$1.getGreen(), color$1.getBlue(), 80));
            g$2.fillPolygon(xPoints, yPoints, n);
            g$2.setColor(color$1);
        }
        g$2.setStroke(new BasicStroke(2.0f));
        g$2.drawPolygon(xPoints, yPoints, n);
        int fontSize = maxFontSize$2;
        int labelWidth = 0;
        int labelHeight = 0;
        Font font = null;
        FontMetrics metrics = null;
        do {
            font = new Font("Arial", 1, fontSize);
            g$2.setFont(font);
            metrics = g$2.getFontMetrics(font);
            labelWidth = metrics.stringWidth(label$1) + 8;
            labelHeight = metrics.getHeight();
        } while (labelWidth > out$2.getWidth() - 8 && --fontSize >= minFontSize$2);
        int labelX = xPoints[0];
        int labelY = yPoints[0] - labelHeight + metrics.getAscent();
        if (labelY < 0) {
            labelY = yPoints[0] + labelHeight;
        }
        if (labelX + labelWidth > out$2.getWidth()) {
            labelX = out$2.getWidth() - labelWidth - 1;
        }
        if (labelX < 0) {
            labelX = 0;
        }
        g$2.setColor(new Color(color$1.getRed(), color$1.getGreen(), color$1.getBlue(), 180));
        g$2.fillRect(labelX, labelY - metrics.getAscent(), labelWidth, labelHeight);
        g$2.setColor(Color.WHITE);
        g$2.drawString(label$1, labelX + 4, labelY);
        g$2.setColor(color$1);
    }

    public static final /* synthetic */ void $anonfun$drawPolygons$2(Graphics2D g$2, boolean fillMask$1, int maxFontSize$2, BufferedImage out$2, int minFontSize$2, Tuple2 x$8) {
        int idx;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x$8;
                if (tuple22 == null) break block2;
                tuple2 = (Tuple2)tuple22._1();
                idx = tuple22._2$mcI$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        Seq polyList = (Seq)tuple2._1();
        String label = (String)tuple2._2();
        Color color = MODULE$.colorMap()[idx % MODULE$.colorMap().length];
        g$2.setColor(color);
        polyList.foreach((Function1 & Serializable & scala.Serializable)polygon -> {
            Florence2Utils$.$anonfun$drawPolygons$3(fillMask$1, g$2, color, maxFontSize$2, label, out$2, minFontSize$2, polygon);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$drawOcrBBoxes$1(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$3;
        boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$drawOcrBBoxes$2(Graphics2D g$3, int maxFontSize$3, BufferedImage out$3, int minFontSize$3, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Tuple2 tuple22 = (Tuple2)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        Seq box = (Seq)tuple22._1();
        String label = (String)tuple22._2();
        Color color = MODULE$.colorMap()[idx % MODULE$.colorMap().length];
        g$3.setColor(color);
        int n = box.length() / 2;
        int[] xPoints = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> (int)BoxesRunTime.unboxToDouble((Object)box.apply(2 * i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        int[] yPoints = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> (int)BoxesRunTime.unboxToDouble((Object)box.apply(2 * i + 1)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        g$3.setStroke(new BasicStroke(3.0f));
        g$3.drawPolygon(xPoints, yPoints, n);
        int fontSize = maxFontSize$3;
        int labelWidth = 0;
        int labelHeight = 0;
        Font font = null;
        FontMetrics metrics = null;
        do {
            font = new Font("Arial", 1, fontSize);
            g$3.setFont(font);
            metrics = g$3.getFontMetrics(font);
            labelWidth = metrics.stringWidth(label) + 8;
            labelHeight = metrics.getHeight();
        } while (labelWidth > out$3.getWidth() - 8 && --fontSize >= minFontSize$3);
        int labelX = xPoints[0];
        int labelY = yPoints[0] - labelHeight + metrics.getAscent();
        if (labelY < 0) {
            labelY = yPoints[0] + labelHeight;
        }
        if (labelX + labelWidth > out$3.getWidth()) {
            labelX = out$3.getWidth() - labelWidth - 1;
        }
        if (labelX < 0) {
            labelX = 0;
        }
        g$3.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 180));
        g$3.fillRect(labelX, labelY - metrics.getAscent(), labelWidth, labelHeight);
        g$3.setColor(Color.WHITE);
        g$3.drawString(label, labelX + 4, labelY);
        g$3.setColor(color);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private Florence2Utils$() {
        MODULE$ = this;
        this.taskPromptsWithoutInputs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<OCR>"), (Object)"What is the text in the image?"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<OCR_WITH_REGION>"), (Object)"What is the text in the image, with regions?"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<CAPTION>"), (Object)"What does the image describe?"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<DETAILED_CAPTION>"), (Object)"Describe in detail what is shown in the image."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<MORE_DETAILED_CAPTION>"), (Object)"Describe with a paragraph what is shown in the image."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<OD>"), (Object)"Locate the objects with category name in the image."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<DENSE_REGION_CAPTION>"), (Object)"Locate the objects in the image, with their descriptions."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_PROPOSAL>"), (Object)"Locate the region proposals in the image.")}));
        this.taskPromptsWithInput = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<CAPTION_TO_PHRASE_GROUNDING>"), (Object)"Locate the phrases in the caption: {input}"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REFERRING_EXPRESSION_SEGMENTATION>"), (Object)"Locate {input} in the image with mask"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_TO_SEGMENTATION>"), (Object)"What is the polygon mask of region {input}"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<OPEN_VOCABULARY_DETECTION>"), (Object)"Locate {input} in the image."), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_TO_CATEGORY>"), (Object)"What is the region {input}?"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_TO_DESCRIPTION>"), (Object)"What does the region {input} describe?"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_TO_OCR>"), (Object)"What text is in the region {input}?")}));
        this.taskAnswerPostProcessingType = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<OCR>"), (Object)"pure_text"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<OCR_WITH_REGION>"), (Object)"ocr"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<CAPTION>"), (Object)"pure_text"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<DETAILED_CAPTION>"), (Object)"pure_text"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<MORE_DETAILED_CAPTION>"), (Object)"pure_text"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<OD>"), (Object)"description_with_bboxes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<DENSE_REGION_CAPTION>"), (Object)"description_with_bboxes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<CAPTION_TO_PHRASE_GROUNDING>"), (Object)"phrase_grounding"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REFERRING_EXPRESSION_SEGMENTATION>"), (Object)"polygons"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_TO_SEGMENTATION>"), (Object)"polygons"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<OPEN_VOCABULARY_DETECTION>"), (Object)"description_with_bboxes_or_polygons"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_TO_CATEGORY>"), (Object)"pure_text"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_TO_DESCRIPTION>"), (Object)"pure_text"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_TO_OCR>"), (Object)"pure_text"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<REGION_PROPOSAL>"), (Object)"bboxes")}));
        this.colorMap = (Color[])((Object[])new Color[]{Color.BLUE, Color.ORANGE, Color.GREEN, Color.MAGENTA, Color.PINK, Color.GRAY, Color.YELLOW, Color.CYAN, Color.RED, Color.LIGHT_GRAY, new Color(128, 0, 128), new Color(255, 192, 203), new Color(128, 128, 0), new Color(0, 255, 255), new Color(255, 0, 255), new Color(255, 127, 80), new Color(255, 215, 0), new Color(210, 180, 140), new Color(135, 206, 235)});
    }
}

