/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.ai.util.transform;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class E5VUtils$ {
    public static E5VUtils$ MODULE$;

    static {
        new E5VUtils$();
    }

    public Tuple2<Object, Object> selectBestResolution(Tuple2<Object, Object> originalSize, List<Tuple2<Object, Object>> possibleResolutions) {
        Tuple2<Object, Object> tuple2 = originalSize;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int originalHeight = tuple2._1$mcI$sp();
        int originalWidth = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(originalHeight, originalWidth);
        Tuple2.mcII.sp sp3 = sp2;
        int originalHeight2 = sp3._1$mcI$sp();
        int originalWidth2 = sp3._2$mcI$sp();
        ObjectRef bestFit = ObjectRef.create((Object)((Tuple2)possibleResolutions.head()));
        IntRef maxEffectiveResolution = IntRef.create((int)0);
        DoubleRef minWastedResolution = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        possibleResolutions.withFilter((Function1 & java.io.Serializable & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)E5VUtils$.$anonfun$selectBestResolution$1(check$ifrefutable$1))).foreach((Function1 & java.io.Serializable & Serializable)x$2 -> {
            E5VUtils$.$anonfun$selectBestResolution$2(originalWidth2, originalHeight2, maxEffectiveResolution, minWastedResolution, bestFit, x$2);
            return BoxedUnit.UNIT;
        });
        return (Tuple2)bestFit.elem;
    }

    public int imageSizeToNumPatches(Tuple2<Object, Object> imageSize, List<Tuple2<Object, Object>> gridPinpoints, int patchSize) {
        Tuple2<Object, Object> tuple2 = this.selectBestResolution(imageSize, gridPinpoints);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int height = tuple2._1$mcI$sp();
        int width = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(height, width);
        Tuple2.mcII.sp sp3 = sp2;
        int height2 = sp3._1$mcI$sp();
        int width2 = sp3._2$mcI$sp();
        int numPatches = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height2).by(patchSize).size() * RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width2).by(patchSize).size();
        return numPatches + 1;
    }

    public Tuple2<Object, Object> getAnyResImageGridShape(Tuple2<Object, Object> imageSize, List<Tuple2<Object, Object>> gridPinpoints, int patchSize) {
        Tuple2<Object, Object> tuple2 = this.selectBestResolution(imageSize, gridPinpoints);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int height = tuple2._1$mcI$sp();
        int width = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(height, width);
        Tuple2.mcII.sp sp3 = sp2;
        int height2 = sp3._1$mcI$sp();
        int width2 = sp3._2$mcI$sp();
        return new Tuple2.mcII.sp(height2 / patchSize, width2 / patchSize);
    }

    public Tuple2<Object, Object> getImageSize(BufferedImage image) {
        return new Tuple2.mcII.sp(image.getHeight(), image.getWidth());
    }

    public BufferedImage expandToSquare(BufferedImage image, Color backgroundColor) {
        BufferedImage bufferedImage;
        int height;
        int width = image.getWidth();
        if (width == (height = image.getHeight())) {
            bufferedImage = image;
        } else if (width > height) {
            BufferedImage result = new BufferedImage(width, width, image.getType());
            Graphics2D g = result.createGraphics();
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, width);
            g.drawImage((Image)image, 0, (width - height) / 2, null);
            g.dispose();
            bufferedImage = result;
        } else {
            BufferedImage result = new BufferedImage(height, height, image.getType());
            Graphics2D g = result.createGraphics();
            g.setColor(backgroundColor);
            g.fillRect(0, 0, height, height);
            g.drawImage((Image)image, (height - width) / 2, 0, null);
            g.dispose();
            bufferedImage = result;
        }
        return bufferedImage;
    }

    public List<BufferedImage> divideToPatches(BufferedImage image, int patchSize) {
        int width = image.getWidth();
        int height = image.getHeight();
        IndexedSeq patches = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).by(patchSize).flatMap((Function1 & java.io.Serializable & Serializable)i -> E5VUtils$.$anonfun$divideToPatches$1(width, patchSize, height, image, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return patches.toList();
    }

    public Tuple2<Object, Object> getPatchOutputSize(BufferedImage image, Tuple2<Object, Object> targetResolution) {
        Tuple2.mcII.sp sp2;
        Tuple2<Object, Object> tuple2 = this.getImageSize(image);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int originalHeight = tuple2._1$mcI$sp();
        int originalWidth = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(originalHeight, originalWidth);
        Tuple2.mcII.sp sp4 = sp3;
        int originalHeight2 = sp4._1$mcI$sp();
        int originalWidth2 = sp4._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = targetResolution;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int targetHeight = tuple22._1$mcI$sp();
        int targetWidth = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(targetHeight, targetWidth);
        Tuple2.mcII.sp sp6 = sp5;
        int targetHeight2 = sp6._1$mcI$sp();
        int targetWidth2 = sp6._2$mcI$sp();
        double scaleW = (double)targetWidth2 / (double)originalWidth2;
        double scaleH = (double)targetHeight2 / (double)originalHeight2;
        if (scaleW < scaleH) {
            int newWidth = targetWidth2;
            int newHeight = package$.MODULE$.min((int)package$.MODULE$.ceil((double)originalHeight2 * scaleW), targetHeight2);
            sp2 = new Tuple2.mcII.sp(newHeight, newWidth);
        } else {
            int newHeight = targetHeight2;
            int newWidth = package$.MODULE$.min((int)package$.MODULE$.ceil((double)originalWidth2 * scaleH), targetWidth2);
            sp2 = new Tuple2.mcII.sp(newHeight, newWidth);
        }
        return sp2;
    }

    public BufferedImage padImage(BufferedImage image, Tuple2<Object, Object> targetResolution) {
        Tuple2<Object, Object> tuple2 = targetResolution;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int targetHeight = tuple2._1$mcI$sp();
        int targetWidth = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(targetHeight, targetWidth);
        Tuple2.mcII.sp sp3 = sp2;
        int targetHeight2 = sp3._1$mcI$sp();
        int targetWidth2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = this.getImageSize(image);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int originalHeight = tuple22._1$mcI$sp();
        int originalWidth = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(originalHeight, originalWidth);
        Tuple2.mcII.sp sp5 = sp4;
        int originalHeight2 = sp5._1$mcI$sp();
        int originalWidth2 = sp5._2$mcI$sp();
        Tuple2<Object, Object> tuple23 = this.getPatchOutputSize(image, targetResolution);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        int newHeight = tuple23._1$mcI$sp();
        int newWidth = tuple23._2$mcI$sp();
        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(newHeight, newWidth);
        Tuple2.mcII.sp sp7 = sp6;
        int newHeight2 = sp7._1$mcI$sp();
        int newWidth2 = sp7._2$mcI$sp();
        BufferedImage result = new BufferedImage(targetWidth2, targetHeight2, image.getType());
        Graphics2D g = result.createGraphics();
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, newWidth2, newHeight2);
        g.drawImage((Image)image, (targetWidth2 - originalWidth2) / 2, (targetHeight2 - originalHeight2) / 2, null);
        g.dispose();
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$selectBestResolution$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$selectBestResolution$2(int originalWidth$1, int originalHeight$1, IntRef maxEffectiveResolution$1, DoubleRef minWastedResolution$1, ObjectRef bestFit$1, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            int height = tuple2._1$mcI$sp();
            int width = tuple2._2$mcI$sp();
            double scale = package$.MODULE$.min((double)width / (double)originalWidth$1, (double)height / (double)originalHeight$1);
            int downscaledWidth = (int)((double)originalWidth$1 * scale);
            int downscaledHeight = (int)((double)originalHeight$1 * scale);
            int effectiveResolution = package$.MODULE$.min(downscaledWidth * downscaledHeight, originalWidth$1 * originalHeight$1);
            int wastedResolution = width * height - effectiveResolution;
            if (effectiveResolution > maxEffectiveResolution$1.elem || effectiveResolution == maxEffectiveResolution$1.elem && (double)wastedResolution < minWastedResolution$1.elem) {
                maxEffectiveResolution$1.elem = effectiveResolution;
                minWastedResolution$1.elem = wastedResolution;
                bestFit$1.elem = new Tuple2.mcII.sp(height, width);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ BufferedImage $anonfun$divideToPatches$2(int patchSize$1, int width$1, int height$1, int i$1, BufferedImage image$1, int j) {
        int w = package$.MODULE$.min(patchSize$1, width$1 - j);
        int h = package$.MODULE$.min(patchSize$1, height$1 - i$1);
        return image$1.getSubimage(j, i$1, w, h);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$divideToPatches$1(int width$1, int patchSize$1, int height$1, BufferedImage image$1, int i) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width$1).by(patchSize$1).map((Function1 & java.io.Serializable & Serializable)j -> E5VUtils$.$anonfun$divideToPatches$2(patchSize$1, width$1, height$1, i, image$1, BoxesRunTime.unboxToInt((Object)j)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private E5VUtils$() {
        MODULE$ = this;
    }
}

