/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.gguf;

import com.johnsnowlabs.ml.gguf.GGUFWrapper;
import com.johnsnowlabs.nlp.llama.LlamaModel;
import com.johnsnowlabs.nlp.llama.ModelParameters;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GGUFWrapper$
implements scala.Serializable {
    public static GGUFWrapper$ MODULE$;
    private final Logger logger;

    static {
        new GGUFWrapper$();
    }

    public Logger logger() {
        return this.logger;
    }

    public synchronized LlamaModel com$johnsnowlabs$ml$gguf$GGUFWrapper$$withSafeGGUFModelLoader(ModelParameters modelParameters) {
        return new LlamaModel(modelParameters);
    }

    public GGUFWrapper read(SparkSession sparkSession, String modelPath) {
        File modelFile = new File(modelPath);
        boolean modelFileExist = modelFile.exists();
        if (!modelFile.getName().endsWith(".gguf")) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Model file ").append(modelPath).append(" is not a GGUF model file").toString());
        }
        if (!modelFileExist) {
            throw new IllegalArgumentException(new StringBuilder(26).append("Model file ").append(modelPath).append(" does not exist").toString());
        }
        sparkSession.sparkContext().addFile(modelPath);
        return new GGUFWrapper(modelFile.getName(), modelFile.getParent());
    }

    public GGUFWrapper readModel(String modelFolderPath, SparkSession spark) {
        URI uri = new URI(new StringOps(Predef$.MODULE$.augmentString(modelFolderPath)).replaceAllLiterally("\\", "/"));
        FileSystem fileSystem = FileSystem.get((URI)uri, (Configuration)spark.sparkContext().hadoopConfiguration());
        String actualFolderPath = fileSystem.resolvePath(new Path(modelFolderPath)).toString();
        String localFolder = ResourceHelper$.MODULE$.copyToLocal(actualFolderPath);
        String modelFile = GGUFWrapper$.findGGUFModelInFolder$1(localFolder);
        return this.read(spark, modelFile);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$readModel$2(File x$2) {
        return x$2.getName().endsWith(".gguf");
    }

    private static final String findGGUFModelInFolder$1(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Path ").append(folderPath).append(" is not a directory").toString());
        }
        String ggufFile = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])folder.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFile())))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GGUFWrapper$.$anonfun$readModel$2(x$2))))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(29).append("Could not find GGUF model in ").append(folderPath).toString());
        });
        return new File(ggufFile).getAbsolutePath();
    }

    private GGUFWrapper$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"GGUFWrapper");
    }
}

