/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.gguf;

import com.johnsnowlabs.ml.gguf.GGUFWrapperMultiModal;
import com.johnsnowlabs.nlp.llama.LlamaModel;
import com.johnsnowlabs.nlp.llama.ModelParameters;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GGUFWrapperMultiModal$
implements scala.Serializable {
    public static GGUFWrapperMultiModal$ MODULE$;

    static {
        new GGUFWrapperMultiModal$();
    }

    public synchronized LlamaModel com$johnsnowlabs$ml$gguf$GGUFWrapperMultiModal$$withSafeGGUFModelLoader(ModelParameters modelParameters) {
        return new LlamaModel(modelParameters);
    }

    public GGUFWrapperMultiModal read(SparkSession sparkSession, String modelPath, String mmprojPath) {
        File modelFile = new File(modelPath);
        File mmprojFile = new File(mmprojPath);
        if (!modelFile.getName().endsWith(".gguf")) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Model file ").append(modelPath).append(" is not a GGUF model file").toString());
        }
        if (!mmprojFile.getName().endsWith(".gguf")) {
            throw new IllegalArgumentException(new StringBuilder(37).append("mmproj file ").append(mmprojPath).append(" is not a GGUF model file").toString());
        }
        if (!mmprojFile.getName().contains("mmproj")) {
            throw new IllegalArgumentException(new StringBuilder(76).append("mmproj file ").append(mmprojPath).append(" is not a GGUF mmproj file (should contain 'mmproj' in its name)").toString());
        }
        if (!modelFile.exists() || !mmprojFile.exists()) {
            throw new IllegalArgumentException(new StringBuilder(42).append("Model file ").append(modelPath).append(" or mmproj file ").append(mmprojPath).append(" does not exist").toString());
        }
        sparkSession.sparkContext().addFile(modelPath);
        sparkSession.sparkContext().addFile(mmprojPath);
        return new GGUFWrapperMultiModal(modelFile.getName(), mmprojFile.getName());
    }

    public GGUFWrapperMultiModal readModel(String modelFolderPath, SparkSession spark) {
        URI uri = new URI(new StringOps(Predef$.MODULE$.augmentString(modelFolderPath)).replaceAllLiterally("\\", "/"));
        FileSystem fileSystem = FileSystem.get((URI)uri, (Configuration)spark.sparkContext().hadoopConfiguration());
        String actualFolderPath = fileSystem.resolvePath(new Path(modelFolderPath)).toString();
        String localFolder = ResourceHelper$.MODULE$.copyToLocal(actualFolderPath);
        Tuple2 tuple2 = GGUFWrapperMultiModal$.findGGUFModelsInFolder$1(localFolder);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String ggufMainPath = (String)tuple2._1();
        String ggufMmprojPath = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)ggufMainPath, (Object)ggufMmprojPath);
        Tuple2 tuple23 = tuple22;
        String ggufMainPath2 = (String)tuple23._1();
        String ggufMmprojPath2 = (String)tuple23._2();
        return this.read(spark, ggufMainPath2, ggufMmprojPath2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$readModel$2(File x$2) {
        return x$2.getName().endsWith(".gguf");
    }

    private static final Tuple2 findGGUFModelsInFolder$1(String folderPath) {
        Tuple2 tuple2;
        File folder = new File(folderPath);
        if (folder.exists() && folder.isDirectory()) {
            String secondModel;
            String firstModel;
            String[] ggufFiles = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])folder.listFiles())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFile())))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)GGUFWrapperMultiModal$.$anonfun$readModel$2(x$2))))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            if (ggufFiles.length == 2 && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ggufFiles)).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains("mmproj")))) {
                String[] stringArray = ggufFiles;
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String firstModel2 = (String)((SeqLike)option.get()).apply(0);
                String secondModel2 = (String)((SeqLike)option.get()).apply(1);
                Tuple2 tuple22 = new Tuple2((Object)firstModel2, (Object)secondModel2);
                Tuple2 tuple23 = tuple22;
                firstModel = (String)tuple23._1();
                secondModel = (String)tuple23._2();
            } else {
                throw new IllegalArgumentException(new StringBuilder(204).append("Could not determine main GGUF model or mmproj GGUF model in ").append(folderPath).append(".").append(" The folder should contain exactly two files:").append(" One main GGUF model and one mmproj GGUF model.").append(" The mmproj model should have 'mmproj' in its name.").toString());
            }
            Tuple2 tuple24 = firstModel.contains("mmproj") ? new Tuple2((Object)secondModel, (Object)firstModel) : new Tuple2((Object)firstModel, (Object)secondModel);
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            String ggufMainPath = (String)tuple24._1();
            String ggufMmprojPath = (String)tuple24._2();
            tuple2 = new Tuple2((Object)ggufMainPath, (Object)ggufMmprojPath);
        } else {
            throw new IllegalArgumentException(new StringBuilder(24).append("Path ").append(folderPath).append(" is not a directory").toString());
        }
        Tuple2 tuple25 = tuple2;
        String ggufMainPath = (String)tuple25._1();
        String ggufMmprojPath = (String)tuple25._2();
        return new Tuple2((Object)ggufMainPath, (Object)ggufMmprojPath);
    }

    private GGUFWrapperMultiModal$() {
        MODULE$ = this;
    }
}

