/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.openvino;

import com.johnsnowlabs.ml.openvino.OpenvinoWrapper;
import com.johnsnowlabs.ml.util.LoadExternalModel$;
import com.johnsnowlabs.ml.util.ONNX$;
import com.johnsnowlabs.ml.util.Openvino$;
import com.johnsnowlabs.ml.util.TensorFlow$;
import com.johnsnowlabs.util.ZipArchiveUtil$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.spark.sql.SparkSession;
import org.intel.openvino.CompiledModel;
import org.intel.openvino.Core;
import org.intel.openvino.Model;
import org.intel.openvino.Openvino;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;

public final class OpenvinoWrapper$
implements scala.Serializable {
    public static OpenvinoWrapper$ MODULE$;
    private final Logger logger;
    private final Core core;
    private final String ModelSuffix;

    static {
        new OpenvinoWrapper$();
    }

    public Option<String> $lessinit$greater$default$1() {
        return None$.MODULE$;
    }

    private Logger logger() {
        return this.logger;
    }

    public Core core() {
        return this.core;
    }

    private String ModelSuffix() {
        return this.ModelSuffix;
    }

    public OpenvinoWrapper read(SparkSession sparkSession, String modelPath, String modelName, boolean zipped, boolean useBundle, String detectedEngine, Map<String, String> properties, Option<String> ovFileSuffix) {
        Tuple2 tuple2;
        String tmpFolder = ((Object)Files.createTempDirectory(new StringBuilder(0).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append(this.ModelSuffix()).toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        Option<String> randomSuffix = this.generateRandomSuffix(ovFileSuffix);
        String folder = zipped ? ZipArchiveUtil$.MODULE$.unzip(new File(modelPath), (Option<String>)new Some((Object)tmpFolder), randomSuffix) : modelPath;
        String string = detectedEngine;
        String string2 = TensorFlow$.MODULE$.name();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            tuple2 = this.convertToOpenvinoFormat(folder, tmpFolder, this.convertToOpenvinoFormat$default$3());
        } else {
            String string4 = ONNX$.MODULE$.name();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                tuple2 = useBundle ? this.convertToOpenvinoFormat(((Object)Paths.get(folder, ONNX$.MODULE$.modelName())).toString(), tmpFolder, this.convertToOpenvinoFormat$default$3()) : this.convertToOpenvinoFormat(((Object)Paths.get(folder, new StringBuilder(5).append(modelName).append(".onnx").toString())).toString(), tmpFolder, this.convertToOpenvinoFormat$default$3());
            } else {
                String string6 = Openvino$.MODULE$.name();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    Tuple2 tuple22;
                    if (useBundle) {
                        tuple22 = new Tuple2((Object)Paths.get(folder, new StringBuilder(4).append(modelName).append(".xml").toString()), (Object)Paths.get(folder, new StringBuilder(4).append(modelName).append(".bin").toString()));
                    } else {
                        String ovModelName = FilenameUtils.getBaseName((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(folder).list())).head()));
                        tuple22 = new Tuple2((Object)Paths.get(folder, new StringBuilder(4).append(ovModelName).append(".xml").toString()), (Object)Paths.get(folder, new StringBuilder(4).append(ovModelName).append(".bin").toString()));
                    }
                    tuple2 = tuple22;
                } else {
                    throw new Exception(LoadExternalModel$.MODULE$.notSupportedEngineError());
                }
            }
        }
        Tuple2 tuple23 = tuple2;
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        Path ovModelPath = (Path)tuple23._1();
        Path ovWeightsPath = (Path)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)ovModelPath, (Object)ovWeightsPath);
        Tuple2 tuple25 = tuple24;
        Path ovModelPath2 = (Path)tuple25._1();
        Path ovWeightsPath2 = (Path)tuple25._2();
        sparkSession.sparkContext().addFile(((Object)ovModelPath2).toString());
        sparkSession.sparkContext().addFile(((Object)ovWeightsPath2).toString());
        Some ovFileName = new Some((Object)FilenameUtils.getBaseName((String)ovModelPath2.toFile().getName()));
        OpenvinoWrapper openvinoWrapper = new OpenvinoWrapper((Option<String>)ovFileName);
        Some x$1 = new Some((Object)((Object)ovModelPath2).toString());
        Map<String, String> x$2 = properties;
        String x$3 = this.withSafeOvModelLoader$default$2();
        CompiledModel compiledModel = this.withSafeOvModelLoader((Option<String>)x$1, x$3, x$2);
        openvinoWrapper.com$johnsnowlabs$ml$openvino$OpenvinoWrapper$$compiledModel_$eq(compiledModel);
        return openvinoWrapper;
    }

    public String read$default$3() {
        return Openvino$.MODULE$.ovModel();
    }

    public boolean read$default$4() {
        return true;
    }

    public boolean read$default$5() {
        return false;
    }

    public String read$default$6() {
        return Openvino$.MODULE$.name();
    }

    public Map<String, String> read$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<String> read$default$8() {
        return None$.MODULE$;
    }

    private Option<String> generateRandomSuffix(Option<String> fileSuffix) {
        Some randomSuffix = new Some((Object)LoadExternalModel$.MODULE$.generateRandomString(10));
        return new Some((Object)new StringBuilder(0).append(randomSuffix.get()).append(fileSuffix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
    }

    public Tuple2<Path, Path> convertToOpenvinoFormat(String srcPath, String exportPath, boolean compressToFp16) {
        this.logger().debug(new StringBuilder(40).append("Converting model from ").append(srcPath).append(", compresToFp16 = ").append(compressToFp16).toString());
        Model model = this.core().read_model(srcPath);
        Path ovXmlPath = Paths.get(exportPath, new StringBuilder(4).append(Openvino$.MODULE$.ovModel()).append(".xml").toString());
        Path ovBinPath = Paths.get(exportPath, new StringBuilder(4).append(Openvino$.MODULE$.ovModel()).append(".bin").toString());
        Openvino.save_model((Model)model, (String)((Object)ovXmlPath.toAbsolutePath()).toString(), (boolean)compressToFp16);
        return new Tuple2((Object)ovXmlPath, (Object)ovBinPath);
    }

    public boolean convertToOpenvinoFormat$default$3() {
        return false;
    }

    public CompiledModel withSafeOvModelLoader(Option<String> modelPath, String device, Map<String, String> properties) {
        this.logger().info(new StringBuilder(36).append("Compiling OpenVINO model to device: ").append(device).toString());
        CompiledModel compiledModel = this.core().compile_model((String)modelPath.get(), device, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(properties).asJava());
        return compiledModel;
    }

    public Option<String> withSafeOvModelLoader$default$1() {
        return None$.MODULE$;
    }

    public String withSafeOvModelLoader$default$2() {
        return "CPU";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final /* synthetic */ Core liftedTree1$1() {
        Core core;
        try {
            core = new Core();
        }
        catch (UnsatisfiedLinkError e) {
            this.logger().error("Could not initialize OpenVINO Core. Please make sure the jsl-openvino JAR is loaded and Intel oneTBB is installed.\n(See https://www.intel.com/content/www/us/en/docs/onetbb/get-started-guide/2021-12/overview.html)");
            throw e;
        }
        return core;
    }

    private OpenvinoWrapper$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)this.getClass().toString());
        this.core = this.liftedTree1$1();
        this.ModelSuffix = "_ov_model";
    }
}

