/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.ml.util;

import com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper;
import com.johnsnowlabs.ml.tensorflow.sentencepiece.SentencePieceWrapper$;
import com.johnsnowlabs.ml.util.ONNX$;
import com.johnsnowlabs.ml.util.Openvino$;
import com.johnsnowlabs.ml.util.TensorFlow$;
import com.johnsnowlabs.ml.util.Unknown$;
import com.johnsnowlabs.nlp.util.io.ExternalResource;
import com.johnsnowlabs.nlp.util.io.ReadAs$;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class LoadExternalModel$ {
    public static LoadExternalModel$ MODULE$;
    private final String notSupportedEngineError;

    static {
        new LoadExternalModel$();
    }

    public String notSupportedEngineError() {
        return this.notSupportedEngineError;
    }

    public boolean isTensorFlowModel(String modelPath) {
        File tfSavedModel = new File(modelPath, TensorFlow$.MODULE$.modelName());
        return tfSavedModel.exists();
    }

    public boolean isOnnxModel(String modelPath, boolean isEncoderDecoder, boolean withPast, boolean isDecoder) {
        boolean bl;
        if (isEncoderDecoder) {
            File onnxDecoderModel;
            File onnxEncoderModel = new File(modelPath, ONNX$.MODULE$.encoderModel());
            File file = onnxDecoderModel = withPast ? new File(modelPath, ONNX$.MODULE$.decoderWithPastModel()) : new File(modelPath, ONNX$.MODULE$.decoderModel());
            bl = onnxEncoderModel.exists() && onnxDecoderModel.exists();
        } else if (isDecoder) {
            File onnxDecoderModel = withPast ? new File(modelPath, ONNX$.MODULE$.decoderWithPastModel()) : new File(modelPath, ONNX$.MODULE$.decoderModel());
            bl = onnxDecoderModel.exists();
        } else {
            File onnxModel = new File(modelPath, ONNX$.MODULE$.modelName());
            bl = onnxModel.exists();
        }
        return bl;
    }

    public boolean isOnnxModel$default$2() {
        return false;
    }

    public boolean isOnnxModel$default$3() {
        return false;
    }

    public boolean isOnnxModel$default$4() {
        return false;
    }

    public boolean isOpenvinoModel(String modelPath, boolean isEncoderDecoder, Option<List<String>> custom) {
        boolean bl;
        Object object = new Object();
        try {
            if (custom.isDefined()) {
                ((List)custom.get()).foreach((Function1 & Serializable & scala.Serializable)model -> {
                    LoadExternalModel$.$anonfun$isOpenvinoModel$1(modelPath, object, model);
                    return BoxedUnit.UNIT;
                });
                bl = true;
            } else if (isEncoderDecoder) {
                File ovEncoderModelXml = new File(modelPath, new StringBuilder(4).append(Openvino$.MODULE$.encoderModel()).append(".xml").toString());
                File ovEncoderModelBin = new File(modelPath, new StringBuilder(4).append(Openvino$.MODULE$.encoderModel()).append(".bin").toString());
                File ovDecoderModelXml = new File(modelPath, new StringBuilder(4).append(Openvino$.MODULE$.decoderModel()).append(".xml").toString());
                File ovDecoderModelBin = new File(modelPath, new StringBuilder(4).append(Openvino$.MODULE$.decoderModel()).append(".bin").toString());
                File ovDecoderModelWithPastXml = new File(modelPath, new StringBuilder(4).append(Openvino$.MODULE$.decoderModelWithPast()).append(".xml").toString());
                File ovDecoderModelWithPastBin = new File(modelPath, new StringBuilder(4).append(Openvino$.MODULE$.decoderModelWithPast()).append(".bin").toString());
                bl = ovEncoderModelXml.exists() && ovEncoderModelBin.exists() && ovDecoderModelXml.exists() && ovDecoderModelBin.exists() && ovDecoderModelWithPastXml.exists() && ovDecoderModelWithPastBin.exists();
            } else {
                File modelXml = new File(modelPath, new StringBuilder(4).append(Openvino$.MODULE$.ovModel()).append(".xml").toString());
                File modelBin = new File(modelPath, new StringBuilder(4).append(Openvino$.MODULE$.ovModel()).append(".bin").toString());
                bl = modelXml.exists() && modelBin.exists();
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public Option<List<String>> isOpenvinoModel$default$3() {
        return None$.MODULE$;
    }

    public String detectEngine(String modelPath, boolean isEncoderDecoder, boolean withPast, boolean isDecoder, Option<List<String>> custom) {
        String string;
        File f = new File(modelPath);
        Predef$.MODULE$.require(f.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Folder ").append(modelPath).append(" not found").toString());
        Predef$.MODULE$.require(f.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Folder ").append(modelPath).append(" is not folder").toString());
        String assetsPath = ((Object)Paths.get(modelPath, "/assets")).toString();
        File assetsPathFile = new File(assetsPath);
        Predef$.MODULE$.require(assetsPathFile.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Folder ").append(assetsPath).append(" not found").toString());
        Predef$.MODULE$.require(assetsPathFile.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Folder ").append(assetsPath).append(" is not folder").toString());
        boolean tfSavedModelExist = this.isTensorFlowModel(modelPath);
        boolean onnxModelExist = this.isOnnxModel(modelPath, isEncoderDecoder, withPast, isDecoder);
        boolean openvinoModelExist = this.isOpenvinoModel(modelPath, isEncoderDecoder, custom);
        if (tfSavedModelExist) {
            string = TensorFlow$.MODULE$.name();
        } else if (onnxModelExist) {
            string = ONNX$.MODULE$.name();
        } else if (openvinoModelExist) {
            string = Openvino$.MODULE$.name();
        } else {
            Predef$.MODULE$.require(tfSavedModelExist || onnxModelExist || openvinoModelExist, (Function0 & Serializable & scala.Serializable)() -> MODULE$.notSupportedEngineError());
            string = Unknown$.MODULE$.name();
        }
        return string;
    }

    public boolean detectEngine$default$2() {
        return false;
    }

    public boolean detectEngine$default$3() {
        return false;
    }

    public boolean detectEngine$default$4() {
        return false;
    }

    public Option<List<String>> detectEngine$default$5() {
        return None$.MODULE$;
    }

    public Tuple2<String, String> modelSanityCheck(String path, boolean isEncoderDecoder, boolean withPast, boolean isDecoder, Option<List<String>> custom) {
        String localPath = ResourceHelper$.MODULE$.copyToLocal(path);
        return new Tuple2((Object)localPath, (Object)this.detectEngine(localPath, isEncoderDecoder, withPast, isDecoder, custom));
    }

    public boolean modelSanityCheck$default$2() {
        return false;
    }

    public boolean modelSanityCheck$default$3() {
        return false;
    }

    public boolean modelSanityCheck$default$4() {
        return false;
    }

    public Option<List<String>> modelSanityCheck$default$5() {
        return None$.MODULE$;
    }

    public String[] loadTextAsset(String assetPath, String assetName) {
        File assetFile = this.checkAndCreateFile(new StringBuilder(7).append(assetPath).append("/assets").toString(), assetName);
        ExternalResource assetResource = new ExternalResource(assetFile.toURI().toURL().toString(), ReadAs$.MODULE$.TEXT(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)"text")}))));
        return ResourceHelper$.MODULE$.parseLines(assetResource);
    }

    public SentencePieceWrapper loadSentencePieceAsset(String assetPath, String assetName) {
        File assetFile = this.checkAndCreateFile(new StringBuilder(7).append(assetPath).append("/assets").toString(), assetName);
        return SentencePieceWrapper$.MODULE$.read(assetFile.toString());
    }

    public String loadJsonStringAsset(String assetPath, String assetName) {
        File assetFile = this.checkAndCreateFile(new StringBuilder(7).append(assetPath).append("/assets").toString(), assetName);
        InputStream vocabStream = ResourceHelper$.MODULE$.getResourceStream(assetFile.getAbsolutePath());
        return Source$.MODULE$.fromInputStream(vocabStream, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    /*
     * WARNING - void declaration
     */
    private File checkAndCreateFile(String filePath, String fileName) {
        void var3_3;
        File f = new File(filePath, fileName);
        Predef$.MODULE$.require(f.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("File ").append(fileName).append(" not found in folder ").append(filePath).toString());
        return var3_3;
    }

    public String generateRandomString(int n) {
        String alphanumeric = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        return ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), n).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(alphanumeric), Random$.MODULE$.nextInt(alphanumeric.length()))), IndexedSeq$.MODULE$.canBuildFrom())).mkString();
    }

    public static final /* synthetic */ void $anonfun$isOpenvinoModel$1(String modelPath$1, Object nonLocalReturnKey1$1, String model) {
        File ovModelXml = new File(modelPath$1, new StringBuilder(4).append(model).append(".xml").toString());
        File ovModelBin = new File(modelPath$1, new StringBuilder(4).append(model).append(".bin").toString());
        if (!ovModelXml.exists() || !ovModelBin.exists()) {
            Predef$.MODULE$.println((Object)new StringBuilder(24).append("Custom model ").append(model).append(" is missing").toString());
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("Model ").append(model).append(" not found in ").append(modelPath$1).toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    private LoadExternalModel$() {
        MODULE$ = this;
        this.notSupportedEngineError = new StringOps(Predef$.MODULE$.augmentString("Your imported model is either not supported or not correctly imported.\n       |\n       |A typical imported TensorFlow SavedModel has the following structure:\n       |\n       |\u251c\u2500\u2500 assets/\n       |    \u251c\u2500\u2500 your-assets-are-here (vocab, sp model, labels, etc.)\n       |\u251c\u2500\u2500 saved_model.pb\n       |\u2514\u2500\u2500 variables/\n       |    \u251c\u2500\u2500 variables.data-00000-of-00001\n       |    \u2514\u2500\u2500 variables.index\n       |\n       |A typical imported ONNX model has the following structure:\n       |\n       |\u251c\u2500\u2500 assets/\n       |    \u251c\u2500\u2500 your-assets-are-here (vocab, sp model, labels, etc.)\n       |\u251c\u2500\u2500 model.onnx\n       |\n       |A typical imported ONNX model for Seq2Seq has the following structure:\n       |\n       |\u251c\u2500\u2500 assets/\n       |    \u251c\u2500\u2500 your-assets-are-here (vocab, sp model, labels, etc.)\n       |\u251c\u2500\u2500 encoder_model.onnx\n       |\u251c\u2500\u2500 decoder_model.onnx\n       |\u251c\u2500\u2500 decoder_with_past_model.onnx\n       |\n       |A typical imported OpenVINO model has the following structure:\n       |\n       |\u251c\u2500\u2500 assets/\n       |    \u251c\u2500\u2500 your-assets-are-here (vocab, sp model, labels, etc.)\n       |\u251c\u2500\u2500 openvino_model.xml\n       |\u251c\u2500\u2500 openvino_model.bin\n       |\n       |A typical imported OpenVINO model for Seq2Seq has the following structure:\n       |\n       |\u251c\u2500\u2500 assets/\n       |    \u251c\u2500\u2500 your-assets-are-here (vocab, sp model, labels, etc.)\n       |\u251c\u2500\u2500 openvino_encoder_model.xml\n       |\u251c\u2500\u2500 openvino_encoder_model.bin\n       |\u251c\u2500\u2500 openvino_decoder_model.xml\n       |\u251c\u2500\u2500 openvino_decoder_model.bin\n       |\u251c\u2500\u2500 openvino_decoder_with_past_model.xml\n       |\u251c\u2500\u2500 openvino_decoder_with_past_model.bin\n       |\n       |Please make sure you follow provided notebooks to import external models into Spark NLP:\n       |https://github.com/JohnSnowLabs/spark-nlp/discussions/5669")).stripMargin();
    }
}

