/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.audio.feature_extractor;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.Axis;
import breeze.linalg.Axis$;
import breeze.linalg.BroadcastedLike;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.max$;
import breeze.linalg.min$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.package;
import breeze.linalg.support.CanZipMapValues;
import breeze.math.Complex;
import breeze.math.Complex$;
import breeze.math.Ring$;
import breeze.numerics.package;
import breeze.signal.fourierTr$;
import breeze.storage.Zero$;
import com.johnsnowlabs.ml.util.LinAlg$implicits$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class AudioUtils$ {
    public static AudioUtils$ MODULE$;

    static {
        new AudioUtils$();
    }

    public double hertzToMel(double freq) {
        double minLogHertz = 1000.0;
        double minLogMel = 15.0;
        double logstep = 27.0 / Math.log(6.4);
        double mels = 3.0 * freq / 200.0;
        return freq >= minLogHertz ? minLogMel + Math.log(freq / minLogHertz) * logstep : mels;
    }

    public double melToHertz(double mels) {
        double minLogHertz = 1000.0;
        double minLogMel = 15.0;
        double logstep = Math.log(6.4) / 27.0;
        double freq = 200.0 * mels / 3.0;
        return mels >= minLogMel ? minLogHertz * Math.exp(logstep * (mels - minLogMel)) : freq;
    }

    private DenseMatrix<Object> createTriangularFilterBank(DenseVector<Object> fftFreqs, DenseVector<Object> filterFreqs) {
        DenseVector filterDiff = (DenseVector)((ImmutableNumericOps)filterFreqs.apply((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), -1), HasOps$.MODULE$.canSlice_DV_Range_eq_DV())).$minus(filterFreqs.apply((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), -2), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        DenseMatrix<Object> filterFreqsMatrix = LinAlg$implicits$.MODULE$.ExtendedDenseMatrix((DenseMatrix<Object>)filterFreqs.toDenseMatrix$mcD$sp()).broadcastTo((Tuple2<Object, Object>)new Tuple2.mcII.sp(fftFreqs.length(), filterFreqs.length()));
        DenseMatrix<Object> fftFreqsMatrix = LinAlg$implicits$.MODULE$.ExtendedDenseMatrix((DenseMatrix<Object>)((DenseMatrix)fftFreqs.toDenseMatrix$mcD$sp().t(HasOps$.MODULE$.canTranspose_DM()))).broadcastTo((Tuple2<Object, Object>)new Tuple2.mcII.sp(fftFreqs.length(), filterFreqs.length()));
        DenseMatrix slopes = (DenseMatrix)filterFreqsMatrix.$minus(fftFreqsMatrix, HasOps$.MODULE$.op_DM_DM_Double_OpSub());
        DenseMatrix negativeSlopes = (DenseMatrix)((ImmutableNumericOps)slopes.apply((Object)package$.MODULE$.$colon$colon(), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), -3), HasOps$.MODULE$.canSliceCols())).unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseMatrix$.MODULE$.scalarOf(), Ring$.MODULE$.ringD(), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar()));
        DenseMatrix<Object> filterFirst = LinAlg$implicits$.MODULE$.ExtendedDenseMatrix((DenseMatrix<Object>)((DenseVector)filterDiff.apply((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), -2), HasOps$.MODULE$.canSlice_DV_Range_eq_DV())).toDenseMatrix$mcD$sp()).broadcastTo((DenseMatrix<Object>)negativeSlopes);
        DenseMatrix downSlopes = (DenseMatrix)negativeSlopes.$div(filterFirst, HasOps$.MODULE$.op_DM_DM_Double_OpDiv());
        DenseMatrix positiveSlopes = (DenseMatrix)slopes.apply((Object)package$.MODULE$.$colon$colon(), (Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(2), -1), HasOps$.MODULE$.canSliceCols());
        DenseMatrix<Object> filterLast = LinAlg$implicits$.MODULE$.ExtendedDenseMatrix((DenseMatrix<Object>)((DenseVector)filterDiff.apply((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), -1), HasOps$.MODULE$.canSlice_DV_Range_eq_DV())).toDenseMatrix$mcD$sp()).broadcastTo((DenseMatrix<Object>)positiveSlopes);
        DenseMatrix upSlopes = (DenseMatrix)positiveSlopes.$div(filterLast, HasOps$.MODULE$.op_DM_DM_Double_OpDiv());
        DenseMatrix slopeMins = (DenseMatrix)min$.MODULE$.apply((Object)downSlopes, (Object)upSlopes, HasOps$.MODULE$.impl_T_S_eq_U_from_ZipMap(DenseMatrix$.MODULE$.scalarOf(), min$.MODULE$.minImpl2_Double(), (CanZipMapValues)HasOps$.MODULE$.zipMap_DM_Double()));
        return (DenseMatrix)max$.MODULE$.apply((Object)DenseMatrix$.MODULE$.zeros$mDc$sp(slopeMins.rows(), slopeMins.cols(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()), (Object)slopeMins, HasOps$.MODULE$.impl_T_S_eq_U_from_ZipMap(DenseMatrix$.MODULE$.scalarOf(), max$.MODULE$.maxImpl2_Double(), (CanZipMapValues)HasOps$.MODULE$.zipMap_DM_Double()));
    }

    public DenseMatrix<Object> melFilterBank(int numFrequencyBins, int numMelFilters, double minFrequency, double maxFrequency, int samplingRate) {
        DenseMatrix normedMelFilters;
        block0: {
            DenseVector enorm;
            double melMax;
            double melMin;
            DenseVector melFreqs;
            DenseVector filterFreqs;
            DenseVector fftFreqs = breeze.linalg.package$.MODULE$.linspace(0.0, (double)(samplingRate / 2), numFrequencyBins);
            DenseMatrix<Object> melFilters = this.createTriangularFilterBank((DenseVector<Object>)fftFreqs, (DenseVector<Object>)(filterFreqs = (DenseVector)(melFreqs = breeze.linalg.package$.MODULE$.linspace(melMin = this.hertzToMel(minFrequency), melMax = this.hertzToMel(maxFrequency), numMelFilters + 2)).map$mcD$sp((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)mels -> MODULE$.melToHertz(mels), DenseVector$.MODULE$.DV_canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))));
            normedMelFilters = (DenseMatrix)melFilters.$times$colon$times(LinAlg$implicits$.MODULE$.ExtendedDenseMatrix((DenseMatrix<Object>)(enorm = (DenseVector)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)2.0))).$div(((ImmutableNumericOps)filterFreqs.apply((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(2), numMelFilters + 2), HasOps$.MODULE$.canSlice_DV_Range_eq_DV())).$minus(filterFreqs.apply((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMelFilters), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double()), HasOps$.MODULE$.impl_Op_S_DV_eq_DV_Double_OpDiv())).toDenseMatrix$mcD$sp()).broadcastTo(melFilters), HasOps$.MODULE$.op_DM_DM_Double_OpMulScalar());
            if (!((Vector)((ImmutableNumericOps)max$.MODULE$.apply((Object)normedMelFilters, (Object)Axis._0$.MODULE$, Axis$.MODULE$.collapseUred(HasOps$.MODULE$.handholdCanMapRows_DM(), max$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()), HasOps$.MODULE$.canCollapseRows_DM(ClassTag$.MODULE$.Double())))).t(HasOps$.MODULE$.canUntranspose())).exists$mcD$sp((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 == 0.0)) break block0;
            Predef$.MODULE$.println((Object)"Warning: At least one mel filter has all zero values. The value of numMelFilters might be set too high or numFrequencyBins too low.");
        }
        return normedMelFilters;
    }

    public DenseVector<Object> padReflective(DenseVector<Object> vector, Tuple2<Object, Object> padding) {
        Predef$.MODULE$.require(padding._1$mcI$sp() <= vector.length() - 1 && padding._2$mcI$sp() <= vector.length() - 1, (Function0 & Serializable & scala.Serializable)() -> "Reflecting past the vector itself is currently not supported. Perhaps the padding value was set too high.");
        DenseVector paddingLeft = (DenseVector)vector.apply((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(padding._1$mcI$sp()), 1).by(-1), HasOps$.MODULE$.canSlice_DV_Range_eq_DV());
        DenseVector paddingRight = (DenseVector)vector.apply((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(-2), -padding._2$mcI$sp() - 1).by(-1), HasOps$.MODULE$.canSlice_DV_Range_eq_DV());
        return DenseVector$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{paddingLeft, vector, paddingRight}), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero());
    }

    public DenseMatrix<Object> calculateSpectrogram(DenseVector<Object> waveform, DenseVector<Object> window, int frameLength, int hopLength, DenseMatrix<Object> melFilters, double power, boolean center, boolean onesided, double melFloor) {
        Predef$.MODULE$.require(window.length() == frameLength, (Function0 & Serializable & scala.Serializable)() -> "Window must be same size as the frame");
        DenseVector<Object> processedWaveform = center ? this.padReflective(waveform, (Tuple2<Object, Object>)new Tuple2.mcII.sp(frameLength / 2, frameLength / 2)) : waveform;
        int fftLength = frameLength;
        int numFrames = 1 + (processedWaveform.size() - frameLength) / hopLength;
        int numFrequencyBins = onesided ? fftLength / 2 + 1 : fftLength;
        IndexedSeq spectrogramRows = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFrames).map((Function1 & Serializable & scala.Serializable)frame -> AudioUtils$.$anonfun$calculateSpectrogram$2(hopLength, frameLength, processedWaveform, window, numFrequencyBins, BoxesRunTime.unboxToInt((Object)frame)), IndexedSeq$.MODULE$.canBuildFrom());
        DenseMatrix spectrogram = DenseMatrix$.MODULE$.vertcat((Seq)spectrogramRows, HasOps$.MODULE$.impl_OpMulSet_InPlace_DM_DM(), ClassTag$.MODULE$.apply(Complex.class), Complex$.MODULE$.ComplexZero());
        DenseMatrix scaledSpectrogram = (DenseMatrix)((ImmutableNumericOps)package.pow$.MODULE$.apply(package.abs$.MODULE$.apply((Object)spectrogram, HasOps$.MODULE$.fromLowOrderCanMapActiveValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)Complex.absComplexImpl$.MODULE$, HasOps$.MODULE$.canMapValues_DM(ClassTag$.MODULE$.Double()))), (Object)BoxesRunTime.boxToDouble((double)power), HasOps$.MODULE$.canMapV1DV(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl2)package.pow$.powDoubleDoubleImpl$.MODULE$, HasOps$.MODULE$.canMapValues_DM$mDDc$sp(ClassTag$.MODULE$.Double())))).t(HasOps$.MODULE$.canTranspose_DM());
        DenseMatrix melFilteredSpectrogram = (DenseMatrix)max$.MODULE$.apply(((ImmutableNumericOps)melFilters.t(HasOps$.MODULE$.canTranspose_DM())).$times((Object)scaledSpectrogram, (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()), (Object)BoxesRunTime.boxToDouble((double)melFloor), max$.MODULE$.maxVS(DenseMatrix$.MODULE$.scalarOf(), max$.MODULE$.maxImpl2_Double(), HasOps$.MODULE$.canMapValues_DM$mDDc$sp(ClassTag$.MODULE$.Double())));
        DenseMatrix logMelSpectrogram = (DenseMatrix)package.log10$.MODULE$.apply((Object)melFilteredSpectrogram, HasOps$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.log10$.log10DoubleImpl$.MODULE$, HasOps$.MODULE$.canMapValues_DM$mDDc$sp(ClassTag$.MODULE$.Double())));
        return logMelSpectrogram;
    }

    public boolean calculateSpectrogram$default$7() {
        return true;
    }

    public boolean calculateSpectrogram$default$8() {
        return true;
    }

    public double calculateSpectrogram$default$9() {
        return 1.0E-10;
    }

    public float[][] matrixToFloatArray(DenseMatrix<Object> matrix) {
        return (float[][])((DenseVector)((BroadcastedLike)matrix.apply((Object)$times$.MODULE$, (Object)package$.MODULE$.$colon$colon(), Broadcaster$.MODULE$.canBroadcastRows(HasOps$.MODULE$.handholdCanMapCols_DM()))).map((Function1 & Serializable & scala.Serializable)row -> (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(row.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$3 -> (float)x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())), HasOps$.MODULE$.canMapValues_BRows(HasOps$.MODULE$.canCollapseCols_DM(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)))))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
    }

    public static final /* synthetic */ DenseMatrix $anonfun$calculateSpectrogram$2(int hopLength$1, int frameLength$1, DenseVector processedWaveform$1, DenseVector window$1, int numFrequencyBins$1, int frame) {
        int timestep = frame * hopLength$1;
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(timestep, timestep + frameLength$1);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int frameStart = sp2._1$mcI$sp();
        int frameEnd = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(frameStart, frameEnd);
        Tuple2.mcII.sp sp4 = sp3;
        int frameStart2 = sp4._1$mcI$sp();
        int frameEnd2 = sp4._2$mcI$sp();
        DenseVector windowedFrame = (DenseVector)((ImmutableNumericOps)processedWaveform$1.apply((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(frameStart2), frameEnd2), HasOps$.MODULE$.canSlice_DV_Range_eq_DV())).$times$colon$times((Object)window$1, HasOps$.MODULE$.impl_Op_DV_DV_eq_DV_Double_OpMulScalar());
        DenseVector qual$1 = (DenseVector)fourierTr$.MODULE$.apply((Object)windowedFrame, fourierTr$.MODULE$.dvDouble1DFFT());
        int x$1 = 0;
        int x$2 = numFrequencyBins$1;
        int x$3 = qual$1.slice$default$3();
        DenseMatrix fourier = qual$1.slice(x$1, x$2, x$3).toDenseMatrix();
        return fourier;
    }

    private AudioUtils$() {
        MODULE$ = this;
    }
}

