/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.audio.feature_extractor;

import com.johnsnowlabs.nlp.annotators.audio.feature_extractor.Preprocessor;
import com.johnsnowlabs.nlp.annotators.audio.feature_extractor.PreprocessorAttributes$;
import com.johnsnowlabs.nlp.annotators.audio.feature_extractor.WhisperPreprocessor;
import com.johnsnowlabs.util.JsonParser$;
import java.io.Serializable;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class Preprocessor$
implements scala.Serializable {
    public static Preprocessor$ MODULE$;

    static {
        new Preprocessor$();
    }

    public boolean $lessinit$greater$default$1() {
        return true;
    }

    public Preprocessor apply(boolean do_normalize, int feature_size, String padding_side, float padding_value, boolean return_attention_mask, int sampling_rate) {
        return new Preprocessor(do_normalize, feature_size, padding_side, padding_value, return_attention_mask, sampling_rate);
    }

    public boolean apply$default$1() {
        return true;
    }

    public Preprocessor.JValueExtended com$johnsnowlabs$nlp$annotators$audio$feature_extractor$Preprocessor$$JValueExtended(JsonAST.JValue value) {
        return new Preprocessor.JValueExtended(value);
    }

    public void checkSchema(JsonAST.JValue json, String processorClass) {
        Seq<String> seq;
        String string = processorClass;
        if ("Wav2Vec2Processor".equals(string)) {
            seq = PreprocessorAttributes$.MODULE$.Wave2Vec();
        } else if ("WhisperProcessor".equals(string)) {
            seq = PreprocessorAttributes$.MODULE$.Whisper();
        } else {
            throw new IllegalArgumentException(new StringBuilder(32).append("Preprocessor for ").append(string).append(" not supported.").toString());
        }
        Seq<String> attributes = seq;
        boolean schemaCorrect = this.com$johnsnowlabs$nlp$annotators$audio$feature_extractor$Preprocessor$$JValueExtended(json).hasAttributes(attributes);
        Predef$.MODULE$.require(schemaCorrect, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("The schema of preprocessor_config.json file is incorrect. It should have the following fields:\n").append(attributes.mkString("\n")).toString());
    }

    public Preprocessor loadPreprocessorConfig(String preprocessorConfigJsonContent) {
        Preprocessor preprocessor;
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JsonAST.JValue parsedJson = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(preprocessorConfigJsonContent), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        String processorClass = (String)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(parsedJson).$bslash("processor_class")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception("\"processor_class\" attribute not found in preprocessor_config.json!");
        }, (Formats)formats, ManifestFactory$.MODULE$.classType(String.class));
        this.checkSchema(parsedJson, processorClass);
        try {
            String string = processorClass;
            Preprocessor preprocessor2 = "WhisperProcessor".equals(string) ? (Preprocessor)JsonParser$.MODULE$.parseObject(preprocessorConfigJsonContent, ManifestFactory$.MODULE$.classType(WhisperPreprocessor.class)) : (Preprocessor)JsonParser$.MODULE$.parseObject(preprocessorConfigJsonContent, ManifestFactory$.MODULE$.classType(Preprocessor.class));
            preprocessor = preprocessor2;
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(37).append("Could not parse preprocessor config ").append(e.getClass().toString()).append(":").append(e.getMessage()).toString());
            throw e;
        }
        Preprocessor preprocessorConfig = preprocessor;
        return preprocessorConfig;
    }

    public float[] normalize(float[] rawAudio) {
        ArrayBuffer normalizedData = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        float meanData = this.mean(rawAudio);
        double varianceData = this.variance(rawAudio);
        new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(rawAudio)).foreach((Function1 & Serializable & scala.Serializable)x -> normalizedData.$plus$eq((Object)BoxesRunTime.boxToFloat((float)((BoxesRunTime.unboxToFloat((Object)x) - meanData) / (float)package$.MODULE$.sqrt(varianceData + 1.0E-7)))));
        return (float[])normalizedData.toArray(ClassTag$.MODULE$.Float());
    }

    public float mean(float[] rawAudio) {
        return new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(rawAudio)).isEmpty() ? 0.0f : BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(rawAudio)).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) / (float)rawAudio.length;
    }

    public double variance(float[] rawAudio) {
        float avg = this.mean(rawAudio);
        return BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(rawAudio)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)a -> package$.MODULE$.pow((double)(a - avg), 2.0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rawAudio.length;
    }

    public List<Object> removeDup(List<Object> lst) {
        Nil$ nil$;
        List<Object> list = lst;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            int head = BoxesRunTime.unboxToInt((Object)colon2.head());
            Tuple2 tuple2 = lst.span((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == head);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List duplicateList = (List)tuple2._1();
            List remainList = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)duplicateList, (Object)remainList);
            Tuple2 tuple23 = tuple22;
            List duplicateList2 = (List)tuple23._1();
            List remainList2 = (List)tuple23._2();
            int n = BoxesRunTime.unboxToInt((Object)duplicateList2.head());
            nil$ = this.removeDup((List<Object>)remainList2).$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
        } else if (Nil$.MODULE$.equals(list)) {
            nil$ = Nil$.MODULE$;
        } else {
            throw new MatchError(list);
        }
        return nil$;
    }

    public float[] pad(float[] audio, float paddingValue, int totalLength, String paddingSide) {
        float[] padding = (float[])Array$.MODULE$.fill(totalLength - audio.length, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> paddingValue, ClassTag$.MODULE$.Float());
        String string = paddingSide;
        float[] fArray = "left".equals(string) ? (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(padding)).$plus$plus((GenTraversableOnce)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(audio)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())) : ("right".equals(string) ? (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(audio)).$plus$plus((GenTraversableOnce)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(padding)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())) : (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(audio)).$plus$plus((GenTraversableOnce)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(padding)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())));
        return fArray;
    }

    public float[] truncate(float[] audio, int maxLength) {
        return audio.length > maxLength ? (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(audio)).slice(0, maxLength) : audio;
    }

    public Option<Tuple6<Object, Object, String, Object, Object, Object>> unapply(Preprocessor x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)BoxesRunTime.boxToBoolean((boolean)x$0.do_normalize()), (Object)BoxesRunTime.boxToInteger((int)x$0.feature_size()), (Object)x$0.padding_side(), (Object)BoxesRunTime.boxToFloat((float)x$0.padding_value()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.return_attention_mask()), (Object)BoxesRunTime.boxToInteger((int)x$0.sampling_rate())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Preprocessor$() {
        MODULE$ = this;
    }
}

