/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.cv.util.io;

import com.johnsnowlabs.nlp.ImageFields;
import com.johnsnowlabs.nlp.util.io.ResourceHelper;
import com.johnsnowlabs.nlp.util.io.ResourceHelper$;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ImageIOUtils$ {
    public static ImageIOUtils$ MODULE$;
    private final Logger logger;
    private final Map<String, Object> ocvTypes;

    static {
        new ImageIOUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public Map<String, Object> ocvTypes() {
        return this.ocvTypes;
    }

    public Option<BufferedImage> loadImage(File file) {
        return this.readImage(file);
    }

    public Option<BufferedImage> loadImage(InputStream inputStream) {
        return this.readImage(inputStream);
    }

    public Option<BufferedImage> loadImage(String path) {
        File filePath = ResourceHelper$.MODULE$.getFileFromPath(path);
        return this.readImage(filePath);
    }

    public Option<BufferedImage> loadImageFromAnySource(String path) {
        Some some;
        String prefix = path.indexOf(":") == -1 ? "" : path.substring(0, path.indexOf(":"));
        String string = prefix;
        if ("dbfs".equals(string)) {
            some = this.loadImage(path.replace("dbfs:", "/dbfs/"));
        } else if ("hdfs".equals(string)) {
            ResourceHelper.SourceStream sourceStream = new ResourceHelper.SourceStream(path);
            some = new Some((Object)ImageIO.read((InputStream)sourceStream.pipe().head()));
        } else {
            some = this.loadImage(path);
        }
        return some;
    }

    public Option<BufferedImage> readImage(File file) {
        Some some;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ImageIO.read(file));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            BufferedImage bufferedImage = (BufferedImage)success.value();
            some = new Some((Object)bufferedImage);
        } else if (try_ instanceof Failure) {
            this.logger().warn(new StringBuilder(52).append("Error in ImageIOUtils.readImage while reading file: ").append(file.getPath()).toString());
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return some;
    }

    public Option<BufferedImage> readImage(InputStream inputStream) {
        None$ none$;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ImageIO.read(inputStream));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            BufferedImage bufferedImage = (BufferedImage)success.value();
            none$ = new Some((Object)bufferedImage);
        } else if (try_ instanceof Failure) {
            this.logger().warn("Error in ImageIOUtils.readImage while reading inputStream");
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    public File[] loadImages(String imagesPath) {
        File[] fileArray;
        Try<File[]> try_ = this.loadImagesFromDirectory(imagesPath);
        if (try_ instanceof Success) {
            File[] files;
            Success success = (Success)try_;
            fileArray = files = (File[])success.value();
        } else if (try_ instanceof Failure) {
            File singleImagePath = ResourceHelper$.MODULE$.getFileFromPath(imagesPath);
            fileArray = (File[])((Object[])new File[]{singleImagePath});
        } else {
            throw new MatchError(try_);
        }
        return fileArray;
    }

    private Try<File[]> loadImagesFromDirectory(String path) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (File[])ResourceHelper$.MODULE$.listLocalFiles(path).toArray(ClassTag$.MODULE$.apply(File.class)));
    }

    public int convertChannelsToType(int channels) {
        int n;
        int n2 = channels;
        switch (n2) {
            case 1: {
                n = 10;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                throw new UnsupportedOperationException(new StringBuilder(66).append("Image resize: number of output  ").append("channels must be 1, 3, or 4, got ").append(n2).append(".").toString());
            }
        }
        return n;
    }

    public BufferedImage byteToBufferedImage(byte[] bytes, int w, int h, int nChannels) {
        BufferedImage img = new BufferedImage(w, h, this.convertChannelsToType(nChannels));
        img.setData(Raster.createRaster(img.getSampleModel(), new DataBufferByte(bytes, bytes.length), new Point()));
        return img;
    }

    public byte[] bufferedImageToByte(BufferedImage img) {
        byte[] byArray;
        if (img == null) {
            byArray = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
        } else {
            int nChannels;
            boolean is_gray = img.getColorModel().getColorSpace().getType() == 6;
            int height = img.getHeight();
            int width = img.getWidth();
            Tuple2<Object, Object> tuple2 = this.getChannelsAndMode(img);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int n = nChannels = tuple2._1$mcI$sp();
            int nChannels2 = n;
            Predef$.MODULE$.assert((double)(height * width * nChannels2) < 1.0E9, (Function0 & Serializable & scala.Serializable)() -> "image is too large");
            byte[] decoded = (byte[])Array$.MODULE$.ofDim(height * width * nChannels2, ClassTag$.MODULE$.Byte());
            if (is_gray) {
                IntRef offset = IntRef.create((int)0);
                WritableRaster raster = img.getRaster();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)h -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)w -> {
                    decoded$1[offset$1.elem] = (byte)raster.getSample(w, h, 0);
                    ++offset$1.elem;
                }));
            } else {
                IntRef offset = IntRef.create((int)0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)h -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)w -> {
                    Color color = new Color(img.getRGB(w, h));
                    decoded$1[offset$2.elem] = (byte)color.getBlue();
                    decoded$1[offset$2.elem + 1] = (byte)color.getGreen();
                    decoded$1[offset$2.elem + 2] = (byte)color.getRed();
                    if (nChannels2 == 4) {
                        decoded$1[offset$2.elem + 3] = (byte)color.getAlpha();
                    }
                    offset$2.elem += nChannels2;
                }));
            }
            byArray = decoded;
        }
        return byArray;
    }

    private Tuple2<Object, Object> getChannelsAndMode(BufferedImage bufferedImage) {
        Tuple2.mcII.sp sp2;
        boolean is_gray = bufferedImage.getColorModel().getColorSpace().getType() == 6;
        boolean has_alpha = bufferedImage.getColorModel().hasAlpha();
        Tuple2.mcII.sp sp3 = is_gray ? new Tuple2.mcII.sp(1, BoxesRunTime.unboxToInt((Object)this.ocvTypes().getOrElse((Object)"CV_8UC1", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))) : (sp2 = has_alpha ? new Tuple2.mcII.sp(4, BoxesRunTime.unboxToInt((Object)this.ocvTypes().getOrElse((Object)"CV_8UC4", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))) : new Tuple2.mcII.sp(3, BoxesRunTime.unboxToInt((Object)this.ocvTypes().getOrElse((Object)"CV_8UC3", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int numberOfChannels = sp2._1$mcI$sp();
        int mode = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(numberOfChannels, mode);
        Tuple2.mcII.sp sp5 = sp4;
        int numberOfChannels2 = sp5._1$mcI$sp();
        int mode2 = sp5._2$mcI$sp();
        return new Tuple2.mcII.sp(numberOfChannels2, mode2);
    }

    public Option<ImageFields> imagePathToImageFields(String imagePath) {
        Option<BufferedImage> bufferedImage = this.loadImageFromAnySource(imagePath);
        return this.bufferedImageToImageFields(bufferedImage, imagePath);
    }

    public Option<ImageFields> imageFileToImageFields(File file) {
        Option<BufferedImage> bufferedImage = this.loadImage(file);
        return this.bufferedImageToImageFields(bufferedImage, file.getPath());
    }

    public Option<ImageFields> bufferedImageToImageFields(Option<BufferedImage> bufferedImage, String origin) {
        None$ none$;
        if (bufferedImage.isDefined()) {
            Tuple2<Object, Object> tuple2 = this.getChannelsAndMode((BufferedImage)bufferedImage.get());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int nChannels = tuple2._1$mcI$sp();
            int mode = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(nChannels, mode);
            Tuple2.mcII.sp sp3 = sp2;
            int nChannels2 = sp3._1$mcI$sp();
            int mode2 = sp3._2$mcI$sp();
            byte[] data = this.bufferedImageToByte((BufferedImage)bufferedImage.get());
            none$ = new Some((Object)new ImageFields(origin, ((BufferedImage)bufferedImage.get()).getHeight(), ((BufferedImage)bufferedImage.get()).getWidth(), nChannels2, mode2, data));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public BufferedImage arrayToBufferedImage(int[][][] pixelArray) {
        int height = pixelArray.length;
        int width = ((int[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pixelArray)).head()).length;
        BufferedImage image = new BufferedImage(width, height, 1);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pixelArray)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pixelArray[y])).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            int[] nArray = pixelArray[y][x];
            Option option = Array$.MODULE$.unapplySeq((Object)nArray);
            if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(3) != 0) {
                throw new IllegalArgumentException("Each pixel must have exactly 3 color channels (RGB)");
            }
            int r = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(0));
            int g = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(1));
            int b = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(2));
            int n = new Color(r, g, b).getRGB();
            int rgb = n;
            image.setRGB(x, y, rgb);
        }));
        return image;
    }

    public String encodeImageBase64(byte[] image) {
        return Base64.getEncoder().encodeToString(image);
    }

    private ImageIOUtils$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"ImageIOUtils");
        this.ocvTypes = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8U"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC3"), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC4"), (Object)BoxesRunTime.boxToInteger((int)24))}));
    }
}

