/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.cv.util.transform;

import com.johnsnowlabs.nlp.annotators.cv.util.transform.ImageResizeUtils$;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MllamaUtils$ {
    public static MllamaUtils$ MODULE$;

    static {
        new MllamaUtils$();
    }

    public List<Tuple2<Object, Object>> getAllSupportedAspectRatios(int maxImageTiles) {
        ListBuffer aspectRatios = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), maxImageTiles).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), maxImageTiles).foreach((Function1 & Serializable & scala.Serializable)height -> MllamaUtils$.$anonfun$getAllSupportedAspectRatios$2(width, maxImageTiles, aspectRatios, BoxesRunTime.unboxToInt((Object)height))));
        return aspectRatios.toList();
    }

    public Tuple2<Object, Object> getImageSizeFitToCanvas(int imageHeight, int imageWidth, int canvasHeight, int canvasWidth, int tileSize) {
        int targetHeight;
        double scaleH;
        int targetWidth = package$.MODULE$.max(package$.MODULE$.min(imageWidth, canvasWidth), tileSize);
        double scaleW = (double)targetWidth / (double)imageWidth;
        return scaleW < (scaleH = (double)(targetHeight = package$.MODULE$.max(package$.MODULE$.min(imageHeight, canvasHeight), tileSize)) / (double)imageHeight) ? new Tuple2.mcII.sp(package$.MODULE$.min((int)package$.MODULE$.floor((double)imageHeight * scaleW), targetHeight), targetWidth) : new Tuple2.mcII.sp(targetHeight, package$.MODULE$.min((int)package$.MODULE$.floor((double)imageWidth * scaleH), targetWidth));
    }

    public Tuple2<Object, Object> getOptimalTiledCanvas(int imageHeight, int imageWidth, int maxImageTiles, int tileSize) {
        List scaleW;
        List<Tuple2<Object, Object>> possibleTileArrangements = this.getAllSupportedAspectRatios(maxImageTiles);
        List possibleCanvasSizes = (List)possibleTileArrangements.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int w = tuple2._1$mcI$sp();
            int h = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(w * tileSize, h * tileSize);
            return sp2;
        }, List$.MODULE$.canBuildFrom());
        List targetHeights = (List)possibleCanvasSizes.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._2$mcI$sp()), List$.MODULE$.canBuildFrom());
        List targetWidths = (List)possibleCanvasSizes.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()), List$.MODULE$.canBuildFrom());
        List scaleH = (List)targetHeights.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$3 -> (double)x$3 / (double)imageHeight, List$.MODULE$.canBuildFrom());
        List scales = (List)((List)scaleH.zip((GenIterable)(scaleW = (List)targetWidths.map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$4 -> (double)x$4 / (double)imageWidth, List$.MODULE$.canBuildFrom())), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)MllamaUtils$.$anonfun$getOptimalTiledCanvas$6(x0$2)), List$.MODULE$.canBuildFrom());
        List upScalingOptions = (List)scales.filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 >= 1.0);
        double selectedScale = upScalingOptions.nonEmpty() ? BoxesRunTime.unboxToDouble((Object)upScalingOptions.min((Ordering)Ordering.Double$.MODULE$)) : BoxesRunTime.unboxToDouble((Object)((TraversableOnce)scales.filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> x$6 < 1.0)).max((Ordering)Ordering.Double$.MODULE$));
        List chosenCanvas = (List)((List)((TraversableLike)possibleCanvasSizes.zip((GenIterable)scales, List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$getOptimalTiledCanvas$9(selectedScale, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 size;
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = size = (Tuple2)tuple2._1();
            return tuple22;
        }, List$.MODULE$.canBuildFrom());
        return chosenCanvas.size() > 1 ? (Tuple2)chosenCanvas.minBy((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToInteger((int)MllamaUtils$.$anonfun$getOptimalTiledCanvas$11(x0$5)), (Ordering)Ordering.Int$.MODULE$) : (Tuple2)chosenCanvas.head();
    }

    public int[][][] imageCropToArray(BufferedImage imgCrop) {
        int height = imgCrop.getHeight();
        int width = imgCrop.getWidth();
        int channels = 3;
        int[][][] cropArray = (int[][][])Array$.MODULE$.ofDim(channels, height, width, ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            Color color = new Color(imgCrop.getRGB(x, y));
            cropArray$1[0][y$1][x] = color.getRed();
            cropArray$1[1][y$1][x] = color.getGreen();
            cropArray$1[2][y$1][x] = color.getBlue();
        }));
        return cropArray;
    }

    public float[][][][] splitToTiles(BufferedImage image, int numTilesHeight, int numTilesWidth, double[] mean, double[] std, boolean doNormalize, boolean doRescale, double rescaleFactor) {
        int cropHeight = image.getHeight() / numTilesHeight;
        int cropWidth = image.getWidth() / numTilesWidth;
        ArrayBuffer cropsBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTilesHeight).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTilesWidth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            BufferedImage imgCrop = image.getSubimage(j * cropHeight, i * cropWidth, cropHeight, cropWidth);
            float[][][] normalizedCrop = ImageResizeUtils$.MODULE$.normalizeAndConvertBufferedImage(imgCrop, mean, std, doNormalize, doRescale, rescaleFactor);
            cropsBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][][][]{normalizedCrop}));
        }));
        return (float[][][][])cropsBuffer.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)))));
    }

    public BufferedImage arrayToBufferedImage(int[][][] imageArray) {
        int height = imageArray[0].length;
        int width = imageArray[0][0].length;
        BufferedImage image = new BufferedImage(width, height, 1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            byte[] rgb = (byte[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])imageArray)).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)MllamaUtils$.$anonfun$arrayToBufferedImage$3(y, x, x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToByte((byte)MllamaUtils$.$anonfun$arrayToBufferedImage$4(BoxesRunTime.unboxToInt((Object)x$8))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
            Color color = new Color(rgb[0], rgb[1], rgb[2]);
            image.setRGB(x, y, color.getRGB());
        }));
        return image;
    }

    public BufferedImage floatArrayToBufferedImage(float[][][] imageArray, double rescaleFactor) {
        int height = imageArray[0].length;
        int width = imageArray[0][0].length;
        BufferedImage image = new BufferedImage(width, height, 1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x2 -> {
            int[] rgb = (int[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])imageArray)).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToFloat((float)MllamaUtils$.$anonfun$floatArrayToBufferedImage$3(y, x2, x$9)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())))).map((Function1)(JFunction1.mcIF.sp & Serializable & scala.Serializable)x -> (int)((double)x * (1.0 / rescaleFactor)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Color color = new Color(rgb[0], rgb[1], rgb[2]);
            image.setRGB(x2, y, color.getRGB());
        }));
        return image;
    }

    public Tuple2<float[][][][][][], List<List<Object>>> packImages(List<float[][][][][]> batchImages, int maxImageTiles) {
        int batchSize = batchImages.size();
        int maxNumImages = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batchImages.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)MllamaUtils$.$anonfun$packImages$1(x$10)), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int channels = ((float[][][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])batchImages.head())).head())).head()).length;
        int tileHeight = ((float[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])batchImages.head())).head())).head())).head()).length;
        int tileWidth = ((float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])batchImages.head())).head())).head())).head())).head()).length;
        ArrayBuffer stackedImages = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ListBuffer allNumTiles = (ListBuffer)ListBuffer$.MODULE$.empty();
        ((TraversableLike)batchImages.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$packImages$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            float[][][][][] images = (float[][][][][])tuple2._1();
            ListBuffer numSampleTiles = (ListBuffer)ListBuffer$.MODULE$.empty();
            ArrayBuffer tempStackedImages = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])images)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$packImages$4(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                MllamaUtils$.$anonfun$packImages$5(numSampleTiles, maxImageTiles, channels, tileHeight, tileWidth, tempStackedImages, x$11);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxNumImages - images.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
                ArrayBuffer tempStackedTiles = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxImageTiles).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> tempStackedTiles.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][][][]{(float[][][])Array$.MODULE$.ofDim(channels, tileHeight, tileWidth, ClassTag$.MODULE$.Float())})));
                tempStackedImages.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][][][][]{(float[][][][])tempStackedTiles.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)))))}));
            });
            stackedImages.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][][][][][]{(float[][][][][])tempStackedImages.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))))))}));
            ListBuffer listBuffer = allNumTiles.$plus$eq((Object)numSampleTiles.toList());
            return listBuffer;
        });
        return new Tuple2(stackedImages.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE))))))), (Object)allNumTiles.toList());
    }

    public int[][][] buildAspectRatioMask(List<List<Tuple2<Object, Object>>> aspectRatios, int maxImageTiles) {
        int batchSize = aspectRatios.size();
        int maxNumImages = BoxesRunTime.unboxToInt((Object)((TraversableOnce)aspectRatios.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.size()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int[][][] aspectRatioMask = (int[][][])Array$.MODULE$.ofDim(batchSize, maxNumImages, maxImageTiles, ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxNumImages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            aspectRatioMask$1[i$2][j][0] = 1;
        }));
        ((TraversableLike)aspectRatios.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$buildAspectRatioMask$4(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            MllamaUtils$.$anonfun$buildAspectRatioMask$5(maxImageTiles, aspectRatioMask, x$16);
            return BoxedUnit.UNIT;
        });
        return aspectRatioMask;
    }

    public int[][][] packAspectRatios(List<List<Tuple2<Object, Object>>> aspectRatios, int padValue) {
        int batchSize = aspectRatios.size();
        int maxNumImages = BoxesRunTime.unboxToInt((Object)((TraversableOnce)aspectRatios.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.size()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int[][][] aspectRatiosStacked = (int[][][])Array$.MODULE$.fill(batchSize, maxNumImages, 2, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> padValue, ClassTag$.MODULE$.Int());
        ((TraversableLike)aspectRatios.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$packAspectRatios$3(check$ifrefutable$5))).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            MllamaUtils$.$anonfun$packAspectRatios$4(aspectRatiosStacked, x$19);
            return BoxedUnit.UNIT;
        });
        return aspectRatiosStacked;
    }

    public int packAspectRatios$default$2() {
        return 1;
    }

    public int[][] convertAspectRatiosToIds(List<List<Tuple2<Object, Object>>> aspectRatios, int maxImageTiles) {
        int batchSize = aspectRatios.size();
        int maxNumImages = BoxesRunTime.unboxToInt((Object)((TraversableOnce)aspectRatios.map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)x$20.size()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        List<Tuple2<Object, Object>> supportedAspectRatios = this.getAllSupportedAspectRatios(maxImageTiles);
        int[][] aspectRatiosIds = (int[][])Array$.MODULE$.fill(batchSize, maxNumImages, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, ClassTag$.MODULE$.Int());
        ((TraversableLike)aspectRatios.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$convertAspectRatiosToIds$3(check$ifrefutable$7))).foreach((Function1 & Serializable & scala.Serializable)x$22 -> {
            MllamaUtils$.$anonfun$convertAspectRatiosToIds$4(aspectRatiosIds, supportedAspectRatios, x$22);
            return BoxedUnit.UNIT;
        });
        return aspectRatiosIds;
    }

    public Tuple2<BufferedImage, Tuple2<Object, Object>> resizeImage(int width, int height, int resample, int maxImageTiles, BufferedImage image) {
        int imageWidth;
        int imageHeight = image.getHeight();
        Tuple2<Object, Object> tuple2 = this.getOptimalTiledCanvas(imageHeight, imageWidth = image.getWidth(), maxImageTiles, height);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int canvasHeight = tuple2._1$mcI$sp();
        int canvasWidth = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(canvasHeight, canvasWidth);
        Tuple2.mcII.sp sp3 = sp2;
        int canvasHeight2 = sp3._1$mcI$sp();
        int canvasWidth2 = sp3._2$mcI$sp();
        int numTilesHeight = canvasHeight2 / height;
        int numTilesWidth = canvasWidth2 / width;
        Tuple2<Object, Object> tuple22 = this.getImageSizeFitToCanvas(imageHeight, imageWidth, canvasHeight2, canvasWidth2, height);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int newHeight = tuple22._1$mcI$sp();
        int newWidth = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(newHeight, newWidth);
        Tuple2.mcII.sp sp5 = sp4;
        int newHeight2 = sp5._1$mcI$sp();
        int newWidth2 = sp5._2$mcI$sp();
        return new Tuple2((Object)ImageResizeUtils$.MODULE$.resizeBufferedImage(newWidth2, newHeight2, resample, image), (Object)new Tuple2.mcII.sp(numTilesHeight, numTilesWidth));
    }

    public float[][] padConstant(float[][] image, int padding, float constantValue) {
        int rows = image.length;
        int cols = image[0].length;
        int paddedRows = rows + 2 * padding;
        int paddedCols = cols + 2 * padding;
        float[][] paddedImage = (float[][])Array$.MODULE$.ofDim(paddedRows, paddedCols, ClassTag$.MODULE$.Float());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), paddedRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), paddedCols).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            paddedImage$1[i$6][j] = i >= padding && i < rows + padding && j >= padding && j < cols + padding ? image[i - padding][j - padding] : constantValue;
        }));
        return paddedImage;
    }

    public BufferedImage padBufferedImage(BufferedImage image, Tuple2<Object, Object> totalPadding, int constantColor) {
        int totalPaddingWidth;
        int originalWidth = image.getWidth();
        int originalHeight = image.getHeight();
        Tuple2<Object, Object> tuple2 = totalPadding;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int totalPaddingHeight = tuple2._1$mcI$sp();
        int totalPaddingWidth2 = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(totalPaddingHeight, totalPaddingWidth2);
        Tuple2.mcII.sp sp3 = sp2;
        int totalPaddingHeight2 = sp3._1$mcI$sp();
        int paddingWidthLeft = totalPaddingWidth = sp3._2$mcI$sp();
        int paddingHeightTop = totalPaddingHeight2;
        int paddedWidth = originalWidth + totalPaddingWidth;
        int paddedHeight = originalHeight + totalPaddingHeight2;
        BufferedImage paddedImage = new BufferedImage(paddedWidth, paddedHeight, image.getType());
        Color colorRGB = new Color(0, 0, 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), paddedWidth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), paddedHeight).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
            if (x < originalWidth && y < originalHeight) {
                paddedImage.setRGB(x, y, image.getRGB(x, y));
            } else {
                paddedImage.setRGB(x, y, colorRGB.getRGB());
            }
        }));
        return paddedImage;
    }

    public BufferedImage pad(BufferedImage image, int paddingConstant, Tuple2<Object, Object> aspectRatio, int tileHeight, int tileWidth) {
        int originalWidth = image.getWidth();
        int originalHeight = image.getHeight();
        int numTilesHeight = aspectRatio._1$mcI$sp();
        int numTilesWidth = aspectRatio._2$mcI$sp();
        int paddedWidth = numTilesWidth * tileWidth;
        int paddedHeight = numTilesHeight * tileHeight;
        int paddingHeight = paddedHeight - originalHeight;
        int paddingWidth = paddedWidth - originalWidth;
        BufferedImage paddedImage = this.padBufferedImage(image, (Tuple2<Object, Object>)new Tuple2.mcII.sp(paddingHeight, paddingWidth), paddingConstant);
        return paddedImage;
    }

    /*
     * Exception decompiling
     */
    public int[][] getCrossAttentionTokenMask(int[] inputIds, int imageTokenId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int[][][][] convertSparseCrossAttentionMaskToDense(int[][][] crossAttentionTokenMask, int[][] numTiles, int maxNumTiles, int length) {
        int batchSize = crossAttentionTokenMask.length;
        int maxNumImages = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])crossAttentionTokenMask)).map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToInteger((int)MllamaUtils$.$anonfun$convertSparseCrossAttentionMaskToDense$1(x$28)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
        int[][][][] crossAttentionMask = (int[][][][])Array$.MODULE$.ofDim(batchSize, length, maxNumImages, maxNumTiles, ClassTag$.MODULE$.Int());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])crossAttentionTokenMask)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sampleIdx -> {
            int[][] sampleMasks = crossAttentionTokenMask[sampleIdx];
            int[] sampleNumTiles = numTiles[sampleIdx];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleMasks)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)maskIdx -> {
                block1: {
                    int[] locations = sampleMasks[maskIdx];
                    int maskNumTiles = sampleNumTiles[maskIdx];
                    if (locations.length != 2) break block1;
                    int start = locations[0];
                    int end = locations[1];
                    if (end == -1) {
                        end = length;
                    }
                    end = package$.MODULE$.min(end, length);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maskNumTiles).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                        crossAttentionMask$1[sampleIdx$1][i$7][maskIdx$1][j] = 1;
                    }));
                }
            });
        });
        return crossAttentionMask;
    }

    public static final /* synthetic */ Object $anonfun$getAllSupportedAspectRatios$2(int width$1, int maxImageTiles$1, ListBuffer aspectRatios$1, int height) {
        return width$1 * height <= maxImageTiles$1 ? aspectRatios$1.$plus$eq((Object)new Tuple2.mcII.sp(width$1, height)) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double $anonfun$getOptimalTiledCanvas$6(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double h = tuple2._1$mcD$sp();
        double w = tuple2._2$mcD$sp();
        double d = w > h ? h : w;
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$getOptimalTiledCanvas$9(double selectedScale$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double s = tuple2._2$mcD$sp();
        boolean bl = s == selectedScale$1;
        return bl;
    }

    public static final /* synthetic */ int $anonfun$getOptimalTiledCanvas$11(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int w = tuple2._1$mcI$sp();
        int h = tuple2._2$mcI$sp();
        int n = w * h;
        return n;
    }

    public static final /* synthetic */ int $anonfun$arrayToBufferedImage$3(int y$2, int x$29, int[][] x$7) {
        return x$7[y$2][x$29];
    }

    public static final /* synthetic */ byte $anonfun$arrayToBufferedImage$4(int x$8) {
        return (byte)x$8;
    }

    public static final /* synthetic */ float $anonfun$floatArrayToBufferedImage$3(int y$3, int x$30, float[][] x$9) {
        return x$9[y$3][x$30];
    }

    public static final /* synthetic */ int $anonfun$packImages$1(float[][][][][] x$10) {
        return x$10.length;
    }

    public static final /* synthetic */ boolean $anonfun$packImages$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$packImages$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$packImages$5(ListBuffer numSampleTiles$1, int maxImageTiles$2, int channels$1, int tileHeight$1, int tileWidth$1, ArrayBuffer tempStackedImages$1, Tuple2 x$11) {
        Tuple2 tuple2 = x$11;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        float[][][][] image = (float[][][][])tuple2._1();
        ArrayBuffer tempStackedTiles = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int numTiles = image.length;
        numSampleTiles$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)numTiles));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTiles).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> tempStackedTiles.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][][][]{image[k]})));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxImageTiles$2 - image.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> tempStackedTiles.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][][][]{(float[][][])Array$.MODULE$.ofDim(channels$1, tileHeight$1, tileWidth$1, ClassTag$.MODULE$.Float())})));
        tempStackedImages$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new float[][][][][]{(float[][][][])tempStackedTiles.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)))))}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$buildAspectRatioMask$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildAspectRatioMask$6(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$buildAspectRatioMask$7(int maxImageTiles$3, int[][][] aspectRatioMask$1, int i$3, Tuple2 x$15) {
        Tuple2.mcII.sp sp2;
        int j;
        Tuple2 tuple2 = x$15;
        if (tuple2 != null) {
            Tuple2 aspectRatio = (Tuple2)tuple2._1();
            j = tuple2._2$mcI$sp();
            Tuple2 tuple22 = aspectRatio;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            int numTilesW = tuple22._1$mcI$sp();
            int numTilesH = tuple22._2$mcI$sp();
            sp2 = new Tuple2.mcII.sp(numTilesW, numTilesH);
        } else {
            throw new MatchError((Object)tuple2);
        }
        Tuple2.mcII.sp sp3 = sp2;
        int numTilesW = sp3._1$mcI$sp();
        int numTilesH = sp3._2$mcI$sp();
        int numTiles = numTilesW * numTilesH;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(numTiles, maxImageTiles$3)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
            aspectRatioMask$1[i$3][j$1][k] = 1;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$buildAspectRatioMask$5(int maxImageTiles$3, int[][][] aspectRatioMask$1, Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List sampleAspectRatios = (List)tuple2._1();
        int i = tuple2._2$mcI$sp();
        ((TraversableLike)sampleAspectRatios.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$buildAspectRatioMask$6(check$ifrefutable$4))).foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            MllamaUtils$.$anonfun$buildAspectRatioMask$7(maxImageTiles$3, aspectRatioMask$1, i, x$15);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$packAspectRatios$3(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$packAspectRatios$5(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$packAspectRatios$6(int[][][] aspectRatiosStacked$1, int i$4, Tuple2 x$18) {
        Tuple2 tuple2 = x$18;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 aspectRatio = (Tuple2)tuple2._1();
        int j = tuple2._2$mcI$sp();
        aspectRatiosStacked$1[i$4][j] = new int[]{aspectRatio._1$mcI$sp(), aspectRatio._2$mcI$sp()};
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$packAspectRatios$4(int[][][] aspectRatiosStacked$1, Tuple2 x$19) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$19;
        if (tuple2 != null) {
            List row = (List)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (row.nonEmpty()) {
                ((TraversableLike)row.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$packAspectRatios$5(check$ifrefutable$6))).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
                    MllamaUtils$.$anonfun$packAspectRatios$6(aspectRatiosStacked$1, i, x$18);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$convertAspectRatiosToIds$3(Tuple2 check$ifrefutable$7) {
        Tuple2 tuple2 = check$ifrefutable$7;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$convertAspectRatiosToIds$5(Tuple2 check$ifrefutable$8) {
        Tuple2 tuple2 = check$ifrefutable$8;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$convertAspectRatiosToIds$6(int[][] aspectRatiosIds$1, int i$5, List supportedAspectRatios$1, Tuple2 x$21) {
        Tuple2 tuple2 = x$21;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 aspectRatio = (Tuple2)tuple2._1();
        int j = tuple2._2$mcI$sp();
        aspectRatiosIds$1[i$5][j] = supportedAspectRatios$1.indexOf((Object)aspectRatio) + 1;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertAspectRatiosToIds$4(int[][] aspectRatiosIds$1, List supportedAspectRatios$1, Tuple2 x$22) {
        Tuple2 tuple2 = x$22;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List sampleAspectRatios = (List)tuple2._1();
        int i = tuple2._2$mcI$sp();
        ((TraversableLike)sampleAspectRatios.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)MllamaUtils$.$anonfun$convertAspectRatiosToIds$5(check$ifrefutable$8))).foreach((Function1 & Serializable & scala.Serializable)x$21 -> {
            MllamaUtils$.$anonfun$convertAspectRatiosToIds$6(aspectRatiosIds$1, i, supportedAspectRatios$1, x$21);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$getCrossAttentionTokenMask$1(int imageTokenId$1, Tuple2 x$26) {
        return x$26._1$mcI$sp() == imageTokenId$1;
    }

    public static final /* synthetic */ void $anonfun$getCrossAttentionTokenMask$4(Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int[] curr;
            int[] prev = (int[])tuple2._1();
            if (prev[0] + 1 == (curr = (int[])tuple2._2())[0]) {
                prev[1] = curr[1];
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ int $anonfun$convertSparseCrossAttentionMaskToDense$1(int[][] x$28) {
        return x$28.length;
    }

    private MllamaUtils$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$getCrossAttentionTokenMask$4$adapted(Tuple2 x0$1) {
        MllamaUtils$.$anonfun$getCrossAttentionTokenMask$4(x0$1);
        return BoxedUnit.UNIT;
    }
}

