/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.cv.util.transform;

import com.johnsnowlabs.nlp.annotators.cv.util.transform.ImageResizeUtils$;
import com.johnsnowlabs.nlp.annotators.cv.util.transform.SmolVLMUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class SmolVLMUtils$ {
    public static SmolVLMUtils$ MODULE$;
    private final int MAX_IMAGE_SIZE;

    static {
        new SmolVLMUtils$();
    }

    public int MAX_IMAGE_SIZE() {
        return this.MAX_IMAGE_SIZE;
    }

    public BufferedImage resizeImage(BufferedImage image, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, image.getType());
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    public BufferedImage _crop(BufferedImage image, int x1, int y1, int x2, int y2) {
        int width = x2 - x1;
        int height = y2 - y1;
        BufferedImage croppedImage = new BufferedImage(width, height, image.getType());
        Graphics2D g = croppedImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, x1, y1, x2, y2, null);
        g.dispose();
        return croppedImage;
    }

    public SmolVLMUtils.SplitImageResult splitImage(BufferedImage image, int maxImageSize, int resample) {
        SmolVLMUtils.SplitImageResult splitImageResult;
        int height = image.getHeight();
        int width = image.getWidth();
        int maxHeight = maxImageSize;
        int maxWidth = maxImageSize;
        ArrayBuffer frames = new ArrayBuffer();
        if (height > maxHeight || width > maxWidth) {
            int numSplitsH = (int)package$.MODULE$.ceil((double)height / (double)maxHeight);
            int numSplitsW = (int)package$.MODULE$.ceil((double)width / (double)maxWidth);
            int optimalHeight = (int)package$.MODULE$.ceil((double)height / (double)numSplitsH);
            int optimalWidth = (int)package$.MODULE$.ceil((double)width / (double)numSplitsW);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSplitsH).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSplitsW).foreach((Function1 & Serializable & scala.Serializable)c -> SmolVLMUtils$.$anonfun$splitImage$2(optimalWidth, r, optimalHeight, width, height, image, frames, BoxesRunTime.unboxToInt((Object)c))));
            BufferedImage resizedImage = ImageResizeUtils$.MODULE$.resizeBufferedImage(maxWidth, maxHeight, resample, image);
            frames.$plus$eq((Object)resizedImage);
            splitImageResult = new SmolVLMUtils.SplitImageResult((Seq<BufferedImage>)frames.toSeq(), numSplitsH, numSplitsW);
        } else {
            frames.$plus$eq((Object)image);
            splitImageResult = new SmolVLMUtils.SplitImageResult((Seq<BufferedImage>)frames.toSeq(), 0, 0);
        }
        return splitImageResult;
    }

    public int splitImage$default$3() {
        return 1;
    }

    private SmolVLMUtils.ImageSize resizeOutputSizeRescaleToMaxLen(int height, int width, int minLen, Option<Object> maxLen) {
        int newWidth;
        int newHeight;
        Tuple2.mcII.sp sp2;
        int newWidth2;
        int newHeight2;
        int effectiveMaxLen = BoxesRunTime.unboxToInt((Object)maxLen.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max(height, width)));
        double aspectRatio = (double)width / (double)height;
        Tuple2.mcII.sp sp3 = width >= height ? new Tuple2.mcII.sp((newHeight2 = (int)((double)(newWidth2 = effectiveMaxLen) / aspectRatio)) % 2 != 0 ? newHeight2 + 1 : newHeight2, newWidth2) : (sp2 = new Tuple2.mcII.sp(newHeight, (newWidth = (int)((double)(newHeight = effectiveMaxLen) * aspectRatio)) % 2 != 0 ? newWidth + 1 : newWidth));
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int newHeight3 = sp2._1$mcI$sp();
        int newWidth3 = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(newHeight3, newWidth3);
        Tuple2.mcII.sp sp5 = sp4;
        int newHeight4 = sp5._1$mcI$sp();
        int newWidth4 = sp5._2$mcI$sp();
        return new SmolVLMUtils.ImageSize(package$.MODULE$.max(newHeight4, minLen), package$.MODULE$.max(newWidth4, minLen));
    }

    private int resizeOutputSizeRescaleToMaxLen$default$3() {
        return 1;
    }

    private Option<Object> resizeOutputSizeRescaleToMaxLen$default$4() {
        return None$.MODULE$;
    }

    private SmolVLMUtils.ImageSize resizeOutputSizeScaleBelowUpperBound(int height, int width, Option<Object> maxLen) {
        Tuple2.mcII.sp sp2;
        Tuple2.mcII.sp sp3;
        int effectiveMaxLen = BoxesRunTime.unboxToInt((Object)maxLen.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max(height, width)));
        double aspectRatio = (double)width / (double)height;
        if (width >= height && width > effectiveMaxLen) {
            int newWidth = effectiveMaxLen;
            int newHeight = (int)((double)newWidth / aspectRatio);
            sp3 = new Tuple2.mcII.sp(newHeight, newWidth);
        } else if (height > width && height > effectiveMaxLen) {
            int newHeight = effectiveMaxLen;
            int newWidth = (int)((double)newHeight * aspectRatio);
            sp3 = new Tuple2.mcII.sp(newHeight, newWidth);
        } else {
            sp3 = sp2 = new Tuple2.mcII.sp(height, width);
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int newHeight = sp2._1$mcI$sp();
        int newWidth = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(newHeight, newWidth);
        Tuple2.mcII.sp sp5 = sp4;
        int newHeight2 = sp5._1$mcI$sp();
        int newWidth2 = sp5._2$mcI$sp();
        return new SmolVLMUtils.ImageSize(package$.MODULE$.max(newHeight2, 1), package$.MODULE$.max(newWidth2, 1));
    }

    private Option<Object> resizeOutputSizeScaleBelowUpperBound$default$3() {
        return None$.MODULE$;
    }

    public SmolVLMUtils.ImageSize getResizeOutputImageSize(BufferedImage image, int resolutionMaxSide, int maxImageSize) {
        int height = image.getHeight();
        int width = image.getWidth();
        int x$1 = height;
        int x$2 = width;
        Some x$3 = new Some((Object)BoxesRunTime.boxToInteger((int)resolutionMaxSide));
        int x$4 = this.resizeOutputSizeRescaleToMaxLen$default$3();
        SmolVLMUtils.ImageSize firstResize = this.resizeOutputSizeRescaleToMaxLen(x$1, x$2, x$4, (Option<Object>)x$3);
        return this.resizeOutputSizeScaleBelowUpperBound(firstResize.height(), firstResize.width(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxImageSize)));
    }

    public int getResizeOutputImageSize$default$3() {
        return this.MAX_IMAGE_SIZE();
    }

    public int[][] makePixelMask(BufferedImage image, SmolVLMUtils.ImageSize outputSize) {
        int inputHeight = image.getHeight();
        int inputWidth = image.getWidth();
        int[][] mask = (int[][])Array$.MODULE$.ofDim(outputSize.height(), outputSize.width(), ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(inputHeight, outputSize.height())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(inputWidth, outputSize.width())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            mask$1[y$1][x] = 1;
        }));
        return mask;
    }

    public BufferedImage resizeWithLongestEdge(BufferedImage image, int longestEdge, int resample) {
        SmolVLMUtils.ImageSize outputSize = this.getResizeOutputImageSize(image, longestEdge, this.getResizeOutputImageSize$default$3());
        return ImageResizeUtils$.MODULE$.resizeBufferedImage(outputSize.width(), outputSize.height(), resample, image);
    }

    public int resizeWithLongestEdge$default$3() {
        return 1;
    }

    public BufferedImage resizeForVisionEncoder(BufferedImage image, int visionEncoderMaxSize, int resample) {
        Tuple2.mcII.sp sp2;
        Tuple2.mcII.sp sp3;
        int height = image.getHeight();
        int width = image.getWidth();
        double aspectRatio = (double)width / (double)height;
        if (width >= height) {
            int newWidth = (int)package$.MODULE$.ceil((double)width / (double)visionEncoderMaxSize) * visionEncoderMaxSize;
            int newHeight = (int)((double)newWidth / aspectRatio);
            int finalHeight = (int)package$.MODULE$.ceil((double)newHeight / (double)visionEncoderMaxSize) * visionEncoderMaxSize;
            sp3 = new Tuple2.mcII.sp(finalHeight, newWidth);
        } else {
            int newHeight = (int)package$.MODULE$.ceil((double)height / (double)visionEncoderMaxSize) * visionEncoderMaxSize;
            int newWidth = (int)((double)newHeight * aspectRatio);
            int finalWidth = (int)package$.MODULE$.ceil((double)newWidth / (double)visionEncoderMaxSize) * visionEncoderMaxSize;
            sp3 = sp2 = new Tuple2.mcII.sp(newHeight, finalWidth);
        }
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int newHeight = sp2._1$mcI$sp();
        int newWidth = sp2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(newHeight, newWidth);
        Tuple2.mcII.sp sp5 = sp4;
        int newHeight2 = sp5._1$mcI$sp();
        int newWidth2 = sp5._2$mcI$sp();
        return ImageResizeUtils$.MODULE$.resizeBufferedImage(newWidth2, newHeight2, resample, image);
    }

    public int resizeForVisionEncoder$default$3() {
        return 1;
    }

    private SmolVLMUtils.ImageSize getMaxHeightWidth(Seq<Seq<float[][][]>> imagesList) {
        IntRef maxHeight = IntRef.create((int)Integer.MIN_VALUE);
        IntRef maxWidth = IntRef.create((int)Integer.MIN_VALUE);
        imagesList.foreach((Function1 & Serializable & scala.Serializable)images -> {
            images.foreach((Function1 & Serializable & scala.Serializable)image -> {
                SmolVLMUtils$.$anonfun$getMaxHeightWidth$2(maxHeight$1, maxWidth$1, image);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        return new SmolVLMUtils.ImageSize(maxHeight.elem, maxWidth.elem);
    }

    private int[][] makePixelMask(float[][][] image, SmolVLMUtils.ImageSize outputSize) {
        int inputHeight = image[0].length;
        int inputWidth = image[0][0].length;
        int[][] mask = (int[][])Array$.MODULE$.ofDim(outputSize.height(), outputSize.width(), ClassTag$.MODULE$.Int());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(inputHeight, outputSize.height())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(inputWidth, outputSize.width())).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            mask$2[y$2][x] = 1;
        }));
        return mask;
    }

    private float[][][] padImage(float[][][] image, SmolVLMUtils.ImageSize outputSize, float constantValue) {
        int inputHeight = image[0].length;
        int inputWidth = image[0][0].length;
        int outputHeight = outputSize.height();
        int outputWidth = outputSize.width();
        int numChannels = image.length;
        float[][][] paddedImage = (float[][][])Array$.MODULE$.ofDim(numChannels, outputHeight, outputWidth, ClassTag$.MODULE$.Float());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numChannels).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)c -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outputHeight).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outputWidth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            paddedImage$1[c$1][y$3][x] = constantValue;
        })));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numChannels).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)c -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(inputHeight, outputHeight)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), package$.MODULE$.min(inputWidth, outputWidth)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
            paddedImage$1[c$2][y$4][x] = image[c][y][x];
        })));
        return paddedImage;
    }

    public SmolVLMUtils.BatchFeature pad(Seq<Seq<float[][][]>> images, float constantValue, boolean returnPixelMask) {
        if (images.isEmpty() || ((SeqLike)images.head()).isEmpty()) {
            return new SmolVLMUtils.BatchFeature((Seq<Seq<float[][][]>>)((Seq)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)), (Option<Seq<Seq<int[][]>>>)(returnPixelMask ? new Some((Object)new .colon.colon((Object)((Seq)Nil$.MODULE$), (List)Nil$.MODULE$)) : None$.MODULE$));
        }
        SmolVLMUtils.ImageSize padSize = this.getMaxHeightWidth(images);
        int batchSize = images.size();
        int maxNumImages = BoxesRunTime.unboxToInt((Object)((TraversableOnce)images.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int numChannels = ((float[][][])((SeqLike)images.apply(0)).apply(0)).length;
        float[][][][][] paddedImages = (float[][][][][])Array$.MODULE$.ofDim(batchSize, maxNumImages, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)))));
        None$ pixelMasks = returnPixelMask ? new Some((Object)Array$.MODULE$.ofDim(batchSize, maxNumImages, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))))) : None$.MODULE$;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batchSize).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> SmolVLMUtils$.$anonfun$pad$2(maxNumImages, images, paddedImages, padSize, constantValue, returnPixelMask, (Option)pixelMasks, numChannels, arg_0)));
        return new SmolVLMUtils.BatchFeature((Seq<Seq<float[][][]>>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paddedImages)).map((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5)).toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).toSeq(), (Option<Seq<Seq<int[][]>>>)pixelMasks.map((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6)).map((Function1 & Serializable & scala.Serializable)x$7 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$7)).toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).toSeq()));
    }

    private float padImage$default$3() {
        return 0.0f;
    }

    public float pad$default$2() {
        return 0.0f;
    }

    public boolean pad$default$3() {
        return true;
    }

    private String promptSplitImage(int imageSeqLen, int imageRows, int imageCols, String fakeTokenAroundImage, String imageToken, String globalImageToken) {
        scala.collection.mutable.StringBuilder textSplitImages = new scala.collection.mutable.StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), imageRows).foreach((Function1 & Serializable & scala.Serializable)nH -> SmolVLMUtils$.$anonfun$promptSplitImage$1(imageCols, textSplitImages, fakeTokenAroundImage, imageToken, BoxesRunTime.unboxToInt((Object)nH)));
        textSplitImages.append("\n\n");
        textSplitImages.append(fakeTokenAroundImage);
        textSplitImages.append(globalImageToken);
        textSplitImages.append(imageToken);
        textSplitImages.append(fakeTokenAroundImage);
        return textSplitImages.toString();
    }

    private String promptSingleImage(int imageSeqLen, String fakeTokenAroundImage, String imageToken, String globalImageToken) {
        return new StringBuilder(0).append(fakeTokenAroundImage).append(globalImageToken).append(new StringOps(Predef$.MODULE$.augmentString(imageToken)).$times(imageSeqLen)).append(fakeTokenAroundImage).toString();
    }

    public String getImagePromptString(int imageRows, int imageCols, int imageSeqLen, String fakeTokenAroundImage, String imageToken, String globalImageToken) {
        return imageRows == 0 && imageCols == 0 ? this.promptSingleImage(imageSeqLen, fakeTokenAroundImage, imageToken, globalImageToken) : this.promptSplitImage(imageSeqLen, imageRows, imageCols, fakeTokenAroundImage, imageToken, globalImageToken);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$splitImage$2(int optimalWidth$1, int r$1, int optimalHeight$1, int width$1, int height$1, BufferedImage image$1, ArrayBuffer frames$1, int c) {
        int startX = c * optimalWidth$1;
        int startY = r$1 * optimalHeight$1;
        int endX = package$.MODULE$.min(startX + optimalWidth$1, width$1);
        int endY = package$.MODULE$.min(startY + optimalHeight$1, height$1);
        BufferedImage croppedImage = MODULE$._crop(image$1, startX, startY, endX, endY);
        return frames$1.$plus$eq((Object)croppedImage);
    }

    public static final /* synthetic */ void $anonfun$getMaxHeightWidth$2(IntRef maxHeight$1, IntRef maxWidth$1, float[][][] image) {
        int height = image[0].length;
        int width = image[0][0].length;
        maxHeight$1.elem = package$.MODULE$.max(height, maxHeight$1.elem);
        maxWidth$1.elem = package$.MODULE$.max(width, maxWidth$1.elem);
    }

    public static final /* synthetic */ void $anonfun$pad$2(int maxNumImages$1, Seq images$1, float[][][][][] paddedImages$1, SmolVLMUtils.ImageSize padSize$1, float constantValue$2, boolean returnPixelMask$1, Option pixelMasks$1, int numChannels$1, int batchIdx) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), maxNumImages$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sampleIdx -> {
            block1: {
                block0: {
                    if (sampleIdx >= ((SeqLike)images$1.apply(batchIdx)).size()) break block0;
                    paddedImages$1[batchIdx$1][sampleIdx] = MODULE$.padImage((float[][][])((SeqLike)images$1.apply(batchIdx)).apply(sampleIdx), padSize$1, constantValue$2);
                    if (!returnPixelMask$1) break block1;
                    ((int[][][][])pixelMasks$1.get())[batchIdx$1][sampleIdx] = MODULE$.makePixelMask((float[][][])((SeqLike)images$1.apply(batchIdx)).apply(sampleIdx), padSize$1);
                    break block1;
                }
                paddedImages$1[batchIdx$1][sampleIdx] = (float[][][])Array$.MODULE$.ofDim(numChannels$1, padSize$1.height(), padSize$1.width(), ClassTag$.MODULE$.Float());
                if (!returnPixelMask$1) break block1;
                ((int[][][][])pixelMasks$1.get())[batchIdx$1][sampleIdx] = (int[][])Array$.MODULE$.ofDim(padSize$1.height(), padSize$1.width(), ClassTag$.MODULE$.Int());
            }
        });
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$promptSplitImage$2(scala.collection.mutable.StringBuilder textSplitImages$1, String fakeTokenAroundImage$1, int nH$1, String imageToken$1, int nW) {
        textSplitImages$1.append(String.valueOf(fakeTokenAroundImage$1));
        textSplitImages$1.append(new StringBuilder(11).append("<row_").append(nH$1 + 1).append("_col_").append(nW + 1).append(">").toString());
        return textSplitImages$1.append(imageToken$1);
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$promptSplitImage$1(int imageCols$1, scala.collection.mutable.StringBuilder textSplitImages$1, String fakeTokenAroundImage$1, String imageToken$1, int nH) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), imageCols$1).foreach((Function1 & Serializable & scala.Serializable)nW -> SmolVLMUtils$.$anonfun$promptSplitImage$2(textSplitImages$1, fakeTokenAroundImage$1, nH, imageToken$1, BoxesRunTime.unboxToInt((Object)nW)));
        return textSplitImages$1.append("\n");
    }

    private SmolVLMUtils$() {
        MODULE$ = this;
        this.MAX_IMAGE_SIZE = 4096;
    }
}

