/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.ner.dl;

import com.johnsnowlabs.ml.tensorflow.DatasetEncoderParams;
import com.johnsnowlabs.ml.tensorflow.DatasetEncoderParams$;
import com.johnsnowlabs.ml.tensorflow.NerDatasetEncoder;
import com.johnsnowlabs.ml.tensorflow.TensorflowNer;
import com.johnsnowlabs.ml.tensorflow.TensorflowWrapper;
import com.johnsnowlabs.ml.tensorflow.TensorflowWrapper$;
import com.johnsnowlabs.nlp.annotators.ner.Verbose$;
import com.johnsnowlabs.nlp.annotators.ner.dl.NerDLModel;
import com.johnsnowlabs.storage.RocksDBConnection;
import com.johnsnowlabs.storage.StorageHelper$;
import com.johnsnowlabs.util.FileHelper$;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0;

public final class NerDLModelPythonReader$ {
    public static NerDLModelPythonReader$ MODULE$;
    private final String embeddingsMetaFile;
    private final String embeddingsFile;
    private final String tagsFile;
    private final String charsFile;

    static {
        new NerDLModelPythonReader$();
    }

    public String embeddingsMetaFile() {
        return this.embeddingsMetaFile;
    }

    public String embeddingsFile() {
        return this.embeddingsFile;
    }

    public String tagsFile() {
        return this.tagsFile;
    }

    public String charsFile() {
        return this.charsFile;
    }

    private List<String> readTags(String folder) {
        return Source$.MODULE$.fromFile(((Object)Paths.get(folder, this.tagsFile())).toString(), Codec$.MODULE$.fallbackSystemCodec()).getLines().toList();
    }

    private List<Object> readChars(String folder) {
        Iterator lines = Source$.MODULE$.fromFile(((Object)Paths.get(folder, this.charsFile())).toString(), Codec$.MODULE$.fallbackSystemCodec()).getLines();
        return new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(((String)lines.toList().head()).toCharArray())).toList();
    }

    private int readEmbeddingsHead(String folder) {
        String metaFile = ((Object)Paths.get(folder, this.embeddingsMetaFile())).toString();
        return new StringOps(Predef$.MODULE$.augmentString((String)Source$.MODULE$.fromFile(metaFile, Codec$.MODULE$.fallbackSystemCodec()).getLines().toList().head())).toInt();
    }

    private RocksDBConnection readEmbeddings(String folder, SparkSession spark, int embeddingsDim, boolean normalize) {
        return StorageHelper$.MODULE$.load(((Object)Paths.get(folder, this.embeddingsFile())).toString(), spark, "python_tf_model", "python_tf_ref", false);
    }

    public TensorflowNer readLocal(String folder, int dim, boolean useBundle, Enumeration.Value verbose, String[] tags) {
        TensorflowWrapper tf;
        List<String> labels = this.readTags(folder);
        List<Object> chars = this.readChars(folder);
        DatasetEncoderParams settings = new DatasetEncoderParams(labels, chars, (List<Object>)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])Array$.MODULE$.fill(dim, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f, ClassTag$.MODULE$.Float()))).toList(), dim, DatasetEncoderParams$.MODULE$.apply$default$5());
        NerDatasetEncoder encoder = new NerDatasetEncoder(settings);
        Tuple2<TensorflowWrapper, Option<Map<String, String>>> tuple2 = TensorflowWrapper$.MODULE$.read(folder, false, useBundle, tags, TensorflowWrapper$.MODULE$.read$default$5(), TensorflowWrapper$.MODULE$.read$default$6());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TensorflowWrapper tensorflowWrapper = tf = (TensorflowWrapper)tuple2._1();
        TensorflowWrapper tf2 = tensorflowWrapper;
        return new TensorflowNer(tf2, encoder, verbose);
    }

    public NerDLModel read(String folder, int dim, SparkSession spark, boolean useBundle, String[] tags) {
        URI uri = new URI(new StringOps(Predef$.MODULE$.augmentString(folder)).replaceAllLiterally("\\", "/"));
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)spark.sparkContext().hadoopConfiguration());
        String tmpFolder = ((Object)Files.createTempDirectory(new StringBuilder(7).append((String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(12)).append("_bundle").toString(), new FileAttribute[0]).toAbsolutePath()).toString();
        fs.copyToLocalFile(new Path(folder), new Path(tmpFolder));
        String x$1 = tmpFolder;
        int x$2 = dim;
        boolean x$3 = useBundle;
        String[] x$4 = tags;
        Enumeration.Value x$5 = this.readLocal$default$4();
        TensorflowNer nerModel = this.readLocal(x$1, x$2, x$3, x$5, x$4);
        FileHelper$.MODULE$.delete(tmpFolder, FileHelper$.MODULE$.delete$default$2());
        return new NerDLModel().setModelIfNotSet(spark, nerModel.tensorflow()).setDatasetParams(nerModel.encoder().params());
    }

    public boolean readLocal$default$3() {
        return false;
    }

    public Enumeration.Value readLocal$default$4() {
        return Verbose$.MODULE$.All();
    }

    public String[] readLocal$default$5() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public boolean read$default$4() {
        return false;
    }

    public String[] read$default$5() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    private NerDLModelPythonReader$() {
        MODULE$ = this;
        this.embeddingsMetaFile = "embeddings.meta";
        this.embeddingsFile = "embeddings";
        this.tagsFile = "tags.csv";
        this.charsFile = "chars.csv";
    }
}

