/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep;

import com.johnsnowlabs.nlp.annotators.parser.typdep.ConllData;
import com.johnsnowlabs.nlp.annotators.parser.typdep.DependencyInstance;
import com.johnsnowlabs.nlp.annotators.parser.typdep.Options;
import com.johnsnowlabs.nlp.annotators.parser.typdep.feature.FeatureTemplate;
import com.johnsnowlabs.nlp.annotators.parser.typdep.feature.SyntacticFeatureFactory;
import com.johnsnowlabs.nlp.annotators.parser.typdep.io.Conll09Reader;
import com.johnsnowlabs.nlp.annotators.parser.typdep.io.ConllUReader;
import com.johnsnowlabs.nlp.annotators.parser.typdep.io.DependencyReader;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.Dictionary;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.DictionarySet;
import com.johnsnowlabs.nlp.annotators.parser.typdep.util.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyPipe
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Logger logger = LoggerFactory.getLogger((String)"TypedDependencyParser");
    private Options options;
    private DictionarySet dictionariesSet = new DictionarySet();
    private SyntacticFeatureFactory synFactory = new SyntacticFeatureFactory();
    private String[] types;
    private HashSet<String> conjWord;
    private HashMap<String, String> coarseMap;
    private boolean[][][] pruneLabel;
    private int numCPOS;

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public DictionarySet getDictionariesSet() {
        return this.dictionariesSet;
    }

    SyntacticFeatureFactory getSynFactory() {
        return this.synFactory;
    }

    public void setDictionariesSet(DictionarySet dictionarySet) {
        this.dictionariesSet = dictionarySet;
    }

    public String[] getTypes() {
        return this.types;
    }

    boolean[][][] getPruneLabel() {
        return this.pruneLabel;
    }

    DependencyPipe(Options options) {
        this.options = options;
        this.loadLanguageInfo();
    }

    private void loadLanguageInfo() {
        this.coarseMap = new HashMap();
        try {
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.options.unimapFile));){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    String[] stringArray = string.split("\\s+");
                    this.coarseMap.put(stringArray[0], stringArray[1]);
                }
            }
            this.coarseMap.put("<root-POS>", "ROOT");
        }
        catch (Exception exception) {
            this.logger.warn("Couldn't find coarse POS map for this language");
        }
        this.conjWord = new HashSet();
        this.conjWord.add("and");
        this.conjWord.add("or");
    }

    private void createDictionaries(String string, String string2) throws IOException {
        String[] stringArray;
        long l = System.currentTimeMillis();
        this.logger.debug("Creating dictionariesSet ... ");
        this.dictionariesSet.setCounters();
        DependencyReader dependencyReader = DependencyReader.createDependencyReader(string2);
        dependencyReader.startReading(string);
        DependencyInstance dependencyInstance = dependencyReader.nextInstance();
        while (dependencyInstance != null) {
            dependencyInstance.setInstIds(this.dictionariesSet, this.coarseMap, this.conjWord);
            dependencyInstance = dependencyReader.nextInstance();
        }
        dependencyReader.close();
        this.dictionariesSet.closeCounters();
        this.synFactory.setTokenStart(this.dictionariesSet.lookupIndex(DictionarySet.DictionaryTypes.POS, "#TOKEN_START#"));
        this.synFactory.setTokenEnd(this.dictionariesSet.lookupIndex(DictionarySet.DictionaryTypes.POS, "#TOKEN_END#"));
        this.synFactory.setTokenMid(this.dictionariesSet.lookupIndex(DictionarySet.DictionaryTypes.POS, "#TOKEN_MID#"));
        this.dictionariesSet.stopGrowth(DictionarySet.DictionaryTypes.DEP_LABEL);
        this.dictionariesSet.stopGrowth(DictionarySet.DictionaryTypes.POS);
        this.dictionariesSet.stopGrowth(DictionarySet.DictionaryTypes.WORD);
        this.synFactory.setWordNumBits(Utils.log2((long)this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.WORD) + 1L));
        this.synFactory.setTagNumBits(Utils.log2((long)this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.POS) + 1L));
        this.synFactory.setDepNumBits(Utils.log2((long)this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.DEP_LABEL) + 1L));
        this.synFactory.setFlagBits(2 * this.synFactory.getDepNumBits() + 4);
        this.types = new String[this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.DEP_LABEL)];
        Dictionary dictionary = this.dictionariesSet.getDictionary(DictionarySet.DictionaryTypes.DEP_LABEL);
        for (String string3 : stringArray = dictionary.newToArray()) {
            int n = dictionary.lookupIndex(string3);
            this.types[n - 1] = string3;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("%d %d %n", FeatureTemplate.Word.NUM_WORD_FEAT_BITS, FeatureTemplate.Arc.NUM_ARC_FEAT_BITS));
            this.logger.debug(String.format("Lexical items: %d (%d bits)%n", this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.WORD), this.synFactory.getWordNumBits()));
            this.logger.debug(String.format("Tag/label items: %d (%d bits)  %d (%d bits)%n", this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.POS), this.synFactory.getTagNumBits(), this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.DEP_LABEL), this.synFactory.getDepNumBits()));
            this.logger.debug(String.format("Flag Bits: %d%n", this.synFactory.getFlagBits()));
            this.logger.debug(String.format("Creation took [%d ms]%n", System.currentTimeMillis() - l));
        }
    }

    public void createAlphabets(String string, String string2) throws IOException {
        this.createDictionaries(string, string2);
        long l = System.currentTimeMillis();
        this.logger.debug("Creating Alphabet ... ");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        DependencyReader dependencyReader = DependencyReader.createDependencyReader(string2);
        dependencyReader.startReading(string);
        DependencyInstance dependencyInstance = dependencyReader.nextInstance();
        while (dependencyInstance != null) {
            for (int i = 0; i < dependencyInstance.getLength(); ++i) {
                if (dependencyInstance.getUPosTags() != null) {
                    hashSet.add(dependencyInstance.getUPosTags()[i]);
                }
                if (dependencyInstance.getXPosTags() == null) continue;
                hashSet2.add(dependencyInstance.getXPosTags()[i]);
            }
            dependencyInstance.setInstIds(this.dictionariesSet, this.coarseMap, this.conjWord);
            this.synFactory.initFeatureAlphabets(dependencyInstance);
            dependencyInstance = dependencyReader.nextInstance();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("[%d ms]%n", System.currentTimeMillis() - l));
        }
        this.closeAlphabets();
        dependencyReader.close();
        this.synFactory.checkCollisions();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Num of CONLL fine POS tags: %d%n", hashSet.size()));
            this.logger.debug(String.format("Num of CONLL coarse POS tags: %d%n", hashSet2.size()));
            this.logger.debug(String.format("Num of labels: %d%n", this.types.length));
            this.logger.debug(String.format("Num of Syntactic Features: %d %d%n", this.synFactory.getNumberWordFeatures(), this.synFactory.getNumberLabeledArcFeatures()));
        }
        this.numCPOS = hashSet2.size();
    }

    public void closeAlphabets() {
        this.synFactory.closeAlphabets();
    }

    public DependencyInstance[] createInstances(String string, String string2) throws IOException {
        this.logger.debug("Creating instances ... ");
        DependencyReader dependencyReader = DependencyReader.createDependencyReader(string2);
        dependencyReader.startReading(string);
        LinkedList<DependencyInstance> linkedList = new LinkedList<DependencyInstance>();
        DependencyInstance dependencyInstance = dependencyReader.nextInstance();
        while (dependencyInstance != null) {
            dependencyInstance.setInstIds(this.dictionariesSet, this.coarseMap, this.conjWord);
            linkedList.add(new DependencyInstance(dependencyInstance));
            dependencyInstance = dependencyReader.nextInstance();
        }
        dependencyReader.close();
        this.closeAlphabets();
        DependencyInstance[] dependencyInstanceArray = new DependencyInstance[linkedList.size()];
        int n = 0;
        for (DependencyInstance dependencyInstance2 : linkedList) {
            dependencyInstanceArray[n++] = dependencyInstance2;
        }
        return dependencyInstanceArray;
    }

    public DependencyInstance nextSentence(ConllData[] conllDataArray, String string) {
        DependencyInstance dependencyInstance;
        if (string.equals("2009")) {
            Conll09Reader conll09Reader = new Conll09Reader();
            dependencyInstance = conll09Reader.nextSentence(conllDataArray);
        } else {
            ConllUReader conllUReader = new ConllUReader();
            dependencyInstance = conllUReader.nextSentence(conllDataArray);
        }
        if (dependencyInstance == null) {
            return null;
        }
        dependencyInstance.setInstIds(this.dictionariesSet, this.coarseMap, this.conjWord);
        return dependencyInstance;
    }

    public void pruneLabel(DependencyInstance[] dependencyInstanceArray) {
        int n = this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.POS) + 1;
        int n2 = this.dictionariesSet.getDictionarySize(DictionarySet.DictionaryTypes.DEP_LABEL) + 1;
        this.pruneLabel = new boolean[n][n][n2];
        int n3 = 0;
        for (DependencyInstance dependencyInstance : dependencyInstanceArray) {
            int n4 = dependencyInstance.getLength();
            for (int i = 1; i < n4; ++i) {
                int n5 = dependencyInstance.getHeads()[i];
                int n6 = dependencyInstance.getDependencyLabelIds()[i];
                int[] nArray = dependencyInstance.getXPosTagIds();
                if (this.pruneLabel[nArray[n5]][nArray[i]][n6]) continue;
                this.pruneLabel[nArray[n5]][nArray[i]][n6] = true;
                ++n3;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Prune label: %d/%d", n3, this.numCPOS * this.numCPOS * n2));
        }
    }
}

